/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.report;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.fit.service.report.ReportGenerator;
import com.huawei.ism.tool.inspect.fit.service.task.TaskWorkerManager;
import com.huawei.ism.tool.inspect.fit.validator.impl.TaskExistValidator;
import com.huawei.ism.tool.inspect.fit.validator.impl.TaskStartValidator;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.ExportReport;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class ExportReportServerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportReportServerImpl.class);
    @Fit
    private final TaskWorkerManager workerManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Fitable(generic=ExportReport.class, id="cc1eca43b2184543afd4c27a2cf9a01f")
    public synchronized Response<String> exportReport(String taskId, String targetDir) {
        try {
            this.validate(taskId);
            InspectWorktaker workTaker = this.workerManager.getTaskWorker(taskId).get();
            workTaker.getInspectScene().initContextScene();
            ReportGenerator generator = new ReportGenerator(workTaker);
            File reportFile = generator.exportReport(new File(targetDir), InspectUtils.buildResultFileName(targetDir).getName());
            Response response = ResponseUtil.success((Object)reportFile.getCanonicalPath());
            return response;
        }
        catch (ToolException e) {
            log.error("Task {} export report {} failed.", new Object[]{taskId, targetDir, e});
            Response response = ResponseUtil.failed((String)e.getErrorLocaleDescription(), (String)"");
            return response;
        }
        catch (Exception e) {
            log.error("Task {} export report {} failed.", new Object[]{taskId, targetDir, e});
            Response response = ResponseUtil.failed((Object)ResourceUtil.getString((String)"inspsctor.wizard.performinspect.report.fail"));
            return response;
        }
        finally {
            InspectScene.REAL_TIME_CHECK.initContextScene();
        }
    }

    private void validate(String taskId) throws ToolException {
        new TaskExistValidator(this.workerManager).validator(taskId, "");
        new TaskStartValidator(this.workerManager).validator(taskId, "");
    }

    @Generated
    public ExportReportServerImpl(TaskWorkerManager workerManager) {
        this.workerManager = workerManager;
    }
}

