/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.report;

import com.huawei.ism.tool.base.utils.CallbackPackageSnMappingUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.result.ExcelConfigurationResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.TreeViewResultBuilder;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportGenerator.class);
    public static final String NOTHING_EXPORT = "inspector.export.failed";
    public static final String COMPRESS_FAILED = "inspsctor.wizard.performinspect.report.fail";
    private static final String SCRIPT_DIR = Paths.get(InspectContext.INSPECT_CONFPATH, "products", "pkginfo", "script").toString();
    private static final String PACKAGE_INFO = SCRIPT_DIR + File.separator + "creatPkgInfo.py";
    private static final JythonExecuter JYTHON_EXECUTOR = new JythonExecuter(new File(SCRIPT_DIR));
    private final InspectWorktaker workTaker;

    public File exportReport(File targetDir, String reportName) throws ToolException, IOException {
        List<CheckDevNode> connectedDevNode = this.workTaker.getConnectedDev();
        if (connectedDevNode == null || connectedDevNode.isEmpty()) {
            throw new ToolException(NOTHING_EXPORT);
        }
        this.buildReport();
        FileUtils.createDir((File)targetDir);
        File resultFile = new File(targetDir, reportName);
        this.exportReport(resultFile);
        return resultFile;
    }

    private void exportReport(File resultFile) throws IOException, ToolException {
        File resultTmpDir = (File)this.workTaker.get("check_savepath");
        String reportTempDir = resultTmpDir.getCanonicalPath();
        InspectUtils.addSHA256SignFile(resultTmpDir);
        if (!ZipUtils.compressFile((String)resultFile.getCanonicalPath(), (String)reportTempDir)) {
            throw new ToolException(COMPRESS_FAILED);
        }
        FileUtils.setFilePermissions((File)resultFile);
        this.recordUploadInfo(this.workTaker.getConnectedDev(), resultFile.getCanonicalPath());
    }

    private void buildReport() throws IOException {
        File resultTmpDir = (File)this.workTaker.get("check_savepath");
        String reportTempDir = resultTmpDir.getCanonicalPath();
        List<CheckDevNode> connectedDevNode = this.workTaker.getConnectedDev();
        FileUtils.copyDir((String)(InspectContext.INSPECT_CONFPATH + File.separator + "template"), (String)reportTempDir);
        if (InspectUtils.isFsExInspect()) {
            ExcelConfigurationResultBuilder excelBuilder = new ExcelConfigurationResultBuilder();
            excelBuilder.injectData(connectedDevNode);
            excelBuilder.saveExcel(reportTempDir + File.separator + "Configuration_Summary.xlsx");
        }
        TreeViewResultBuilder builder = new TreeViewResultBuilder(this.workTaker);
        builder.buildResult((Map<String, List<CheckDevNode>>)InspectUtils.classifyDevs(connectedDevNode), resultTmpDir, connectedDevNode);
        this.buildPackageInfo(reportTempDir);
    }

    private void recordUploadInfo(List<CheckDevNode> connectedDevNode, String reportPath) {
        try {
            if (!InspectUtils.checkUploadRight()) {
                return;
            }
            String recordInfo = this.buildRecordDevInfo(connectedDevNode);
            CallbackPackageSnMappingUtils.recordToolPackageSnMapping((String)"inspector", (String)recordInfo, (String)reportPath);
        }
        catch (Exception e) {
            log.error("record upload sn failed!", (Throwable)e);
        }
    }

    private String buildRecordDevInfo(List<CheckDevNode> connectedDevNode) {
        JSONArray devicesInfo = new JSONArray();
        connectedDevNode.stream().map(CheckDevNode::getAllCheckNode).flatMap(Collection::stream).map(CheckDevNode::getDevNode).filter(Objects::nonNull).map(this::buildRecordDevInfo).forEach(arg_0 -> ((JSONArray)devicesInfo).put(arg_0));
        return devicesInfo.toString();
    }

    @NonNull
    private JSONObject buildRecordDevInfo(DevNode node) {
        JSONObject devInfo = new JSONObject();
        devInfo.put("SN", (Object)node.getDeviceSerialNumber());
        devInfo.put("DeviceType", (Object)node.getItDeviceType().getName());
        return devInfo;
    }

    public void buildPackageInfo(String inspectDir) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dir", inspectDir);
        params.put("logger", log);
        params.put("connectedDevs", this.workTaker.getConnectedDev());
        Object scene = this.workTaker.get("select_sceneId");
        params.put("scene", String.valueOf(scene));
        params.put("qualityCheckUser", this.gbEncoding(System.getProperty("qualityCheckUser")));
        InspectContext context = InspectContext.getInstance();
        if (context.getExtendInspectScene() != null) {
            params.put("scene", context.getExpMode());
        }
        try {
            JYTHON_EXECUTOR.compileScript(new File(PACKAGE_INFO));
            JYTHON_EXECUTOR.invokeFunction("execute", params);
        }
        catch (Exception e) {
            log.error("Build package info error!", (Throwable)e);
        }
    }

    private String gbEncoding(String gbString) {
        if (StringUtils.isNULLStr((String)gbString)) {
            return "";
        }
        char[] utfBytes = gbString.toCharArray();
        String unicodeBytes = "";
        for (int i = 0; i < utfBytes.length; ++i) {
            String hexB = Integer.toHexString(utfBytes[i]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes = unicodeBytes + "\\u" + hexB;
        }
        return unicodeBytes;
    }

    @Generated
    public ReportGenerator(InspectWorktaker workTaker) {
        this.workTaker = workTaker;
    }
}

