/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.task;

import com.huawei.ism.tool.fusionstorage.common.FusionConstants;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.fit.service.report.ReportGenerator;
import com.huawei.ism.tool.inspect.fit.service.task.ITaskExecutor;
import com.huawei.ism.tool.inspect.logic.inspector.DStorageInspectCallable;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.InspectCaller;
import com.huawei.ism.tool.inspect.logic.inspector.InspectEventRecorder;
import com.huawei.ism.tool.inspect.logic.inspector.TaskSchedule;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.CheckDevParams;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.StartInspectParams;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedTaskExecutor
implements ITaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistributedTaskExecutor.class);
    private final InspectWorktaker workTaker;
    private final IUiObserver uiObserver;
    private final StartInspectParams params;
    private final TaskSchedule taskSchedule = new TaskSchedule();
    private final File resultTmpDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        long startTime = System.currentTimeMillis();
        this.workTaker.setStartTimeStamp(startTime);
        InspectScene inspectScene = InspectScene.of(this.params.getScene());
        try {
            inspectScene.initContextScene();
            this.workTaker.put("check_dev_nodes", this.workTaker.loadProductConfigByDevNode());
            this.bindStorageConfigParams(this.params);
            this.uiObserver.start();
            this.initTaskName();
            this.initInspectConfig();
            InspectEventRecorder.getInstance().startRecord(this.workTaker.getCheckDevNodes());
            CompletableFuture.allOf(this.submitTask().toArray(new CompletableFuture[0])).join();
            this.exportTempReport();
        }
        catch (Exception e) {
            log.error("Exec inspect task failed.", (Throwable)e);
        }
        finally {
            InspectScene.REAL_TIME_CHECK.initContextScene();
            log.info("Finished all dev inspect.");
            long endTime = System.currentTimeMillis();
            this.workTaker.setEndTimeStamp(endTime);
            SwingUtilities.invokeLater(() -> this.uiObserver.finishAll(endTime - startTime));
        }
    }

    void exportTempReport() throws ToolException, IOException {
        ReportGenerator generator = new ReportGenerator(this.workTaker);
        FileUtils.createDir((String)FusionConstants.REPORT_TEMP_DIR);
        generator.exportReport(new File(FusionConstants.REPORT_TEMP_DIR), InspectUtils.buildResultFileName(FusionConstants.REPORT_TEMP_DIR).getName());
    }

    private void bindStorageConfigParams(StartInspectParams params) {
        InspectScene scene = InspectScene.of(params.getScene());
        if (scene != InspectScene.STORAGE_CONFIG) {
            return;
        }
        params.getCheckDevParams().forEach(param -> {
            try {
                CheckDevNode checkDevNode = this.workTaker.findCheckDevNode(param.getDevId());
                if (param.getStorageConfigParams() != null) {
                    checkDevNode.setScsiTimeOut(param.getStorageConfigParams().getScsiTimeOut());
                    checkDevNode.setCompressionRatio(param.getStorageConfigParams().getCompressionRatio());
                }
            }
            catch (ToolException e) {
                log.error("Find check dev node {} failed.", (Object)param.getDevId());
            }
        });
    }

    private List<CompletableFuture<Object>> submitTask() {
        return this.workTaker.getCheckDevNodes().stream().peek(CheckDevNode::reset).map(this::buildInspectCaller).map(inspectCaller -> CompletableFuture.supplyAsync(() -> this.startInspect((InspectCaller)inspectCaller), EXECUTOR_SERVICE)).collect(Collectors.toList());
    }

    @Nullable
    private Object startInspect(InspectCaller inspectCaller) {
        try {
            return inspectCaller.call();
        }
        catch (Exception exception) {
            log.error("Execute failed.", (Throwable)exception);
            return Boolean.FALSE;
        }
    }

    private void initTaskName() {
        Thread.currentThread().setName("InspectTask_" + this.params.getTaskId());
    }

    @NonNull
    private InspectCaller buildInspectCaller(CheckDevNode checkDevNode) {
        InspectScene scene = InspectScene.of(this.params.getScene());
        DStorageInspectCallable caller = new DStorageInspectCallable(scene, this.findItemIds(checkDevNode));
        ((InspectCaller)caller).initValue(checkDevNode, this.uiObserver, this.taskSchedule, this.resultTmpDir, this.workTaker);
        return caller;
    }

    @NonNull
    private List<String> findItemIds(CheckDevNode checkDevNode) {
        return this.params.getCheckDevParams().stream().filter(params -> params.getDevId().equals(checkDevNode.getDevNodeSafe().getDevKey())).findFirst().map(CheckDevParams::getItemIds).orElse(Collections.emptyList());
    }

    private void initInspectConfig() {
        this.workTaker.put("not_connected_devices_" + this.workTaker.getUuid(), Collections.synchronizedList(new ArrayList()));
        InspectScene scene = InspectScene.of(this.params.getScene());
        scene.initContextScene();
        InspectContext.getInstance().getIsScenesInspect().clear();
        InspectContext.getInstance().getIsScenesInspect().put(scene.getItemScene(), true);
        InspectContext.getInstance().setInspectWorktaker(this.workTaker);
        this.workTaker.put("select_sceneId", scene.getSceneId());
    }

    public String toString() {
        return this.params.getTaskId();
    }

    @Generated
    public DistributedTaskExecutor(InspectWorktaker workTaker, IUiObserver uiObserver, StartInspectParams params, File resultTmpDir) {
        this.workTaker = workTaker;
        this.uiObserver = uiObserver;
        this.params = params;
        this.resultTmpDir = resultTmpDir;
    }
}

