/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.task;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.fit.TaskRunningObserver;
import com.huawei.ism.tool.inspect.fit.service.task.DistributedTaskExecutor;
import com.huawei.ism.tool.inspect.fit.service.task.ITaskExecutor;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.StartInspectParams;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class TaskWorkerManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskWorkerManager.class);
    public static final String DEFAULT_WORKER_ID = "default";
    private final int taskNum = Integer.parseInt(ResourceBundle.getBundle("config.inspect").getString("inspect.task.num"));
    private final ExecutorService pool = Executors.newFixedThreadPool(this.taskNum);
    private final Map<String, InspectWorktaker> workers = new ConcurrentHashMap<String, InspectWorktaker>();
    private final Map<String, IUiObserver> observers = new ConcurrentHashMap<String, IUiObserver>();

    public TaskWorkerManager() {
        this.workers.put(DEFAULT_WORKER_ID, new InspectWorktaker());
    }

    public synchronized InspectWorktaker registerTask(String taskId) throws ToolException {
        if (this.observers.containsKey(taskId) && !this.getUiObserver(taskId).isFinished()) {
            throw new ToolException("Task " + taskId + "exist,and is running");
        }
        return this.workers.computeIfAbsent(taskId, key -> new InspectWorktaker(taskId));
    }

    public void clearTaskWorker(String taskId) {
        Optional.ofNullable(this.workers.remove(taskId)).ifPresent(HashMap::clear);
    }

    public Optional<InspectWorktaker> getTaskWorker(String taskId) {
        return Optional.ofNullable(this.workers.get(taskId));
    }

    public CompletableFuture<Void> submitTask(StartInspectParams params) throws ToolException {
        InspectWorktaker workTaker = this.workers.get(params.getTaskId());
        IUiObserver uiObserver = this.initUiObserver(workTaker, params.getTaskId());
        return this.submitTask(params, uiObserver);
    }

    private IUiObserver initUiObserver(InspectWorktaker workTaker, String taskId) throws ToolException {
        if (this.observers.containsKey(taskId) && !this.observers.get(taskId).isFinished()) {
            throw new ToolException("inspector.background.process.running");
        }
        IUiObserver uiObserver = this.updateUiObserver(taskId, workTaker);
        uiObserver.init();
        return uiObserver;
    }

    private CompletableFuture<Void> submitTask(StartInspectParams params, IUiObserver uiObserver) {
        ITaskExecutor executor = this.buildTaskExecutor(params, uiObserver);
        long submitTime = System.currentTimeMillis();
        return CompletableFuture.runAsync(executor::execute, this.pool).exceptionally(throwable -> this.handleException(executor, uiObserver, (Throwable)throwable, submitTime));
    }

    public boolean hasTaskRunning() {
        return !this.observers.values().stream().allMatch(IUiObserver::isFinished);
    }

    public boolean isTaskRunning(String taskId) {
        return this.observers.containsKey(taskId) && !this.observers.get(taskId).isFinished();
    }

    @NonNull
    ITaskExecutor buildTaskExecutor(StartInspectParams params, IUiObserver uiObserver) {
        InspectWorktaker workTaker = this.workers.get(params.getTaskId());
        return new DistributedTaskExecutor(workTaker, uiObserver, params, workTaker.getResultTempDir());
    }

    private Void handleException(ITaskExecutor executor, IUiObserver uiObserver, Throwable ex, long submitTime) {
        log.error("Inspect task {} error", (Object)executor, (Object)ex);
        uiObserver.updateAllStatus(InspectStatus.EXEFALID);
        SwingUtilities.invokeLater(() -> uiObserver.finishAll(System.currentTimeMillis() - submitTime));
        return null;
    }

    public void clearAll() {
        this.workers.clear();
        this.observers.clear();
    }

    IUiObserver updateUiObserver(String taskId, InspectWorktaker workTaker) {
        TaskRunningObserver uiObserver = new TaskRunningObserver(workTaker);
        this.observers.put(taskId, uiObserver);
        return uiObserver;
    }

    IUiObserver getUiObserver(String taskId) {
        return this.observers.get(taskId);
    }

    void destroy() {
        this.clearAll();
        this.pool.shutdownNow();
    }
}

