/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.switchcheck.check.impl;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.inspect.fit.switchcheck.check.ISwitchCheckService;
import com.huawei.ism.tool.inspect.fit.switchcheck.constants.SwitchCheckConstants;
import com.huawei.ism.tool.inspect.fit.switchcheck.entity.SwitchCheckResult;
import com.huawei.ism.tool.inspect.fit.util.SwitchCheckUtil;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.SwitchNode;
import com.huawei.ism.tool.obase.entity.SwitchPort;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchCheckService
implements ISwitchCheckService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchCheckService.class);
    private long checkTimeOut = TimeUnit.MINUTES.toMillis(30L);
    private final SftpConnector sftpConnector;
    private final ICliConnection ssh;
    private final List<ResourceBundle> resourceBundles;
    private final String authedIp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SwitchCheckResult> batchCheckSwitch(List<SwitchNode> switchNodes) {
        try {
            SwitchCheckUtil.uploadPyScript(this.sftpConnector, this.ssh);
            List<SwitchCheckResult> list = this.doCheck(switchNodes);
            return list;
        }
        catch (ToolException exception) {
            log.error("upload script error", (Throwable)exception);
            List<SwitchCheckResult> list = Collections.singletonList(SwitchCheckResult.builder().errorCode("1").errorMsg(exception.getDes()).build());
            return list;
        }
        catch (IsmException | EncapsulatedRuntimeException exception) {
            log.error("upload script error", exception);
            List<SwitchCheckResult> list = Collections.singletonList(SwitchCheckResult.builder().errorCode("1").errorMsg(ResourceUtil.getStringWithParams((String)"upload.script.error", (Object[])new Object[]{this.authedIp})).build());
            return list;
        }
        finally {
            SwitchCheckUtil.deleteResultDir(this.ssh);
            SwitchCheckUtil.deleteServerFile(this.ssh);
        }
    }

    private List<SwitchCheckResult> doCheck(List<SwitchNode> switchNodes) {
        return switchNodes.stream().map(this::execCheckCmd).collect(Collectors.toList());
    }

    private SwitchCheckResult execCheckCmd(SwitchNode node) {
        CompletableFuture.runAsync(() -> this.runCheckCmd(node));
        return this.waitForResult(node);
    }

    private void runCheckCmd(SwitchNode node) {
        try {
            this.ssh.execCmdNoLog(this.buildExecCmd(node));
        }
        catch (ToolException toolException) {
            log.error("run check for switch :{} error", (Object)node.getIp(), (Object)toolException);
        }
    }

    @NotNull
    private String buildExecCmd(SwitchNode node) {
        return String.join((CharSequence)";", this.buildCheckCmd(node), SwitchCheckService.buildMoveCmd(node), this.buildChangeOwnCmd());
    }

    @NotNull
    private String buildChangeOwnCmd() {
        return String.format(Locale.ROOT, "chown -R %s %s", this.sftpConnector.getLoginUser(), "/tmp/rdma_check");
    }

    @NotNull
    private static String buildMoveCmd(SwitchNode node) {
        return String.format(Locale.ROOT, "mv %s %s/", SwitchCheckUtil.buildResultWithIp("/var/log/rdma_check/rdma_check_switch_%s.json", node.getIp()), "/tmp/rdma_check");
    }

    @NotNull
    private String buildCheckCmd(SwitchNode node) {
        return String.format(Locale.ROOT, "{\npython %s -i %s -u %s -f %s -c <<\\EOF\n%s\nEOF\n}", "/tmp/rdma_check_switch.py", node.getIp(), node.getUser().getUserName(), this.buildCheckPort(node.getSwitchPort()), node.getUser().getPassword());
    }

    private String buildCheckPort(List<SwitchPort> switchPort) {
        return switchPort.stream().filter(SwitchPort::isSelected).map(SwitchPort::getPortName).collect(Collectors.joining(" "));
    }

    private SwitchCheckResult waitForResult(SwitchNode node) {
        try {
            Optional<File> file = this.downloadResultFile(node);
            if (!file.isPresent()) {
                return this.handleCheckFail(node);
            }
            String content = FileUtils.readFileToString((File)file.get(), (Charset)StandardCharsets.UTF_8);
            return this.parseResult(node, content);
        }
        catch (IOException e) {
            log.error("read result file error", (Throwable)e);
            return this.handleCheckFail(node);
        }
    }

    private SwitchCheckResult parseResult(SwitchNode node, String content) {
        JSONArray jsonArray = new JSONArray(content);
        SwitchCheckResult.SwitchCheckResultBuilder builder = SwitchCheckResult.builder().ip(node.getIp());
        String errorMsg = this.buildErrorMsg(jsonArray);
        if (StringUtils.isNULLStr((String)errorMsg)) {
            return builder.errorCode("0").build();
        }
        return builder.errorCode("1").errorMsg(errorMsg).build();
    }

    private Optional<File> downloadResultFile(SwitchNode node) {
        long startTime = System.currentTimeMillis();
        Optional<File> file;
        while (!(file = SwitchCheckUtil.downResultFile(this.sftpConnector, SwitchCheckUtil.buildResultWithIp("/tmp/rdma_check/rdma_check_switch_%s.json", node.getIp()), SwitchCheckUtil.buildResultWithIp(SwitchCheckConstants.CHECK_RESULT_FILE, node.getIp()))).isPresent() && !this.isTimeout(startTime)) {
            this.sleepNoException();
        }
        return file;
    }

    private void sleepNoException() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            log.error("sleep error", (Throwable)interruptedException);
        }
    }

    private boolean isTimeout(long startTime) {
        return System.currentTimeMillis() - startTime > this.checkTimeOut;
    }

    private String buildErrorMsg(JSONArray jsonArray) {
        return IntStream.range(0, jsonArray.length()).mapToObj(index -> this.buildErrorMsg(jsonArray.getJSONObject(index))).filter(errorMsg -> !StringUtils.isNULLStr((String)errorMsg)).collect(Collectors.joining("\n"));
    }

    private String buildErrorMsg(JSONObject resultObj) {
        String resultCode = resultObj.getStringOrDefault("resultCode", "0");
        if ("0".equals(resultCode)) {
            return "";
        }
        String checkItemId = resultObj.getStringOrDefault("checkItemId", "");
        return com.huawei.ism.tool.base.utils.StringUtils.fillValues((String)this.getResource(checkItemId), (Object[])new Object[]{this.getPortsMsg(resultObj.getJSONArray("errorPort"))});
    }

    private String getPortsMsg(JSONArray errorPort) {
        return IntStream.range(0, errorPort.length()).mapToObj(arg_0 -> ((JSONArray)errorPort).getString(arg_0)).collect(Collectors.joining(","));
    }

    private String getResource(String checkItemId) {
        ResourceBundle resourceBundle;
        if (CollectionUtil.isEmpty(this.resourceBundles)) {
            return checkItemId;
        }
        String resource = "--";
        Iterator<ResourceBundle> iterator = this.resourceBundles.iterator();
        while (iterator.hasNext() && "--".equals(resource = (resourceBundle = iterator.next()).getString(checkItemId))) {
        }
        if ("--".equals(resource)) {
            resource = checkItemId;
        }
        return resource;
    }

    private SwitchCheckResult handleCheckFail(SwitchNode node) {
        return SwitchCheckResult.builder().ip(node.getIp()).errorCode("1").errorMsg(ResourceUtil.getString((String)"download.result.error")).build();
    }

    @Generated
    public SwitchCheckService(SftpConnector sftpConnector, ICliConnection ssh, List<ResourceBundle> resourceBundles, String authedIp) {
        this.sftpConnector = sftpConnector;
        this.ssh = ssh;
        this.resourceBundles = resourceBundles;
        this.authedIp = authedIp;
    }

    @Generated
    public void setCheckTimeOut(long checkTimeOut) {
        this.checkTimeOut = checkTimeOut;
    }
}

