/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.switchcheck.login.impl;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.inspect.fit.switchcheck.constants.SwitchCheckConstants;
import com.huawei.ism.tool.inspect.fit.switchcheck.login.ILoginSwitchService;
import com.huawei.ism.tool.inspect.fit.util.SwitchCheckUtil;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.SwitchNode;
import com.huawei.ism.tool.obase.entity.SwitchPort;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SwitchLoginInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginSwitchService
implements ILoginSwitchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginSwitchService.class);
    private final SftpConnector sftpConnector;
    private final ICliConnection ssh;
    private final String authIp;

    @Override
    public List<SwitchNode> batchLoginSwitch(List<SwitchLoginInfo> switchLoginInfos) throws ToolException {
        try {
            SwitchCheckUtil.uploadPyScript(this.sftpConnector, this.ssh);
            List<SwitchNode> list = this.doLogin(switchLoginInfos);
            return list;
        }
        catch (IsmException | EncapsulatedRuntimeException toolException) {
            log.error("upload file error", toolException);
            throw new ToolException("upload.script.error", (Object[])new String[]{this.authIp});
        }
        finally {
            SwitchCheckUtil.deleteResultDir(this.ssh);
            SwitchCheckUtil.deleteServerFile(this.ssh);
        }
    }

    private List<SwitchNode> doLogin(List<SwitchLoginInfo> switchLoginInfos) {
        if (!this.execCmd(this.buildLoginBatchCmd(switchLoginInfos))) {
            return switchLoginInfos.stream().map(this::buildAuthFailInfo).collect(Collectors.toList());
        }
        if (!this.execCmd(this.buildMoveBatchCmd(switchLoginInfos))) {
            return switchLoginInfos.stream().map(this::buildAuthFailInfo).collect(Collectors.toList());
        }
        this.execCmd(this.buildChangeOwnCmd());
        return switchLoginInfos.stream().map(this::waitForLoginResult).collect(Collectors.toList());
    }

    @NotNull
    private String buildLoginBatchCmd(List<SwitchLoginInfo> switchLoginInfos) {
        return String.join((CharSequence)" & ", switchLoginInfos.stream().map(this::buildLoginCmd).collect(Collectors.joining(" & ")), "wait");
    }

    @NotNull
    private String buildMoveBatchCmd(List<SwitchLoginInfo> switchLoginInfos) {
        return String.join((CharSequence)" & ", switchLoginInfos.stream().map(this::buildMoveCmd).collect(Collectors.joining(" & ")), "wait");
    }

    private boolean execCmd(String cmd) {
        try {
            this.ssh.execCmdNoLog(cmd);
            return true;
        }
        catch (ToolException toolException) {
            log.error("login failed with error", (Throwable)toolException);
            return false;
        }
    }

    @NotNull
    private String buildChangeOwnCmd() {
        return String.format(Locale.ROOT, "chown -R %s %s", this.sftpConnector.getLoginUser(), "/tmp/rdma_check");
    }

    @NotNull
    private String buildMoveCmd(SwitchLoginInfo info) {
        return String.format(Locale.ROOT, "mv %s %s/", SwitchCheckUtil.buildResultWithIp("/var/log/rdma_check/switch_ports_%s.json", info.getIp()), "/tmp/rdma_check");
    }

    @NotNull
    private String buildLoginCmd(SwitchLoginInfo info) {
        return String.format(Locale.ROOT, "{\npython %s -i %s -u %s -l <<\\EOF\n%s\nEOF\n}", "/tmp/rdma_check_switch.py", info.getIp(), info.getUsername(), info.getPassword());
    }

    private SwitchNode buildAuthFailInfo(SwitchLoginInfo info) {
        return SwitchNode.builder().ip(info.getIp()).auth(false).build();
    }

    private SwitchNode waitForLoginResult(SwitchLoginInfo info) {
        Optional<File> result = SwitchCheckUtil.downResultFile(this.sftpConnector, SwitchCheckUtil.buildResultWithIp("/tmp/rdma_check/switch_ports_%s.json", info.getIp()), SwitchCheckUtil.buildResultWithIp(SwitchCheckConstants.LOCAL_LOGIN_RESULT_FILE, info.getIp()));
        if (!result.isPresent()) {
            return this.buildAuthFailInfo(info);
        }
        try {
            String content = FileUtils.readFileToString((File)result.get(), (Charset)StandardCharsets.UTF_8);
            JSONObject jsonObject = new JSONObject(content);
            if (!"0".equals(jsonObject.getStringOrDefault("resultCode", "1"))) {
                return this.buildAuthFailInfo(info);
            }
            JSONObject data = jsonObject.getJSONObject("data");
            return SwitchNode.builder().ip(info.getIp()).model(data.getStringOrDefault("type", "")).version(data.getStringOrDefault("version", "")).auth(true).switchPort(this.buildSwitchPort(data.getJSONArray("ports"))).user(new User(info.getUsername(), info.getPassword())).build();
        }
        catch (IOException e) {
            log.error("read file error", (Throwable)e);
            return this.buildAuthFailInfo(info);
        }
    }

    private List<SwitchPort> buildSwitchPort(JSONArray ports) {
        return IntStream.range(0, ports.length()).mapToObj(index -> this.buildSwitchPortVO(ports.getJSONObject(index))).sorted(this::sortWithPortName).collect(Collectors.toList());
    }

    private int sortWithPortName(SwitchPort port, SwitchPort otherPort) {
        int statusCompare = port.getStatus().compareTo(otherPort.getStatus());
        if (statusCompare != 0) {
            return -statusCompare;
        }
        return this.compareName(port.getPortName(), otherPort.getPortName());
    }

    private int compareName(String portName, String otherPortName) {
        String[] port = portName.split("/");
        String[] otherPort = otherPortName.split("/");
        for (int index = 0; index < port.length; ++index) {
            if (otherPort.length <= index) {
                return -1;
            }
            String portSplit = port[index];
            String otherSplit = otherPort[index];
            try {
                int compare = Integer.parseInt(portSplit) - Integer.parseInt(otherSplit);
                if (compare == 0) continue;
                return compare;
            }
            catch (NumberFormatException e) {
                int compare = portSplit.compareTo(otherSplit);
                if (compare == 0) continue;
                return compare;
            }
        }
        return 0;
    }

    private SwitchPort buildSwitchPortVO(JSONObject port) {
        return SwitchPort.builder().portName(port.getStringOrDefault("portName", "")).status(port.getStringOrDefault("status", "down")).selected(!"down".equals(port.getStringOrDefault("status", "down"))).build();
    }

    @Generated
    public LoginSwitchService(SftpConnector sftpConnector, ICliConnection ssh, String authIp) {
        this.sftpConnector = sftpConnector;
        this.ssh = ssh;
        this.authIp = authIp;
    }
}

