/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.util;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstorageAfterCheckConfig;
import com.huawei.ism.tool.inspect.entity.DstoragePreCheckConfig;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.fit.service.task.TaskWorkerManager;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.logic.config.TagCondition;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ExpansionTaskUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.entity.ItemInfo;
import com.huawei.json.JSONUtils;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.item.entity.CheckItemDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.item.entity.DeviceCheckItemTreeNodeDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class CheckDevNodeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckDevNodeUtil.class);
    @Fit
    private final TaskWorkerManager workerManager;

    @NotNull
    public DeviceCheckItemTreeNodeDTO getDeviceCheckItemTreeNodeDto(String taskId, String devId, String scene) throws ToolException {
        Optional<InspectWorktaker> taskWorker = this.workerManager.getTaskWorker(taskId);
        if (!taskWorker.isPresent()) {
            throw new ToolException("Task execution exception.");
        }
        return this.buildDeviceCheckItemTreeNodeDto(taskId, devId, scene, taskWorker.get());
    }

    private DeviceCheckItemTreeNodeDTO buildDeviceCheckItemTreeNodeDto(String taskId, String devId, String scene, InspectWorktaker workTaker) throws ToolException {
        List<CheckItemDTO> checkItemDtos = this.buildCheckItemDto(taskId, devId, scene, workTaker);
        return DeviceCheckItemTreeNodeDTO.builder().checkItemDTO(checkItemDtos).build();
    }

    @NotNull
    private List<CheckItemDTO> buildCheckItemDto(String taskId, String devId, String scene, InspectWorktaker workTaker) throws ToolException {
        DevNode devNode = new DevUtil(this.workerManager).findDevNode(taskId, devId);
        workTaker.put("select_dev_nodes", Collections.singletonList(devNode));
        List<CheckDevNode> checkDevNodes = workTaker.loadProductConfigByDevNode();
        HashSet<CheckItemDTO> checkItemDtos = new HashSet<CheckItemDTO>(this.getCheckItemDtoFromDevNode(scene, checkDevNodes));
        this.updateCheckItemDtosWithLocal(checkItemDtos, this.getCheckItemInfoFromLocal(scene, devNode));
        return new ArrayList<CheckItemDTO>(checkItemDtos);
    }

    private void updateCheckItemDtosWithLocal(Set<CheckItemDTO> checkItemDtos, List<ItemInfo> localItemInfos) {
        localItemInfos.forEach(localItemInfo -> this.buildLocalItem(checkItemDtos, (ItemInfo)localItemInfo));
    }

    private void buildLocalItem(Set<CheckItemDTO> checkItemDtos, ItemInfo localItemInfo) {
        String layerDescription = localItemInfo.getLayer();
        CheckItemDTO parentByLayer = this.getParentByLayer(checkItemDtos, layerDescription);
        CheckItemDTO checkItemDTO = this.creatCheckItemDto(localItemInfo, parentByLayer);
        checkItemDtos.add(checkItemDTO);
    }

    private CheckItemDTO getParentByLayer(Set<CheckItemDTO> checkItemDtos, String layerDescription) {
        return checkItemDtos.stream().filter(checkItemDTO -> checkItemDTO.getDescription().equals(layerDescription)).findFirst().orElseGet(this.buildNewParent(checkItemDtos, layerDescription));
    }

    private Supplier<? extends CheckItemDTO> buildNewParent(Set<CheckItemDTO> checkItemDtos, String layerDescription) {
        return () -> {
            CheckItemDTO parent = CheckItemDTO.builder().description(layerDescription).id(layerDescription).selected(Boolean.valueOf(true)).build();
            checkItemDtos.add(parent);
            return parent;
        };
    }

    private List<CheckItemDTO> getCheckItemDtoFromDevNode(String scene, List<CheckDevNode> checkDevNodes) {
        ArrayList<CheckItemDTO> itemDTOS = new ArrayList<CheckItemDTO>();
        for (CheckDevNode checkDevNode : checkDevNodes) {
            itemDTOS.addAll(checkDevNode.getDstorageCheckItemsByScene(scene).entrySet().stream().filter(entry -> !CollectionUtil.isEmpty((Collection)((Collection)entry.getValue()))).flatMap(entry -> this.getCheckItemDtoFromMap(checkDevNode, (Map.Entry<String, List<CheckItem>>)entry, this.buildParentCheckItem((Map.Entry<String, List<CheckItem>>)entry)).stream()).collect(Collectors.toList()));
        }
        return itemDTOS;
    }

    @NotNull
    private List<CheckItemDTO> getCheckItemDtoFromMap(CheckDevNode checkDevNode, Map.Entry<String, List<CheckItem>> entry, CheckItemDTO parentItem) {
        return entry.getValue().stream().filter(this::hasNoHiddenTagByScene).filter(item -> this.isNotHiddenItem(checkDevNode.getDevNode(), item.getItemId())).map(item -> this.buildCheckItemDto(parentItem, (CheckItem)item)).collect(Collectors.toList());
    }

    private boolean hasNoHiddenTagByScene(CheckItem checkItem) {
        String subScene = JSONUtils.jsonToMaps((String)System.getenv("jsonScene")).getOrDefault("subScene", "").toString();
        return !TagCondition.hasTag(checkItem.getTag(), "HIDDEN") && !String.format(Locale.ENGLISH, "%s_%s", subScene, "CANCEL").equals(checkItem.getTag());
    }

    private boolean isNotHiddenItem(DevNode devNode, String itemId) {
        return !DstoragePreCheckConfig.INS.isHiddenItem(devNode, itemId) && !DstorageAfterCheckConfig.INS.isHiddenItem(devNode, itemId) && !this.isGlobalSceneBlockItemFromLocal(devNode, itemId);
    }

    private boolean isGlobalSceneBlockItemFromLocal(DevNode devNode, String itemId) {
        if (!InspectContext.getInstance().isNfvMode()) {
            return false;
        }
        List<Map<String, List<String>>> displayItemsMap = ExpansionTaskUtils.getDisplayItemsMap(devNode);
        List globalBlockItems = displayItemsMap.stream().map(itemMap -> new ArrayList(itemMap.getOrDefault("bureau_check_nfv", Collections.emptyList()))).flatMap(Collection::stream).collect(Collectors.toList());
        return globalBlockItems.contains(itemId);
    }

    @NotNull
    private CheckItemDTO buildParentCheckItem(Map.Entry<String, List<CheckItem>> entry) {
        CheckItemDTO checkItemDTOParent = new CheckItemDTO();
        checkItemDTOParent.setId(entry.getKey());
        checkItemDTOParent.setDescription(entry.getKey());
        checkItemDTOParent.setSelected(Boolean.valueOf(true));
        return checkItemDTOParent;
    }

    @NotNull
    private CheckItemDTO buildCheckItemDto(CheckItemDTO parenItem, CheckItem item) {
        CheckItemDTO childItem = new CheckItemDTO();
        childItem.setId(item.getItemId());
        childItem.setDescription(item.getName());
        childItem.setParent(parenItem);
        childItem.setSelected(Boolean.valueOf(item.isEnable()));
        return childItem;
    }

    public List<ItemInfo> getCheckItemInfoFromLocal(String scene, DevNode devNode) throws ToolException {
        DstoragePatchInfo bestMatchPatch = Context.INS.findBestMatchPatch(devNode, DstoragePatchInfo.Type.INSPECT);
        if (Objects.isNull(bestMatchPatch) && InspectContext.getInstance().isNfvMode()) {
            throw new ToolException("inspector.patch.config.nfv.not.found");
        }
        return this.getItemByMode(bestMatchPatch).stream().filter(itemInfo -> Objects.nonNull(itemInfo.getScenes())).filter(itemInfo -> itemInfo.getScenes().contains(InspectScene.of(scene).getItemScene())).filter(itemInfo -> this.isNotHiddenItem(devNode, itemInfo.getItem())).collect(Collectors.toList());
    }

    private List<ItemInfo> getItemByMode(DstoragePatchInfo bestMatchPatch) {
        return InspectContext.getInstance().isNfvMode() ? bestMatchPatch.getNfvItemInfos() : bestMatchPatch.getItemInfos();
    }

    private CheckItemDTO creatCheckItemDto(ItemInfo itemInfo, CheckItemDTO parentCheckItem) {
        return CheckItemDTO.builder().id(itemInfo.getItem()).description(StringEscapeUtils.unescapeJava((String)itemInfo.getDescription())).selected(Boolean.valueOf(true)).parent(parentCheckItem).build();
    }

    @Generated
    public CheckDevNodeUtil(TaskWorkerManager workerManager) {
        this.workerManager = workerManager;
    }
}

