/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.util;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.fit.entity.task.ResultStatus;
import com.huawei.ism.tool.inspect.fit.service.expansion.ExpansionConfigManager;
import com.huawei.ism.tool.inspect.fit.util.SwitchCheckUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.yinglong.drop.entity.storage.entity.MultiStroageNodeDto;
import com.huawei.yinglong.drop.entity.storage.entity.StorageNodeDto;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

@Fitable
public class ClusterDtoBuilder {
    @Fit
    private final ExpansionConfigManager manager;

    public MultiStroageNodeDto builder(String taskId, List<DevNode> nodes, InspectScene inspectScene) {
        if (inspectScene == InspectScene.DISTRIBUTED_EXPANSION) {
            return MultiStroageNodeDto.builder().stroageNodeDto(this.buildExpansionClusterDto(taskId, nodes)).build();
        }
        if (inspectScene == InspectScene.BUREAU_CHECK) {
            return MultiStroageNodeDto.builder().stroageNodeDto(this.buildBureauClusterDto(nodes)).build();
        }
        return MultiStroageNodeDto.builder().stroageNodeDto(this.buildNormalClusterDto(nodes)).build();
    }

    private List<StorageNodeDto> buildNormalClusterDto(List<DevNode> nodes) {
        return nodes.stream().map(this::buildNormalClusterDto).collect(Collectors.toList());
    }

    private StorageNodeDto buildNormalClusterDto(DevNode node) {
        return ClusterDtoBuilder.buildStorageNodeDtoBasic(node).status("").build();
    }

    private List<StorageNodeDto> buildBureauClusterDto(List<DevNode> nodes) {
        return nodes.stream().map(this::buildBureauClusterDto).collect(Collectors.toList());
    }

    private StorageNodeDto buildBureauClusterDto(DevNode node) {
        return ClusterDtoBuilder.buildStorageNodeDtoBasic(node).productVersion(node.getProductVersionToShow()).status("").build();
    }

    private List<StorageNodeDto> buildExpansionClusterDto(String taskId, List<DevNode> nodes) {
        return nodes.stream().map(node -> this.buildExpansionClusterDto(taskId, (DevNode)node)).collect(Collectors.toList());
    }

    private StorageNodeDto buildExpansionClusterDto(String taskId, DevNode node) {
        String splicing = this.manager.splicing(taskId, node.getDevKey());
        return ClusterDtoBuilder.buildStorageNodeDtoBasic(node).status(this.manager.hasConfig(splicing) ? ResultStatus.CONFIGURED.getKey() : ResultStatus.NOT_CONFIGURED.getKey()).build();
    }

    private static StorageNodeDto.StorageNodeDtoBuilder buildStorageNodeDtoBasic(DevNode node) {
        return StorageNodeDto.builder().id(node.getDevKey()).ip(node.getIp()).name(node.getDeviceName()).sn(node.getDeviceSerialNumber()).productModel(node.getProductModel()).productVersion(node.getProductVersion()).sn(node.getDeviceSerialNumber()).needSwitchCheck(Boolean.valueOf(SwitchCheckUtil.isNeedSwitchCheck(node)));
    }

    @Generated
    public ClusterDtoBuilder(ExpansionConfigManager manager) {
        this.manager = manager;
    }
}

