/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.util;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.FusionCubeInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.fit.service.device.auth.entity.AuthStatusEnum;
import com.huawei.ism.tool.inspect.fit.service.task.TaskWorkerManager;
import com.huawei.ism.tool.inspect.fit.util.filter.InspectNodeFilter;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.rest.service.device.SshProxyConfigService;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.AuthStatus;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.MultiBmcAuthParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.MultiOsAuthParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Cluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class DevUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DevUtil.class);
    private static final int DSTORAGE_REST_PORT = 8088;
    @Fit
    private final TaskWorkerManager workerManager;

    public DevNode findDevNode(String taskId, String devId) {
        InspectWorktaker workTaker = this.workerManager.getTaskWorker(taskId).get();
        List devNodes = (List)workTaker.get("supported_device");
        return devNodes.stream().filter(dev -> dev.getDevKey().equals(devId)).findFirst().get();
    }

    public List<ClusterNode> findTargetClusterNode(String taskId, String devId, List<String> clusterNodeUids) {
        DevNode cluster = this.findDevNode(taskId, devId);
        return cluster.getClusterNodes().stream().filter(clusterNode -> clusterNodeUids.contains(DevUtil.getClusterNodeUid(cluster, clusterNode))).collect(Collectors.toList());
    }

    public Optional<ClusterNode> findTargetClusterNode(String taskId, String devId, String uid) {
        DevNode cluster = this.findDevNode(taskId, devId);
        return cluster.getClusterNodes().stream().filter(clusterNode -> uid.equals(DevUtil.getClusterNodeUid(cluster, clusterNode))).findFirst();
    }

    public CheckDevNode findCheckDevNode(String taskId, String devId) throws ToolException {
        InspectWorktaker workTaker = this.workerManager.getTaskWorker(taskId).get();
        return workTaker.findCheckDevNode(devId);
    }

    public List<CheckDevNode> findAllCheckDevNodes(String taskId) {
        InspectWorktaker workTaker = this.workerManager.getTaskWorker(taskId).get();
        return (List)workTaker.get("check_dev_nodes");
    }

    public boolean initDistributedDevNode(DevNode devNode) throws ToolException {
        return this.initDistributedDevNode(devNode, false);
    }

    public boolean initDistributedDevNode(DevNode devNode, boolean hasDirectPlanes) throws ToolException {
        String sn;
        if (!this.isDistributed(devNode)) {
            return false;
        }
        boolean executeInit = false;
        List nodes = devNode.getClusterNodes();
        if (nodes == null || nodes.isEmpty()) {
            TaskResult taskResult;
            if (devNode.isFusionCube()) {
                devNode.setProductSubModel("");
                FusionCubeInfoQryServiceImpl restQueryService = new FusionCubeInfoQryServiceImpl();
                taskResult = restQueryService.queryNodeInfo(devNode, DeviceOpr.ADD, null);
            } else {
                DSstorageInfoQryServiceImpl restQueryService = new DSstorageInfoQryServiceImpl();
                restQueryService.setQueryDirectPlanes(hasDirectPlanes);
                taskResult = restQueryService.queryNodeInfo(devNode, DeviceOpr.ADD, null);
            }
            if (taskResult.getResult() != TaskResult.Result.SUCCESS) {
                throw new ToolException("inspsctor.wizard.fs.select.dev.query.node.error", new Object[]{devNode.getIp()});
            }
            executeInit = true;
        }
        if (!(sn = devNode.getDeviceSerialNumber()).equals(devNode.getDeviceSerialNumber())) {
            log.warn("Dev {} sn is change.", (Object)devNode.getIp());
            devNode.setDeviceSerialNumber(sn);
            devNode.getClusterNodes().clear();
            devNode.setErrorDecs("sn_change_err");
            throw new ToolException("Device sn is change.");
        }
        return executeInit;
    }

    public void bindSelectedClusterNodes(DevNode node, List<String> selectedClusterNodeIds) {
        if (!this.isDistributed(node)) {
            return;
        }
        if (selectedClusterNodeIds.isEmpty()) {
            log.info("Dev {} selected all storage cluster node", (Object)node.getIp());
            node.getClusterNodes().stream().peek(clusterNode -> clusterNode.setSelected(false)).filter(clusterNode -> clusterNode.includedStorageService() || clusterNode.includeManagementRole()).forEach(clusterNode -> clusterNode.setSelected(true));
            return;
        }
        node.getClusterNodes().stream().peek(clusterNode -> clusterNode.setSelected(false)).filter(clusterNode -> DevUtil.isTargetClusterNode(node, selectedClusterNodeIds, clusterNode)).forEach(clusterNode -> clusterNode.setSelected(true));
    }

    private static boolean isTargetClusterNode(DevNode node, List<String> selectedClusterNodeIds, ClusterNode clusterNode) {
        if (clusterNode.isDirectPlanesNode()) {
            log.warn("data cluster node ({}) no need to inspect.", (Object)clusterNode.getBmcIp());
            return false;
        }
        return selectedClusterNodeIds.contains(String.valueOf(clusterNode.getId())) || selectedClusterNodeIds.contains(DevUtil.getClusterNodeUid(node, clusterNode));
    }

    public List<DevNode> getAllSupportedDevs(InspectWorktaker workTaker, InspectScene scene) {
        InspectNodeFilter supportFilter = new InspectNodeFilter(scene);
        List<DevNode> supportDevs = this.filterSupportedDevs(supportFilter);
        workTaker.put("supported_device", supportDevs);
        return supportDevs;
    }

    private List<DevNode> getDevNodesInExpansion(InspectWorktaker workTaker, InspectScene scene) {
        InspectNodeFilter supportFilter = new InspectNodeFilter(scene);
        if (workTaker.containsKey("supported_device")) {
            return (List)workTaker.get("supported_device");
        }
        List<DevNode> supportDevs = this.filterSupportedDevsInCopy(supportFilter).collect(Collectors.toList());
        workTaker.put("supported_device", supportDevs);
        return supportDevs;
    }

    @NonNull
    private Stream<DevNode> filterSupportedDevsInCopy(INodeSupport supportFilter) {
        return ((Stream)DefaultNodeProviderImpl.getInstance().getNodeList().stream().parallel()).map(EntityUtils::toNewDev).filter(arg_0 -> ((INodeSupport)supportFilter).isNodeSupport(arg_0)).map(EntityUtils::toOldDev).peek(this::updateProductModel);
    }

    @NonNull
    private List<DevNode> filterSupportedDevs(INodeSupport supportFilter) {
        return ((Stream)DefaultNodeProviderImpl.getInstance().getNodeList().stream().parallel()).filter(devNode -> supportFilter.isNodeSupport(EntityUtils.toNewDev((DevNode)devNode))).peek(this::updateProductModel).collect(Collectors.toList());
    }

    private void updateProductModel(DevNode devNode) {
        if (!StringUtils.isNULLStr((String)devNode.getProductModel())) {
            return;
        }
        devNode.setProductModel(devNode.getDeviceType() != null ? devNode.getDeviceType().toString() : "--");
    }

    public static DevNode buildBmcDevNode(Server server, MultiBmcAuthParams param) {
        DevNode bmcNode = new DevNode();
        bmcNode.setIp(server.getBmcIp());
        bmcNode.setLoginUser(new User(param.getLoginUser().getName(), param.getLoginUser().getPwd()));
        bmcNode.setDeviceSerialNumber(server.getUid());
        bmcNode.setPort(param.getPort().intValue());
        bmcNode.setRedFishPort(String.valueOf(param.getPort()));
        return bmcNode;
    }

    public static DevNode buildOsDevNode(Server server, MultiOsAuthParams param) {
        DevNode osNode = new DevNode();
        osNode.setIp(server.getOsIp());
        osNode.setLoginUser(new User(param.getLoginUser().getName(), param.getLoginUser().getPwd()));
        if (param.getRootUser() != null) {
            osNode.setRootUser(new User(param.getRootUser().getName(), Base64EncodeUtils.encode((String)param.getRootUser().getPwd())));
        }
        osNode.setDeviceSerialNumber(server.getUid());
        osNode.setPort(param.getPort().intValue());
        if (!StringUtils.isNULLStr((String)param.getProxyNodeId())) {
            osNode.setSshForwardList(SshProxyConfigService.INS.getSSHRouteList(param.getProxyNodeId()));
        }
        return osNode;
    }

    public static DevNode buildOsDevNode(Server server, int port) {
        DevNode osNode = new DevNode();
        osNode.setIp(server.getOsIp());
        DevUtil.buildLoginUser(osNode, server);
        if (server.getOsRootUser() != null) {
            User rootUser = new User();
            rootUser.setUserName(server.getOsRootUser().getName());
            rootUser.setEcptPassword(server.getOsRootUser().getPwd());
            osNode.setRootUser(rootUser);
        }
        osNode.setDeviceSerialNumber(server.getUid());
        osNode.setPort(port);
        return osNode;
    }

    public static DevNode buildOsNodeWithNewPwd(Server server, int port) {
        DevNode osNode = new DevNode();
        osNode.setIp(server.getOsIp());
        DevUtil.buildLoginUserWithNewPwd(osNode, server);
        if (server.getOsRootUser() != null) {
            User rootUser = new User();
            rootUser.setUserName(server.getOsRootUser().getName());
            rootUser.setEcptPassword(server.getOsRootUser().getNewPwd());
            osNode.setRootUser(rootUser);
        }
        osNode.setDeviceSerialNumber(server.getUid());
        osNode.setPort(port);
        return osNode;
    }

    private static void buildLoginUserWithNewPwd(DevNode devNode, Server server) {
        if ((server.getOsUser() == null || StringUtils.isNULLStr((String)server.getOsUser().getName())) && server.getOsRootUser() != null) {
            User loginUser = new User();
            loginUser.setUserName(server.getOsRootUser().getName());
            loginUser.setPassword(DevUtil.getRootNewPwdIfExist(server));
            devNode.setLoginUser(loginUser);
            return;
        }
        User loginUser = new User();
        loginUser.setUserName(server.getOsUser().getName());
        loginUser.setEcptPassword(DevUtil.getNewPwdIfExist(server));
        devNode.setLoginUser(loginUser);
    }

    private static void buildLoginUser(DevNode devNode, Server server) {
        if ((server.getOsUser() == null || StringUtils.isNULLStr((String)server.getOsUser().getName())) && server.getOsRootUser() != null) {
            User loginUser = new User();
            loginUser.setUserName(server.getOsRootUser().getName());
            loginUser.setPassword(Base64EncodeUtils.decode((String)AESEncrypt.decrypt((String)server.getOsRootUser().getPwd())));
            devNode.setLoginUser(loginUser);
            return;
        }
        User loginUser = new User();
        loginUser.setUserName(server.getOsUser().getName());
        loginUser.setEcptPassword(server.getOsUser().getPwd());
        devNode.setLoginUser(loginUser);
    }

    @NotNull
    private static String getRootNewPwdIfExist(Server server) {
        if (StringUtils.isNULLStr((String)server.getOsRootUser().getNewPwd())) {
            return Base64EncodeUtils.decode((String)AESEncrypt.decrypt((String)server.getOsRootUser().getPwd()));
        }
        return Base64EncodeUtils.decode((String)AESEncrypt.decrypt((String)server.getOsRootUser().getNewPwd()));
    }

    @NotNull
    private static String getNewPwdIfExist(Server server) {
        if (StringUtils.isNULLStr((String)server.getOsUser().getNewPwd())) {
            return server.getOsUser().getPwd();
        }
        return server.getOsUser().getNewPwd();
    }

    public static DevNode buildBmcDevNode(Server server, int port) {
        DevNode bmcNode = new DevNode();
        bmcNode.setIp(server.getBmcIp());
        User loginUser = new User();
        loginUser.setUserName(server.getLoginUser().getName());
        loginUser.setEcptPassword(server.getLoginUser().getPwd());
        bmcNode.setLoginUser(loginUser);
        bmcNode.setDeviceSerialNumber(server.getUid());
        bmcNode.setPort(port);
        bmcNode.setRedFishPort(String.valueOf(port));
        return bmcNode;
    }

    public static DevNode buildClusterDevNode(Cluster cluster) {
        DevNode clusterDevNode = new DevNode();
        clusterDevNode.setIp(cluster.getIp());
        User loginUser = new User();
        loginUser.setUserName(cluster.getLoginUser().getName());
        loginUser.setEcptPassword(cluster.getLoginUser().getPwd());
        clusterDevNode.setLoginUser(loginUser);
        clusterDevNode.setDeviceSerialNumber(cluster.getUid());
        clusterDevNode.setPort(8088);
        clusterDevNode.setItDeviceType(ItDeviceType.DStorage);
        return clusterDevNode;
    }

    public static Server buildServerByCluster(DevNode node, ClusterNode clusterNode) {
        return Server.builder().isComputeNode(Boolean.valueOf(!clusterNode.isStorageNode())).clusterId(node.getDevKey()).uid(DevUtil.getClusterNodeUid(node, clusterNode)).bmcIp(clusterNode.getBmcIp()).osIp(clusterNode.getManagementIp()).bmcAuthStatus(AuthStatus.builder().status(DevUtil.getBmcAuthStatus(clusterNode)).build()).osAuthStatus(AuthStatus.builder().status(DevUtil.getOsAuthStatus(clusterNode)).build()).build();
    }

    private static String getBmcAuthStatus(ClusterNode clusterNode) {
        if (!CheckItemUtils.needAuth(clusterNode)) {
            return AuthStatusEnum.NOT_SUPPORT.getKey();
        }
        if (CheckItemUtils.needBmcAuth(clusterNode)) {
            return AuthStatusEnum.UN_AUTH.getKey();
        }
        return AuthStatusEnum.AUTHED.getKey();
    }

    private static String getOsAuthStatus(ClusterNode clusterNode) {
        if (!CheckItemUtils.needAuth(clusterNode) || clusterNode.isDirectPlanesNode()) {
            return AuthStatusEnum.NOT_SUPPORT.getKey();
        }
        if (CheckItemUtils.needOsAuth(clusterNode)) {
            return AuthStatusEnum.UN_AUTH.getKey();
        }
        return AuthStatusEnum.AUTHED.getKey();
    }

    private boolean isDistributed(DevNode node) {
        return node != null && (node.isDsStorage() || node.isFusionCube());
    }

    public static String getClusterNodeUid(DevNode cluster, ClusterNode clusterNode) {
        return cluster.getDevKey() + "_" + clusterNode.getBmcIp() + "_" + clusterNode.getManagementIp();
    }

    public List<DevNode> findExceptionDevNodes(String taskId) {
        return this.workerManager.getTaskWorker(taskId).map(workTaker -> (List)workTaker.get("exception_dev_nodes")).orElseGet(ArrayList::new);
    }

    @NotNull
    public static DevNode findAuthedStorageNode(DevNode devNode) throws ToolException {
        return devNode.getClusterNodes().stream().filter(DevUtil::isStorageNode).filter(DevUtil::isNodeAuthed).findAny().map(ClusterNode::getOsNode).orElseThrow(() -> new ToolException("no.authed.node.found"));
    }

    private static boolean isStorageNode(ClusterNode clusterNode) {
        return clusterNode.getRoles().contains("storage");
    }

    private static boolean isNodeAuthed(ClusterNode clusterNode) {
        return Objects.nonNull(clusterNode.getOsNode());
    }

    @Generated
    public DevUtil(TaskWorkerManager workerManager) {
        this.workerManager = workerManager;
    }
}

