/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.util;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.ExpansionConfig;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class ExpansionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExpansionUtils.class);

    public boolean isNewNode(ExpansionConfig expansionConfig) {
        return Optional.ofNullable(expansionConfig).map(ExpansionConfig::getNewNode).map("Y"::equals).orElse(false);
    }

    public String getCapacity(String config) {
        if (StringUtils.isNULLStr((String)config)) {
            return "0";
        }
        int index = config.indexOf("B") - 1;
        if (index < 1) {
            log.error("The expansion configuration information is incorrect.");
            return "0";
        }
        return config.substring(0, index);
    }

    public int getDiskQuantity(String config) {
        if (StringUtils.isNULLStr((String)config)) {
            return 0;
        }
        int index = config.lastIndexOf("-");
        if (index < 1) {
            log.error("The expansion configuration information is incorrect.");
            return 0;
        }
        try {
            return Integer.parseInt(config.substring(index + 1));
        }
        catch (NumberFormatException e) {
            log.error("Conversion exception", (Throwable)e);
            return 0;
        }
    }

    public String getCapacityUnit(String expansionConfig) {
        String descriptionTb = FusionStorDiskInfo.CapacityUnit.TB.getDescription();
        if (expansionConfig.contains(descriptionTb)) {
            return descriptionTb;
        }
        String descriptionGb = FusionStorDiskInfo.CapacityUnit.GB.getDescription();
        if (expansionConfig.contains(descriptionGb)) {
            return descriptionGb;
        }
        return FusionStorDiskInfo.CapacityUnit.BYTE.getDescription();
    }
}

