/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.util;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.config.IProductParser;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class ProductUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProductUtil.class);

    public Optional<Product> initDistributedProduct(DevNode devNode) throws ToolException {
        if (!devNode.isDsStorage() && !devNode.isFusionCube()) {
            return Optional.empty();
        }
        try {
            File productDir = InspectContext.getInstance().getResourceFileAndAddProductFile(devNode);
            log.info("Loading product for {}  dir:{}", (Object)devNode.getIp(), (Object)productDir);
            List<Product> products = SysConfiguration.getInstance().loadProductWithReturn(productDir);
            if (products == null || products.isEmpty()) {
                return Optional.empty();
            }
            products.forEach(loadedProduct -> loadedProduct.setConfigDir(productDir));
            if (devNode.isFusionCube()) {
                products.forEach(loadedProduct -> loadedProduct.setProductName(ItDeviceType.FUSIONCUBE.getName()));
            }
            if (devNode.isDataTurbo()) {
                products.forEach(loadedProduct -> loadedProduct.setProductName(ItDeviceType.DATATURBO.getName()));
            }
            if (devNode.isOceanStorA310()) {
                products.forEach(loadedProduct -> loadedProduct.setProductName(ItDeviceType.OCEAN_STOR_A310.getName()));
            }
            if (devNode.isA800DpcOm()) {
                products.forEach(loadedProduct -> loadedProduct.setProductName(ItDeviceType.A800_OM.getName()));
            }
            return Optional.of(products.stream().filter(loadedProduct -> devNode.getDeviceType().toString().contains(loadedProduct.getProductName())).findFirst().orElse(products.get(products.size() - 1)));
        }
        catch (ToolException e) {
            log.error("init product for {} failed.", (Object)devNode.getIp(), (Object)e);
            throw e;
        }
    }

    public void updateDStorageProduct(CheckDevNode checkDevNode, boolean shouldUpdate) throws ToolException {
        DevNode devNode = checkDevNode.getDevNode();
        if (InspectContext.getInstance().existDistributedProduct(devNode)) {
            Product oldProduct = InspectContext.getInstance().getProductByDevNode(devNode);
            FileUtils.deleteFile((File)oldProduct.getConfigDir());
        }
        try {
            Optional<Product> newProduct = this.initDistributedProduct(devNode);
            if (shouldUpdate && newProduct.isPresent()) {
                log.info("Update check item to check dev.");
                IProductParser parser = newProduct.get().getProductResolver();
                parser.updateCheckDevNode(checkDevNode, newProduct.get());
            }
        }
        catch (ToolException e) {
            log.error("get inspection resource or unzip resource exception:", (Throwable)e);
            throw e;
        }
    }
}

