/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.util;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.inspect.fit.switchcheck.constants.SwitchCheckConstants;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchCheckUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchCheckUtil.class);

    public static void uploadPyScript(SftpConnector sftpConnector, ICliConnection ssh) throws ToolException {
        SwitchCheckUtil.verifyScript();
        SwitchCheckUtil.deleteResultDir(ssh);
        sftpConnector.putFile(SwitchCheckConstants.EXPECT_LOGIN_PATH, "/tmp", null);
        sftpConnector.putFile(SwitchCheckUtil.getScriptPath(), "/tmp", null);
        log.info("upload switch script success.");
        SwitchCheckUtil.preHandleAfterUploaded(ssh);
    }

    private static void verifyScript() throws ToolException {
        File scriptFile = new File(SwitchCheckUtil.getScriptPath());
        try {
            if (!scriptFile.exists() || !SHAAndRSAVerifyUtils.getInstance().excuteVerify(scriptFile)) {
                throw new ToolException("dstorage.expansiontask.error.filenotfound");
            }
        }
        catch (ToolException toolException) {
            throw toolException;
        }
        catch (Exception exception) {
            log.error("sign verify exception ", (Throwable)exception);
            throw new ToolException("dstorage.expansiontask.error.filenotfound");
        }
    }

    private static String getScriptPath() {
        return SwitchCheckConstants.SCRIPT_PATH;
    }

    private static void preHandleAfterUploaded(ICliConnection ssh) throws ToolException {
        try {
            SwitchCheckUtil.execPreHandleCmd(ssh);
        }
        catch (ToolException toolException) {
            log.error("exec cmd error", (Throwable)toolException);
            throw new ToolException("upload.script.error");
        }
    }

    private static void execPreHandleCmd(ICliConnection ssh) throws ToolException {
        ssh.execCmd(SwitchCheckUtil.buildPreHandleCmd());
    }

    @NotNull
    private static String buildPreHandleCmd() {
        return String.join((CharSequence)" & ", String.format(Locale.ROOT, "chmod 550 %s", "/tmp/rdma_check_switch.py"), String.format(Locale.ROOT, "chmod 550 %s", "/tmp/expectLogin.sh"), String.format(Locale.ROOT, "mkdir %s", "/tmp/rdma_check"));
    }

    public static void deleteServerFile(ICliConnection ssh) {
        SwitchCheckUtil.deletePyScript(ssh);
    }

    private static void deletePyScript(ICliConnection ssh) {
        try {
            ssh.execCmd(String.format(Locale.ROOT, "rm -f %s", "/tmp/rdma_check_switch.py"));
            ssh.execCmd(String.format(Locale.ROOT, "rm -f %s", "/tmp/expectLogin.sh"));
        }
        catch (ToolException toolException) {
            log.warn("remove check script failed", (Throwable)toolException);
        }
    }

    public static void deleteResultDir(ICliConnection ssh) {
        try {
            ssh.execCmd(String.format(Locale.ROOT, "rm -rf %s", "/tmp/rdma_check"));
        }
        catch (ToolException toolException) {
            log.warn("remove result file failed", (Throwable)toolException);
        }
    }

    public static Optional<File> downResultFile(SftpConnector sftpConnector, String serverResultPath, String localResultFile) {
        try {
            sftpConnector.getFile(SwitchCheckConstants.TMP_DIR, serverResultPath, null);
        }
        catch (IsmException exception) {
            log.error("download result failed", (Throwable)exception);
            return Optional.empty();
        }
        File result = new File(localResultFile);
        if (!result.exists() || !result.isFile()) {
            log.error("download result failed");
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public static boolean isNeedSwitchCheck(DevNode devNode) {
        String configVersion = ResourceBundle.getBundle("config.inspect").getString("switch.check.version");
        if (StringUtils.isNULLStr((String)configVersion)) {
            return false;
        }
        return Arrays.stream(configVersion.split(",")).anyMatch(version -> devNode.getProductVersion().startsWith((String)version));
    }

    public static String buildResultWithIp(String filePath, String switchIp) {
        return String.format(Locale.ROOT, filePath, switchIp);
    }

    @Generated
    private SwitchCheckUtil() {
    }
}

