/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.util;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.fit.entity.task.ResultStatus;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.yinglong.drop.entity.item.entity.ItemConf;
import com.huawei.yinglong.drop.entity.item.entity.MultiRunningDetailDTO;
import com.huawei.yinglong.drop.entity.item.entity.ResultDetailDTO;
import com.huawei.yinglong.drop.entity.item.entity.RunningDetailDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.CheckdDevOverviewDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.TaskOverviewDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import lombok.NonNull;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

@Fitable
public class TaskInfoUtil {
    @NotNull
    public TaskOverviewDTO buildTaskOverview(List<CheckDevNode> checkDevNodes) {
        List<CheckdDevOverviewDTO> overviews = checkDevNodes.stream().map(this::buildCheckDevOverview).collect(Collectors.toList());
        return TaskOverviewDTO.builder().overviews(overviews).progress(this.calcTotalProgress(overviews)).status(TaskInfoUtil.calcTotalStatus(checkDevNodes).getKey()).build();
    }

    public TaskOverviewDTO buildFailedTaskOverview(List<DevNode> devNodes) {
        List overviews = devNodes.stream().map(this::buildFailedDevOverview).collect(Collectors.toList());
        return TaskOverviewDTO.builder().overviews(overviews).progress(Double.valueOf(0.0)).status(ResultStatus.FAILED.getKey()).build();
    }

    public static ResultStatus calcTotalStatus(List<CheckDevNode> checkDevNodes) {
        List<ResultStatus> statuses = TaskInfoUtil.collectStatus(checkDevNodes);
        if (statuses.stream().allMatch(ResultStatus::isWaiting)) {
            return ResultStatus.WAITED;
        }
        if (statuses.stream().anyMatch(ResultStatus::isRunning)) {
            return ResultStatus.RUNNING;
        }
        if (statuses.stream().allMatch(ResultStatus::isSuccess)) {
            return ResultStatus.SUCCESS;
        }
        if (statuses.stream().allMatch(ResultStatus::isFailed)) {
            return ResultStatus.FAILED;
        }
        return ResultStatus.PART_SUCCESS;
    }

    private static List<ResultStatus> collectStatus(List<CheckDevNode> checkDevNodes) {
        InspectContext context = InspectContext.getInstance();
        return checkDevNodes.stream().map(context::getUiUpdatePair).map(UiUpdatePair::getInspectStatus).map(status -> ResultStatus.from(status.getKey())).collect(Collectors.toList());
    }

    private Double calcTotalProgress(List<CheckdDevOverviewDTO> overviews) {
        return overviews.stream().mapToDouble(CheckdDevOverviewDTO::getProgress).average().orElse(0.0);
    }

    public MultiRunningDetailDTO buildMultiRunningDetail(CheckDevNode checkDevNode) {
        List<Record> records = this.getRecordList(checkDevNode);
        return this.buildMultiRunningDetail(records);
    }

    @NonNull
    public List<Record> getRecordList(CheckDevNode checkDevNode) {
        DefaultListModel model = InspectContext.getInstance().getUiUpdatePair(checkDevNode).getListMode();
        ArrayList<Record> records = new ArrayList<Record>();
        Enumeration recordEnumeration = model.elements();
        while (recordEnumeration.hasMoreElements()) {
            records.add((Record)recordEnumeration.nextElement());
        }
        return records;
    }

    public Record findTargetItemRecord(CheckDevNode node, String itemId) throws ToolException {
        CheckItem checkItem = InspectUtils.getAllCheckItem(node).stream().filter(item -> item.getItemId().equals(itemId)).findFirst().orElseThrow(() -> new ToolException("Can not find item " + itemId));
        return this.getRecordList(node).stream().filter(record -> checkItem.equals(record.getCheckItem())).findFirst().orElseThrow(() -> new ToolException("Can not find record " + itemId));
    }

    public MultiRunningDetailDTO buildMultiRunningDetail(List<Record> records) {
        List runningDetails = records.stream().map(this::buildRunningDetail).collect(Collectors.toList());
        return MultiRunningDetailDTO.builder().runningDetails(runningDetails).build();
    }

    public ResultDetailDTO buildResultDetail(Record record) {
        String status = this.getStatus(record);
        return ResultDetailDTO.builder().errorMsg(record.getCheckItem().getErrorInfo()).originInfo(record.getOriginalInfo()).status(status).suggestion(ResultStatus.PASS.getKey().equals(status) ? "" : this.getSuggestion(record)).itemConf(this.buildItemConf(record)).build();
    }

    private String getSuggestion(Record record) {
        return StringEscapeUtils.unescapeHtml4((String)record.getSuggestion().replaceAll("<br>", "\n"));
    }

    private ItemConf buildItemConf(Record rec) {
        CheckItem item = rec.getCheckItem();
        return ItemConf.builder().id(item.getItemId()).name(item.getName()).criterion(StringEscapeUtils.unescapeHtml4((String)rec.getCriterion())).method(StringEscapeUtils.unescapeHtml4((String)rec.getMethod())).suggestion(this.getSuggestion(rec)).build();
    }

    private CheckdDevOverviewDTO buildCheckDevOverview(CheckDevNode checkDevNode) {
        DevNode node = checkDevNode.getDevNodeSafe();
        return CheckdDevOverviewDTO.builder().hostName(node.getDeviceName()).ip(node.getIp()).sn(node.getDeviceSerialNumber()).model(node.getProductModel()).version(node.getProductVersion()).progress(Double.valueOf(this.getInspectProgress(checkDevNode))).status(this.getInspectStatus(checkDevNode)).build();
    }

    private CheckdDevOverviewDTO buildFailedDevOverview(DevNode node) {
        return CheckdDevOverviewDTO.builder().hostName(node.getDeviceName()).ip(node.getIp()).sn(node.getDeviceSerialNumber()).model(node.getProductModel()).version(node.getProductVersion()).progress(Double.valueOf(0.0)).status(ResultStatus.FAILED.getKey()).build();
    }

    private double getInspectProgress(CheckDevNode checkDevNode) {
        UiUpdatePair uiUpdatePair = InspectContext.getInstance().getUiUpdatePair(checkDevNode);
        return uiUpdatePair == null ? 0.0 : (double)uiUpdatePair.getProgress();
    }

    private String getInspectStatus(CheckDevNode checkDevNode) {
        UiUpdatePair uiUpdatePair = InspectContext.getInstance().getUiUpdatePair(checkDevNode);
        return ResultStatus.of(uiUpdatePair.getInspectStatus().getKey(), ResultStatus.FAILED);
    }

    private RunningDetailDTO buildRunningDetail(Record record) {
        return RunningDetailDTO.builder().description(record.getMessage()).startTime(this.getTime(record.getDate())).endTime(this.getTime(record.getEndTime())).status(this.getStatus(record)).progress(Double.valueOf(record.getProgress())).id(record.getRecordId()).type(record.isCommonStep() ? "step" : "checkItem").build();
    }

    private String getTime(Date date) {
        if (date == null) {
            return "";
        }
        return StringUtils.formatDate((Object)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public String getStatus(Record rec) {
        if (rec.isCommonStep()) {
            return ResultStatus.of(rec.getStatus().toString(), ResultStatus.SUCCESS);
        }
        String status = ResultStatus.of(rec.getStatus().toString());
        if (status.equals(ResultStatus.RUNNING.getKey())) {
            return status;
        }
        RItem retItem = rec.getItem();
        return ResultStatus.of(retItem.getJudge(), ResultStatus.RUNNING);
    }
}

