/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.util;

import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DiskTypeEnum;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.inspect.entity.ExpansionModeEnum;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.ExpansionConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyLld {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyLld.class);
    private static final int MINIMUM_NUMBER_OF_NODES_IN_A_NEW_POOL = 3;
    private static final int CUBE_MINIMUM_NUMBER_OF_NODES_IN_A_NEW_POOL = 2;
    private static final int MINIMUM_MAIN_DISK_NUMBER_BY_CAREAT_STORAGE_POOL = 4;
    private static final int MINIMUM_CACHE_DISK_NUMBER_BY_CAREAT_STORAGE_POOL = 1;
    private static final String HYPHEN = "-";
    private static final String COLON = ":";
    private static final String NEW_NODE = "Y";
    private static final int THE_ONLY = 1;
    private final Set<String> creatPoolMode = new HashSet<String>();
    private final Map<String, Set<String>> expansionNodes = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> diskTypes = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> diskPoolName = new HashMap<String, Set<String>>();
    private final Set<String> preServiceType = new HashSet<String>();

    public void verifyExpansionInfo(List<ExpansionConfig> expansionConfigs, DevNode devNode) throws ToolException {
        for (ExpansionConfig expansionConfig2 : expansionConfigs) {
            this.cacheSingleConfig(expansionConfig2);
            this.verifyDiskQuantity(expansionConfig2);
            this.verifyExpansionMode(expansionConfig2);
            this.simpleVerifyDiskPoolName(expansionConfig2, devNode);
        }
        this.checkNodesLimit(devNode);
        if (!this.isOnlyDiskType()) {
            if (expansionConfigs.stream().anyMatch(expansionConfig -> ExpansionModeEnum.CREAT_STORAGE_DISK_POOL.getScene().equalsIgnoreCase(expansionConfig.getExpansionMode()))) {
                throw new ToolException("fit.inconsistent.disk.pool.type");
            }
            throw new ToolException("fit.inconsistent.storage.pool.type");
        }
        if (this.preServiceType.size() > 1) {
            throw new ToolException("fit.same.service.type.error");
        }
    }

    private void checkNodesLimit(DevNode devNode) throws ToolException {
        int nodeLimit;
        int n = nodeLimit = devNode.isFusionCube() ? 2 : 3;
        if (!this.isNodesMoreThanLimit(nodeLimit)) {
            throw new ToolException("fit.creat.pools.rule", (Object[])new String[]{String.valueOf(nodeLimit), (String)this.creatPoolMode.stream().findFirst().get()});
        }
    }

    private boolean isNodesMoreThanLimit(int nodesLimit) {
        return this.expansionNodes.values().stream().allMatch(nodes -> nodes.size() >= nodesLimit);
    }

    private boolean isOnlyDiskType() {
        return this.diskTypes.values().stream().allMatch(diskType -> diskType.size() <= 1);
    }

    private void cacheSingleConfig(ExpansionConfig expansionConfig) {
        boolean isCreatPool = Stream.of(ExpansionModeEnum.CREAT_STORAGE_POOL.getScene(), ExpansionModeEnum.CREAT_STORAGE_DISK_POOL.getScene()).anyMatch(mode -> mode.equals(expansionConfig.getExpansionMode()));
        if (isCreatPool) {
            String key = String.join((CharSequence)COLON, expansionConfig.getExpansionMode(), expansionConfig.getParentStoragePool(), expansionConfig.getParentDiskPool());
            this.creatPoolMode.add(expansionConfig.getExpansionMode());
            this.setExpansionNodes(expansionConfig, key);
            this.setDiskType(expansionConfig, key);
        }
        if (ExpansionModeEnum.CREAT_STORAGE_DISK_POOL.getScene().equals(expansionConfig.getExpansionMode())) {
            this.setDiskPoolName(expansionConfig, expansionConfig.getParentDiskPool());
            this.preServiceType.add(expansionConfig.getServiceType());
        }
    }

    private void setExpansionNodes(ExpansionConfig expansionConfig, String key) {
        this.expansionNodes.putIfAbsent(key, new HashSet());
        this.expansionNodes.get(key).add(expansionConfig.getBmcIp());
    }

    private void setDiskType(ExpansionConfig expansionConfig, String key) {
        String value = String.join((CharSequence)COLON, expansionConfig.getMainStorageType(), expansionConfig.getCacheStorageType(), String.valueOf(this.diskQuantity(expansionConfig.getCacheStorageConfigure())));
        this.diskTypes.putIfAbsent(key, new HashSet());
        this.diskTypes.get(key).add(value);
    }

    private void setDiskPoolName(ExpansionConfig expansionConfig, String key) {
        this.diskPoolName.putIfAbsent(key, new HashSet());
        this.diskPoolName.get(key).add(expansionConfig.getParentStoragePool());
    }

    private void verifyDiskQuantity(ExpansionConfig expansionConfig) throws ToolException {
        boolean isExpansionDisk = ExpansionModeEnum.EXPANSION_DISK.getScene().equals(expansionConfig.getExpansionMode());
        if (isExpansionDisk) {
            log.info("Skip expansion disk");
            return;
        }
        if (!this.isRightMainDisk(expansionConfig)) {
            throw new ToolException("fit.creat.storage.pool.main.disk.rule", (Object[])new String[]{expansionConfig.getManagerIp()});
        }
        if (!this.isRightCacheDisk(expansionConfig)) {
            throw new ToolException("fit.creat.storage.pool.cache.disk.rule", (Object[])new String[]{expansionConfig.getManagerIp()});
        }
    }

    private boolean isRightMainDisk(ExpansionConfig expansionConfig) {
        Integer mainDiskQuantity = this.diskQuantity(expansionConfig.getMainStorageConfigure());
        return mainDiskQuantity >= 4;
    }

    @NotNull
    private Integer diskQuantity(String expansionConfig) {
        String[] expansionConfigures = expansionConfig.split(",");
        return Arrays.stream(expansionConfigures).map(this::getDiskQuantity).reduce(Integer::sum).orElse(0);
    }

    private boolean isRightCacheDisk(ExpansionConfig expansionConfig) {
        if (!this.isAllFlash(expansionConfig)) {
            Integer cacheDiskQuantity = this.diskQuantity(expansionConfig.getCacheStorageConfigure());
            return cacheDiskQuantity >= 1;
        }
        return true;
    }

    private boolean isAllFlash(ExpansionConfig expansionConfig) {
        return DiskTypeEnum.getAllFlashTypes().contains(DiskTypeEnum.getDiskTypeEnum((String)expansionConfig.getMainStorageType()));
    }

    private int getDiskQuantity(String config) {
        if (StringUtils.isNULLStr((String)config)) {
            return 0;
        }
        int index = config.lastIndexOf(HYPHEN);
        if (index < 1) {
            return 0;
        }
        try {
            return Integer.parseInt(config.substring(index + 1));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void verifyExpansionMode(ExpansionConfig expansionConfig) throws ToolException {
        boolean isNewNode = NEW_NODE.equals(expansionConfig.getNewNode());
        boolean isExpansionDisk = ExpansionModeEnum.EXPANSION_DISK.getScene().equals(expansionConfig.getExpansionMode());
        if (isNewNode && isExpansionDisk) {
            throw new ToolException("fit.node.expansion.mode.error");
        }
    }

    private void simpleVerifyDiskPoolName(ExpansionConfig expansionConfig, DevNode devNode) throws ToolException {
        if (!ExpansionModeEnum.CREAT_STORAGE_DISK_POOL.getScene().equals(expansionConfig.getExpansionMode())) {
            return;
        }
        if (!devNode.isFusionCube() && StringUtils.isNULLStr((String)expansionConfig.getParentDiskPool())) {
            throw new ToolException("fit.creat.disk.pool.name.error");
        }
    }

    public void verifyNewExpansionNodes(List<ExpansionConfig> expansionConfigs, DevNode devNode) throws ToolException {
        Set managerIps = devNode.getClusterNodes().stream().map(ClusterNode::getManagementIp).collect(Collectors.toSet());
        Set nodeExist = expansionConfigs.stream().filter(expansionConfig -> NEW_NODE.equals(expansionConfig.getNewNode())).map(ExpansionConfig::getManagerIp).filter(managerIps::contains).collect(Collectors.toSet());
        if (!CollectionUtil.isEmpty(nodeExist)) {
            throw new ToolException("fit.expansion.node.exist.error", (Object[])new String[]{String.join((CharSequence)COLON, nodeExist)});
        }
    }

    public void verifyExistExpansionNodes(List<ExpansionConfig> expansionConfigs, DevNode devNode) throws ToolException {
        Set<String> clusterNodeIps = this.getClusterNodeIp(devNode);
        List<String> nodeIps = this.getIpNotInCluster(expansionConfigs, clusterNodeIps);
        if (!CollectionUtil.isEmpty(nodeIps)) {
            throw new ToolException("fit.expansion.node.not.exist.error", (Object[])new String[]{String.join((CharSequence)COLON, nodeIps)});
        }
        Set<String> nodeIpInPools = this.getNodeIpInPools(devNode);
        Set<String> duplicateNodeInPools = this.duplicateNodeIp(expansionConfigs, nodeIpInPools);
        if (!CollectionUtil.isEmpty(duplicateNodeInPools)) {
            throw new ToolException("fit.expansion.node.in.pool.error", (Object[])new String[]{String.join((CharSequence)COLON, duplicateNodeInPools)});
        }
    }

    private Set<String> getClusterNodeIp(DevNode devNode) {
        return devNode.getClusterNodes().stream().map(ClusterNode::getManagementIp).collect(Collectors.toSet());
    }

    private List<String> getIpNotInCluster(List<ExpansionConfig> expansionConfigs, Set<String> clusterNodeIps) {
        return expansionConfigs.stream().filter(this::isExistNode).map(ExpansionConfig::getManagerIp).filter(nodIp -> !clusterNodeIps.contains(nodIp)).collect(Collectors.toList());
    }

    private Set<String> getNodeIpInPools(DevNode devNode) {
        ArrayList storagePools = new ArrayList();
        storagePools.addAll(devNode.getStoragePools());
        storagePools.addAll(devNode.getStoragePools().stream().flatMap(storagePool -> storagePool.getDiskPools().stream()).collect(Collectors.toList()));
        return storagePools.stream().flatMap(storagePool -> storagePool.getJoinedClusterNode().stream()).map(ClusterNode::getManagementIp).collect(Collectors.toSet());
    }

    private Set<String> duplicateNodeIp(List<ExpansionConfig> expansionConfigs, Set<String> nodeIpInPools) {
        return expansionConfigs.stream().filter(this::isExistNode).map(ExpansionConfig::getManagerIp).filter(nodeIpInPools::contains).collect(Collectors.toSet());
    }

    private boolean isExistNode(ExpansionConfig expansionConfig) {
        boolean isNewNode = NEW_NODE.equals(expansionConfig.getNewNode());
        boolean isExpansionNode = Stream.of(ExpansionModeEnum.EXPANSION_NODE.getScene(), ExpansionModeEnum.CREAT_STORAGE_POOL.getScene(), ExpansionModeEnum.CREAT_STORAGE_DISK_POOL.getScene()).anyMatch(expansionScene -> expansionScene.equals(expansionConfig.getExpansionMode()));
        return !isNewNode && isExpansionNode;
    }

    public void verifyExistDiskPoolName(List<ExpansionConfig> expansionConfigs, DevNode devNode) throws ToolException {
        Set existPoolName = devNode.getStoragePools().stream().flatMap(storage -> storage.getDiskPools().stream()).map(FusionStorStoragePool::getName).collect(Collectors.toSet());
        Set expansionPoolName = expansionConfigs.stream().filter(expansionConfig -> ExpansionModeEnum.CREAT_STORAGE_DISK_POOL.getScene().equals(expansionConfig.getExpansionMode())).map(ExpansionConfig::getParentDiskPool).filter(existPoolName::contains).collect(Collectors.toSet());
        if (!this.isOnlyPoolName()) {
            HashSet<String> poolName = new HashSet<String>(this.diskPoolName.keySet());
            throw new ToolException("fit.disk.pool.name.exist.error", (Object[])new String[]{String.join((CharSequence)COLON, poolName)});
        }
        if (!CollectionUtil.isEmpty(expansionPoolName)) {
            throw new ToolException("fit.disk.pool.name.exist.error", (Object[])new String[]{String.join((CharSequence)COLON, existPoolName)});
        }
    }

    private boolean isOnlyPoolName() {
        return this.diskPoolName.values().stream().allMatch(poolName -> poolName.size() <= 1);
    }

    public static void verifyDiskTypeInPool(FusionStorStoragePool fusionStoragePool, ExpansionConfig expansionConfig) throws ToolException {
        DiskTypeEnum poolDiskType = VerifyLld.getCurrentPoolDiskType(fusionStoragePool);
        boolean isSameMainType = VerifyLld.isSameDiskTpe(expansionConfig.getMainStorageType(), poolDiskType);
        if (!isSameMainType) {
            throw new ToolException("fit.main.disk.type.error", (Object[])new String[]{expansionConfig.getManagerIp(), expansionConfig.getMainStorageType(), poolDiskType.toShowInExpansion()});
        }
        if (fusionStoragePool.diskIsFlash() && !expansionConfig.getCacheStorageType().isEmpty()) {
            throw new ToolException("fit.flash.error", (Object[])new String[]{fusionStoragePool.getName()});
        }
        boolean isSameCacheType = VerifyLld.isSameDiskTpe(expansionConfig.getCacheStorageType(), fusionStoragePool.getCacheDiskType());
        if (!isSameCacheType) {
            throw new ToolException("fit.cache.disk.type.error", (Object[])new String[]{expansionConfig.getManagerIp()});
        }
    }

    private static DiskTypeEnum getCurrentPoolDiskType(FusionStorStoragePool fusionStoragePool) {
        return Optional.ofNullable(fusionStoragePool.getMainStorageDiskExtend()).orElse(fusionStoragePool.getMainStorageDiskType());
    }

    private static boolean isSameDiskTpe(String diskType, DiskTypeEnum diskTypeEnum) {
        return DiskTypeEnum.getDiskTypeEnum((String)diskType) == null || DiskTypeEnum.getDiskTypeEnum((String)diskType).equals((Object)diskTypeEnum);
    }

    public static boolean isFusionStorage(DevNode devNode) {
        return devNode.getProductVersion().startsWith("8.0");
    }

    public static void afterBindVerifyBlockDiskPool(DevNode devNode) throws ToolException {
        List blockServiceStoragePool = devNode.getStoragePools().stream().filter(FusionStorStoragePool::isBlock).collect(Collectors.toList());
        for (FusionStorStoragePool storagePool : blockServiceStoragePool) {
            Set<DiskTypeEnum> mainDiskType = VerifyLld.getDiskTypeEnums(storagePool, true);
            Set<DiskTypeEnum> cacheDiskType = VerifyLld.getDiskTypeEnums(storagePool, false);
            if (mainDiskType.size() > 1) {
                throw new ToolException("fit.between.mian.disk.pool.type.error", (Object[])new String[]{storagePool.getName()});
            }
            if (cacheDiskType.size() <= 1) continue;
            throw new ToolException("fit.between.cache.disk.pool.type.error", (Object[])new String[]{storagePool.getName()});
        }
    }

    private static Set<DiskTypeEnum> getDiskTypeEnums(FusionStorStoragePool storagePool, boolean isMainDisk) {
        return storagePool.getDiskPools().stream().map(storage -> isMainDisk ? storage.getMainStorageDiskType() : storage.getCacheDiskType()).collect(Collectors.toSet());
    }

    public static boolean isNewNode(ExpansionConfig expansionConfig) {
        return NEW_NODE.equals(expansionConfig.getNewNode());
    }
}

