/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.util.filter;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.config.SupportVersion;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import utils.Products;

public class DistributedStorageSupportFilter {
    private static final String SPLIT = ",";
    private static final String[] HPDA_SCENE_ID = new String[]{"HPDADeploy_genesequencing", "HPDADeploy_edueesearch", "HPDADeploy_edueesearch110", "HPDADeploy_edueesearch120", "HPDADeploy_genesequencing110", "RECOVERYDeploy_disasterrecovery"};
    private final Map<InspectScene, Function<DevNode, Boolean>> route = new HashMap<InspectScene, Function<DevNode, Boolean>>();

    public DistributedStorageSupportFilter() {
        this.route.put(InspectScene.REAL_TIME_CHECK, dev -> true);
        this.route.put(InspectScene.DISTRIBUTED_EXPANSION, this::isSupportExpansion);
        this.route.put(InspectScene.BUREAU_CHECK, this::isSupportBureau);
        this.route.put(InspectScene.BUREAU_CHECK_NFV, this::isSupportBureauNfv);
        this.route.put(InspectScene.STORAGE_CONFIG, this::isSupportBureauNfv);
    }

    public boolean isNodeSupport(InspectScene scene, DevNode dev) {
        return this.route.getOrDefault((Object)scene, node -> false).apply(dev);
    }

    private boolean isSupportBureauNfv(DevNode dev) {
        return Products.compareVersion((String)dev.getProductVersion(), (String)FusionStorageConfig.getNfvVersion("compareversionfornfv")) >= 0;
    }

    private boolean isSupportBureau(DevNode dev) {
        String productVersion = dev.getProductVersion();
        String type = dev.getDeviceType().toString();
        if (Arrays.asList(HPDA_SCENE_ID).contains(SceneUtils.getCurrentSubScene())) {
            String versionListStr = SceneUtils.getParamFormArgList((String)"versionList");
            List<String> versionList = Arrays.asList(versionListStr.split(SPLIT));
            return versionList.stream().anyMatch(version -> productVersion.contains(this.getSplitVersion((String)version)));
        }
        return FusionStorageConfig.getBureauSupportTypeAndVer().stream().anyMatch(support -> type.equals(support.getKey()) && productVersion.contains((CharSequence)support.getValue()));
    }

    private String getSplitVersion(String version) {
        int lastIndex = version.lastIndexOf(".");
        return version.substring(0, lastIndex);
    }

    private boolean isSupportExpansion(DevNode dev) {
        return InspectContext.getInstance().getExtendVersions().stream().filter(supportVersion -> supportVersion.getSupportInspectType().contains(InspectScene.DISTRIBUTED_EXPANSION.getSceneId())).anyMatch(supportVersion -> this.isSupportVersion(dev, (SupportVersion)supportVersion));
    }

    private boolean isSupportVersion(DevNode dev, SupportVersion supportVersion) {
        String version = dev.getProductVersion();
        String type = dev.getDeviceType().toString();
        return Arrays.stream(supportVersion.getVersion().split(SPLIT)).anyMatch(support -> type.equals(supportVersion.getModel()) && version.contains((CharSequence)support));
    }
}

