/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.validator.impl;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.inspect.fit.service.task.TaskWorkerManager;
import com.huawei.ism.tool.inspect.fit.validator.IValidator;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Optional;
import lombok.Generated;

@Fitable
public class DevExistValidator
implements IValidator {
    public static final String DEV_NOT_FOUND_KEY = "inspector.dev.notfound";
    @Fit
    private final TaskWorkerManager workerManager;

    @Override
    public void validator(String taskId, String devId) throws ToolException {
        Optional<InspectWorktaker> workTakerOpt = this.workerManager.getTaskWorker(taskId);
        if (!workTakerOpt.isPresent()) {
            throw new ToolException(DEV_NOT_FOUND_KEY, new Object[]{devId});
        }
        Optional<DevNode> devNodeOpt = workTakerOpt.get().findDevNode(devId);
        if (!devNodeOpt.isPresent()) {
            throw new ToolException(DEV_NOT_FOUND_KEY, new Object[]{devId});
        }
    }

    @Generated
    public DevExistValidator(TaskWorkerManager workerManager) {
        this.workerManager = workerManager;
    }
}

