/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.validator.impl;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.fit.entity.task.ResultStatus;
import com.huawei.ism.tool.inspect.fit.service.task.TaskWorkerManager;
import com.huawei.ism.tool.inspect.fit.util.TaskInfoUtil;
import com.huawei.ism.tool.inspect.fit.validator.IValidator;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class TaskStartValidator
implements IValidator {
    public static final String TASK_RUNNING = "inspector.task.running.error";
    @Fit
    private final TaskWorkerManager workerManager;

    @Override
    public void validator(String taskId, String devId) throws ToolException {
        if (this.workerManager.isTaskRunning(taskId) && !this.isTaskFinished(taskId)) {
            throw new ToolException(TASK_RUNNING, new Object[]{taskId});
        }
    }

    public boolean isTaskFinished(String taskId) {
        InspectWorktaker workTaker = this.workerManager.getTaskWorker(taskId).get();
        List<CheckDevNode> checkDevNodes = workTaker.getOrDefault("check_dev_nodes", Collections.emptyList());
        List devNodes = (List)workTaker.get("exception_dev_nodes");
        if (CollectionUtils.isEmpty(checkDevNodes) && CollectionUtils.isNotEmpty((Collection)devNodes)) {
            return true;
        }
        ResultStatus resultStatus = TaskInfoUtil.calcTotalStatus(checkDevNodes);
        return resultStatus.isFinished();
    }

    @Generated
    public TaskStartValidator(TaskWorkerManager workerManager) {
        this.workerManager = workerManager;
    }
}

