/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.config.IProductParser;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractProductParser
implements IProductParser {
    protected static final String QUERY_DEVICE_SH = "querydevice.sh";
    private static final long serialVersionUID = -146813461635852018L;
    private static final String DEVICES_TAG = "devices";
    private static final String DEVICE_TAG = "device";

    protected List<DevNode> getStorageUnits(DevNode srcNode, String queryDevRet) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(InspectContext.getInstance().getSupportTypes(), ShowSysConstans.getShowSysCmds());
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        try {
            Document doc = XmlUtils.createDomByXmlString((String)queryDevRet, (String)DEVICES_TAG);
            Collection deviceNodes = XmlUtils.getChildren((Element)doc.getDocumentElement(), (String)DEVICE_TAG);
            for (Element devEle : deviceNodes) {
                String ip = XmlUtils.getTextContentOfChild((Element)devEle, (String)"ip");
                String username = XmlUtils.getTextContentOfChild((Element)devEle, (String)"username");
                String password = XmlUtils.getTextContentOfChild((Element)devEle, (String)"password");
                DevNode devNode = new DevNode();
                devNode.setIp(ip);
                devNode.setLoginUser(new User(username, password));
                devNode.setSocks5Proxy(srcNode.getSocks5Proxy());
                devNode.setSshForwardList(srcNode.getSshForwardList());
                List devNodeModifyContext = DeviceContext.getInstance().getModifyDevicesInfo();
                this.setDeveloperPwd(ip, devNode, devNodeModifyContext);
                TaskResult result = nodeTypeQuery.queryNodeInfo(devNode, DeviceOpr.OTHERS);
                Object ret = result.getResultObject();
                if (ret == null) continue;
                devNodes.add((DevNode)ret);
            }
        }
        catch (ToolException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("resolever querydevice.sh result error.", (Throwable)e);
        }
        return devNodes;
    }

    private void setDeveloperPwd(String ip, DevNode devNode, List<DevNode> devNodeModifyContext) {
        for (DevNode devNode2 : devNodeModifyContext) {
            if (!ip.equals(devNode2.getIp())) continue;
            devNode.setDeveloperPwd(devNode2.getDeveloperPwd());
        }
    }

    protected void initialAddtionDevices(CheckDevNode rootCheckDevNode, DevNode srcNode, ICliConnection con) throws ToolException {
        String queryDevRet = con.execCmd("/tmp/inspect/querydevice.sh");
        List<DevNode> addtionDevices = this.getStorageUnits(srcNode, queryDevRet);
        HashMap devNodes = new HashMap();
        for (DevNode devNode : addtionDevices) {
            List<CheckDevNode> nodes;
            Product product = null;
            try {
                product = InspectContext.getInstance().getProductByDevNode(devNode);
            }
            catch (ToolException ex) {
                ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)ex);
                continue;
            }
            catch (RuntimeException ex) {
                ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)ex);
                continue;
            }
            IProductParser parser = product.getProductResolver();
            CheckDevNode checkDev = parser.initCheckDevByXml(product, devNode);
            if (checkDev == null) {
                ToolLoggerFactory.getLogger(this.getClass()).error("checkDev is null.");
                throw new NullPointerException();
            }
            checkDev.setIntegration(true);
            String productName = product.getProductName();
            if (devNodes.containsKey(productName)) {
                nodes = (List)devNodes.get(productName);
                nodes.add(checkDev);
                continue;
            }
            nodes = new ArrayList();
            nodes.add(checkDev);
            devNodes.put(productName, nodes);
        }
        Set allDevs = devNodes.entrySet();
        for (Map.Entry entry : allDevs) {
            List nodes = (List)entry.getValue();
            CheckDevNode type = new CheckDevNode();
            type.setNodeName((String)entry.getKey());
            type.setIntegration(true);
            for (CheckDevNode node : nodes) {
                type.addChildren(node);
            }
            rootCheckDevNode.addChildren(type);
        }
    }
}

