/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.ConstantField;
import com.huawei.ism.tool.inspect.entity.DstorageAfterCheckConfig;
import com.huawei.ism.tool.inspect.entity.DstoragePreCheckConfig;
import com.huawei.ism.tool.inspect.entity.DstorageSceneCheckItems;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.entity.SupportScenes;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.logic.config.AbstractProductParser;
import com.huawei.ism.tool.inspect.logic.config.CheckItemPlatformAdapterInInspect;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.config.InspectSceneValue;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.SecureLineChecker;
import com.huawei.ism.tool.inspect.logic.config.TagCondition;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ExpansionTaskUtils;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.CheckModelInfo;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.ComputerStorageUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.entity.ItemInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import utils.FilesUtil;
import utils.Products;

public class ArrayProductParser
extends AbstractProductParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArrayProductParser.class);
    private static final String ATTR_ID = "id";
    private static final String VER_REGX = "verRegx";
    private static final String MODEL_REGX = "modelRegx";
    private static final String MIN_PATCH = "minPatch";
    private static final String MAX_PATCH = "maxPatch";
    private static final String ENABLE_MARK = "enableMark";
    private static final String RISK_WEIGHT = "riskWeight";
    private static final String ATTR_SCRIPT = "script";
    private static final String ATTR_TAG = "tag";
    private static final String ATTR_ITEM_EFFSCENE = "itemEffScene";
    private static final String XQL_CMDTYPES = "/device/cmdtype";
    private static final String ATTR_CMDTYPENAME = "name";
    private static final String ATTR_CMDTYPE_EFFECTIVESENE = "effectiveScene";
    private static final long serialVersionUID = -1209320079190382695L;
    private JythonExecuter jythonExecuter;
    private static final String XQL_ITEMLIST = "/itemlist";
    private static final String SITE_DEPLOYMENT_CHECK_NFV = "site_deployment_check_nfv";
    public static final String DSTORAGE_EXPANSION_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "packages" + File.separator + "inspector" + File.separator + "products" + File.separator + "DStorageExtende";

    @Override
    public CheckDevNode initCheckDevByXml(Product product, DevNode ... devNodes) throws ToolException {
        if (devNodes == null || devNodes.length == 0) {
            return null;
        }
        if (devNodes.length > 1) {
            return null;
        }
        DevNode devNode = devNodes[0];
        CheckDevNode checkDevNode = new CheckDevNode();
        checkDevNode.setProduct(product);
        checkDevNode.setNodeName(devNode.getDeviceName());
        checkDevNode.setDevNode(devNode);
        checkDevNode.setViewAble(true);
        File propertiesFilePath = new File(product.getConfigDir(), "res");
        ResourceBundle bundle = this.readProperties(propertiesFilePath);
        this.initSwitchResource(checkDevNode);
        checkDevNode.setResourceBundle(bundle);
        checkDevNode.setScriptDir(new File(product.getConfigDir(), "sh"));
        String inspectType = InspectContext.getInstance().getSelectInspectType();
        if (this.needDealWithSpecial(devNode, inspectType)) {
            this.specialScenes(product, checkDevNode);
        } else {
            this.commonScenes(product, devNode, checkDevNode);
        }
        return checkDevNode;
    }

    private boolean needDealWithSpecial(DevNode devNode, String inspectType) {
        return !inspectType.equals("") && !"realTimed_check".equals(inspectType) && !"timed_check".equals(inspectType) && !inspectType.contains("T3000") && !inspectType.contains("UltraPath") && !devNode.isDsStorage();
    }

    private void initSwitchResource(CheckDevNode checkDevNode) {
        File file = Paths.get(InspectContext.INSPECT_CONFPATH, "products", "SwitchCheck", "res").toFile();
        if (!file.exists() || !file.isDirectory()) {
            log.info("switch resource dose not exists");
            return;
        }
        checkDevNode.setSwitchResource(this.readProperties(file));
    }

    @Override
    public void updateCheckDevNode(CheckDevNode checkDevNode, Product product) {
        checkDevNode.setProduct(product);
        checkDevNode.getDstorageSceneCheckItemsList().clear();
        File propertiesFilePath = new File(product.getConfigDir(), "res");
        ResourceBundle bundle = this.readProperties(propertiesFilePath);
        checkDevNode.setResourceBundle(bundle);
        this.loadDistributedStorageItems(product, checkDevNode);
    }

    private void specialScenes(Product product, CheckDevNode checkDevNode) throws ToolException {
        String configPath = FilesUtil.getCanonicalPath((File)product.getConfigDir());
        for (SupportScenes scenes : product.getSencesList()) {
            File propertiesFilePath;
            File checklistXml = new File(FilePathUtils.checkFile((String)(FilePathUtils.checkFile((File)product.getConfigDir()) + File.separator + scenes.getCheckListFileName())));
            if (InspectContext.getInstance().getSelectInspectType().equals(scenes.getScenesId()) && "bureau_check".equals(scenes.getScenesId())) {
                checkDevNode.setScriptDir(new File(configPath, "sh"));
                propertiesFilePath = new File(configPath, "res");
                this.initScenes(checklistXml, checkDevNode, propertiesFilePath);
                break;
            }
            if (!InspectContext.getInstance().getSelectInspectType().equalsIgnoreCase(scenes.getScenesId())) continue;
            checkDevNode.setScriptDir(new File(configPath, "sh"));
            propertiesFilePath = new File(configPath, "res");
            this.initScenes(checklistXml, checkDevNode, propertiesFilePath);
        }
    }

    private void commonScenes(Product product, DevNode devNode, CheckDevNode checkDevNode) throws ToolException {
        if (devNode.isDsStorage()) {
            this.loadDistributedStorageItems(product, checkDevNode);
            return;
        }
        String configPath = FilesUtil.getCanonicalPath((File)product.getConfigDir());
        File checklistXml = this.getConfigedChecklist(product) != null ? new File(configPath + File.separator + this.getConfigedChecklist(product)) : (product.getCheckListFile() != null ? product.getCheckListFile() : new File(configPath + File.separator + "checklist.xml"));
        CheckModelInfo modelInfo = product.getCheckModelInfo();
        if (modelInfo != null && "auto".equals(modelInfo.getModelType())) {
            boolean isSecure = SecureLineChecker.isSecuredLine(checkDevNode, product.getConfigDir());
            InspectContext.ISVERSION.put(devNode.getIp(), String.valueOf(isSecure));
            if (isSecure) {
                checkDevNode.setScriptDir(new File(product.getConfigDir(), "pyscript"));
                checklistXml = new File(product.getConfigDir(), "pychecklist.xml");
                File propertiesFilePath = new File(product.getConfigDir(), "pyres");
                ResourceBundle bundle = this.readProperties(propertiesFilePath);
                checkDevNode.setResourceBundle(bundle);
            }
        }
        this.setCheckItems(checkDevNode, checklistXml);
    }

    private void loadDistributedStorageItems(Product product, CheckDevNode checkDevNode) {
        Map<String, String> extendedSceneItemConfig = this.initDstorageExpansion(checkDevNode);
        for (SupportScenes supportScene : product.getSencesList()) {
            this.initCheckItemByScene(product, checkDevNode, extendedSceneItemConfig, supportScene);
        }
        this.initCheckItemBySingleScene(extendedSceneItemConfig, checkDevNode);
        ExpansionTaskUtils.filterCheckItemsByBlock(checkDevNode);
        File propertiesFilePath = new File(product.getConfigDir(), "res");
        ResourceBundle bundle = this.readProperties(propertiesFilePath);
        checkDevNode.setResourceBundle(bundle);
        product.setPassedNotShowSuggest(true);
    }

    private void initCheckItemBySingleScene(Map<String, String> extendedSceneItemConfig, CheckDevNode checkDevNode) {
        if (InspectUtils.isDistributedFrw()) {
            this.initDistributeFirmwareItem(extendedSceneItemConfig, checkDevNode);
        }
        if (!InspectUtils.isStartedByYingLong()) {
            return;
        }
        List<String> singleSceneConfigs = Arrays.asList(InspectScene.STORAGE_CONFIG.getSceneId());
        singleSceneConfigs.stream().filter(extendedSceneItemConfig::containsKey).forEach(sceneId -> this.initSceneItems(extendedSceneItemConfig, checkDevNode, (String)sceneId));
    }

    private void initSceneItems(Map<String, String> extendedSceneItemConfig, CheckDevNode checkDevNode, String sceneId) {
        String checkListFileName = extendedSceneItemConfig.get(sceneId);
        DstorageSceneCheckItems sceneItems = new DstorageSceneCheckItems();
        sceneItems.setSceneId(sceneId);
        sceneItems.setSceneDesc(ResourceUtil.getString((String)sceneId));
        sceneItems.setCheckListFileName(checkListFileName);
        sceneItems.setCheckItems(new ConcurrentHashMap<String, List<CheckItem>>());
        try {
            this.initExpansionItem(sceneItems, checkListFileName, checkDevNode);
        }
        catch (FileNotFoundException e) {
            log.error("Init config {} failed.", (Object)checkListFileName);
        }
        checkDevNode.getDstorageSceneCheckItemsList().add(sceneItems);
    }

    private void initDistributeFirmwareItem(Map<String, String> extendedSceneItemConfig, CheckDevNode checkDevNode) {
        try {
            String scene = "pre_upgrade_check";
            Map<String, List<CheckItem>> checkItemDtoFromLocal = this.getCheckItemDtoFromLocal(checkDevNode.getDevNode());
            DstorageSceneCheckItems dstorageSceneCheckItem = new DstorageSceneCheckItems();
            if (checkDevNode.getDevNode().getClusterNodes().stream().anyMatch(ClusterNode::isProprietaryHardware)) {
                dstorageSceneCheckItem.setCheckItems(checkItemDtoFromLocal);
            }
            this.initDsFwExtendItems(extendedSceneItemConfig, checkDevNode, dstorageSceneCheckItem);
            dstorageSceneCheckItem.setSceneId(scene);
            dstorageSceneCheckItem.setSceneDesc(ResourceUtil.getString((String)"pre.upgrade.check"));
            ArrayList<DstorageSceneCheckItems> dstorageSceneCheckItems = new ArrayList<DstorageSceneCheckItems>();
            dstorageSceneCheckItems.add(dstorageSceneCheckItem);
            checkDevNode.setDstorageSceneCheckItemsList(dstorageSceneCheckItems);
        }
        catch (Exception e) {
            log.warn("get distributedItem failed", (Throwable)e);
        }
    }

    private void initDsFwExtendItems(Map<String, String> extendedSceneItemConfig, CheckDevNode checkDevNode, DstorageSceneCheckItems dstorageSceneCheckItem) {
        String checkListFileName = extendedSceneItemConfig.get(FusionStorageConfig.getDsFwExtendCheckId());
        try {
            this.initExpansionItem(dstorageSceneCheckItem, checkListFileName, checkDevNode);
        }
        catch (FileNotFoundException e) {
            log.warn("Init config {} failed.", (Object)checkListFileName);
        }
    }

    public Map<String, List<CheckItem>> getCheckItemDtoFromLocal(DevNode devNode) {
        DstoragePatchInfo bestMatchPatch = Context.INS.findBestMatchPatch(devNode, DstoragePatchInfo.Type.INSPECT);
        if (bestMatchPatch == null) {
            log.info("The current device {} does not match the local inspection item.", (Object)devNode.getIp());
            return Collections.emptyMap();
        }
        Map<String, List<ItemInfo>> itemInfos = bestMatchPatch.getItemInfos().stream().collect(Collectors.groupingBy(ItemInfo::getLayer));
        return this.changeItemInfo2CheckItem(itemInfos);
    }

    @NotNull
    private Map<String, List<CheckItem>> changeItemInfo2CheckItem(Map<String, List<ItemInfo>> itemInfos) {
        HashMap<String, List<CheckItem>> checkItems = new HashMap<String, List<CheckItem>>();
        itemInfos.forEach((key, value) -> checkItems.put((String)key, value.stream().map(this::creatCheckItem).collect(Collectors.toList())));
        return checkItems;
    }

    private CheckItem creatCheckItem(ItemInfo itemInfo) {
        CheckItem checkItem = new CheckItem();
        checkItem.setSelected(true);
        checkItem.setItemId(itemInfo.getItem());
        checkItem.setName(StringEscapeUtils.unescapeJava((String)itemInfo.getDescription()));
        Item item = new Item();
        item.setId(checkItem.getItemId());
        item.setName(checkItem.getName());
        checkItem.setItems(Collections.singletonList(item));
        return checkItem;
    }

    private void initCheckItemByScene(Product product, CheckDevNode checkDevNode, Map<String, String> expansionItem, SupportScenes supportScene) {
        File checklistXml = new File(FilesUtil.getCanonicalPath((File)product.getConfigDir()), supportScene.getCheckListFileName());
        if (FusionStorageConfig.isMatchFixVersion(checkDevNode.getDevNodeSafe())) {
            this.initAllSceneItemToCache(checkDevNode, checklistXml);
        }
        if (InspectContext.getInstance().isBureauCheckSelected()) {
            if (!FusionStorageConfig.getBureauCheckId().contains(supportScene.getScenesId())) {
                return;
            }
        } else if (InspectUtils.isDistributedFru()) {
            if (!FusionStorageConfig.getRealTimedCheckId().contains(supportScene.getScenesId())) {
                return;
            }
        } else if (InspectUtils.isDistributedBatchUpgrade()) {
            if (InspectUtils.isBatchPreUpgradeScene() && !InspectScene.PRE_UPGRADE_CHECK.getSceneId().contains(supportScene.getScenesId())) {
                return;
            }
            if (InspectUtils.isBatchPostUpgradeScene() && !InspectScene.REAL_TIME_CHECK.getSceneId().contains(supportScene.getScenesId())) {
                return;
            }
        } else {
            if (FusionStorageConfig.getBureauCheckId().contains(supportScene.getScenesId())) {
                return;
            }
            if (InspectUtils.isFsExInspect() && !FusionStorageConfig.getRealTimedCheckId().contains(supportScene.getScenesId())) {
                return;
            }
        }
        this.loadCheckItemByScene(checkDevNode, checklistXml, expansionItem, supportScene);
    }

    private void initAllSceneItemToCache(CheckDevNode checkDevNode, File checklistXml) {
        try {
            Map<String, List<CheckItem>> checkItems = this.getCheckItems(checklistXml, checkDevNode);
            Set<String> items = checkItems.values().stream().flatMap(Collection::stream).map(CheckItem::getItemId).collect(Collectors.toSet());
            FusionStorageConfig.putAllSceneItems(checkDevNode.getDevNodeSafe(), items);
        }
        catch (FileNotFoundException e) {
            log.error("init all scene item to cache failed");
        }
    }

    private void loadCheckItemByScene(CheckDevNode checkDevNode, File checklistXml, Map<String, String> expansionItem, SupportScenes supportScene) {
        try {
            Map<String, List<CheckItem>> checkItems = this.getCheckItems(checklistXml, checkDevNode);
            DstorageSceneCheckItems dstorageSceneCheckItems = new DstorageSceneCheckItems();
            dstorageSceneCheckItems.setCheckItems(checkItems);
            String scenesId = supportScene.getScenesId();
            dstorageSceneCheckItems.setSceneId(scenesId);
            dstorageSceneCheckItems.setCheckListFileName(checklistXml.getCanonicalPath());
            if (expansionItem.containsKey(scenesId)) {
                this.initExpansionItem(dstorageSceneCheckItems, expansionItem.get(scenesId), checkDevNode);
            }
            if (InspectContext.getInstance().isNfvMode()) {
                this.initExpansionItem(dstorageSceneCheckItems, expansionItem.get(SITE_DEPLOYMENT_CHECK_NFV), checkDevNode);
            }
            if (InspectUtils.isFsExInspect() && expansionItem.containsKey(FusionStorageConfig.getFsExpansionCheckId())) {
                this.initExpansionItem(dstorageSceneCheckItems, expansionItem.get(FusionStorageConfig.getFsExpansionCheckId()), checkDevNode);
            }
            checkDevNode.getDstorageSceneCheckItemsList().add(dstorageSceneCheckItems);
            if (!(InspectContext.getInstance().isBureauCheckSelected() || InspectUtils.isDistributedBatchUpgrade() || "realTimed_check".equals(supportScene.getScenesId()))) {
                this.disableAllCheckItems(checkItems.values());
            }
            DstoragePreCheckConfig.INS.hiddenPreCheckItem(checkItems, checkDevNode);
            DstoragePreCheckConfig.hiddenPreItems(checkItems);
            DstorageAfterCheckConfig.INS.hiddenAfterCheckItem(checkItems, checkDevNode);
        }
        catch (FileNotFoundException e) {
            log.error("can not find checklist file.");
        }
        catch (IOException e) {
            log.error("get checklist xml path error.");
        }
    }

    private Map<String, String> initDstorageExpansion(CheckDevNode checkDevNode) {
        Document deviceDoc;
        String extendedFilePath = DSTORAGE_EXPANSION_PATH + File.separator + "ExtendeDevice.xml";
        File distributedExtendedConfig = new File(extendedFilePath);
        try (InputStream inputStream = Files.newInputStream(distributedExtendedConfig.toPath(), new OpenOption[0]);){
            deviceDoc = XmlUtils.parseDocument((InputStream)inputStream);
        }
        catch (IOException e) {
            log.error("init distributed extended config {} failed.", (Object)distributedExtendedConfig.getName());
            return Collections.emptyMap();
        }
        DevNode devNode = checkDevNode.getDevNode();
        HashMap<String, String> sceneConfigMap = new HashMap<String, String>();
        NodeList products = XmlUtils.searchNodeByExp((Document)deviceDoc, (String)"products/product");
        IntStream.range(0, products.getLength()).mapToObj(products::item).filter(product -> product instanceof Element).map(Element.class::cast).forEach(product -> this.initSceneConfigMap((Map<String, String>)sceneConfigMap, devNode, (Element)product));
        if (sceneConfigMap.isEmpty()) {
            return sceneConfigMap;
        }
        File propertiesPath = new File(DSTORAGE_EXPANSION_PATH + File.separator + "res");
        ResourceBundle expansionResource = this.readProperties(propertiesPath);
        checkDevNode.setExpansionResource(expansionResource);
        return sceneConfigMap;
    }

    private void initSceneConfigMap(Map<String, String> sceneConfigMap, DevNode devNode, Element product) {
        String confDeviceType;
        String confProductVersion = XmlUtils.getTextContentOfChild((Element)product, (String)"supportVersion");
        if (!this.isSuppotExtended(confProductVersion, confDeviceType = XmlUtils.getTextContentOfChild((Element)product, (String)"supportDeviceType"), devNode)) {
            return;
        }
        Collection supports = XmlUtils.getChildren((Element)XmlUtils.getChild((Element)product, (String)"supportList"), (String)"supportscene");
        supports.forEach(sceneConfigEle -> {
            String sceneId = XmlUtils.getTextContentOfChild((Element)sceneConfigEle, (String)ATTR_ID);
            String itemXmlName = XmlUtils.getTextContentOfChild((Element)sceneConfigEle, (String)"itemXmlName");
            sceneConfigMap.put(sceneId, itemXmlName);
        });
    }

    private boolean isSuppotExtended(String confProductVersion, String confDeviceType, DevNode devNode) {
        String[] versionSet;
        String productVersion = devNode.getProductVersion();
        String deviceType = devNode.getDeviceType().toString();
        if (!deviceType.equals(confDeviceType)) {
            return false;
        }
        if (StringUtils.isNULLStr((String)confProductVersion)) {
            return true;
        }
        for (String version : versionSet = confProductVersion.split(",")) {
            if (!productVersion.contains(version)) continue;
            return true;
        }
        return false;
    }

    private void initExpansionItem(DstorageSceneCheckItems dstorageSceneCheckItems, String itemXmlName, CheckDevNode checkDevNode) throws FileNotFoundException {
        String itemXmlPath = DSTORAGE_EXPANSION_PATH + File.separator + itemXmlName;
        Map<String, List<CheckItem>> expansionCheckItems = this.getCheckItems(new File(itemXmlPath), checkDevNode);
        Map<String, List<CheckItem>> checkItems = dstorageSceneCheckItems.getCheckItems();
        this.removeDuplicateItems(expansionCheckItems, checkItems);
        for (String expansionKey : expansionCheckItems.keySet()) {
            if (checkItems.containsKey(expansionKey)) {
                checkItems.get(expansionKey).addAll((Collection<CheckItem>)expansionCheckItems.get(expansionKey));
                continue;
            }
            checkItems.put(expansionKey, expansionCheckItems.get(expansionKey));
        }
    }

    private void removeDuplicateItems(Map<String, List<CheckItem>> expansionCheckItems, Map<String, List<CheckItem>> checkItems) {
        this.removeInvalidExpansionCheckItem(expansionCheckItems, checkItems);
        expansionCheckItems.values().stream().flatMap(Collection::stream).map(CheckItem::getItemId).distinct().forEach(itemId -> checkItems.values().forEach(items -> items.removeIf(item -> item.getItemId().equals(itemId))));
    }

    private void removeInvalidExpansionCheckItem(Map<String, List<CheckItem>> expansionCheckItems, Map<String, List<CheckItem>> checkItems) {
        expansionCheckItems.values().forEach(extendItems -> extendItems.removeIf(extendItem -> this.isNeedRemoveExtendItme(checkItems, (CheckItem)extendItem)));
    }

    private boolean isNeedRemoveExtendItme(Map<String, List<CheckItem>> checkItems, CheckItem extendItem) {
        return this.isRestfulItem(extendItem) && checkItems.values().stream().flatMap(Collection::stream).noneMatch(checkItem -> checkItem.getItemId().equals(extendItem.getItemId()));
    }

    private boolean isRestfulItem(CheckItem checkItem) {
        return StringUtils.isNULLStr((String)checkItem.getExtendItemMode());
    }

    private void disableAllCheckItems(Collection<List<CheckItem>> itemsList) {
        itemsList.stream().flatMap(Collection::stream).forEach(checkItem -> checkItem.setEnable(false));
    }

    private void setCheckItems(CheckDevNode checkDevNode, File checklistXml) throws ToolException {
        try {
            Map<String, List<CheckItem>> checkItems = EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)checkDevNode.getDevNodeSafe()) ? ComputerStorageUtils.getFcvCheckItems(checkDevNode) : this.getCheckItems(checklistXml, checkDevNode);
            checkDevNode.setCheckListFile(checklistXml);
            checkDevNode.setCheckItems(checkItems);
        }
        catch (Exception e) {
            log.error("Parse checklist file {} error.", (Object)checklistXml.getName());
            throw new ToolException("query device check item info error.", false, (Throwable)e);
        }
    }

    private String getConfigedChecklist(Product product) {
        for (SupportScenes scenes : product.getSencesList()) {
            if (!InspectContext.getInstance().getSelectInspectType().equalsIgnoreCase(scenes.getScenesId())) continue;
            return scenes.getCheckListFileName();
        }
        return null;
    }

    private void initScenes(File checklistXml, CheckDevNode checkDevNode, File propertiesFilePath) throws ToolException {
        ResourceBundle bundle = this.readProperties(propertiesFilePath);
        checkDevNode.setResourceBundle(bundle);
        Map<String, List<CheckItem>> checkItems = null;
        try {
            checkItems = EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)checkDevNode.getDevNodeSafe()) ? ComputerStorageUtils.getFcvCheckItems(checkDevNode) : this.getCheckItems(checklistXml, checkDevNode);
            checkDevNode.setCheckListFile(checklistXml);
            checkDevNode.setCheckItems(checkItems);
        }
        catch (Exception e) {
            log.error("init scnecs checkitem error.", (Throwable)e);
            throw new ToolException("query device checkitem info error.", false, (Throwable)e);
        }
    }

    protected Map<String, List<CheckItem>> getCheckItems(File checklistXml, CheckDevNode checkDevNode) throws FileNotFoundException {
        Document doc = null;
        try (InputStream inputStream = Files.newInputStream(checklistXml.toPath(), new OpenOption[0]);){
            doc = XmlUtils.parseDocument((InputStream)inputStream);
        }
        catch (IOException e) {
            log.error("init check item error {}. ", (Object)checklistXml.getName());
        }
        catch (RuntimeException e) {
            log.error("init check item error.", (Throwable)e);
        }
        KeyOrderedHashMap checkItems = new KeyOrderedHashMap();
        if (doc == null) {
            return checkItems;
        }
        NodeList cmdTypes = XmlUtils.searchNodeByExp((Document)doc, (String)XQL_CMDTYPES);
        this.getResourceName(checkDevNode, (ListOrderedMap<String, List<CheckItem>>)checkItems, cmdTypes, false);
        try {
            if ("realTimed_check".equals(InspectContext.getInstance().getSelectInspectType())) {
                this.depthCheckItems(checkDevNode, (ListOrderedMap<String, List<CheckItem>>)checkItems);
            }
        }
        catch (ToolException e) {
            log.error("init depthCheck failure.", (Throwable)e);
        }
        this.handleFusionCubeItem((ListOrderedMap<String, List<CheckItem>>)checkItems, checkDevNode.getDevNode());
        return checkItems;
    }

    private void handleFusionCubeItem(ListOrderedMap<String, List<CheckItem>> checkItemMaps, DevNode devNode) {
        List<CheckItem> fusionCubeItems = this.filterFusionCubeCheckItem(checkItemMaps, devNode);
        if (CollectionUtils.isEmpty(fusionCubeItems)) {
            return;
        }
        this.removeFusionCubeItem(checkItemMaps, fusionCubeItems);
        String type = ResourceUtil.getString((String)"insepctor.fusioncube");
        this.addDstorageCheckItems(checkItemMaps, type, fusionCubeItems);
    }

    private List<CheckItem> filterFusionCubeCheckItem(ListOrderedMap<String, List<CheckItem>> checkItemMaps, DevNode devNode) {
        if (MapUtils.isEmpty(checkItemMaps) || devNode == null || !devNode.isFusionCube()) {
            return Collections.emptyList();
        }
        return checkItemMaps.values().stream().filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).filter(Objects::nonNull).filter(CheckItem::isFusionCube).distinct().collect(Collectors.toList());
    }

    private void removeFusionCubeItem(ListOrderedMap<String, List<CheckItem>> checkItemMaps, List<CheckItem> checkItems) {
        if (CollectionUtils.isEmpty(checkItems) || MapUtils.isEmpty(checkItemMaps)) {
            return;
        }
        checkItemMaps.values().forEach(tmpCheckItems -> tmpCheckItems.removeIf(checkItems::contains));
    }

    private void depthCheckItems(CheckDevNode checkDevNode, ListOrderedMap<String, List<CheckItem>> checkItems) throws ToolException, FileNotFoundException {
        String fileName = "qryHighGradeCheckItems.py";
        File pyScFile = new File(checkDevNode.getScriptDir().getParentFile(), fileName);
        if (!pyScFile.exists()) {
            return;
        }
        HashMap<String, Object> pyMap = new HashMap<String, Object>();
        pyMap.put("devNode", checkDevNode.getDevNode());
        pyMap.put("log", ToolLoggerFactory.getLogger(this.getClass()));
        if (this.jythonExecuter == null) {
            this.jythonExecuter = new JythonExecuter();
        }
        this.jythonExecuter.compileScript(pyScFile);
        List ret = this.jythonExecuter.invokeFunction("execute", pyMap);
        if (ret == null || ret.isEmpty()) {
            throw new NullPointerException();
        }
        String cmdResult = ret.get(1).toString();
        Document dom = XmlUtils.createDomByXmlString((String)cmdResult, (String)"device");
        NodeList pyTypes = XmlUtils.searchNodeByExp((Document)dom, (String)XQL_CMDTYPES);
        this.getResourceName(checkDevNode, checkItems, pyTypes, true);
    }

    private void getResourceName(CheckDevNode checkDevNode, ListOrderedMap<String, List<CheckItem>> checkItems, NodeList cmdTypes, boolean isDepth) {
        if (cmdTypes == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < cmdTypes.getLength(); ++i) {
            Element e;
            String tag;
            Node node = cmdTypes.item(i);
            if (!(node instanceof Element) || this.tagCheck(tag = (e = (Element)node).getAttribute(ATTR_TAG), checkDevNode)) continue;
            List<CheckItem> items = this.parseCheckItems(e, checkDevNode, isDepth);
            String typeKey = XmlUtils.getAttribute((Element)e, (String)ATTR_CMDTYPENAME);
            if (this.notShowHostItem(checkDevNode, typeKey)) continue;
            String effectiveScene = XmlUtils.getAttribute((Element)e, (String)ATTR_CMDTYPE_EFFECTIVESENE);
            String type = CheckItemUtils.getModuleName(checkDevNode, items, typeKey);
            this.addCheckItems(checkDevNode, checkItems, effectiveScene, type, items);
        }
        CheckItemPlatformAdapterInInspect.getInstance().addCheckConfigItem((Map<String, List<CheckItem>>)checkItems, checkDevNode);
    }

    private boolean notShowHostItem(CheckDevNode checkDevNode, String typeKey) {
        if (InspectUtils.isDpaInspectScene()) {
            return "linux".equalsIgnoreCase(checkDevNode.getDevNode().getDeviceType().toString()) && !"dpa".equalsIgnoreCase(typeKey);
        }
        return "dpa".equalsIgnoreCase(typeKey);
    }

    public void addCheckItems(CheckDevNode checkDevNode, ListOrderedMap<String, List<CheckItem>> checkItems, String effectiveScene, String type, List<CheckItem> items) {
        if (checkDevNode.getDevNode() != null && checkDevNode.getDevNode().isDsStorage()) {
            this.addDstorageCheckItems(checkItems, type, items);
            return;
        }
        if (effectiveScene == null) {
            checkItems.put((Object)type, items);
            return;
        }
        if (effectiveScene.equals(InspectContext.getInstance().getExtendInspectScene())) {
            checkItems.put((Object)type, items);
            return;
        }
    }

    private void addDstorageCheckItems(ListOrderedMap<String, List<CheckItem>> checkItems, String type, List<CheckItem> items) {
        if (checkItems.containsKey((Object)type)) {
            List checkItemsByType = (List)checkItems.get((Object)type);
            List itemIdList = checkItemsByType.stream().map(CheckItem::getItemId).collect(Collectors.toList());
            items.forEach(item -> {
                if (!itemIdList.contains(item.getItemId())) {
                    checkItemsByType.add(item);
                }
            });
        } else {
            checkItems.put((Object)type, items);
        }
    }

    private boolean isSupportHostItem(String tag, CheckDevNode checkDevNode) {
        String verRegx = tag.replace("MAPPER_STORAGE_VERSION:", "");
        List<String> versions = InspectContext.getStorageProductByHost(checkDevNode);
        if (versions == null || versions.isEmpty()) {
            return false;
        }
        return versions.stream().anyMatch(version -> version.matches(verRegx));
    }

    private boolean tagCheck(String tag, CheckDevNode checkDevNode) {
        boolean onlyMemoryInspection = TagCondition.hasTag(tag, "ONLY_MEMORY_INSPECTION");
        if (InspectContext.getInstance().isInMemoryInspectionSence()) {
            return !onlyMemoryInspection;
        }
        boolean oemoutCheck = TagCondition.hasTag(tag, "NO_OEMOUT") && InspectContext.getInstance().isOemOutTool();
        boolean bureauCheck = TagCondition.hasTag(tag, "BUREAU_CHECK") && !BureauDocuService.INS.isDevSupport(checkDevNode.getDevNode());
        boolean hostItemNoSuppot = TagCondition.hasTag(tag, "MAPPER_STORAGE_VERSION:") && !this.isSupportHostItem(tag, checkDevNode);
        boolean timingNotSupport = TagCondition.hasTag(tag, "NO_TIMING") && InspectUtils.isToolkitTimingTask();
        boolean isToolKitZh = TagCondition.hasTag(tag, "ZH_ONLY") && !InspectContext.getInstance().isToolkitZhCn();
        boolean isSceneEqual = TagCondition.hasTag(tag, "YINGLONG") && !InspectUtils.isStartedByYingLong();
        return oemoutCheck || bureauCheck || hostItemNoSuppot || timingNotSupport || isToolKitZh || onlyMemoryInspection || isSceneEqual;
    }

    private List<CheckItem> parseCheckItems(Element e, CheckDevNode checkDevNode, boolean isDepth) {
        Collection cmditems = XmlUtils.getChildren((Element)e);
        ArrayList<CheckItem> checkItems = new ArrayList<CheckItem>();
        Node deviceNode = e.getParentNode();
        String enableMark = null;
        if (deviceNode instanceof Element) {
            enableMark = XmlUtils.getAttribute((Element)((Element)deviceNode), (String)ENABLE_MARK);
            log.info("enableMark=" + enableMark);
        }
        InspectSceneValue inspectSceneValue = InspectContext.getInstance().getInspectSceneValue();
        log.info("inspectSceneValue: {}", (Object)inspectSceneValue);
        this.checkScriptInfo(checkDevNode, isDepth, cmditems, checkItems, enableMark, inspectSceneValue);
        return checkItems;
    }

    private void checkScriptInfo(CheckDevNode checkDevNode, boolean isDepth, Collection<Element> cmditems, List<CheckItem> checkItems, String enableMark, InspectSceneValue inspectSceneValue) {
        for (Element ele : cmditems) {
            String modelRegx;
            String minPatch;
            String maxPatch;
            String verRegx;
            String tag;
            Set<InspectSceneValue> notSupportSceneValueSet = this.getNotSupportSceneValueSet(ele);
            if (InspectSceneValue.containSceneValueSet(notSupportSceneValueSet, inspectSceneValue) || this.tagCheck(tag = XmlUtils.getAttribute((Element)ele, (String)ATTR_TAG), checkDevNode)) continue;
            String itemEffectScene = XmlUtils.getAttribute((Element)ele, (String)ATTR_ITEM_EFFSCENE);
            CheckItem item = new CheckItem();
            if (!StringUtils.isNULLStr((String)tag)) {
                item.setTag(tag);
            }
            if (!StringUtils.isNULLStr((String)itemEffectScene)) {
                item.setEffectiveScene(itemEffectScene);
            }
            if (!StringUtils.isNULLStr((String)(verRegx = XmlUtils.getAttribute((Element)ele, (String)VER_REGX))) && !checkDevNode.getDevNode().getProductVersion().matches(verRegx) || !StringUtils.isNULLStr((String)(maxPatch = XmlUtils.getAttribute((Element)ele, (String)MAX_PATCH))) && !this.isLessThanTheMaximumVersion(checkDevNode, maxPatch) || !StringUtils.isNULLStr((String)(minPatch = XmlUtils.getAttribute((Element)ele, (String)MIN_PATCH))) && !this.isNotLessThanTheMinimumVersion(checkDevNode, minPatch) || !StringUtils.isNULLStr((String)(modelRegx = XmlUtils.getAttribute((Element)ele, (String)MODEL_REGX))) && !this.checkDevType(checkDevNode, modelRegx)) continue;
            this.setType(item, ele);
            String id = XmlUtils.getAttribute((Element)ele, (String)ATTR_ID);
            if (this.isDistributeDiagnoseItem(checkDevNode, id)) continue;
            String riskWeight = XmlUtils.getAttribute((Element)ele, (String)RISK_WEIGHT);
            String script = XmlUtils.getAttribute((Element)ele, (String)ATTR_SCRIPT);
            String isSelect = XmlUtils.getAttribute((Element)ele, (String)"isSelect");
            this.setScriptItem(checkDevNode, isDepth, checkItems, enableMark, ele, item, id, riskWeight, script, isSelect);
        }
    }

    private boolean isLessThanTheMaximumVersion(CheckDevNode checkDevNode, String maxPatch) {
        Optional<String> patchOptional = this.parsingThePatchVersion(checkDevNode, maxPatch);
        return patchOptional.map(patchVersion -> Products.compareVersion((String)checkDevNode.getDevNode().getHotPatchVersion(), (String)patchVersion) < 0).orElse(true);
    }

    private boolean isNotLessThanTheMinimumVersion(CheckDevNode checkDevNode, String minPatch) {
        Optional<String> patchOptional = this.parsingThePatchVersion(checkDevNode, minPatch);
        return patchOptional.map(patchVersion -> Products.compareVersion((String)checkDevNode.getDevNode().getHotPatchVersion(), (String)patchVersion) >= 0).orElse(true);
    }

    private Optional<String> parsingThePatchVersion(CheckDevNode checkDevNode, String patchInfo) {
        return Arrays.stream(patchInfo.trim().split(",")).map(str -> str.split(":")).filter(arrays -> ((String[])arrays).length >= 2).filter(arrays -> checkDevNode.getDevNode().getProductVersion().equals(arrays[0])).findFirst().map(arrays -> arrays[1]);
    }

    private boolean isDistributeDiagnoseItem(CheckDevNode checkDevNode, String id) {
        return checkDevNode.isDistributed() && !StringUtils.isNULLStr((String)id) && (id.startsWith("fd_ds") || id.startsWith("FD_DS"));
    }

    private boolean checkDevType(CheckDevNode checkDevNode, String modelRegx) {
        String devType = checkDevNode.getDevNode().getDeviceType().toString();
        log.info("devType: {}", (Object)devType);
        if ("NewDorado".equals(modelRegx)) {
            return ConstantField.NEW_DORADO_DEV.contains(devType);
        }
        return devType.contains(modelRegx);
    }

    private void setType(CheckItem item, Element ele) {
        String type = XmlUtils.getAttribute((Element)ele, (String)"type");
        if (!StringUtils.isNULLStr((String)type)) {
            item.setItemCheckType(CheckItem.ItemCheckType.getByType(type));
        }
    }

    private void setScriptItem(CheckDevNode checkDevNode, boolean isDepth, List<CheckItem> checkItems, String enableMark, Element ele, CheckItem item, String id, String riskWeight, String script, String isSelect) {
        if (isDepth) {
            item.setDepth(true);
        }
        if (isSelect != null) {
            item.setEnable(Boolean.parseBoolean(isSelect));
        }
        item.setItemId(id);
        item.setRiskWeight(riskWeight);
        item.setEnableMark(enableMark);
        item.setScript(script);
        String timeout = XmlUtils.getAttribute((Element)ele, (String)"timeout");
        if (timeout != null) {
            int time = StringUtils.str2Int((String)timeout, (int)1200);
            item.setTimeouts(time);
        }
        this.parssExpansionItems(ele, item);
        List<Item> items = this.getItems(ele, item, checkDevNode);
        item.setItems(items);
        item.setName(checkDevNode.getNameByRes(id));
        checkItems.add(item);
    }

    private void parssExpansionItems(Element ele, CheckItem item) {
        String preInspectionScrip;
        String extendItemMode;
        String shellPath = XmlUtils.getAttribute((Element)ele, (String)"shellPath");
        String shellupdatePath = XmlUtils.getAttribute((Element)ele, (String)"updatePath");
        if (shellPath != null && shellupdatePath != null) {
            item.setDstorageShellPath(shellPath);
            item.setDstorageShellUpdatePath(shellupdatePath);
            item.setUserExpansionRes(true);
        }
        if ((extendItemMode = XmlUtils.getAttribute((Element)ele, (String)"extendItemMode")) != null) {
            item.setExtendItemMode(extendItemMode);
            item.setUserExpansionRes(true);
        }
        if ((preInspectionScrip = XmlUtils.getAttribute((Element)ele, (String)"preInspectionScrip")) != null) {
            item.setPreInspectionScrip(preInspectionScrip);
            item.setUserExpansionRes(true);
        }
        Optional.ofNullable(XmlUtils.getAttribute((Element)ele, (String)"checkScript")).ifPresent(item::setCheckScript);
    }

    private List<Item> getItems(Element ele, CheckItem checkItem, CheckDevNode checkDevNode) {
        Collection elements = XmlUtils.getChildren((Element)ele);
        ArrayList<Item> items = new ArrayList<Item>();
        for (Element e : elements) {
            Item item = new Item();
            String id = XmlUtils.getAttribute((Element)e, (String)ATTR_ID);
            item.setId(id);
            item.setName(checkDevNode.getNameByRes(checkItem.getItemId() + "." + id));
            items.add(item);
        }
        return items;
    }

    protected ResourceBundle readProperties(File propertiesPath) {
        Locale loc = InspectContext.getInstance().getLoc();
        String currentLanguage = null == loc ? ApplicationContext.getInstance().getCurrentLanguage().getLanguage() : loc.getLanguage();
        File propertiesFile = new File(propertiesPath, "resource_" + currentLanguage + ".properties");
        PropertyResourceBundle bundle = null;
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]));){
            bundle = new PropertyResourceBundle(input);
        }
        catch (IOException | RuntimeException e) {
            log.error("Read resource properties error", (Throwable)e);
        }
        return bundle;
    }

    private Set<InspectSceneValue> getNotSupportSceneValueSet(Element ele) {
        HashSet<InspectSceneValue> sceneValueSet = new HashSet<InspectSceneValue>();
        Element eleCmdItem = XmlUtils.getChild((Element)ele, (String)"item");
        Element notSupportScenesEle = XmlUtils.getChild((Element)eleCmdItem, (String)"notSupportScenes");
        if (notSupportScenesEle == null) {
            return sceneValueSet;
        }
        Collection sceneEleCollection = XmlUtils.getChildren((Element)notSupportScenesEle, (String)"scene");
        for (Element sceneEle : sceneEleCollection) {
            String field = XmlUtils.getAttribute((Element)sceneEle, (String)"field");
            String mainScene = XmlUtils.getAttribute((Element)sceneEle, (String)"mainScene");
            String subScene = XmlUtils.getAttribute((Element)sceneEle, (String)"subScene");
            InspectSceneValue value = new InspectSceneValue(mainScene, subScene, field);
            log.info("value: {}", (Object)value);
            sceneValueSet.add(value);
        }
        return sceneValueSet;
    }

    public static ArrayList<String> getWhiteItems(String checklistXmlPath) {
        ArrayList<String> checkItems = new ArrayList<String>();
        Document doc = null;
        File checklistXml = new File(checklistXmlPath);
        try (InputStream inputStream = Files.newInputStream(checklistXml.toPath(), new OpenOption[0]);){
            doc = XmlUtils.parseDocument((InputStream)inputStream);
        }
        catch (IOException e) {
            log.error("init check item error. file {} not found.", (Object)checklistXml.getName());
        }
        catch (RuntimeException e) {
            log.error("init check item error.", (Throwable)e);
        }
        NodeList items = XmlUtils.searchNodeByExp(doc, (String)XQL_ITEMLIST);
        if (items == null) {
            log.error("white items is null");
            return checkItems;
        }
        return IntStream.range(0, items.getLength()).mapToObj(items::item).filter(node -> node instanceof Element).map(Element.class::cast).map(XmlUtils::getChildren).flatMap(Collection::stream).map(ele -> XmlUtils.getAttribute((Element)ele, (String)ATTR_ID)).collect(Collectors.toCollection(ArrayList::new));
    }
}

