/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.PyScriptCheckModel;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.jython.JythonCheckItemService;
import com.huawei.ism.tool.pyengine.psdk.bean.CheckConfigItem;
import com.huawei.ism.tool.pyengine.psdk.bean.ExecuteEnv;
import com.huawei.ism.tool.pyengine.psdk.bean.ExpansionExecuteEnv;
import com.huawei.ism.tool.pyengine.psdk.bean.InspectExecuteEnv;
import com.huawei.ism.tool.pyengine.psdk.bean.PyTaskResult;
import com.huawei.ism.tool.pyengine.psdk.common.CheckItemStatus;
import com.huawei.ism.tool.pyengine.psdk.common.ExecuteEnvConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckItemPlatformAdapterInInspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckItemPlatformAdapterInInspect.class);
    private static final String USER_NO_PERMISSION_CHECK = "inspect.no.permission.check";
    private static final CheckItemPlatformAdapterInInspect INSTANCE = new CheckItemPlatformAdapterInInspect();
    private final Map<CheckDevNode, ExecuteEnv> devExecuteEnvMap = new ConcurrentHashMap<CheckDevNode, ExecuteEnv>();

    public static CheckItemPlatformAdapterInInspect getInstance() {
        return INSTANCE;
    }

    private CheckItemPlatformAdapterInInspect() {
    }

    private void initExecuteEnv(CheckDevNode dev) {
        Optional env;
        String expScene = InspectContext.getInstance().getExtendInspectScene();
        if ("exInspect".equalsIgnoreCase(expScene)) {
            String expMode = InspectContext.getInstance().getExpMode();
            log.info("current scene is expansion eval. exp mode={}", (Object)expMode);
            env = ExpansionExecuteEnv.buildExecuteEnvForEval((String)expMode);
            PyScriptCheckModel model = new PyScriptCheckModel(dev, null);
            env.ifPresent(actual -> actual.setOriEnv(model.getEnv()));
        } else {
            env = this.getInspectEnv();
        }
        env.ifPresent(actual -> this.devExecuteEnvMap.put(dev, (ExecuteEnv)actual));
    }

    private Optional<ExecuteEnv> getInspectEnv() {
        String sceneId = (String)InspectContext.getInstance().getInspectWorktaker().get("select_sceneId");
        if (InspectContext.getInstance().isInMemoryInspectionSence()) {
            return Optional.empty();
        }
        if ("realTimed_check".equals(sceneId)) {
            return Optional.of(new InspectExecuteEnv(ExecuteEnvConstants.ExecuteTool.INSPECT_DAILY));
        }
        if ("bureau_check".equals(sceneId)) {
            return Optional.of(new InspectExecuteEnv(ExecuteEnvConstants.ExecuteTool.INSPECT_BUREAU));
        }
        return Optional.empty();
    }

    public void addCheckConfigItem(Map<String, List<CheckItem>> allCheckItems, CheckDevNode checkDevNode) {
        this.initExecuteEnv(checkDevNode);
        if (this.devExecuteEnvMap.get(checkDevNode) == null) {
            log.info("no need add config item.");
            return;
        }
        JythonCheckItemService itemService = new JythonCheckItemService(this.devExecuteEnvMap.get(checkDevNode));
        List configItems = itemService.getCheckItemList(EntityUtils.toNewDev((DevNode)checkDevNode.getDevNode()));
        Map<String, List<CheckConfigItem>> groupedConfigItem = configItems.stream().collect(Collectors.groupingBy(CheckConfigItem::getModule));
        groupedConfigItem.forEach((moduleId, moduleItems) -> {
            String moduleName;
            List<CheckItem> addItems = moduleItems.stream().map(this::transConfigItem).collect(Collectors.toList());
            log.info("addCheckConfigItem: moduleId" + moduleId);
            if ("leak".equals(moduleId)) {
                CheckItemPlatformAdapterInInspect.setCheckTitleNotSelected(moduleId, addItems);
            }
            String storageSoftwareName = CheckItemUtils.getModuleName(checkDevNode, addItems, "storageSoftware");
            if (moduleId.equals("software") && allCheckItems.containsKey(storageSoftwareName)) {
                moduleId = "storageSoftware";
            }
            if (allCheckItems.containsKey(moduleName = CheckItemUtils.getModuleName(checkDevNode, addItems, moduleId))) {
                this.mergeCheckItem((List)allCheckItems.get(moduleName), addItems);
            } else {
                allCheckItems.put(moduleName, addItems);
            }
        });
    }

    private static void setCheckTitleNotSelected(String moduleId, List<CheckItem> addItems) {
        List<CheckItem> checkAddItems = addItems;
        if ("basic".equals(System.getenv("sence"))) {
            checkAddItems = new ArrayList<CheckItem>();
        }
        for (CheckItem checkItem : checkAddItems) {
            log.info("checkItem.setSelected(false) addCheckConfigItem: moduleId" + moduleId + "; item name:" + checkItem.getName());
            checkItem.setEnable(false);
        }
    }

    private void mergeCheckItem(List<CheckItem> existedItems, List<CheckItem> addItems) {
        List itemIds = existedItems.stream().map(CheckItem::getItemId).collect(Collectors.toList());
        addItems.stream().filter(checkItem -> !itemIds.contains(checkItem.getItemId())).forEach(existedItems::add);
    }

    private CheckItem transConfigItem(CheckConfigItem configItem) {
        CheckItem item = new CheckItem();
        item.setConfigItem(configItem);
        item.setItemId(configItem.getItemId());
        item.setName(configItem.getName());
        Item childItem = new Item();
        childItem.setId(configItem.getItemId());
        childItem.setName(configItem.getName());
        item.setItems(Collections.singletonList(childItem));
        return item;
    }

    public ResultItem runConfigItem(CheckDevNode devNode, CheckItem checkItem) {
        ResultItem resultItem = new ResultItem();
        resultItem.setCheckItem(checkItem);
        JythonCheckItemService service = new JythonCheckItemService(this.devExecuteEnvMap.get(devNode));
        PyTaskResult taskResult = service.runCheckConfigItem(EntityUtils.toNewDev((DevNode)devNode.getDevNode()), checkItem.getConfigItem().getScript());
        checkItem.setErrorInfo(taskResult.getDetail());
        String originInfo = StringUtils.isNULLStr((String)taskResult.getOriginInfo()) ? "" : taskResult.getOriginInfo();
        checkItem.setSourceInfo(originInfo, devNode);
        if (StringUtils.isNULLStr((String)taskResult.getStatus())) {
            String errorDes = ResourceUtil.getStringWithParams((String)USER_NO_PERMISSION_CHECK, (Object[])new Object[0]);
            taskResult.setDetail(errorDes);
            checkItem.setErrorInfo(errorDes);
            resultItem.setNoCheck(true);
            return resultItem;
        }
        CheckItemStatus itemStatus = CheckItemStatus.valueOf((String)taskResult.getStatus());
        switch (itemStatus) {
            case PASS: {
                resultItem.setNormal(true);
                break;
            }
            case NOT_PASS: {
                resultItem.setNormal(false);
                break;
            }
            case NOT_SUPPORT: {
                resultItem.setNoSupport(true);
                break;
            }
            case WARNING: {
                resultItem.setWarning(true);
                break;
            }
            default: {
                resultItem.setNoCheck(true);
            }
        }
        return resultItem;
    }

    @Generated
    public Map<CheckDevNode, ExecuteEnv> getDevExecuteEnvMap() {
        return this.devExecuteEnvMap;
    }
}

