/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.inspect.logic.config.InspectSceneValue;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class FlowConfig {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FlowConfig.class);
    private static Config commonSceneConfig = null;
    private static Config commonConfig = null;
    private static List<Config> configs = new ArrayList<Config>();
    private static Config viewConfig = null;

    public static Config getCommonSceneConfig() {
        return commonSceneConfig;
    }

    public static void setCommonSceneConfig(Config commonSceneConfig) {
        FlowConfig.commonSceneConfig = commonSceneConfig;
    }

    public static List<Config> getConfigs() {
        return configs;
    }

    public static Config getCommonConfig() {
        return commonConfig;
    }

    public static void setCommonConfig(Config commonConfig) {
        FlowConfig.commonConfig = commonConfig;
    }

    public static Config getViewConfig() {
        if (viewConfig != null) {
            return viewConfig;
        }
        InspectUtils.initSceneData();
        InspectSceneValue sceneValue = InspectContext.getInstance().getInspectSceneValue();
        if (SceneUtils.isScene()) {
            viewConfig = commonSceneConfig;
            LOGGER.info("scene value : {}", (Object)sceneValue);
            for (Config sceneConfig : configs) {
                if (!sceneConfig.getSceneValue().equals(sceneValue)) continue;
                viewConfig = sceneConfig;
                break;
            }
        } else {
            viewConfig = commonConfig;
        }
        return viewConfig;
    }

    public static class Config {
        private InspectSceneValue sceneValue = null;
        private List<String> stepViewList = new LinkedList<String>();
        private Map<Class, Map<String, Object>> taskImplMap = new HashMap<Class, Map<String, Object>>();

        public InspectSceneValue getSceneValue() {
            return this.sceneValue;
        }

        public void setSceneValue(InspectSceneValue sceneValue) {
            this.sceneValue = sceneValue;
        }

        public List<String> getStepViewList() {
            return this.stepViewList;
        }

        public void setStepViewList(List<String> stepViewList) {
            this.stepViewList = stepViewList;
        }

        public Map<Class, Map<String, Object>> getTaskImplMap() {
            return this.taskImplMap;
        }

        public void setTaskImplMap(Map<Class, Map<String, Object>> taskImplMap) {
            this.taskImplMap = taskImplMap;
        }

        public String toString() {
            return "Config [sceneValue=" + this.sceneValue + ", stepViewList=" + this.stepViewList + ", taskImplMap=" + this.taskImplMap + "]";
        }
    }
}

