/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.inspect.logic.config.FlowConfig;
import com.huawei.ism.tool.inspect.logic.config.InspectSceneValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FlowParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowParser.class);
    private static final String FLOWCONFIG = "config/ViewConfig.xml";
    private static Document flowConfigDoc = null;
    private static InputStream in;

    public static void initFlowConfig() {
        if (flowConfigDoc == null) {
            return;
        }
        Node node = flowConfigDoc.getFirstChild();
        if (node instanceof Element) {
            Element e = (Element)node;
            FlowParser.parseConfig(e);
        }
    }

    private static void parseConfig(Element e) {
        FlowConfig.Config commonCofig = new FlowConfig.Config();
        FlowConfig.Config commonSceneConfig = new FlowConfig.Config();
        FlowParser.parseConfig(e, commonCofig, "commonConfig");
        FlowParser.parseConfig(e, commonSceneConfig, "commonSceneConfig");
        FlowConfig.setCommonConfig(commonCofig);
        FlowConfig.setCommonSceneConfig(commonSceneConfig);
        FlowParser.parseConfig(e, null, "sceneConfig", true);
    }

    private static void parseConfig(Element e, FlowConfig.Config config, String nodeName) {
        FlowParser.parseConfig(e, config, nodeName, false);
    }

    private static void parseConfig(Element e, FlowConfig.Config config, String nodeName, boolean isMutiNode) {
        Collection configCollect = XmlUtils.searchByExp2Ele((Node)e, (String)nodeName);
        List<FlowConfig.Config> configs = FlowConfig.getConfigs();
        if (isMutiNode) {
            for (Element cofigEle : configCollect) {
                FlowConfig.Config sceneConfig = new FlowConfig.Config();
                FlowParser.parseSceneInfo(cofigEle, sceneConfig);
                configs.add(sceneConfig);
                FlowParser.parseViewList(cofigEle, sceneConfig);
                FlowParser.parseExtraTasks(cofigEle, sceneConfig);
            }
        } else {
            for (Element cofigEle : configCollect) {
                FlowParser.parseViewList(cofigEle, config);
                FlowParser.parseExtraTasks(cofigEle, config);
            }
        }
    }

    private static void parseSceneInfo(Element e, FlowConfig.Config config) {
        String field = e.getAttribute("field");
        String mainScene = e.getAttribute("mainScene");
        String subScene = e.getAttribute("subScene");
        String argsList = e.getAttribute("argsList");
        InspectSceneValue sceneValue = new InspectSceneValue(mainScene, subScene, field);
        sceneValue.setArgsList(argsList);
        LOGGER.info("load sceneValue : {}", (Object)sceneValue);
        config.setSceneValue(sceneValue);
    }

    private static void parseExtraTasks(Element e, FlowConfig.Config config) {
        Collection extraTasks = XmlUtils.searchByExp2Ele((Node)e, (String)"extraTaskList/extraTask");
        if (extraTasks != null) {
            for (Element extraTask : extraTasks) {
                String taskImpClazzStr = extraTask.getAttribute("taskImplClazz");
                HashMap<String, Object> args = new HashMap<String, Object>();
                String proiority = extraTask.getAttribute("priority");
                boolean condition = Boolean.parseBoolean(extraTask.getAttribute("condition"));
                args.put("priority", proiority);
                args.put("condition", condition);
                try {
                    Class<?> taskImpClazz = Class.forName(taskImpClazzStr);
                    config.getTaskImplMap().put(taskImpClazz, args);
                }
                catch (Exception e1) {
                    LOGGER.error("ref taskImpClass failed. " + taskImpClazzStr, (Throwable)e1);
                }
            }
        }
    }

    private static void parseViewList(Element e, FlowConfig.Config config) {
        String stepViewStr = XmlUtils.getTextContentOfChild((Element)e, (String)"stepViewList");
        if (!StringUtils.isNULLStr((String)stepViewStr)) {
            config.setStepViewList(Arrays.asList(stepViewStr.split(",")));
        }
    }

    static {
        try {
            in = ClassLoader.getSystemResourceAsStream(FLOWCONFIG);
            flowConfigDoc = XmlUtils.parseDocument((InputStream)in);
        }
        catch (Exception e) {
            LOGGER.error("parse document flowconfig error.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("InputStream close error.", (Throwable)e);
                }
            }
        }
    }
}

