/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class FusionStorageConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionStorageConfig.class);
    public static final int FS_EXPANSION_WIZARD_DIALOG_WIDTH = 1080;
    public static final int FS_EXPANSION_WIZARD_DIALOG_HEIGHT = 650;
    private static List<KeyValue<String, String>> bureauSupportTypeAndVer = new ArrayList<KeyValue<String, String>>();
    private static List<KeyValue<String, String>> supportFixItemProduct = new ArrayList<KeyValue<String, String>>();
    private static String bureauCheckId = "site_deployment_check";
    private static String realTimedCheckId = "realTimed_check";
    private static String dsFwExtendCheckId = "ds_fw_extend_check";
    private static String fsExpansionCheckId = "FsExpansion";
    private static int reportMaxShowNode = 20;
    private static int queryTimeout = 1200000;
    private static String inspectionIds = ResourceBundle.getBundle("config.inspect").getString("inspectionIds");
    private static long AFTER_CHECK_EXEC_TIMEOUT = 120000L;
    private static final Map<DevNode, Set<String>> ALL_SCENE_ITEMS = new ConcurrentHashMap<DevNode, Set<String>>();
    private static Map<String, String> specificCheckItems = new ConcurrentHashMap<String, String>();
    private static Map<String, List<String>> timingTaskCheckItemIdsMap = new ConcurrentHashMap<String, List<String>>();

    public static synchronized Map<String, String> getSpecificCheckItems() {
        if (specificCheckItems.size() > 0) {
            return specificCheckItems;
        }
        try {
            NodeList checkItems = XmlUtils.parseDocument((InputStream)new FileInputStream(new File(ApplicationContext.getInstance().getConfigurationPath() + "specific_check_item_id.xml"))).getElementsByTagName("checkItem");
            for (int i = 0; i < checkItems.getLength(); ++i) {
                NamedNodeMap attributes = checkItems.item(i).getAttributes();
                specificCheckItems.put(attributes.item(0).getTextContent(), attributes.item(1).getTextContent());
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("specific_check_item_id.xml not fount");
        }
        return specificCheckItems;
    }

    public static synchronized Map<String, List<String>> getTimingTaskCheckItemIdsMap() {
        if (!timingTaskCheckItemIdsMap.isEmpty()) {
            return timingTaskCheckItemIdsMap;
        }
        try {
            Document document = XmlUtils.parseDocument((InputStream)new FileInputStream(new File(ApplicationContext.getInstance().getConfigurationPath() + "timing_task_check_item.xml")));
            timingTaskCheckItemIdsMap.put("concentratedCheckItem", new ArrayList());
            timingTaskCheckItemIdsMap.put("distributedCheckItem", new ArrayList());
            timingTaskCheckItemIdsMap.keySet().forEach(deviceType -> timingTaskCheckItemIdsMap.get(deviceType).addAll(Arrays.asList(document.getElementsByTagName((String)deviceType).item(0).getTextContent().split(","))));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("timing_task_check_item.xml not fount");
        }
        return timingTaskCheckItemIdsMap;
    }

    public static String getBureauCheckId() {
        return bureauCheckId;
    }

    public static String getRealTimedCheckId() {
        return realTimedCheckId;
    }

    public static String getFsExpansionCheckId() {
        return fsExpansionCheckId;
    }

    public static List<KeyValue<String, String>> getBureauSupportTypeAndVer() {
        return bureauSupportTypeAndVer;
    }

    public static int getReportMaxShowNode() {
        return reportMaxShowNode;
    }

    public static int getQueryTimeOut() {
        return queryTimeout;
    }

    public static long getAfterCheckExecTimeout() {
        return AFTER_CHECK_EXEC_TIMEOUT;
    }

    public static List<String> getInspectionIds() {
        String[] ids = inspectionIds.split(",");
        List<String> idList = Arrays.asList(ids);
        return idList;
    }

    public static boolean isMatchFixVersion(DevNode devNode) {
        String model = devNode.getProductModel();
        String version = devNode.getProductVersion();
        return supportFixItemProduct.stream().anyMatch(modeAndVer -> ((String)modeAndVer.getKey()).equals(model) && ((String)modeAndVer.getValue()).equals(version));
    }

    public static String getNfvVersion(String nfvVersionKey) {
        return ResourceBundle.getBundle("config.inspect").getString(nfvVersionKey);
    }

    public static List<String> getDiskZoneOldRulesVersions() {
        return Arrays.asList(ResourceBundle.getBundle("config.inspect").getString("diskZoneOldRulesInvolveVersions").split(","));
    }

    public static boolean isDos2UnixSwitchOpened() {
        return Boolean.parseBoolean(ResourceBundle.getBundle("config.inspect").getString("isDos2UnixFor6.xScript"));
    }

    public static void putAllSceneItems(DevNode devNode, Set<String> items) {
        ALL_SCENE_ITEMS.computeIfAbsent(devNode, key -> new HashSet()).addAll(items);
    }

    public static Set<String> getAllSceneItems(DevNode devNode) {
        return ALL_SCENE_ITEMS.getOrDefault(devNode, new HashSet());
    }

    @Generated
    public static String getDsFwExtendCheckId() {
        return dsFwExtendCheckId;
    }

    static {
        ResourceBundle sysBundle = ResourceBundle.getBundle("config.inspect");
        try {
            String[] map;
            String[] typeVersion;
            bureauCheckId = sysBundle.getString("dstorage_bureau_check_id");
            reportMaxShowNode = Integer.parseInt(sysBundle.getString("dstorage_report_max_show_node"));
            queryTimeout = Integer.parseInt(sysBundle.getString("fsQueryTimeoutMinute")) * 60000;
            for (String mapStr : typeVersion = sysBundle.getString("dstorage_bureau_support_map").split(",")) {
                map = mapStr.split(":");
                bureauSupportTypeAndVer.add((KeyValue<String, String>)new KeyValue((Object)map[0], (Object)map[1]));
            }
            for (String mapStr : typeVersion = sysBundle.getString("dstorage_remove_map").split(",")) {
                map = mapStr.split(":");
                supportFixItemProduct.add((KeyValue<String, String>)new KeyValue((Object)map[0], (Object)map[1]));
            }
        }
        catch (Exception e) {
            LOGGER.error("init ds support type error.", (Throwable)e);
        }
    }
}

