/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HostSupportVersionParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(HostSupportVersionParser.class);
    private static final String CONFIG_PATH;
    private static final String HOST_WHITE_LIST_NAME = "Host_WhiteList.xml";
    private static final String HOST_WHITE_LIST_DORADO_V6_NAME = "Host_WhiteList_DoradoV6.xml";

    public static Map<String, List<String>> getHostSupportVers() {
        String[] xmlSet;
        HashMap<String, Set<String>> allHostSupportVers = new HashMap<String, Set<String>>();
        for (String xmlPath : xmlSet = new String[]{CONFIG_PATH + HOST_WHITE_LIST_NAME, CONFIG_PATH + HOST_WHITE_LIST_DORADO_V6_NAME}) {
            Map<String, Set<String>> hostSupportVers = HostSupportVersionParser.pareSupportXml(xmlPath);
            for (String model : hostSupportVers.keySet()) {
                if (allHostSupportVers.containsKey(model)) {
                    ((Set)allHostSupportVers.get(model)).addAll((Collection)hostSupportVers.get(model));
                    continue;
                }
                allHostSupportVers.put(model, hostSupportVers.get(model));
            }
        }
        HashMap<String, List<String>> allHostSupportVersNew = new HashMap<String, List<String>>();
        for (String model : allHostSupportVers.keySet()) {
            Set versionSet = (Set)allHostSupportVers.get(model);
            ArrayList versionList = new ArrayList(versionSet);
            allHostSupportVersNew.put(model, versionList);
        }
        return allHostSupportVersNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Set<String>> pareSupportXml(String hostSupportXmlPath) {
        HashMap<String, Set<String>> hostSupportVers = new HashMap<String, Set<String>>();
        File hostSupportFile = new File(hostSupportXmlPath);
        if (!hostSupportFile.exists()) {
            return hostSupportVers;
        }
        Document deviceDoc = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(hostSupportFile);
            deviceDoc = XmlUtils.parseDocument((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("init checkitem error.hostSupportFile {} not found.", (Object)hostSupportFile.getName());
        }
        catch (RuntimeException e) {
            LOGGER.error("init checkitem error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)deviceDoc, (String)"root/host");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element product = (Element)node;
            HashSet<String> versionList = new HashSet<String>();
            Collection chiadNodeList = XmlUtils.getChildren((Element)product, (String)"version");
            for (Element chiadNode : chiadNodeList) {
                String ver = chiadNode.getTextContent();
                versionList.add(ver);
            }
            String type = product.getAttribute("type");
            hostSupportVers.put(type, versionList);
        }
        return hostSupportVers;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        InspectContext.getInstance();
        CONFIG_PATH = stringBuilder.append(InspectContext.INSPECT_CONFPATH).append(File.separator).append("products").append(File.separator).append("HOST_Common").append(File.separator).append("config").append(File.separator).toString();
    }
}

