/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Set;

public class InspectSceneValue {
    private String mainScene;
    private String subScene;
    private String field;
    private String argsList = "";

    public InspectSceneValue(String mainScene, String subScene, String field) {
        this.mainScene = mainScene;
        this.subScene = subScene;
        this.field = field;
    }

    public String getMainScene() {
        return this.mainScene;
    }

    public void setMainScene(String mainScene) {
        this.mainScene = mainScene;
    }

    public String getSubScene() {
        return this.subScene;
    }

    public void setSubScene(String subScene) {
        this.subScene = subScene;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String toString() {
        return "InspectSceneValue [mainScene=" + this.mainScene + ", subScene=" + this.subScene + ", field=" + this.field + ", argsList=" + this.argsList + "]";
    }

    public String getArgsList() {
        return this.argsList;
    }

    public void setArgsList(String argsList) {
        if (StringUtils.isNULLStr((String)argsList) || "{}".equals(argsList)) {
            return;
        }
        this.argsList = argsList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.argsList == null ? 0 : this.argsList.hashCode());
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.mainScene == null ? 0 : this.mainScene.hashCode());
        result = 31 * result + (this.subScene == null ? 0 : this.subScene.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof InspectSceneValue) {
            boolean hasNullType;
            InspectSceneValue other = (InspectSceneValue)obj;
            boolean bl = hasNullType = this.field == null || this.mainScene == null || this.subScene == null;
            if (!hasNullType) {
                return this.field.equals(other.getField()) && this.mainScene.equals(other.getMainScene()) && this.subScene.equals(other.getSubScene()) && this.containsArgs(other.argsList);
            }
        }
        return true;
    }

    private boolean containsArgs(String otherArgsList) {
        if (this.argsList != null && otherArgsList != null) {
            String[] args;
            for (String arg : args = this.argsList.split(",")) {
                if (otherArgsList.contains(arg)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containSceneValueSet(Set<InspectSceneValue> sceneValueSet, InspectSceneValue inspectSceneValue) {
        if (inspectSceneValue == null) {
            return false;
        }
        if (sceneValueSet.contains(inspectSceneValue)) {
            return true;
        }
        for (InspectSceneValue sceneValue : sceneValueSet) {
            if (StringUtils.isNULLStr((String)sceneValue.getField()) || !sceneValue.getField().equals(inspectSceneValue.getField())) continue;
            if (StringUtils.isNULLStr((String)sceneValue.getMainScene())) {
                return true;
            }
            if (!sceneValue.getMainScene().equals(inspectSceneValue.getMainScene()) || !StringUtils.isNULLStr((String)sceneValue.getSubScene())) continue;
            return true;
        }
        return false;
    }
}

