/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.config.ArrayProductParser;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import com.huawei.ism.tool.protocol.tlv.TlvConnectionManager;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.ResourceBundle;

public class Nexr5ProductParser
extends ArrayProductParser {
    private static final long serialVersionUID = 5196145707033934561L;
    private static final String QUERY_NASDEV_PYNAME = "querydevice.py";

    @Override
    public CheckDevNode initCheckDevByXml(Product product, DevNode ... devNodes) throws ToolException {
        DevNode header = devNodes[0];
        CheckDevNode rootCheckDevNode = new CheckDevNode();
        rootCheckDevNode.setIntegration(true);
        if (header.getDeviceType() != null) {
            rootCheckDevNode.setNodeName(header.getDeviceType().toString());
        }
        rootCheckDevNode.setProduct(product);
        CheckDevNode engineType = new CheckDevNode();
        engineType.setIntegration(true);
        rootCheckDevNode.addChildren(engineType);
        CheckDevNode r3ArrayNode = super.initCheckDevByXml(product, header);
        if (!InspectContext.getInstance().getSelectInspectType().equals("")) {
            String string = InspectContext.getInstance().getSelectInspectType();
            SysConfiguration.getInstance();
            if (!string.equals("realTimed_check")) {
                String string2 = InspectContext.getInstance().getSelectInspectType();
                SysConfiguration.getInstance();
                if (!string2.equals("timed_check")) {
                    return r3ArrayNode;
                }
            }
        }
        r3ArrayNode.setIntegration(true);
        engineType.addChildren(r3ArrayNode);
        engineType.setNodeName(ResourceUtil.getString((ResourceBundle)r3ArrayNode.getResourceBundle(), (String)"Handpiece"));
        rootCheckDevNode.setResourceBundle(r3ArrayNode.getResourceBundle());
        Object headerTlvConnection = null;
        this.checkInitialAddtion(product, header, rootCheckDevNode, r3ArrayNode);
        List<CheckDevNode> nodelist = rootCheckDevNode.getChildrens();
        if (nodelist.size() > 1) {
            return rootCheckDevNode;
        }
        return super.initCheckDevByXml(product, header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInitialAddtion(Product product, DevNode header, CheckDevNode rootCheckDevNode, CheckDevNode r3ArrayNode) {
        try {
            ITLVConnection headerTlvConnection = TlvConnectionManager.getConnection((DevNode)header);
            JythonExecuter executer = new JythonExecuter();
            File pyFile = new File(r3ArrayNode.getProduct().getConfigDir(), QUERY_NASDEV_PYNAME);
            executer.compileScript(pyFile);
            List ret = executer.invokeFunction("execute", new Object[]{headerTlvConnection});
            Boolean isOk = Boolean.valueOf(ret.get(0).toString());
            if (isOk.booleanValue()) {
                String xmlRet = ret.get(1).toString();
                this.initialAddtionDevices(rootCheckDevNode, header, xmlRet);
            }
        }
        catch (ToolException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("query nas device error.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("query nas device error. py file {} not found.", (Object)QUERY_NASDEV_PYNAME);
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("query nas device error.", (Throwable)e);
        }
        finally {
            try {
                TlvConnectionManager.releaseConnection((DevNode)header);
            }
            catch (ToolException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("release Connection error.", (Throwable)e);
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error(" ", (Throwable)e);
            }
        }
    }

    protected void initialAddtionDevices(CheckDevNode rootCheckDevNode, DevNode srcNode, String xmlResult) throws ToolException {
        List<DevNode> nasHeades = this.getStorageUnits(srcNode, xmlResult);
        CheckDevNode storageTypeNode = new CheckDevNode();
        storageTypeNode.setIntegration(true);
        for (DevNode node : nasHeades) {
            Product product = null;
            try {
                product = InspectContext.getInstance().getProductByDevNode(node);
                CheckDevNode nasHead = super.initCheckDevByXml(product, node);
                nasHead.setIntegration(true);
                storageTypeNode.addChildren(nasHead);
            }
            catch (ToolException ex) {
                ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)ex);
            }
            catch (RuntimeException ex) {
                ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)ex);
            }
        }
        if (!storageTypeNode.getChildrens().isEmpty()) {
            storageTypeNode.setNodeName(ResourceUtil.getString((ResourceBundle)rootCheckDevNode.getResourceBundle(), (String)"additionDevName"));
            rootCheckDevNode.addChildren(storageTypeNode);
        }
    }
}

