/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SecureLineChecker {
    private static final String CHECK_DEV_MODEL_PYNAME = "checkModel.py";
    private static final String SSH_CON_ENVKEY = "ssh";

    private SecureLineChecker() {
    }

    public static boolean isSecuredLine(CheckDevNode checkDevNode, File checkScriptDir) throws ToolException {
        JythonExecuter jythonExecuter = null;
        Map<String, Object> exeEnv = null;
        boolean beforSecure = false;
        try {
            File checkModelPyFile = new File(checkScriptDir, CHECK_DEV_MODEL_PYNAME);
            jythonExecuter = new JythonExecuter(checkScriptDir);
            exeEnv = SecureLineChecker.buildEnv(checkDevNode);
            jythonExecuter.compileScript(checkModelPyFile);
            List rets = jythonExecuter.invokeFunction("execute", exeEnv);
            beforSecure = Boolean.valueOf(rets.get(0).toString());
        }
        catch (PwdException e) {
            ToolLoggerFactory.getLogger(SecureLineChecker.class).error("", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(SecureLineChecker.class).error("check secured line.", (Throwable)e);
            throw new ToolException("check secured line.", (Throwable)e);
        }
        finally {
            if (jythonExecuter != null) {
                jythonExecuter.cleanup();
            }
            if (exeEnv != null) {
                SshConnectionManager.releaseConnection((ICliConnection)((ICliConnection)exeEnv.get(SSH_CON_ENVKEY)));
            }
        }
        return beforSecure;
    }

    private static Map<String, Object> buildEnv(CheckDevNode node) throws ToolException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        ICliConnection con = SshConnectionManager.getSshConnection((DevNode)node.getDevNode(), null, (boolean)true, (boolean)false);
        env.put(SSH_CON_ENVKEY, con);
        return env;
    }
}

