/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.config;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.inspect.entity.CollectItem;
import com.huawei.ism.tool.inspect.entity.CollectModule;
import com.huawei.ism.tool.inspect.entity.PARSER;
import com.huawei.ism.tool.inspect.entity.SupportScenes;
import com.huawei.ism.tool.inspect.fit.switchcheck.constants.SwitchCheckConstants;
import com.huawei.ism.tool.inspect.logic.config.IProductParser;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.ProductFileFilter;
import com.huawei.ism.tool.inspect.logic.config.SupportVersion;
import com.huawei.ism.tool.inspect.logic.debug.DebugType;
import com.huawei.ism.tool.inspect.logic.debug.IDebugModel;
import com.huawei.ism.tool.inspect.logic.debug.NullDebugModel;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.CheckModelInfo;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.PlusPackageDesc;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.IniReader;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.obase.utils.ZipUtils;
import com.huawei.ism.tool.obase.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SysConfiguration {
    public static final String DEF_CHECK_REALTIMED = "realTimed_check";
    public static final String DEF_CHECK_TIMED = "timed_check";
    public static final String WARNING_CHECK = "warning_check";
    public static final String T3000 = "T3000";
    public static final String ULTRAPATH = "UltraPath";
    public static final String SUP_SCENE_SPLIT = " ";
    public static final String SUP_SCENE_SPLIT_REGEX = "[ ]";
    public static final String PACKAGE_INI = "package.ini";
    public static final String ATTR_PRODUCT_ISSENCES = "isSences";
    public static final String ATTR_PRODUCT_INSPECT = "isInspect";
    public static final String PRODUCTS_FOLDER = "packages" + File.separator + "inspector" + File.separator + "products";
    public static final String SYSCONF_FILENAME = "sysconf.xml";
    public static final String EXTEND_SYSCONF_FILENAME = "ExtendSysconf.xml";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SysConfiguration.class);
    private static final String INSPECTOR_PATH = "packages" + File.separator + "inspector";
    private static final String WORKPATH;
    private static final String PACKAGE_PATH;
    private static final String NODE_DEBUGMODEL = "debugmodel";
    private static final String NODE_NOTNEEDDEBUG = "notneeddebug";
    private static final String NODE_PRODUCTNAME = "productname";
    private static final String NODE_NEEDPYJAVAENV = "needPyJavaEnv";
    private static final String NODE_ERROR_RED_VIEW = "errorRedView";
    private static final String NODE_APPLYRANGE = "applyrange";
    private static final String NODE_PARSERDEVCLASS = "parserdevclass";
    private static final String ADDITIONAL_ATTR = "properties";
    private static final String NODE_CHECKLIST = "checklist";
    private static final String PRODUCT_CODE = "productcode";
    private static final String ATTR_EXCLUDE_PRODUCT = "exclude";
    private static final String ATTR_PRODUCT_ISOLD = "isold";
    private static final String ATTR_PRODUCT_ISPASSEDNOTSHOWSUGGEST = "isPassedNotShowSuggest";
    private static final String ATTR_SUPPORT_REALTIME = "isSupportRealTime";
    private static final String ATTR_PRODUCT_CFG_VERSION = "cfgver";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_SCRIPT = "script";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_ZH_DESCRIPTION = "descZh";
    private static final String ATTR_EN_DESCRIPTION = "descEn";
    private static final String ATTR_SUPPORT_INSPECT_TYPE = "supportInspectType";
    private static final String EXTEND_SYS_COLLECT_CONF = "extendCollectConfig";
    private static final String COLLECT_MODULE = "module";
    private static final String NODE_CONF_DIR = "config";
    private static final String SUPPORT_SCENELIST = "supportList";
    private static final String SUPPORT_SCENES = "supportscene";
    private static final String SUPPORT_SCENES_ID = "id";
    private static final String SUPPORT_SCENES_CHECKLIST = "checklist";
    private static final String NODE_SUPPORT_TYPE = "supporttypes";
    private static final String XQL_QUERY_PRODUCTS = "/products/product";
    private static final String XQL_QUERY_SUPPORT_VERSION = "/products/supportLogic";
    private static final String PRODUCT_ELEMENT_SHOW_IMPACT = "showImpact";
    private static final String SCENES_FILENAME = "ScenesConfigSet.xml";
    private static final String SCENE = "scene";
    private static final String DEF_CHENK_FILENAME = "checklist.xml";
    private static final String REQUIRE_CHECK = "requireCheck";
    private static final String SCENES_CONFIG_FILE;
    private static final SysConfiguration INSTANCE;
    private static final String ITEM_ID = "id";
    private static final String MICRO_SERVICE_ID = "microservice";
    private static final String NAME_KEY = "namekey";
    private static final String MODE = "mode";
    private static final String DEFAULT_CHOOSE = "default";
    private static final String VERSIONS = "versions";
    private List<Product> products = new ArrayList<Product>();
    private List<SupportVersion> supportVersions = new ArrayList<SupportVersion>();
    private Map<String, String> productPackageMapping = new HashMap<String, String>();
    private Map<String, PlusPackageDesc> productPackages = new HashMap<String, PlusPackageDesc>();
    private boolean sceneList = false;
    private List<Product> switchProducts;

    public static final SysConfiguration getInstance() {
        return INSTANCE;
    }

    public void initSysconf() {
        this.products.clear();
        this.supportVersions.clear();
        this.loadProductSysconf();
        this.loadExtendSysconf();
        this.initRecommendedPatch();
        InspectContext.getInstance().setInspectProducts(this.products);
        InspectContext.getInstance().setSupportVersions(this.supportVersions);
    }

    private void initRecommendedPatch() {
        if (!InspectUtils.isDistributedFrw()) {
            Context.INS.initPatchConfig(InspectConstans.DSTORAGE_EXTENDE_PATH);
            return;
        }
        Context.INS.initPatchConfig(InspectConstans.DSTORAGE_PANGEA_EXTENDE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtendSysconf() {
        File productsFolder = new File(PACKAGE_PATH, PRODUCTS_FOLDER + File.separator + EXTEND_SYSCONF_FILENAME);
        Document doc = null;
        InputStream inputStream = null;
        try {
            inputStream = StreamUtils.createInputStream((File)productsFolder);
            doc = XmlUtils.parseDocumentNoPrintException((InputStream)inputStream);
        }
        catch (Exception e) {
            LOGGER.error("load Sysconf error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
        if (null == doc) {
            LOGGER.error("load Sysconf error.");
            return;
        }
        ArrayList<SupportVersion> versionList = new ArrayList<SupportVersion>();
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)XQL_QUERY_PRODUCTS);
        if (null == nodeList || nodeList.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element product = (Element)node;
            SupportVersion version = new SupportVersion();
            version.setModel(XmlUtils.getAttribute((Element)product, (String)ATTR_NAME));
            version.setVersion(XmlUtils.getAttribute((Element)product, (String)ATTR_VERSION));
            version.setDescZh(XmlUtils.getAttribute((Element)product, (String)ATTR_ZH_DESCRIPTION));
            version.setDescEn(XmlUtils.getAttribute((Element)product, (String)ATTR_EN_DESCRIPTION));
            version.setSupportInspectType(XmlUtils.getAttribute((Element)product, (String)ATTR_SUPPORT_INSPECT_TYPE));
            if (!StringUtils.isNULLStr((String)XmlUtils.getAttribute((Element)product, (String)EXTEND_SYS_COLLECT_CONF))) {
                this.loadExtendSysExtCollect(version, XmlUtils.getAttribute((Element)product, (String)EXTEND_SYS_COLLECT_CONF));
            }
            versionList.add(version);
        }
        InspectContext.getInstance().setExtendVersions(versionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtendSysExtCollect(SupportVersion sVersion, String extCollectConf) {
        File extCollectFolder = new File(PACKAGE_PATH, PRODUCTS_FOLDER + File.separator + extCollectConf);
        Document doc = null;
        InputStream inputStream = null;
        try {
            inputStream = StreamUtils.createInputStream((File)extCollectFolder);
            doc = XmlUtils.parseDocumentNoPrintException((InputStream)inputStream);
        }
        catch (Exception e) {
            LOGGER.error("load extCollectFolder error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
        if (null == doc) {
            LOGGER.error("load Sysconf error.");
            return;
        }
        ArrayList<CollectModule> conf = new ArrayList<CollectModule>();
        Element root = doc.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName(COLLECT_MODULE);
        this.getResult(nodeList, conf);
        sVersion.setExtCollectItems(conf);
    }

    private void getResult(NodeList nodeList, List<CollectModule> result) {
        int length = nodeList.getLength();
        for (int index = 0; index < length; ++index) {
            Node modelNode = nodeList.item(index);
            if (!(modelNode instanceof Element)) continue;
            result.add(this.parseCollectModule((Element)modelNode));
        }
    }

    private CollectModule parseCollectModule(Element moduleElement) {
        CollectModule module = new CollectModule();
        String nameKey = moduleElement.getAttribute(NAME_KEY);
        String mode = moduleElement.getAttribute(MODE);
        module.setNameKey(nameKey);
        module.setModuleId(nameKey);
        module.setMode(mode);
        module.setItems(this.getCollectItems(moduleElement));
        String versions = moduleElement.getAttribute(VERSIONS);
        module.setVersions(versions);
        return module;
    }

    private List<CollectItem> getCollectItems(Element moduleElement) {
        try {
            String nameKey = moduleElement.getAttribute(NAME_KEY);
            NodeList nodeList = moduleElement.getChildNodes();
            ArrayList<CollectItem> result = new ArrayList<CollectItem>();
            int length = nodeList.getLength();
            for (int index = 0; index < length; ++index) {
                Node itemNode = nodeList.item(index);
                if (!(itemNode instanceof Element)) continue;
                result.add(this.parseCollectItem((Element)itemNode, nameKey));
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("parse collect list config file error!!", (Throwable)e);
            return new ArrayList<CollectItem>();
        }
    }

    private CollectItem parseCollectItem(Element itemElement, String moduleNameKey) {
        CollectItem item = new CollectItem();
        item.setModuleId(moduleNameKey);
        item.setId(itemElement.getAttribute("id"));
        item.setMicroServiceId(itemElement.getAttribute(MICRO_SERVICE_ID));
        item.setPackageURL(itemElement.getAttribute("packageURL"));
        item.setGetpathURL(itemElement.getAttribute("getpathURL"));
        item.setDownURL(itemElement.getAttribute("downURL"));
        String nameKey = itemElement.getAttribute(NAME_KEY);
        item.setEnNameKey(nameKey);
        item.setNameKey(nameKey);
        String defaultString = itemElement.getAttribute(DEFAULT_CHOOSE);
        boolean defaultChoosen = true;
        if (!StringUtils.isNULLStr((String)defaultString)) {
            defaultChoosen = Boolean.parseBoolean(defaultString);
        }
        item.setDefaultChoose(defaultChoosen);
        String versions = itemElement.getAttribute(VERSIONS);
        item.setVersions(versions);
        return item;
    }

    public void loadSingedFolderProduct(File signedSysconfFile) {
        this.loadProductWithReturn(signedSysconfFile);
    }

    private void loadProductSysconf() {
        File productsFolder = new File(PACKAGE_PATH, PRODUCTS_FOLDER);
        File[] allProductFolder = productsFolder.listFiles(new ProductFileFilter());
        if (null == allProductFolder) {
            return;
        }
        for (File f : allProductFolder) {
            File versionConfigFile = new File(f, PACKAGE_INI);
            if (versionConfigFile.exists()) {
                PlusPackageDesc packageVersion = new PlusPackageDesc();
                IniReader iniReader = new IniReader(versionConfigFile);
                packageVersion.loadProperties(iniReader);
                if (packageVersion.isValid()) {
                    try {
                        this.productPackageMapping.put(packageVersion.getProductName(), f.getCanonicalPath());
                    }
                    catch (Exception e) {
                        LOGGER.error("get path error.", (Throwable)e);
                        continue;
                    }
                    this.productPackages.put(packageVersion.getProductName(), packageVersion);
                }
            }
            this.loadSysconf(f);
        }
    }

    public String getProductPath(String packageName) {
        return this.productPackageMapping.get(packageName);
    }

    public PlusPackageDesc getProductPacage(String packageName) {
        return this.productPackages.get(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSysconf(File productFolder) {
        File sysconfFile = new File(productFolder, SYSCONF_FILENAME);
        if (sysconfFile.exists()) {
            InputStream inputStream = null;
            Document doc = null;
            try {
                inputStream = StreamUtils.createInputStream((File)sysconfFile);
                doc = XmlUtils.parseDocumentNoPrintException((InputStream)inputStream);
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("load Sysconf error.", (Throwable)e);
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)inputStream);
            }
            if (null == doc) {
                ToolLoggerFactory.getLogger(this.getClass()).error("load Sysconf error.");
                return;
            }
            this.loadSupportVersions(productFolder, doc);
            this.loadProducts(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Product> loadProductWithReturn(File productFolder) {
        File sysconfFile = new File(productFolder, SYSCONF_FILENAME);
        if (sysconfFile.exists()) {
            InputStream inputStream = null;
            Document doc = null;
            try {
                inputStream = StreamUtils.createInputStream((File)sysconfFile);
                doc = XmlUtils.parseDocumentNoPrintException((InputStream)inputStream);
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("load Sysconf error.", (Throwable)e);
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)inputStream);
            }
            if (null == doc) {
                ToolLoggerFactory.getLogger(this.getClass()).error("load Sysconf error.");
                return null;
            }
            this.loadSupportVersions(productFolder, doc);
            return this.loadProducts(doc);
        }
        return null;
    }

    private List<Product> loadProducts(Document doc) {
        Element productsNode = doc.getDocumentElement();
        boolean isPassedNotShowSuggest = false;
        String passedNotShowSuggest = XmlUtils.getAttribute((Element)productsNode, (String)ATTR_PRODUCT_ISPASSEDNOTSHOWSUGGEST);
        isPassedNotShowSuggest = StringUtils.isNULLStr((String)passedNotShowSuggest) ? false : Boolean.valueOf(passedNotShowSuggest);
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)XQL_QUERY_PRODUCTS);
        if (null == nodeList) {
            return null;
        }
        ArrayList<Product> sysconfProducts = new ArrayList<Product>();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            String isold = XmlUtils.getAttribute((Element)ele, (String)ATTR_PRODUCT_ISOLD);
            int iCfgVer = StringUtils.str2Int((String)XmlUtils.getAttribute((Element)ele, (String)ATTR_PRODUCT_CFG_VERSION));
            if (Boolean.valueOf(isold).booleanValue()) {
                sysconfProducts.add(this.initOldProducts(ele, isPassedNotShowSuggest));
                continue;
            }
            if (3 == iCfgVer) {
                sysconfProducts.add(this.initSecondGenerationProduct(ele, isPassedNotShowSuggest));
                continue;
            }
            sysconfProducts.add(this.initProducts(ele, isPassedNotShowSuggest));
        }
        return sysconfProducts;
    }

    private List<SupportVersion> getSupportVersions(File productFolder, Document doc) {
        ArrayList<SupportVersion> versionList = new ArrayList<SupportVersion>();
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)XQL_QUERY_SUPPORT_VERSION);
        if (null == nodeList || nodeList.getLength() == 0) {
            return versionList;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element parent = (Element)node;
            Collection children = XmlUtils.getChildren((Element)parent);
            Iterator it = children.iterator();
            while (it.hasNext()) {
                SupportVersion version = new SupportVersion();
                Element child = (Element)it.next();
                try {
                    version.setScript(productFolder.getCanonicalPath() + File.separator + parent.getAttribute(ATTR_SCRIPT));
                }
                catch (Exception e) {
                    LOGGER.error("get path error.", (Throwable)e);
                    continue;
                }
                version.setModel(XmlUtils.getAttribute((Element)child, (String)ATTR_NAME));
                version.setVersion(XmlUtils.getAttribute((Element)child, (String)ATTR_VERSION));
                version.setDescZh(XmlUtils.getAttribute((Element)child, (String)ATTR_ZH_DESCRIPTION));
                version.setDescEn(XmlUtils.getAttribute((Element)child, (String)ATTR_EN_DESCRIPTION));
                versionList.add(version);
            }
        }
        return versionList;
    }

    private void loadSupportVersions(File productFolder, Document doc) {
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)XQL_QUERY_SUPPORT_VERSION);
        if (null == nodeList || nodeList.getLength() == 0) {
            return;
        }
        this.supportVersions.addAll(this.getSupportVersions(productFolder, doc));
    }

    public List<Object> getPackageVers(File packageFile) throws IOException {
        this.sceneList = false;
        ArrayList<Object> packageVerList = new ArrayList<Object>();
        HashSet<String> supportVers = new HashSet<String>();
        HashSet<String> excludeVers = new HashSet<String>();
        String xmlText = ZipUtils.readTxtFileOnZip((File)packageFile, (String)SYSCONF_FILENAME);
        NodeList nodeList = null;
        try (ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(xmlText.getBytes(Charset.forName("UTF-8")));){
            Document doc = XmlUtils.parseDocument((InputStream)arrayInputStream);
            packageVerList.add(this.getSupportVersions(packageFile, doc));
            nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)XQL_QUERY_PRODUCTS);
        }
        if (null == nodeList) {
            return packageVerList;
        }
        ArrayList<String> supportSceneList = new ArrayList<String>();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element ele = (Element)node;
                String supportTypes = XmlUtils.getTextContentOfChild((Element)ele, (String)NODE_SUPPORT_TYPE);
                supportVers.addAll(this.getAllSupportOrExcludeVers(supportTypes));
                Element supportNodeTypes = XmlUtils.getChild((Element)ele, (String)NODE_SUPPORT_TYPE);
                String excludeTypes = XmlUtils.getAttribute((Element)supportNodeTypes, (String)ATTR_EXCLUDE_PRODUCT);
                if (!StringUtils.isNULLStr((String)excludeTypes)) {
                    excludeVers.addAll(this.getAllSupportOrExcludeVers(excludeTypes));
                }
                Element supportScenes = XmlUtils.getChild((Element)ele, (String)SUPPORT_SCENELIST);
                String supportRealTime = XmlUtils.getAttribute((Element)ele, (String)ATTR_SUPPORT_REALTIME);
                supportRealTime = null == supportRealTime ? "true" : supportRealTime;
                this.traversalScenList(supportSceneList, supportScenes, supportRealTime);
            }
            if (supportSceneList.size() != size) continue;
            this.sceneList = true;
        }
        packageVerList.add(supportVers);
        packageVerList.add(excludeVers);
        return packageVerList;
    }

    private void traversalScenList(List<String> supportSceneList, Element supportScenes, String supportRealTime) {
        for (SupportScenes scenes : this.getSupportSceneList(Boolean.valueOf(supportRealTime), supportScenes)) {
            if (!InspectContext.getInstance().getSelectInspectType().equals(scenes.getScenesId())) continue;
            supportSceneList.add(scenes.getScenesId());
        }
    }

    private Product initSecondGenerationProduct(Element element, boolean isPassedNotShowSuggest) {
        Product productConf = new Product();
        productConf.setOld(true);
        productConf.setPassedNotShowSuggest(isPassedNotShowSuggest);
        String supportTypes = XmlUtils.getTextContentOfChild((Element)element, (String)NODE_SUPPORT_TYPE);
        Set<String> allSupportVers = this.getAllSupportOrExcludeVers(supportTypes);
        productConf.getSupportDevModels().addAll(allSupportVers);
        Element supportScenes = XmlUtils.getChild((Element)element, (String)SUPPORT_SCENELIST);
        String supportRealTime = XmlUtils.getAttribute((Element)element, (String)ATTR_SUPPORT_REALTIME);
        supportRealTime = null == supportRealTime ? "true" : supportRealTime;
        productConf.setSencesList(this.getSupportSceneList(Boolean.valueOf(supportRealTime), supportScenes));
        productConf.setProductName(XmlUtils.getTextContentOfChild((Element)element, (String)NODE_PRODUCTNAME));
        String applyRange = XmlUtils.getTextContentOfChild((Element)element, (String)NODE_APPLYRANGE);
        if (!StringUtils.isNULLStr((String)applyRange)) {
            productConf.setApplyRange(applyRange);
        }
        String parserClass = XmlUtils.getTextContentOfChild((Element)element, (String)NODE_PARSERDEVCLASS);
        String confDir = XmlUtils.getTextContentOfChild((Element)element, (String)NODE_CONF_DIR);
        if ("SECOND_GENERATION".equals(parserClass)) {
            parserClass = "com.huawei.ism.tool.inspect.second.adapter.SecondGenerationArrayProductParser";
        }
        try {
            String newInsStr = "com.huawei.ism.tool.inspect.second.adapter.SecondGenerationArrayProductParser";
            IProductParser parser = (IProductParser)ReflectionUtils.newInstance((String)newInsStr);
            productConf.setProductResolver(parser);
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(SysConfiguration.class).error("Load class error.", (Throwable)e);
        }
        File productDir = new File(PACKAGE_PATH + File.separator + INSPECTOR_PATH + File.separator + confDir);
        productConf.setConfigDir(productDir);
        int iCfgVer = StringUtils.str2Int((String)XmlUtils.getAttribute((Element)element, (String)ATTR_PRODUCT_CFG_VERSION));
        productConf.setInspectCfgVersion(-1 == iCfgVer ? 0 : iCfgVer);
        String isold = XmlUtils.getAttribute((Element)element, (String)ATTR_PRODUCT_ISOLD);
        productConf.setOld(Boolean.valueOf(isold));
        String isSences = XmlUtils.getAttribute((Element)element, (String)ATTR_PRODUCT_ISSENCES);
        productConf.setSences(Boolean.valueOf(isSences));
        String isInspect = XmlUtils.getAttribute((Element)element, (String)ATTR_PRODUCT_INSPECT);
        productConf.setInspect(Boolean.valueOf(isInspect));
        String productCode = XmlUtils.getTextContentOfChild((Element)element, (String)PRODUCT_CODE);
        Element el = XmlUtils.getChild((Element)element, (String)ADDITIONAL_ATTR);
        if (null != el) {
            List<Element> attrs = this.getNodeList(el);
            productConf.setAttus(attrs);
        }
        if (!StringUtils.isNULLStr((String)productCode)) {
            productConf.setProductCode(productCode);
        }
        this.products.add(productConf);
        return productConf;
    }

    private Product getOldProductInfo(Element element) {
        Product productConf = new Product();
        productConf.setOld(true);
        String supportTypes = XmlUtils.getTextContentOfChild((Element)element, (String)NODE_SUPPORT_TYPE);
        productConf.getSupportDevModels().addAll(this.getAllSupportOrExcludeVers(supportTypes));
        productConf.setProductName(XmlUtils.getTextContentOfChild((Element)element, (String)NODE_PRODUCTNAME));
        String parserClass = XmlUtils.getTextContentOfChild((Element)element, (String)NODE_PARSERDEVCLASS);
        IProductParser parser = this.createProductParser(parserClass);
        productConf.setProductResolver(parser);
        File productDir = new File(PACKAGE_PATH + File.separator + INSPECTOR_PATH);
        productConf.setConfigDir(productDir);
        int iCfgVer = StringUtils.str2Int((String)XmlUtils.getAttribute((Element)element, (String)ATTR_PRODUCT_CFG_VERSION));
        productConf.setInspectCfgVersion(-1 == iCfgVer ? 0 : iCfgVer);
        Element el = XmlUtils.getChild((Element)element, (String)ADDITIONAL_ATTR);
        if (null != el) {
            List<Element> attrs = this.getNodeList(el);
            productConf.setAttus(attrs);
        }
        return productConf;
    }

    public List<Element> getNodeList(Element el) {
        ArrayList<Element> attributs = new ArrayList<Element>();
        NodeList childs = el.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node attr = childs.item(i);
            if (!(attr instanceof Element)) continue;
            Element ele = (Element)attr;
            attributs.add(ele);
        }
        return attributs;
    }

    private Product initOldProducts(Element product, boolean isPassedNotShowSuggest) {
        Product productConf = this.getOldProductInfo(product);
        productConf.setPassedNotShowSuggest(isPassedNotShowSuggest);
        this.products.add(productConf);
        return productConf;
    }

    private String replaceMuiltiBlank(String src) {
        return src.trim().replaceAll("\r", "").replaceAll("\n", "").replaceAll("\t", "").replaceAll("  ", "");
    }

    private IProductParser createProductParser(String parser) {
        if (StringUtils.isNULLStr((String)parser)) {
            return PARSER.ARRAY.getParser();
        }
        return PARSER.of(parser.trim()).getParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProductCheckModel(File sysconfFile) {
        InputStream inputStream = null;
        Document doc = null;
        try {
            inputStream = StreamUtils.createInputStream((File)sysconfFile);
            doc = XmlUtils.parseDocumentNoPrintException((InputStream)inputStream);
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("load Sysconf error.", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
        if (null == doc) {
            ToolLoggerFactory.getLogger(this.getClass()).error("load Sysconf error.");
            return null;
        }
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)XQL_QUERY_PRODUCTS);
        if (null == nodeList) {
            return null;
        }
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            Element ckModelEle = XmlUtils.getChild((Element)ele, (String)"checkmodel");
            return XmlUtils.getAttribute((Element)ckModelEle, (String)"modelType");
        }
        return null;
    }

    private Product initProducts(Element product, boolean isPassedNotShowSuggest) {
        String notNeedDebug;
        Product productConf = new Product();
        productConf.setPassedNotShowSuggest(isPassedNotShowSuggest);
        productConf.setShowImpact(XmlUtils.getAttribute((Element)product, (String)PRODUCT_ELEMENT_SHOW_IMPACT));
        String supportTypes = XmlUtils.getTextContentOfChild((Element)product, (String)NODE_SUPPORT_TYPE);
        productConf.getSupportDevModels().addAll(this.getAllSupportOrExcludeVers(supportTypes));
        Element supportNodeTypes = XmlUtils.getChild((Element)product, (String)NODE_SUPPORT_TYPE);
        String excludeTypes = XmlUtils.getAttribute((Element)supportNodeTypes, (String)ATTR_EXCLUDE_PRODUCT);
        if (!StringUtils.isNULLStr((String)excludeTypes)) {
            productConf.getExcludeDevModels().addAll(this.getAllSupportOrExcludeVers(excludeTypes));
        }
        if (!StringUtils.isNULLStr((String)(notNeedDebug = XmlUtils.getTextContentOfChild((Element)product, (String)NODE_NOTNEEDDEBUG)))) {
            productConf.getNotNeedDebug().addAll(this.getAllSupportOrExcludeVers(notNeedDebug));
        }
        Element supportScenes = XmlUtils.getChild((Element)product, (String)SUPPORT_SCENELIST);
        String supportRealTime = XmlUtils.getAttribute((Element)product, (String)ATTR_SUPPORT_REALTIME);
        supportRealTime = null == supportRealTime ? "true" : supportRealTime;
        productConf.setSencesList(this.getSupportSceneList(Boolean.valueOf(supportRealTime), supportScenes));
        String confDir = XmlUtils.getTextContentOfChild((Element)product, (String)NODE_CONF_DIR);
        File productDir = new File(FilePathUtils.checkFile((String)(PACKAGE_PATH + File.separator + INSPECTOR_PATH + File.separator + confDir)));
        productConf.setConfigDir(productDir);
        String requireCheckPath = XmlUtils.getTextContentOfChild((Element)product, (String)REQUIRE_CHECK);
        if (!StringUtils.isNULLStr((String)requireCheckPath)) {
            productConf.setRequireCheckFile(requireCheckPath);
        }
        this.checkProductConf(product, productConf);
        this.setParaserClass(product, productConf);
        return productConf;
    }

    private void checkProductConf(Element product, Product productConf) {
        String isold = XmlUtils.getAttribute((Element)product, (String)ATTR_PRODUCT_ISOLD);
        productConf.setOld(Boolean.valueOf(isold));
        String isSences = XmlUtils.getAttribute((Element)product, (String)ATTR_PRODUCT_ISSENCES);
        productConf.setSences(Boolean.valueOf(isSences));
        String inspectCfgVersion = XmlUtils.getAttribute((Element)product, (String)ATTR_PRODUCT_CFG_VERSION);
        int iCfgVer = StringUtils.str2Int((String)inspectCfgVersion);
        productConf.setInspectCfgVersion(-1 == iCfgVer ? 1 : iCfgVer);
        String checklistName = XmlUtils.getTextContentOfChild((Element)product, (String)"checklist");
        if (null != checklistName) {
            productConf.setCheckListFile(new File(productConf.getConfigDir(), checklistName));
        }
        productConf.setNeedPyJavaEnv(Boolean.valueOf(XmlUtils.getTextContentOfChild((Element)product, (String)NODE_NEEDPYJAVAENV)));
        productConf.setErrorRedView(Boolean.valueOf(XmlUtils.getTextContentOfChild((Element)product, (String)NODE_ERROR_RED_VIEW)));
        productConf.setProductName(XmlUtils.getTextContentOfChild((Element)product, (String)NODE_PRODUCTNAME));
    }

    private void setParaserClass(Element product, Product productConf) {
        Element el;
        String applyRange = XmlUtils.getTextContentOfChild((Element)product, (String)NODE_APPLYRANGE);
        if (!StringUtils.isNULLStr((String)applyRange)) {
            productConf.setApplyRange(applyRange);
        }
        String parserClass = XmlUtils.getTextContentOfChild((Element)product, (String)NODE_PARSERDEVCLASS);
        IProductParser parser = this.createProductParser(parserClass);
        productConf.setProductResolver(parser);
        productConf.setDebugModel(this.createDebugModel(XmlUtils.getChild((Element)product, (String)NODE_DEBUGMODEL)));
        Element ckModelEle = XmlUtils.getChild((Element)product, (String)"checkmodel");
        if (null != ckModelEle) {
            CheckModelInfo model = new CheckModelInfo();
            model.setConType(XmlUtils.getAttribute((Element)ckModelEle, (String)"conType"));
            model.setModelType(XmlUtils.getAttribute((Element)ckModelEle, (String)"modelType"));
            String transType = XmlUtils.getAttribute((Element)ckModelEle, (String)"transType");
            String tlvType = XmlUtils.getAttribute((Element)ckModelEle, (String)"needTlv");
            String sftpPath = XmlUtils.getAttribute((Element)ckModelEle, (String)"sftpPath");
            if (!StringUtils.isNULLStr((String)transType)) {
                model.setTransType(transType);
            }
            if (!StringUtils.isNULLStr((String)tlvType)) {
                model.setTlvType(Boolean.valueOf(tlvType));
            }
            if (!StringUtils.isNULLStr((String)sftpPath)) {
                model.setSftpPath(sftpPath);
            }
            productConf.setCheckModelInfo(model);
        }
        if (null != (el = XmlUtils.getChild((Element)product, (String)ADDITIONAL_ATTR))) {
            List<Element> attrs = this.getNodeList(el);
            productConf.setAttus(attrs);
        }
        this.products.add(productConf);
    }

    private Set<String> getAllSupportOrExcludeVers(String versionTypes) {
        String[] vers;
        HashSet<String> modelTypes = new HashSet<String>();
        if (null == versionTypes) {
            return modelTypes;
        }
        for (String ver : vers = versionTypes.split(",")) {
            if (StringUtils.isNULLStr((String)ver)) continue;
            modelTypes.add(this.replaceMuiltiBlank(ver));
        }
        return modelTypes;
    }

    private IDebugModel createDebugModel(Element debugModel) {
        if (null == debugModel) {
            return new NullDebugModel();
        }
        DebugType type = DebugType.valueOf(DebugType.class, XmlUtils.getAttribute((Element)debugModel, (String)ATTR_TYPE));
        IDebugModel model = type.getModel();
        return model;
    }

    private List<SupportScenes> getSupportSceneList(Boolean isSupportRealTime, Element ele) {
        Collection chiadNodeList = XmlUtils.getChildren((Element)ele, (String)SUPPORT_SCENES);
        ArrayList<SupportScenes> supportScenesList = new ArrayList<SupportScenes>();
        if (isSupportRealTime.booleanValue() && !this.hasCheckScenesConfiged(DEF_CHECK_REALTIMED, chiadNodeList)) {
            this.addDefaultScenes(DEF_CHECK_REALTIMED, supportScenesList);
        }
        if (!chiadNodeList.isEmpty()) {
            this.firstHandleElement(chiadNodeList, supportScenesList);
        }
        return supportScenesList;
    }

    private void firstHandleElement(Collection<Element> chiadNodeList, List<SupportScenes> supportScenesList) {
        for (Element chiadNode : chiadNodeList) {
            Collection chiadNodeList1 = XmlUtils.getChildren((Element)chiadNode, (String)SUPPORT_SCENES);
            String sceneId = XmlUtils.getTextContentOfChild((Element)chiadNode, (String)"id");
            this.handleSupportScenesList(supportScenesList, chiadNode, chiadNodeList1, sceneId);
        }
    }

    private void handleSupportScenesList(List<SupportScenes> supportScenesList, Element chiadNode, Collection<Element> chiadNodeList1, String sceneId) {
        if (null == chiadNodeList1 || chiadNodeList1.isEmpty()) {
            SupportScenes supportScenes = new SupportScenes();
            String sceneCheckList = XmlUtils.getTextContentOfChild((Element)chiadNode, (String)"checklist");
            supportScenes.setScenesId(sceneId);
            supportScenes.setCheckListFileName(sceneCheckList);
            supportScenesList.add(supportScenes);
        } else {
            this.handleElement(supportScenesList, chiadNodeList1, sceneId);
        }
    }

    private void handleElement(List<SupportScenes> supportScenesList, Collection<Element> chiadNodeList1, String sceneId) {
        for (Element element : chiadNodeList1) {
            Collection chiadNodeList2 = XmlUtils.getChildren((Element)element, (String)SUPPORT_SCENES);
            String sceneId2 = XmlUtils.getTextContentOfChild((Element)element, (String)"id");
            if (null == chiadNodeList2 || chiadNodeList2.isEmpty()) {
                SupportScenes supportScenes = new SupportScenes();
                String sceneCheckList = XmlUtils.getTextContentOfChild((Element)element, (String)"checklist");
                supportScenes.setScenesId(sceneId + SUP_SCENE_SPLIT + sceneId2);
                supportScenes.setCheckListFileName(sceneCheckList);
                supportScenesList.add(supportScenes);
                continue;
            }
            this.setSupportScenesList(supportScenesList, sceneId, chiadNodeList2, sceneId2);
        }
    }

    private void setSupportScenesList(List<SupportScenes> supportScenesList, String sceneId, Collection<Element> chiadNodeList2, String sceneId2) {
        for (Element element2 : chiadNodeList2) {
            String sceneId3 = XmlUtils.getTextContentOfChild((Element)element2, (String)"id");
            SupportScenes supportScenes = new SupportScenes();
            String sceneCheckList = XmlUtils.getTextContentOfChild((Element)element2, (String)"checklist");
            supportScenes.setScenesId(sceneId + SUP_SCENE_SPLIT + sceneId2 + SUP_SCENE_SPLIT + sceneId3);
            supportScenes.setCheckListFileName(sceneCheckList);
            supportScenesList.add(supportScenes);
        }
    }

    private boolean hasCheckScenesConfiged(String checkScene, Collection<Element> supportScenes) {
        for (Element scene : supportScenes) {
            String sceneId = XmlUtils.getTextContentOfChild((Element)scene, (String)"id");
            if (!checkScene.equals(sceneId)) continue;
            return true;
        }
        return false;
    }

    private void addDefaultScenes(String scene, List<SupportScenes> supportScenesList) {
        for (SupportScenes supportScenes1 : supportScenesList) {
            if (!supportScenes1.getCheckListFileName().equals(DEF_CHENK_FILENAME)) continue;
            return;
        }
        SupportScenes supportScenes = new SupportScenes();
        supportScenes.setScenesId(scene);
        supportScenes.setCheckListFileName(DEF_CHENK_FILENAME);
        supportScenesList.add(supportScenes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> toolSupportScenes() {
        ArrayList<String> scenes = new ArrayList<String>();
        File scenesFile = new File(WORKPATH, SCENES_CONFIG_FILE);
        Collection sceneLs = null;
        InputStream inputStream = null;
        try {
            inputStream = StreamUtils.createInputStream((File)scenesFile);
            Document doc = XmlUtils.parseDocument((InputStream)inputStream);
            Element root = doc.getDocumentElement();
            sceneLs = XmlUtils.getChildren((Element)root, (String)SCENE);
        }
        catch (RuntimeException e) {
            LOGGER.error("Parse scenes error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
        if (sceneLs == null) {
            return scenes;
        }
        for (Element scene : sceneLs) {
            scenes.addAll(this.buildChildrenScene(scene));
        }
        return scenes;
    }

    private Set<String> buildChildrenScene(Element scene2) {
        HashSet<String> sceneIds = new HashSet<String>();
        String sceneId = XmlUtils.getAttribute((Element)scene2, (String)"id");
        Collection sceneLs = XmlUtils.getChildren((Element)scene2, (String)SCENE);
        if (null == sceneLs || sceneLs.isEmpty()) {
            sceneIds.add(sceneId);
        } else {
            for (Element element : sceneLs) {
                String sceneId1 = XmlUtils.getAttribute((Element)element, (String)"id");
                Collection sceneList1 = XmlUtils.getChildren((Element)element, (String)SCENE);
                this.buildThirdScene(sceneIds, sceneId, sceneId1, sceneList1);
            }
        }
        return sceneIds;
    }

    private void buildThirdScene(Set<String> sceneIds, String sceneId, String sceneId1, Collection<Element> sceneList1) {
        if (null == sceneList1 || sceneList1.isEmpty()) {
            sceneIds.add(sceneId + SUP_SCENE_SPLIT + sceneId1);
        } else {
            this.appendThirdSecene(sceneIds, sceneId, sceneId1, sceneList1);
        }
    }

    private void appendThirdSecene(Set<String> sceneIds, String sceneId, String sceneId1, Collection<Element> sceneList1) {
        for (Element element2 : sceneList1) {
            String sceneId2 = XmlUtils.getAttribute((Element)element2, (String)"id");
            sceneIds.add(sceneId + SUP_SCENE_SPLIT + sceneId1 + SUP_SCENE_SPLIT + sceneId2);
        }
    }

    public List<SupportScenes> createdSceneList() {
        ArrayList<SupportScenes> scenes = new ArrayList<SupportScenes>();
        List<String> sceneIdSet = this.sceneLit();
        if (!ApplicationContext.getInstance().isWindowsOS()) {
            sceneIdSet.remove("bureau_check");
        }
        for (String sceneId : sceneIdSet) {
            SupportScenes supportScenes = new SupportScenes();
            supportScenes.setScenesId(sceneId);
            supportScenes.setNameKey("inspsctor.wizard.welcome.head." + sceneId);
            scenes.add(supportScenes);
        }
        return scenes;
    }

    private List<String> sceneLit() {
        ArrayList<String> scenesList = new ArrayList<String>();
        File productsFolder = new File(PACKAGE_PATH, PRODUCTS_FOLDER);
        File[] allProductFolder = productsFolder.listFiles(new ProductFileFilter());
        if (null == allProductFolder) {
            return new ArrayList<String>(0);
        }
        for (File f : allProductFolder) {
            File productConfigFile = new File(f, SYSCONF_FILENAME);
            if (!productConfigFile.exists()) continue;
            List<String> sceneXml = this.getSceneXml(productConfigFile);
            for (String sceneId : sceneXml) {
                if (scenesList.contains(sceneId)) continue;
                scenesList.add(sceneId);
            }
        }
        return scenesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSceneXml(File scenesFile) {
        List<String> toolSupport = this.toolSupportScenes();
        ArrayList<String> sceneXmlList = new ArrayList<String>();
        InputStream inputStream = null;
        NodeList nodeList = null;
        try {
            inputStream = StreamUtils.createInputStream((File)scenesFile);
            Document doc = XmlUtils.parseDocumentNoPrintException((InputStream)inputStream);
            nodeList = XmlUtils.searchNodeByExpNoPrintException((Document)doc, (String)XQL_QUERY_PRODUCTS);
        }
        catch (RuntimeException e) {
            LOGGER.error("Init products error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
        if (null == nodeList) {
            return sceneXmlList;
        }
        int size = nodeList.getLength();
        this.traversalNode(toolSupport, sceneXmlList, nodeList, size);
        return sceneXmlList;
    }

    private void traversalNode(List<String> toolSupport, List<String> sceneXmlList, NodeList nodeList, int size) {
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            Element supportScenes = XmlUtils.getChild((Element)ele, (String)SUPPORT_SCENELIST);
            String supportRealTime = XmlUtils.getAttribute((Element)ele, (String)ATTR_SUPPORT_REALTIME);
            supportRealTime = null == supportRealTime ? "true" : supportRealTime;
            List<SupportScenes> sceneLs = this.getSupportSceneList(Boolean.valueOf(supportRealTime), supportScenes);
            for (SupportScenes scenes : sceneLs) {
                if (!toolSupport.contains(scenes.getScenesId())) continue;
                sceneXmlList.addAll(this.getSupportSceneId(sceneXmlList, scenes));
            }
        }
    }

    private List<String> getSupportSceneId(List<String> sceneXmlList, SupportScenes scenes) {
        ArrayList<String> sceneIdList = new ArrayList<String>();
        if (sceneXmlList.isEmpty()) {
            sceneIdList.add(scenes.getScenesId());
        } else if (!sceneXmlList.contains(scenes.getScenesId())) {
            sceneIdList.add(scenes.getScenesId());
        }
        return sceneIdList;
    }

    public void reloadAllProductInfo() {
        this.products.clear();
        this.initSysconf();
    }

    public boolean isSceneList() {
        return this.sceneList;
    }

    public void setSceneList(boolean scenes) {
        this.sceneList = scenes;
    }

    public synchronized List<Product> getSwitchProducts() {
        if (!CollectionUtil.isEmpty(this.switchProducts)) {
            return this.switchProducts;
        }
        File file = new File(SwitchCheckConstants.SWITCH_CONFIG_PATH);
        if (!file.exists() || !file.isDirectory()) {
            return Collections.emptyList();
        }
        this.switchProducts = this.loadProductWithReturn(file);
        return this.switchProducts;
    }

    static {
        PACKAGE_PATH = WORKPATH = ApplicationContext.getInstance().getWorkPath();
        SCENES_CONFIG_FILE = "packages" + File.separator + "inspector" + File.separator + SCENES_FILENAME;
        INSTANCE = new SysConfiguration();
    }
}

