/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.debug;

import com.huawei.ism.tool.inspect.logic.debug.IDebugModel;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import org.slf4j.Logger;

public class CalcPasswordDebugModel
implements IDebugModel {
    private static final long serialVersionUID = -4524999002546920036L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CalcPasswordDebugModel.class);
    private static final String OPEN_DEBUG_MODEL_FILE = "openDebugModel.py";

    @Override
    public void exitDebugModel(ICliConnection cliConnection, DevNode devNode, File scriptDir) throws ToolException {
        cliConnection.execCmd("exit");
    }

    @Override
    public void openDebugModel(ICliConnection cliConnection, DevNode devNode, File scriptDir) throws ToolException {
        if (cliConnection == null) {
            ToolLoggerFactory.getLogger(this.getClass()).error("open debug model error. cliConnection is null.");
            return;
        }
        JythonExecuter jythonExecuter = new JythonExecuter();
        File scriptFile = new File(scriptDir.getAbsoluteFile() + File.separator + OPEN_DEBUG_MODEL_FILE);
        try {
            jythonExecuter.compileScript(scriptFile);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Compile script error- script file {} not found.", (Object)OPEN_DEBUG_MODEL_FILE);
        }
        catch (RuntimeException e) {
            LOGGER.error("Compile script error- ", (Throwable)e);
        }
        jythonExecuter.invokeFunction("execute", new Object[]{cliConnection});
    }
}

