/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.entity;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.entity.InspectDeviceType;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import java.util.List;
import java.util.stream.Collectors;

public class DistributedBatchType
extends InspectDeviceType {
    private static final int ITEM_PER_BATCH_SIZE = 50;
    private static final int ITEM_PER_BATCH_COST_MINUTES = 2;
    private static final double ITEM_PER_COSE_SECONDS = 2.4;
    private int totalBatchNumber;

    public DistributedBatchType(CheckDevNode checkDevNode, int storageOnceNumber, int computeOnceNumber) {
        super(checkDevNode);
        this.initProperty(storageOnceNumber, computeOnceNumber);
    }

    private void initProperty(int storageOnceNumber, int computeOnceNumber) {
        List<ClusterNode> selectNodes = this.getCheckDevNode().getDevNode().getClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toList());
        this.totalBatchNumber = InspectUtils.getBatchNodes(selectNodes, storageOnceNumber, computeOnceNumber).size();
    }

    @Override
    public int calculateInspectTime() {
        int itemCount = this.getCheckItemCount();
        int itemBatchNumber = this.getGroupNumber(itemCount, 50);
        return this.totalBatchNumber == 1 ? itemBatchNumber * 2 : (int)Math.ceil((double)itemCount * 2.4 * (double)this.totalBatchNumber / 60.0);
    }
}

