/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.entity;

import com.google.common.collect.Lists;
import com.huawei.ism.tool.fusioncube.service.MetaVisionInspectService;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.logic.entity.CentralizedType;
import com.huawei.ism.tool.inspect.logic.entity.DistributedBatchType;
import com.huawei.ism.tool.inspect.logic.entity.DistributedNotBatchType;
import com.huawei.ism.tool.inspect.logic.entity.InspectDeviceType;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class InspectTimeSummary {
    private final List<CheckDevNode> checkDevNodes;
    private final int concurrentNumber;
    private final int storageInputNumber;
    private final int computeInputNumber;

    public int calculateInspectTime() {
        if (CollectionUtils.isEmpty(this.checkDevNodes)) {
            return 0;
        }
        List<Integer> times = this.checkDevNodes.stream().map(this::createInspectDeviceType).map(InspectDeviceType::calculateInspectTime).collect(Collectors.toList());
        return this.parallelTime(times, this.concurrentNumber) + 1;
    }

    private int parallelTime(List<Integer> times, int concurrentNumber) {
        return Lists.partition(times, (int)concurrentNumber).stream().map(list -> list.stream().mapToInt(Integer::intValue).max()).mapToInt(OptionalInt::getAsInt).sum();
    }

    private InspectDeviceType createInspectDeviceType(CheckDevNode checkDevNode) {
        if (!checkDevNode.isDistributed()) {
            return new CentralizedType(checkDevNode);
        }
        if (MetaVisionInspectService.isFusionCubeMetaVisionNode(checkDevNode)) {
            return new DistributedNotBatchType(checkDevNode);
        }
        return new DistributedBatchType(checkDevNode, this.storageInputNumber, this.computeInputNumber);
    }

    @Generated
    public InspectTimeSummary(List<CheckDevNode> checkDevNodes, int concurrentNumber, int storageInputNumber, int computeInputNumber) {
        this.checkDevNodes = checkDevNodes;
        this.concurrentNumber = concurrentNumber;
        this.storageInputNumber = storageInputNumber;
        this.computeInputNumber = computeInputNumber;
    }
}

