/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstorageSceneCheckItems;
import com.huawei.ism.tool.inspect.entity.FusionStorCheckItemBlock;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.logic.config.ArrayProductParser;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.PropertiesUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExpansionTaskUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExpansionTaskUtils.class);
    public static final int MAX_PROGRESS = 100;
    public static final String EXTEND_ITEM_MODE = "extendItemMode";
    public static final String PRE_INSPECTION_SCITP = "preInspectionScrip";
    public static final String CHECK_SCRIPT = "checkScript";
    public static final String SHELL_PATH = "shellPath";
    public static final String UPDATE_PATH = "updatePath";
    public static final String EXTEND_ITEM_MODE_LOCAL = "local";
    public static final String EXTEND_ITEM_MODE_UPLOAD = "upload";
    public static final String CHECK_ITEM_BLOCK_PATH = ArrayProductParser.DSTORAGE_EXPANSION_PATH + File.separator + "CheckItemBlock.xml";
    public static final String COMMA = ",";
    public static final String PY_SCRIPTS_DIR = ArrayProductParser.DSTORAGE_EXPANSION_PATH + File.separator + "pyItem";
    private static List<String> needBmcAuthTypeRs = null;
    private static List<FusionStorCheckItemBlock> displayItems = null;

    public static void updateInspectResult(CheckDevNode checkDevNode, IUiObserver uiObserver, ResultItem result, String flag, CheckItem item) {
        result.setFinished(true);
        result.setProgress(100);
        result.setTimeTake(System.currentTimeMillis() - result.getStartTime().getTimeInMillis());
        if ("0".equals(flag)) {
            result.setNormal(true);
        } else if ("1".equals(flag)) {
            result.setNormal(false);
        } else if ("2".equals(flag)) {
            result.setNoCheck(true);
        } else if ("3".equals(flag)) {
            result.setNoSupport(true);
        } else if ("4".equals(flag)) {
            result.setWarning(true);
        } else {
            item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.checkfail"));
            result.setNormal(false);
        }
        uiObserver.update(checkDevNode, item, item.getName(), 100, result.getStartTime());
    }

    public static List<String> getNeedBmcAuthTypeRs() {
        if (needBmcAuthTypeRs == null) {
            ExpansionTaskUtils.initNeedBmcAtchTypeRs();
        }
        return needBmcAuthTypeRs;
    }

    private static void initNeedBmcAtchTypeRs() {
        String[] needBmcAuthItemTypes;
        String currentLanguage = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        String propertiesPath = ArrayProductParser.DSTORAGE_EXPANSION_PATH + File.separator + "res" + File.separator + "resource_" + currentLanguage + ".properties";
        ResourceBundle rs = PropertiesUtils.readProperties(new File(propertiesPath));
        needBmcAuthTypeRs = new ArrayList<String>();
        for (String type : needBmcAuthItemTypes = ResourceBundle.getBundle("config.inspect").getString("needBmcAuthItemTypes").split(COMMA)) {
            needBmcAuthTypeRs.add(ResourceUtil.getString((String)type, (ResourceBundle[])new ResourceBundle[]{rs}));
        }
    }

    public static void filterCheckItemsByBlock(CheckDevNode checkDevNode) {
        DevNode devNode = checkDevNode.getDevNode();
        if (devNode == null || !devNode.isDsStorage()) {
            return;
        }
        List<Map<String, List<String>>> sceneAndCheckItemBlockMapList = ExpansionTaskUtils.getDisplayItemsMap(checkDevNode.getDevNode());
        sceneAndCheckItemBlockMapList.forEach(sceneAndCheckItemBlockMap -> ExpansionTaskUtils.filterByBlockList(checkDevNode, sceneAndCheckItemBlockMap));
    }

    private static void filterByBlockList(CheckDevNode checkDevNode, Map<String, List<String>> sceneAndCheckItemBlockMap) {
        if (sceneAndCheckItemBlockMap.isEmpty()) {
            return;
        }
        ExpansionTaskUtils.filterItemByGlobalConf(checkDevNode, sceneAndCheckItemBlockMap);
        ExpansionTaskUtils.filterItemBySceneId(checkDevNode, sceneAndCheckItemBlockMap);
    }

    private static void filterItemBySceneId(CheckDevNode checkDevNode, Map<String, List<String>> sceneAndCheckItemBlockMap) {
        checkDevNode.getDstorageSceneCheckItemsList().forEach(dstorageSceneCheckItems -> ExpansionTaskUtils.removeDistributedDisplayItems(sceneAndCheckItemBlockMap.getOrDefault(dstorageSceneCheckItems.getSceneId(), Collections.emptyList()), dstorageSceneCheckItems));
    }

    private static void filterItemByGlobalConf(CheckDevNode checkDevNode, Map<String, List<String>> diskPlayItems) {
        checkDevNode.getDstorageSceneCheckItemsList().forEach(items -> ExpansionTaskUtils.removeDistributedDisplayItems(diskPlayItems.getOrDefault("", Collections.emptyList()), items));
        if (InspectContext.getInstance().isNfvMode()) {
            checkDevNode.getDstorageSceneCheckItemsList().forEach(items -> ExpansionTaskUtils.removeDistributedDisplayItems(diskPlayItems.getOrDefault("bureau_check_nfv", Collections.emptyList()), items));
        }
    }

    private static void removeDistributedDisplayItems(List<String> displayItems, DstorageSceneCheckItems dstorageSceneCheckItems) {
        if (displayItems.isEmpty()) {
            return;
        }
        Map<String, List<CheckItem>> checkItems = dstorageSceneCheckItems.getCheckItems();
        HashSet removedItemIds = new HashSet();
        checkItems.forEach((key, value) -> {
            Iterator iter = value.iterator();
            while (iter.hasNext()) {
                CheckItem item = (CheckItem)iter.next();
                if (!displayItems.contains(item.getItemId())) continue;
                iter.remove();
                removedItemIds.add(item.getItemId());
            }
        });
        log.info("Display items {} .", removedItemIds);
    }

    public static synchronized List<Map<String, List<String>>> getDisplayItemsMap(DevNode devNode) {
        if (displayItems == null) {
            ExpansionTaskUtils.initDisPlayItems();
        }
        return displayItems.stream().map(black -> black.getFusionStorCheckItemBlock(devNode)).filter(map -> !map.isEmpty()).collect(Collectors.toList());
    }

    private static void initDisPlayItems() {
        displayItems = new ArrayList<FusionStorCheckItemBlock>();
        File checkItemBlockFile = new File(CHECK_ITEM_BLOCK_PATH);
        if (!checkItemBlockFile.exists()) {
            log.error("CheckItemBlock.xml is not exists.");
            return;
        }
        ExpansionTaskUtils.parsesCheckItemBlockXml(checkItemBlockFile);
    }

    private static void parsesCheckItemBlockXml(File checkItemBlockFile) {
        Document deviceDoc = null;
        try (InputStream inputStream = Files.newInputStream(checkItemBlockFile.toPath(), new OpenOption[0]);){
            deviceDoc = XmlUtils.parseDocument((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error("init CheckItemBlock error.", (Throwable)e);
        }
        if (deviceDoc == null) {
            return;
        }
        NodeList nodeList = XmlUtils.searchNodeByExp(deviceDoc, (String)"products/product");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            ExpansionTaskUtils.buildDisplayItem((Element)node);
        }
    }

    private static void buildDisplayItem(Element product) {
        FusionStorCheckItemBlock block = new FusionStorCheckItemBlock();
        ExpansionTaskUtils.buildBlockSupportDev(block, product);
        ExpansionTaskUtils.builedSceneAndCheckItemBlockMap(block, product);
        displayItems.add(block);
    }

    private static void builedSceneAndCheckItemBlockMap(FusionStorCheckItemBlock block, Element product) {
        Collection chiadNodeList = XmlUtils.getChildren((Element)XmlUtils.getChild((Element)product, (String)"supportList"), (String)"supportscene");
        for (Element chiadNode : chiadNodeList) {
            String sceneId = XmlUtils.getTextContentOfChild((Element)chiadNode, (String)"id");
            String itemIds = XmlUtils.getTextContentOfChild((Element)chiadNode, (String)"items");
            if (StringUtils.isNULLStr((String)itemIds)) continue;
            String nfvItems = XmlUtils.getTextContentOfChild((Element)chiadNode, (String)"nfvItems");
            if (InspectContext.getInstance().isNfvMode() && !StringUtils.isNULLStr((String)nfvItems)) {
                ExpansionTaskUtils.addblockItems(block, sceneId, nfvItems);
            }
            ExpansionTaskUtils.addblockItems(block, sceneId, itemIds);
        }
    }

    private static void addblockItems(FusionStorCheckItemBlock block, String sceneId, String itemIds) {
        ArrayList<String> itemIdList = new ArrayList<String>();
        if (itemIds.contains(COMMA)) {
            Collections.addAll(itemIdList, itemIds.split(COMMA));
        } else {
            itemIdList.add(itemIds);
        }
        if (StringUtils.isNULLStr((String)sceneId)) {
            block.getSceneAndCheckItemBlockMap().put("", itemIdList);
        } else {
            block.getSceneAndCheckItemBlockMap().put(sceneId, itemIdList);
        }
    }

    private static void buildBlockSupportDev(FusionStorCheckItemBlock block, Element product) {
        String confDeviceType = XmlUtils.getTextContentOfChild((Element)product, (String)"supportDeviceType");
        block.setProduct(confDeviceType);
        String confProductVersion = XmlUtils.getTextContentOfChild((Element)product, (String)"supportVersion");
        if (!StringUtils.isNULLStr((String)confProductVersion)) {
            if (confProductVersion.contains(COMMA)) {
                Collections.addAll(block.getVersion(), confProductVersion.split(COMMA));
            } else {
                block.getVersion().add(confProductVersion);
            }
        }
    }
}

