/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstoragePreCheckConfig;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.fit.common.ExpansionNodesManager;
import com.huawei.ism.tool.inspect.logic.config.ArrayProductParser;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ExpansionTaskUtils;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.PreInspectHandler;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportDataManager;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.service.deploy.conf.VersionMappingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class FusionStorExpansionTaskByLocal {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FusionStorExpansionTaskByLocal.class);
    private static final String PYTHON_ENV = "py_java_env";
    private static final String VERSION_MAPPING_FILE_PATH = ArrayProductParser.DSTORAGE_EXPANSION_PATH;
    private static final VersionMappingStrategy VERSION_MAPPING_STRATEGY = new VersionMappingStrategy(VERSION_MAPPING_FILE_PATH);
    private final CheckDevNode checkDevNode;
    private final IUiObserver uiObserver;
    private final List<CheckItem> checkItems;
    private JythonExecuter jythonExecuter;
    private final UiUpdatePair ui;

    public FusionStorExpansionTaskByLocal(CheckDevNode checkDevNode, IUiObserver uiObserver, List<CheckItem> checkItems) {
        this.checkDevNode = checkDevNode;
        this.uiObserver = uiObserver;
        this.checkItems = checkItems;
        this.ui = InspectContext.getInstance().getUiUpdatePair(checkDevNode);
    }

    public void execute() {
        this.initContext();
        this.checkItems.forEach(this::executeScript);
    }

    private void executeScript(CheckItem item) {
        ResultItem result = this.initResultItem(item);
        RestConnection conn = this.createRestConnection();
        if (this.isNeedConnection() && Objects.isNull(conn)) {
            this.updateItemProcess(item, result);
            return;
        }
        String resultFlag = this.executePyScript(item, conn);
        ExpansionTaskUtils.updateInspectResult(this.checkDevNode, this.uiObserver, result, resultFlag, item);
    }

    private void updateItemProcess(CheckItem item, ResultItem result) {
        item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.checkfail"));
        ExpansionTaskUtils.updateInspectResult(this.checkDevNode, this.uiObserver, result, "1", item);
    }

    private boolean isNeedConnection() {
        return !InspectContext.getInstance().isHardwareInspect();
    }

    private RestConnection createRestConnection() {
        if (InspectContext.getInstance().isHardwareInspect()) {
            return null;
        }
        try {
            return RestConnectionManager.getRestConnection((DevNode)this.checkDevNode.getDevNode());
        }
        catch (ToolException e) {
            log.error("inspect interrupt by toolException");
            return null;
        }
    }

    private String executePyScript(CheckItem item, RestConnection conn) {
        String resultFlag;
        String fileName = "check_item_" + item.getItemId() + ".py";
        File pythonScFile = new File(ExpansionTaskUtils.PY_SCRIPTS_DIR, fileName);
        if (pythonScFile.exists()) {
            try {
                this.jythonExecuter.compileScript(pythonScFile);
                List retList = this.jythonExecuter.invokeFunction("execute", new Object[]{Objects.isNull(conn) ? item : conn});
                resultFlag = retList.get(0).toString();
                String cmdResult = retList.get(1).toString();
                item.setSourceInfo(cmdResult, this.checkDevNode);
                item.setErrorInfo(retList.get(2).toString());
            }
            catch (Throwable et) {
                log.error("", et);
                resultFlag = "1";
                item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.checkfail"));
            }
        } else {
            resultFlag = "1";
            item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.filenotfound"));
        }
        return resultFlag;
    }

    private ResultItem initResultItem(CheckItem item) {
        int progressStep = 0;
        ResultItem result = new ResultItem();
        result.setStartTime(Calendar.getInstance());
        item.setCheckResult(result);
        this.uiObserver.update(this.checkDevNode, item, item.getName(), progressStep, result.getStartTime(), RecordStatus.RUNNING);
        return result;
    }

    private void initContext() {
        String baseScriptPath = FilesUtil.getCanonicalPath((File)this.checkDevNode.getScriptDir().getParentFile().getParentFile());
        ArrayList<File> pyClassPaths = new ArrayList<File>();
        String preResPath = InspectContext.getInstance().getDstorageTmpPath() + File.separator + this.checkDevNode.getDevNode().getDeviceSerialNumber() + File.separator;
        String pyFramePth = baseScriptPath + File.separator + "pyframe";
        pyClassPaths.add(new File(pyFramePth));
        pyClassPaths.add(new File(ExpansionTaskUtils.PY_SCRIPTS_DIR));
        this.jythonExecuter = new JythonExecuter(pyClassPaths);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("preResPath", preResPath);
        env.put("lang", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        env.put("devInfo", this.checkDevNode.getDevNode());
        env.put("newExpansionNodes", this.getDevNodeList());
        env.put("progressObserver", this.ui);
        env.put("logger", log);
        env.put("result_path", ReportDataManager.DS_RESULT_PATH + File.separator + this.checkDevNode.getDevNodeSafe().getDeviceSerialNumber());
        env.put("temp_path", InspectContext.getInstance().getDstorageTmpPath() + File.separator + this.checkDevNode.getDevNodeSafe().getDeviceSerialNumber());
        env.put("mappingStrategy", VERSION_MAPPING_STRATEGY);
        env.put("hot_patch_file", InspectContext.HOT_PATCH_FILE);
        env.put("preInspectHandle", new PreInspectHandler(this.checkDevNode.getDevNode(), DstoragePreCheckConfig.INS.findMatchConfigs(this.checkDevNode.getDevNode())));
        env.put("inspect_context", (Object)InspectContext.getInstance());
        env.put("scsi_driver_timeout", this.checkDevNode.getScsiTimeOut());
        env.put("switch_resource", this.checkDevNode.getSwitchResource());
        if (Objects.nonNull(this.checkDevNode.getSwitchResource())) {
            env.put("switch_bundle", this.checkDevNode.getSwitchResource());
        }
        env.put("compression_ratio", this.checkDevNode.getCompressionRatio());
        env.put("version", this.checkDevNode.getTargetVersion().toUpperCase(Locale.ENGLISH));
        this.jythonExecuter.set(PYTHON_ENV, env);
    }

    private List<DevNode> getDevNodeList() {
        if (InspectUtils.isStartedByYingLong()) {
            return ExpansionNodesManager.getInstance().getNewAddNode().entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(this.checkDevNode.getDevNode().getDevKey())).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
        }
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(node -> ItDeviceType.FUIONSTOR_EXP_NEW_NODE.equals((Object)node.getItDeviceType())).collect(Collectors.toList());
    }
}

