/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.config.ArrayProductParser;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ExpansionTaskUtils;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorExpansionTaskByUpload {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionStorExpansionTaskByUpload.class);
    private CheckDevNode checkDevNode;
    private IUiObserver uiObserver;
    private List<CheckItem> checkItems;

    public FusionStorExpansionTaskByUpload(CheckDevNode checkDevNode, IUiObserver uiObserver, List<CheckItem> checkItems) {
        this.checkDevNode = checkDevNode;
        this.uiObserver = uiObserver;
        this.checkItems = checkItems;
    }

    public void execute() {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(this.checkDevNode);
        for (CheckItem item : this.checkItems) {
            String[] resultSet;
            HashMap<String, Integer> progressMap = new HashMap<String, Integer>();
            int progressStep = 0;
            progressMap.put(item.getItemId(), progressStep);
            ResultItem result = new ResultItem();
            result.setStartTime(Calendar.getInstance());
            item.setCheckResult(result);
            this.uiObserver.update(this.checkDevNode, item, item.getName(), progressStep, result.getStartTime(), RecordStatus.RUNNING);
            progressMap.put(item.getItemId(), progressStep);
            ui.updateProgress(progressMap);
            if (!this.beforeCheck(result, item, progressStep, ui, progressMap)) continue;
            progressStep = 20;
            progressMap.put(item.getItemId(), progressStep);
            ui.updateProgress(progressMap);
            String resultCmd = this.executeCommand(result, item, progressStep, ui, progressMap);
            String resultflag = "";
            if (!StringUtils.isNULLStr((String)resultCmd) && (resultSet = resultCmd.split(System.lineSeparator())).length > 1) {
                resultflag = resultSet[1];
            }
            progressStep = 100;
            ExpansionTaskUtils.updateInspectResult(this.checkDevNode, this.uiObserver, result, resultflag, item);
            this.update(ui, progressMap, progressStep, item);
        }
    }

    private boolean beforeCheck(ResultItem result, CheckItem item, int progressStep, UiUpdatePair ui, Map<String, Integer> progressMap) {
        Map map = (Map)InspectContext.getInstance().getInspectWorktaker().get("ssh_root_devs");
        if (null == map || null == map.get(this.checkDevNode.getDevNode().getDeviceSerialNumber())) {
            result.setFinished(true);
            item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.nochek"));
            result.setNoCheck(true);
            result.setProgress(progressStep);
            this.uiObserver.update(this.checkDevNode, item, item.getName(), progressStep, result.getStartTime(), RecordStatus.NORMAL);
            this.update(ui, progressMap, progressStep, item);
            return false;
        }
        String shellPath = FilePathUtils.checkFile((String)(ArrayProductParser.DSTORAGE_EXPANSION_PATH + File.separator + item.getDstorageShellPath()));
        File shell = new File(shellPath);
        if (!shell.exists()) {
            item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.filenotfound"));
            result.setFinished(true);
            result.setNoCheck(true);
            result.setProgress(progressStep);
            this.uiObserver.update(this.checkDevNode, item, item.getName(), progressStep, result.getStartTime(), RecordStatus.NORMAL);
            this.update(ui, progressMap, progressStep, item);
            return false;
        }
        boolean flag = false;
        try {
            flag = SHAAndRSAVerifyUtils.getInstance().verify(shell);
        }
        catch (Exception e) {
            LOGGER.error("verify Script error!" + shellPath, (Throwable)e);
        }
        if (!flag) {
            item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.filenotfound"));
            result.setFinished(true);
            result.setNoCheck(true);
            result.setProgress(progressStep);
            this.uiObserver.update(this.checkDevNode, item, item.getName(), progressStep, result.getStartTime(), RecordStatus.NORMAL);
            this.update(ui, progressMap, progressStep, item);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeCommand(ResultItem result, CheckItem item, int progressStep, UiUpdatePair ui, Map<String, Integer> progressMap) {
        Map map = (Map)InspectContext.getInstance().getInspectWorktaker().get("ssh_root_devs");
        DevNode rootDevNode = (DevNode)map.get(this.checkDevNode.getDevNode().getDeviceSerialNumber());
        String shellPath = FilePathUtils.checkFile((String)(ArrayProductParser.DSTORAGE_EXPANSION_PATH + File.separator + item.getDstorageShellPath()));
        File shell = new File(shellPath);
        String uploadPath = item.getDstorageShellUpdatePath();
        SshConnection sshConnection = null;
        String resultCmd = "";
        try {
            sshConnection = (SshConnection)SshConnectionManager.getSshConnection((DevNode)rootDevNode);
            String mkdirCmd = "mkdir -vp " + uploadPath;
            sshConnection.execCmd(mkdirCmd);
            String changePermission = "chmod 750 " + uploadPath;
            sshConnection.execCmd(changePermission);
            String changeOwnerCmd = "chown -Rh " + rootDevNode.getLoginUser().getUserName() + ":root " + uploadPath;
            sshConnection.execCmd(changeOwnerCmd);
            SftpConnector sftpConnector = new SftpConnector(rootDevNode);
            sftpConnector.putFile(shellPath, uploadPath, null);
            String cdDirCmd = "cd " + uploadPath;
            sshConnection.execCmd(cdDirCmd);
            String exeShell = "sh " + shell.getName();
            sshConnection.execCmd(exeShell);
            String getShellResult = "echo $?";
            resultCmd = sshConnection.execCmd(getShellResult);
            item.setSourceInfo(resultCmd, this.checkDevNode);
            String rmCmd = "rm -f " + uploadPath + shell.getName();
            sshConnection.execCmd(rmCmd);
            String reducingPermission = "chmod 640 " + uploadPath;
            sshConnection.execCmd(reducingPermission);
        }
        catch (Exception e) {
            LOGGER.error("Execute Expansion Task Command is error", (Throwable)e);
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)rootDevNode);
        }
        return resultCmd;
    }

    private void update(UiUpdatePair ui, Map<String, Integer> progressMap, int progressStep, CheckItem item) {
        List<CheckItem> selectedAllItems = InspectUtils.getAllCheckItem(this.checkDevNode);
        int nowProgress = ui.getProgress();
        int newProgress = nowProgress + 1 / selectedAllItems.size();
        ui.setProgress(newProgress);
        progressMap.put(item.getItemId(), progressStep);
        ui.updateProgress(progressMap);
    }
}

