/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CollectItem;
import com.huawei.ism.tool.inspect.entity.CollectModule;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.DStorageModuleCollectTask;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.NodeCollectStatus;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.RestCollectSubTask;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorExtendCollect {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionStorExtendCollect.class);
    private static final String PERFORMANCE_COLLECT = "performance";
    private static final int REST_SUB_TSK_TIME_OUT_SECONDS = 1800;
    private static final int REST_QRY_PGOGRESS_INTERVAL_SECONDS = 8;
    private static final int ERROR_SUB_TASK_NOT_EXIST = 404;
    private static final int ERRORCODE_QUERYP_PACKEG = 83887409;
    private static final String TASK_ID = "task_id";
    private String resultPath;
    private CheckDevNode checkDevNode;
    private DevNode devNode = null;
    private ConcurrentHashMap<CollectModule, DStorageModuleCollectTask> moduleTaskMap = new ConcurrentHashMap();
    private ProgressUpdator updator = null;

    public FusionStorExtendCollect(CheckDevNode checkDevNode, String resultPath) {
        this.checkDevNode = checkDevNode;
        this.devNode = checkDevNode.getDevNode();
        this.resultPath = resultPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCollect() {
        LOGGER.info("start collect devNode {} extend info .", (Object)this.devNode.getIp());
        try {
            List<CollectModule> collectModules = InspectContext.getInstance().getExtendSysExtCollectConfig(this.devNode.getProductModel());
            if (collectModules == null || collectModules.isEmpty()) {
                LOGGER.info("devNode {} no extend collection config ,continue.", (Object)this.devNode.getIp());
                return;
            }
            File resultFile = new File(this.resultPath);
            if (!resultFile.exists() && !resultFile.mkdirs()) {
                LOGGER.error("create collect result directory:{} error", (Object)this.resultPath);
                return;
            }
            this.updator = new ProgressUpdator(InspectContext.getInstance().getUiUpdatePair(this.checkDevNode), 0, 100, false);
            Thread progressThread = new Thread(this.updator);
            progressThread.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Update progress error", e));
            progressThread.setName("FusionStorExtendCollect-Thread-1");
            progressThread.start();
            this.doCollect(collectModules);
        }
        catch (Exception e2) {
            LOGGER.error("execute collect error: {}", (Throwable)e2);
        }
        finally {
            if (this.updator != null) {
                this.updator.setTaskFinish(true);
            }
            LOGGER.info("finish collect devNode {} extend info .", (Object)this.devNode.getIp());
        }
    }

    private void doCollect(List<CollectModule> collectModules) {
        boolean downModeCollected = false;
        for (CollectModule cm : collectModules) {
            LOGGER.info("start collect devNode {} extend info:collectModule name:{} .", (Object)this.devNode.getIp(), (Object)cm.getName());
            String mode = cm.getMode();
            List<CollectItem> selectItems = cm.getItems();
            if ("down".equalsIgnoreCase(mode)) {
                downModeCollected = this.downModeCollect(selectItems, cm);
                if (downModeCollected) continue;
                LOGGER.error("performance info collect failed.");
                continue;
            }
            if ("package".equalsIgnoreCase(mode)) {
                this.executeRestCheckItem(selectItems, cm);
                continue;
            }
            if (this.createModuleCollectTask(selectItems, cm)) {
                this.queryAndStartAllSubTasksOfModuleTask(cm);
                continue;
            }
            LOGGER.error("create module:{} collect task failed.", (Object)cm.getModuleId());
        }
    }

    private void executeRestCheckItem(List<CollectItem> selectItems, CollectModule cm) {
        for (CollectItem collectItem : selectItems) {
            String downURL;
            String datePath;
            String packageURL;
            if (cm.getItems().contains(collectItem) && this.exePackageURL(packageURL = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + collectItem.getPackageURL().replace("{system_esn}", this.devNode.getDeviceSerialNumber())) && !StringUtils.isNULLStr((String)(datePath = this.queryUrlPackageResult(collectItem))) && this.exeDowURL(downURL = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + collectItem.getDownURL().replace("{system_esn}", this.devNode.getDeviceSerialNumber()) + datePath, this.resultPath)) continue;
        }
    }

    private boolean exePackageURL(String url) {
        boolean execRes = false;
        RestConnection conn = null;
        ResponseInfo resp = null;
        try {
            conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            resp = conn.execGet(url);
            execRes = true;
        }
        catch (ToolException e) {
            LOGGER.error("execute PackageURL error.");
        }
        catch (JSONException e) {
            LOGGER.error("execute PackageURL error,JSONException is happen.");
        }
        long errorCode = this.getErrorCode(resp);
        if (0L != errorCode && -1L != errorCode) {
            LOGGER.error("execute PackageURL have errorCode {}", (Object)errorCode);
            execRes = false;
        }
        return execRes;
    }

    private String queryUrlPackageResult(CollectItem collectItem) {
        String packageResult = null;
        boolean query = true;
        String getPathUrl = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + collectItem.getGetpathURL().replace("{system_esn}", this.devNode.getDeviceSerialNumber());
        while (query) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread sleep error");
            }
            RestConnection conn = null;
            ResponseInfo resp = null;
            try {
                conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
                resp = conn.execGet(getPathUrl);
            }
            catch (ToolException e) {
                LOGGER.error("execute PackegResulte error.");
                query = false;
                continue;
            }
            long errorCode = this.getErrorCode(resp);
            if (0L != errorCode && -1L != errorCode) {
                if (errorCode == 83887409L) continue;
                LOGGER.error("execute PackegResulte have errorCode {} ", (Object)errorCode);
                query = false;
                continue;
            }
            long resultCode = this.getResultCode(resp);
            if (resultCode == 83887409L) continue;
            JSONObject pathJson = new JSONObject(resp.getContent());
            if (resp.getContent().contains("data")) {
                packageResult = pathJson.getString("data");
                query = false;
                continue;
            }
            LOGGER.error("PackegResulte ResponseInfo not have data.");
            query = false;
        }
        return packageResult;
    }

    private boolean exeDowURL(String url, String downPath) {
        boolean downloadRes = false;
        RestConnection conn = null;
        ResponseInfo resp = null;
        try {
            conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            if (conn == null) {
                LOGGER.error("execute DowURL connection error.");
                return false;
            }
            resp = conn.execGetFile(url, null, downPath);
        }
        catch (ToolException e) {
            LOGGER.error("execute DowURL error.");
            return false;
        }
        long errorCode = this.getErrorCode(resp);
        if (0L != errorCode && -1L != errorCode) {
            LOGGER.error("execute DowURL have errorCode,is {}", (Object)errorCode);
            return false;
        }
        Map restContentMap = resp.getContentMap();
        Iterator entryItr = restContentMap.entrySet().iterator();
        boolean gotFile = false;
        while (entryItr.hasNext()) {
            Map.Entry contentEntry = entryItr.next();
            String key = (String)contentEntry.getKey();
            if (key == null || !key.contains(".tgz")) continue;
            gotFile = true;
            downloadRes = true;
        }
        if (!gotFile) {
            LOGGER.error("execute DowURL,rest is not have tgz file.");
        }
        return downloadRes;
    }

    private boolean downModeCollect(List<CollectItem> selectItems, CollectModule cm) {
        long statusCode;
        Integer[] items = this.constructPerformanceItems(selectItems, cm);
        String startCollectionUri = RestUtil.getPerformanceCollectUri((DevNode)this.devNode);
        HashMap<String, Object> reqParam = new HashMap<String, Object>();
        Long[] times = this.getDefaultStartTimeLong();
        reqParam.put("begin_time", times[0]);
        reqParam.put("object_type", items);
        reqParam.put("end_time", times[1]);
        RestConnection conn = null;
        ResponseInfo resp = null;
        try {
            conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            if (conn == null) {
                LOGGER.error("Start permance collection error:no connection ");
                return false;
            }
            resp = conn.execGetFile(startCollectionUri, reqParam, this.resultPath);
        }
        catch (ToolException e) {
            LOGGER.error("Start permance collection exception.{} ", (Throwable)e);
        }
        catch (JSONException e) {
            LOGGER.error("Start permance collection exception,JSONException is happen. {}", (Throwable)e);
        }
        if (resp == null) {
            LOGGER.error("Start permance collection error:no response");
            return false;
        }
        long l = statusCode = null == resp || resp.getStatusLine() == null ? -1L : (long)resp.getStatusLine().getStatusCode();
        if (200L != statusCode) {
            if (503L == statusCode) {
                LOGGER.error("performance collect failed,service is unavaliable and status code is:{}", (Object)statusCode);
            } else {
                LOGGER.error("performance collect failed, and status code is:{}", (Object)statusCode);
            }
            return false;
        }
        long resultCode = this.getResultCode(resp);
        if (!resp.getContentType().equalsIgnoreCase("application/octet-stream")) {
            LOGGER.error("Start performance collection failed, error code is:", (Object)resultCode);
            if (-211L == resultCode) {
                LOGGER.error("Start performance collection failed, no data");
            } else {
                LOGGER.error(this.getErrorDesAndSuggest(resp));
            }
            return false;
        }
        return this.downloadPerformanceFile(resp);
    }

    private Long[] getDefaultStartTimeLong() {
        Date now = new Date();
        Calendar calen = Calendar.getInstance();
        calen.setTime(now);
        calen.add(5, -7);
        Date dat = calen.getTime();
        return new Long[]{dat.getTime() / 1000L, now.getTime() / 1000L};
    }

    private boolean downloadPerformanceFile(ResponseInfo resp) {
        Map restContentMap = resp.getContentMap();
        Iterator entryItr = restContentMap.entrySet().iterator();
        boolean gotCsvFile = false;
        while (entryItr.hasNext()) {
            Map.Entry contentEntry = entryItr.next();
            String key = (String)contentEntry.getKey();
            if (key == null || !key.contains(".zip") && !key.contains(".txt")) continue;
            gotCsvFile = true;
            String resultFileName = key;
            LOGGER.info("download performance collect file success, resultFileName={}", (Object)resultFileName);
        }
        if (!gotCsvFile) {
            LOGGER.error("download performance collect file finished, the file request may failed.");
        }
        return gotCsvFile;
    }

    private long getErrorCode(ResponseInfo resp) {
        if (null == resp || !resp.getContentMap().containsKey("errorCode")) {
            LOGGER.error("resp null or resp does not contain error code.");
            return -1L;
        }
        return (Long)resp.getContentMap().get("errorCode");
    }

    private long getResultCode(ResponseInfo resp) {
        if (resp == null || !resp.getContent().contains("code")) {
            LOGGER.error("resp null or resp does not contain result code.");
            return -1L;
        }
        JSONObject content = new JSONObject(resp.getContent());
        return content.getJSONObject("result").getLong("code");
    }

    private String getErrorDesAndSuggest(ResponseInfo resp) {
        String errorDetail = "";
        if (null != resp && null != resp.getContentMap().get("description")) {
            errorDetail = "error: " + (String)resp.getContentMap().get("description");
        }
        if (null != resp && null != resp.getContentMap().get("suggestion")) {
            errorDetail = errorDetail + System.lineSeparator() + "suggestion: " + (String)resp.getContentMap().get("suggestion");
        }
        return errorDetail;
    }

    private Integer[] constructPerformanceItems(List<CollectItem> selectItems, CollectModule cm) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (CollectItem ci : selectItems) {
            int intId;
            String microSrvId = ci.getMicroServiceId();
            String collectType = ci.getModuleId();
            if (!collectType.equalsIgnoreCase(PERFORMANCE_COLLECT) || items.contains(intId = Integer.parseInt(microSrvId))) continue;
            items.add(intId);
        }
        return items.toArray(new Integer[items.size()]);
    }

    private boolean createModuleCollectTask(List<CollectItem> selectItems, CollectModule cm) {
        String collectType = cm.getModuleId();
        Map<String, List<String>> microSrvIdListMap = this.constructMicroCompItemsPara(selectItems, cm);
        List<Integer> clusterIds = this.getSelectedNodes();
        String startCollectionUri = RestUtil.getInfoCollectUri((DevNode)this.devNode);
        HashMap<String, Object> reqParam = new HashMap<String, Object>();
        reqParam.put("type", collectType);
        reqParam.put("micro_comp", microSrvIdListMap);
        reqParam.put("nodes", clusterIds);
        RestConnection conn = null;
        ResponseInfo resp = null;
        try {
            conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            resp = conn.execPost(startCollectionUri, reqParam);
        }
        catch (ToolException e) {
            LOGGER.error("Start module {} info collection exception, {}", (Object)cm.getModuleId(), (Object)e);
            return false;
        }
        catch (JSONException e) {
            LOGGER.error("Start module {} info collection exception,,JSONException is happen {}. ", (Object)cm.getModuleId(), (Object)e);
            return false;
        }
        long errorCode = this.getErrorCode(resp);
        if (0L != errorCode) {
            LOGGER.error("Start module {} info collection failed, and error code is: {}", (Object)cm.getModuleId(), (Object)errorCode);
            return false;
        }
        JSONObject taskIdObj = (JSONObject)resp.getContentMap().get("data");
        if (taskIdObj.has(TASK_ID)) {
            DStorageModuleCollectTask dmcr = new DStorageModuleCollectTask(cm.getModuleId(), taskIdObj.getString(TASK_ID));
            this.moduleTaskMap.put(cm, dmcr);
            return true;
        }
        LOGGER.error("can not parse the task id.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryAndStartAllSubTasksOfModuleTask(CollectModule cm) {
        if (this.moduleTaskMap.isEmpty()) {
            LOGGER.error("no module task is running...");
            return;
        }
        DStorageModuleCollectTask dmcr = this.moduleTaskMap.get(cm);
        String moduleTaskId = dmcr.getModuleTaskId();
        String infoCollectModuleTaskUri = RestUtil.getInfoCollectModuleTaskUri((DevNode)this.devNode, (String)moduleTaskId);
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            ResponseInfo resp = conn.execGet(infoCollectModuleTaskUri);
            long errorCode = this.getErrorCode(resp);
            if (0L != errorCode) {
                LOGGER.error("query tasks: {} failed, and error code is: {}", (Object)moduleTaskId, (Object)errorCode);
                return;
            }
            JSONObject taskData = (JSONObject)resp.getContentMap().get("data");
            JSONArray subTaskIdArray = taskData.getJSONArray("sub_tasks");
            ArrayList<Integer> otherTasks = new ArrayList<Integer>();
            int firstTaskId = -1;
            dmcr.setSubTaskNum(subTaskIdArray.length());
            for (int j = 0; j < subTaskIdArray.length(); ++j) {
                int subTaskId = subTaskIdArray.getInt(j);
                RestCollectSubTask rcst = dmcr.getSubTaskMap().get(subTaskId);
                if (rcst == null) {
                    rcst = new RestCollectSubTask(moduleTaskId, subTaskId);
                }
                dmcr.getSubTaskMap().put(subTaskId, rcst);
                if (0 != j) {
                    otherTasks.add(subTaskId);
                    continue;
                }
                firstTaskId = subTaskId;
            }
            if (firstTaskId == -1 && otherTasks.isEmpty()) {
                LOGGER.error("Parse module task: {} failed, because no valid sub task found.", (Object)moduleTaskId);
                dmcr.setTaskFailed(true);
                return;
            }
            this.queryInfoCollectSubTaskDetail(cm, moduleTaskId, firstTaskId, otherTasks);
        }
        catch (Exception e) {
            LOGGER.error("query module task: {} exception:{}", (Object)moduleTaskId, (Object)e);
            dmcr.setTaskFailed(true);
            return;
        }
        finally {
            this.deleteModuleTask(cm);
        }
    }

    private void queryInfoCollectSubTaskDetail(CollectModule cm, String moduleTaskId, int firstSubTaskId, List<Integer> otherTaskIds) {
        HashMap<String, String> reqPara = new HashMap<String, String>();
        reqPara.put(TASK_ID, moduleTaskId);
        reqPara.put("sub_task_id", String.valueOf(firstSubTaskId));
        boolean subTaskFinished = this.querySubTaskAndDownloadResult(cm, moduleTaskId, firstSubTaskId, reqPara);
        if (!subTaskFinished) {
            LOGGER.error("sub task {} not finished, may timed out or exception.", (Object)firstSubTaskId);
        }
        for (int eleSubTaskId : otherTaskIds) {
            if (this.triggerNextSubTaskAndDownloadResult(cm, moduleTaskId, reqPara, eleSubTaskId)) continue;
            LOGGER.error("Start next sub task {} failed or exception.", (Object)eleSubTaskId);
        }
    }

    private boolean triggerNextSubTaskAndDownloadResult(CollectModule cm, String moduleTaskId, Map<String, String> reqPara, int eleSubTaskId) {
        String infoCollectSubTaskUri = RestUtil.getInfoCollectSubTaskUri((DevNode)this.devNode);
        String urlParam = "?task_id=" + reqPara.get(TASK_ID);
        RestConnection conn = null;
        Map param = null;
        try {
            conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            ResponseInfo resp = conn.execPut(infoCollectSubTaskUri + urlParam, param);
            long errorCode = this.getResultCode(resp);
            if (0L != errorCode) {
                LOGGER.error("Execute next task: {} sub task: {} failed, and error code is:{}", new Object[]{moduleTaskId, eleSubTaskId, errorCode});
                return false;
            }
        }
        catch (ToolException e) {
            LOGGER.error("execute next task: {} sub task: {} exception: {}", new Object[]{moduleTaskId, eleSubTaskId, e});
            return false;
        }
        LOGGER.info("Start next sub task {} success, begin to loop query status  and download sub task result.", (Object)eleSubTaskId);
        reqPara.put("sub_task_id", String.valueOf(eleSubTaskId));
        if (!this.querySubTaskAndDownloadResult(cm, moduleTaskId, eleSubTaskId, reqPara)) {
            LOGGER.error("sub task {} not finished, may timed out or exception.", (Object)eleSubTaskId);
        }
        return true;
    }

    private boolean querySubTaskAndDownloadResult(CollectModule cm, String moduleTaskId, int subTaskId, Map<String, String> reqPara) {
        String infoCollectSubTaskUri = RestUtil.getInfoCollectSubTaskUri((DevNode)this.devNode);
        boolean needQueryAgain = false;
        int qryCnt = 225;
        for (int i = 0; i < qryCnt; ++i) {
            try {
                Thread.sleep(8000L);
                RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
                ResponseInfo resp = conn.execGet(infoCollectSubTaskUri, reqPara);
                needQueryAgain = this.parseSubTaskQueryRespAndDownLoadFile(cm, moduleTaskId, subTaskId, resp);
                if (needQueryAgain) continue;
                return true;
            }
            catch (ToolException e) {
                LOGGER.error("Rest connection exception:{}", (Throwable)e);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted connection exception:{}", (Throwable)e);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("other exception occurred:{}", (Throwable)e);
            }
        }
        if (needQueryAgain) {
            RestCollectSubTask scst = this.moduleTaskMap.get(cm).getSubTaskMap().get(subTaskId);
            scst.setFailed(true);
            scst.setErrorMsg(ResourceUtil.getString((String)"query.or.down.load.sub.task.result.file.time.out"));
            if (!this.devNode.getClusterNodes().isEmpty()) {
                for (ClusterNode clusterNode : this.devNode.getClusterNodes()) {
                    NodeCollectStatus nodeStatus = new NodeCollectStatus(clusterNode.getId(), "failure", clusterNode.getManagementIp());
                    scst.getNodesCollectStatusMap().put(clusterNode.getId(), nodeStatus);
                }
            } else {
                NodeCollectStatus nodeStatus = new NodeCollectStatus(subTaskId, "failure", " ");
                scst.getNodesCollectStatusMap().put(subTaskId, nodeStatus);
            }
            LOGGER.error("Parse sub task query response and download result file timeout.");
            return false;
        }
        return true;
    }

    private boolean parseSubTaskQueryRespAndDownLoadFile(CollectModule cm, String moduleTaskId, int subTaskId, ResponseInfo resp) {
        DStorageModuleCollectTask dmcr = this.moduleTaskMap.get(cm);
        RestCollectSubTask moduleSubTask = dmcr.getSubTaskMap().get(subTaskId);
        long errorCode = this.getErrorCode(resp);
        if (0L != errorCode) {
            if (errorCode == 404L) {
                LOGGER.error("sub task not exist, the task my start failed.");
                return false;
            }
            if (errorCode == -1L) {
                LOGGER.error("query tasks:{} failed, and error code is -1", (Object)moduleTaskId);
                moduleSubTask.setErrorMsg(ResourceUtil.getString((String)"query.or.down.load.sub.task.result.file.failed"));
                moduleSubTask.setFailed(true);
                return false;
            }
            LOGGER.warn("query tasks:{} failed, and error code is:{}", (Object)moduleTaskId, (Object)errorCode);
            return true;
        }
        JSONObject taskData = (JSONObject)resp.getContentMap().get("data");
        int subTaskProgress = taskData.getInt("progress");
        boolean isSubTaskHasFile = taskData.getBoolean("sub_task_result");
        moduleSubTask.setSubTaskProgress(subTaskProgress);
        moduleSubTask.setHasResultFile(isSubTaskHasFile);
        JSONArray serverDetailArray = taskData.getJSONArray("server_detail");
        for (int i = 0; i < serverDetailArray.length(); ++i) {
            int serverId = serverDetailArray.getJSONObject(i).getInt("server_id");
            String serverStatus = serverDetailArray.getJSONObject(i).getString("server_task_status");
            NodeCollectStatus nodeStatus = moduleSubTask.getNodesCollectStatusMap().get(serverId);
            if (null == nodeStatus) {
                nodeStatus = new NodeCollectStatus(serverId, serverStatus, this.getClusterNodeIP(serverId));
                moduleSubTask.getNodesCollectStatusMap().put(serverId, nodeStatus);
                continue;
            }
            nodeStatus.setServerTaskStatus(serverStatus);
        }
        if (subTaskProgress == 100) {
            if (isSubTaskHasFile) {
                this.downloadSubTaskResultFile(cm, moduleTaskId, subTaskId);
                LOGGER.info("Sub task finished, and sub task result file download finished.");
            }
            return false;
        }
        return true;
    }

    private boolean downloadSubTaskResultFile(CollectModule cm, String moduleTaskId, int subTaskId) {
        ResponseInfo resp;
        String infoCollectSubTaskUri = RestUtil.getSubTaskResultFileUri((DevNode)this.devNode);
        HashMap<String, Object> reqPara = new HashMap<String, Object>();
        reqPara.put(TASK_ID, moduleTaskId);
        reqPara.put("sub_task_id", subTaskId);
        RestCollectSubTask subTask = this.moduleTaskMap.get(cm).getSubTaskMap().get(subTaskId);
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            resp = conn.execGetFile(infoCollectSubTaskUri, reqPara, this.resultPath);
        }
        catch (Exception t) {
            LOGGER.error("download module task: {} sub task id:{} result file exception:{}", new Object[]{moduleTaskId, subTaskId, t});
            subTask.setFailed(true);
            return false;
        }
        long statusCode = resp.getStatusLine().getStatusCode();
        if (200L != statusCode) {
            LOGGER.error("query tasks:{} failed, and status code is:{}", (Object)moduleTaskId, (Object)statusCode);
            subTask.setErrorMsg(ResourceUtil.getStringWithParams((String)"download.sub.task.result.failed", (Object[])new Object[]{moduleTaskId, subTaskId, subTask.getNodesString()}));
            subTask.setFailed(true);
            return false;
        }
        Map restContentMap = resp.getContentMap();
        Iterator entryItr = restContentMap.entrySet().iterator();
        boolean gotZipFile = false;
        while (entryItr.hasNext()) {
            Map.Entry contentEntry = entryItr.next();
            String key = (String)contentEntry.getKey();
            if (null == key || !key.contains(".zip")) continue;
            gotZipFile = true;
            String subTaskResultFileName = key;
            this.moduleTaskMap.get(cm).getSubTaskMap().get(subTaskId).setResultFileName(subTaskResultFileName);
            subTask.setFailed(false);
            LOGGER.info("download sub task file success, subTaskResultFileName is {}", (Object)subTaskResultFileName);
        }
        if (!gotZipFile) {
            subTask.setFailed(true);
            LOGGER.error("download sub task file finished, the file request may failed.");
        }
        return gotZipFile;
    }

    private Map<String, List<String>> constructMicroCompItemsPara(List<CollectItem> selectItems, CollectModule cm) {
        HashMap<String, List<String>> microSrvIdListMap = new HashMap<String, List<String>>();
        List<CollectItem> moduleItems = cm.getItems();
        for (CollectItem ci : selectItems) {
            List<String> itemIdList;
            String microSrvId = ci.getMicroServiceId();
            String itemId = ci.getId();
            if (!moduleItems.contains(ci)) continue;
            if (microSrvIdListMap.containsKey(microSrvId)) {
                itemIdList = (List)microSrvIdListMap.get(microSrvId);
                itemIdList.add(itemId);
                continue;
            }
            itemIdList = new ArrayList();
            itemIdList.add(itemId);
            microSrvIdListMap.put(microSrvId, itemIdList);
        }
        return microSrvIdListMap;
    }

    public void deleteModuleTask(CollectModule cm) {
        DStorageModuleCollectTask dmcr = this.moduleTaskMap.get(cm);
        String moduleTaskId = dmcr.getModuleTaskId();
        String infoCollectModuleTaskUri = RestUtil.getInfoCollectModuleTaskUri((DevNode)this.devNode, (String)moduleTaskId);
        ResponseInfo resp = null;
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            resp = conn.execDelete(infoCollectModuleTaskUri);
            long errorCode = this.getErrorCode(resp);
            if (0L != errorCode) {
                LOGGER.error("delete task:{} failed, and error code is:{}", (Object)moduleTaskId, (Object)errorCode);
            } else {
                LOGGER.info("delete module:{} collect task:{} success.", (Object)cm.getModuleId(), (Object)moduleTaskId);
            }
        }
        catch (Exception e) {
            LOGGER.error("delete module:{} collect task:{} exception:{}", new Object[]{cm.getModuleId(), moduleTaskId, e});
        }
    }

    private List<Integer> getSelectedNodes() {
        ArrayList<Integer> clusterIds = new ArrayList<Integer>();
        for (ClusterNode cn : this.devNode.getClusterNodes()) {
            if (!cn.isSelected()) continue;
            clusterIds.add(cn.getId());
        }
        return clusterIds;
    }

    private String getClusterNodeIP(int serviceId) {
        for (ClusterNode clusterNode : this.devNode.getClusterNodes()) {
            if (serviceId != clusterNode.getId()) continue;
            return clusterNode.getManagementIp();
        }
        return "";
    }

    private class ProgressUpdator
    implements Runnable {
        UiUpdatePair ui;
        private int progressLast;
        private int progressPieceLength;
        private volatile boolean taskFinish;

        private ProgressUpdator(UiUpdatePair ui, int progressLast, int progressPieceLength, boolean taskFinish) {
            this.ui = ui;
            this.progressLast = progressLast;
            this.progressPieceLength = progressPieceLength;
            this.taskFinish = taskFinish;
        }

        @Override
        public void run() {
            int num = 0;
            while (!this.taskFinish) {
                try {
                    int nowProgress = this.progressLast + this.calcStepLength(++num, this.progressPieceLength);
                    this.ui.updateProgress(nowProgress);
                    Thread.sleep(8000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Thread sleep error");
                }
            }
        }

        private int calcStepLength(int current, int max) {
            double speed = 10.0;
            double block = speed * 2.0;
            int quotient = (int)((double)current / speed);
            int leftover = (int)((double)current % speed);
            if (quotient < 1) {
                return (int)((double)leftover / block * (double)max);
            }
            double undone = 1.0;
            for (int i = 0; i < quotient; ++i) {
                undone *= 2.0;
            }
            double rulst = 1.0 - 1.0 / undone + (double)leftover * (1.0 / undone) / block;
            return (int)(rulst * (double)max);
        }

        public void setTaskFinish(boolean taskFinish) {
            this.taskFinish = taskFinish;
        }
    }
}

