/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.exception.BatchInspectStartException;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.FusionStorInspector;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ItemProgressResult;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorInspectRestImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionStorInspector.class);
    private CheckDevNode checkDevNode;
    private IUiObserver uiObserver;

    public FusionStorInspectRestImpl(CheckDevNode checkDevNode, IUiObserver uiObserver) {
        this.checkDevNode = checkDevNode;
        this.uiObserver = uiObserver;
    }

    public String startPreCheck(String[] items, String[] nodes) throws ToolException {
        HashMap<String, String[]> reqParam = new HashMap<String, String[]>();
        reqParam.put("items", items);
        reqParam.put("nodes", nodes);
        RestConnection conn = null;
        ResponseInfo resp = null;
        try {
            conn = RestConnectionManager.getRestConnection((DevNode)this.checkDevNode.getDevNode());
            resp = conn.execPost(RestUtil.getInspectionUri((DevNode)this.checkDevNode.getDevNode()), reqParam);
        }
        catch (JSONException e) {
            throw new ToolException("Start inspection failed.");
        }
        if (0L != this.getErrorCode(resp)) {
            throw new ToolException("Start inspection failed.");
        }
        return ((JSONObject)resp.getContentMap().get("data")).getString("task_id");
    }

    public String startDStorageInspectTask(String[] items, String[] nodes) throws ToolException {
        this.uiObserver.update(this.checkDevNode, null, ResourceUtil.getString((String)"starting.ds.storage.inspection"), 1, Calendar.getInstance());
        ResponseInfo resp = this.inspectTaskExec(items, nodes);
        long errorCode = this.getErrorCode(resp);
        if (errorCode != 0L) {
            String suffix = String.valueOf(errorCode);
            String msg = ResourceUtil.getString((String)("start.inspection.failed." + suffix));
            if ("--".equals(msg)) {
                msg = ResourceUtil.getString((String)"start.inspection.failed");
            }
            LOGGER.error("Start distributed storage inspection failed, and error code is:" + errorCode);
            this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
            throw new ToolException("Start inspection failed.");
        }
        this.uiObserver.update(this.checkDevNode, null, ResourceUtil.getString((String)"finished.ds.storage.inspection"), 1, Calendar.getInstance());
        return this.getTaskId(resp);
    }

    public String startOneBatchInspectTask(String[] items, String[] nodes, int currentBatch) throws ToolException {
        ResponseInfo resp = this.inspectTaskExec(items, nodes);
        long errorCode = this.getErrorCode(resp);
        if (errorCode != 0L) {
            LOGGER.error("current batch inspect start failed, and error code is:{},current batch number is {}, nodeIds is {}", new Object[]{errorCode, currentBatch, Arrays.toString(nodes)});
            throw new BatchInspectStartException(String.valueOf(errorCode), "Start inspection failed.");
        }
        LOGGER.info("current batch inspect start success, current batch number is {}, nodes is{}, items is {}", new Object[]{currentBatch, Arrays.toString(nodes), Arrays.toString(items)});
        return this.getTaskId(resp);
    }

    private String getTaskId(ResponseInfo resp) {
        return ((JSONObject)resp.getContentMap().get("data")).getString("task_id");
    }

    public String startAfterCheckTask(String[] items, String[] nodes) throws ToolException {
        ResponseInfo resp = this.inspectTaskExec(items, nodes);
        long errorCode = this.getErrorCode(resp);
        if (0L != errorCode) {
            LOGGER.error("Start distributed storage AfterCheck failed, and error code is:" + errorCode);
            throw new ToolException("startAfterCheckTask failed.");
        }
        return this.getTaskId(resp);
    }

    private ResponseInfo inspectTaskExec(String[] items, String[] nodes) throws ToolException {
        String startInspectionUri = RestUtil.getInspectionUri((DevNode)this.checkDevNode.getDevNode());
        HashMap<String, String[]> reqParam = new HashMap<String, String[]>();
        reqParam.put("items", items);
        reqParam.put("nodes", nodes);
        RestConnection conn = null;
        ResponseInfo resp = null;
        try {
            conn = RestConnectionManager.getRestConnection((DevNode)this.checkDevNode.getDevNode());
            resp = conn.execPost(startInspectionUri, reqParam);
        }
        catch (JSONException e) {
            LOGGER.error("Start distributed storage inspection failed,JSONException is happen.");
            this.uiObserver.update(this.checkDevNode, null, ResourceUtil.getString((String)"start.inspection.failed"), 1, Calendar.getInstance());
            throw new ToolException("Start inspection failed.");
        }
        return resp;
    }

    public void deleteDStorageInspectTask(DevNode devNode, String taskId) {
        try {
            String taskUri = RestUtil.getInspectionTaskUri((DevNode)devNode, (String)taskId);
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            ResponseInfo resp = conn.execDelete(taskUri, null);
            long errorCode = this.getErrorCode(resp);
            if (0L != errorCode) {
                LOGGER.error("delete distributed storage inspection failed, and error code is:" + errorCode);
            }
        }
        catch (Exception e) {
            LOGGER.error("deleteDStorageInspectTask exception.", (Throwable)e);
        }
    }

    public Map<String, ItemProgressResult> queryDStorageInspectProgress(String taskId, String[] itemIds, String[] taskNodeIds) throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.checkDevNode.getDevNode());
        String inspectTaskUri = RestUtil.getInspectionTaskUri((DevNode)this.checkDevNode.getDevNode(), (String)taskId);
        HashMap reqParam = new HashMap();
        HashMap<String, ItemProgressResult> itemProgressResultMap = new HashMap<String, ItemProgressResult>();
        ArrayList<String> qryIds = new ArrayList<String>();
        int itemIdNum = itemIds.length;
        for (int i = 0; i < itemIds.length; ++i) {
            qryIds.add(itemIds[i]);
            if (qryIds.size() < 10 && qryIds.size() < itemIdNum) continue;
            reqParam.put("items", qryIds);
            try {
                ResponseInfo resp = conn.execPost(inspectTaskUri, reqParam);
                itemIdNum -= qryIds.size();
                qryIds = new ArrayList();
                long errorCode = this.getErrorCode(resp);
                if (0L != errorCode) {
                    LOGGER.error("Query some items:" + ((Object)qryIds).toString() + " failed, and error code is:" + errorCode);
                    continue;
                }
                this.parseItemQryResponse(itemProgressResultMap, resp, taskNodeIds);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Query some items:" + ((Object)qryIds).toString() + "error trace info : ", (Throwable)e);
            }
        }
        return itemProgressResultMap;
    }

    public boolean downloadDStorageInspectResult(CheckDevNode checkDev, String taskId, String itemId, String productDir) throws ToolException {
        LOGGER.info("download DStorage inspect result.itemId={}", (Object)itemId);
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)checkDev.getDevNode());
        String uri = RestUtil.getInspectionTaskUri((DevNode)checkDev.getDevNode(), (String)taskId);
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("item_id", itemId);
        ResponseInfo resp = conn.execGetFile(uri, reqParam, productDir);
        Map restContentMap = resp.getContentMap();
        Long errorCode = (Long)restContentMap.get("errorCode");
        if (null != errorCode && 0L != errorCode) {
            LOGGER.error("Get inspection resource file failed, error code:" + errorCode);
            return false;
        }
        String resourceZipFileName = (String)restContentMap.get("filePath");
        File resultFile = new File(resourceZipFileName);
        return resultFile.exists() && resultFile.isFile();
    }

    private void parseItemQryResponse(Map<String, ItemProgressResult> itemProgressResultMap, ResponseInfo resp, String[] taskNodeIds) {
        JSONArray itemJsonArray = (JSONArray)resp.getContentMap().get("data");
        for (int i = 0; i < itemJsonArray.length(); ++i) {
            JSONObject itemJson = (JSONObject)itemJsonArray.get(i);
            String itemId = itemJson.getString("item_id");
            int progress = itemJson.getInt("process");
            ItemProgressResult itemResult = new ItemProgressResult(itemId, progress);
            HashMap<String, Integer> ipToResultMap = new HashMap<String, Integer>();
            if (progress == 100) {
                this.initMap(ipToResultMap, taskNodeIds);
                JSONObject allNodesResult = itemJson.getJSONObject("node_status");
                Set nodeIps = allNodesResult.keySet();
                for (String nodeIp : nodeIps) {
                    int nodeErrCode = allNodesResult.getInt(nodeIp);
                    ipToResultMap.put(nodeIp, nodeErrCode);
                }
                itemResult.setIpToResultMap(ipToResultMap, this.checkDevNode);
            }
            itemProgressResultMap.put(itemId, itemResult);
        }
    }

    private void initMap(Map<String, Integer> ipToResultMap, String[] taskNodeIds) {
        for (String nodeId : taskNodeIds) {
            ipToResultMap.put(nodeId, 1);
        }
    }

    long getErrorCode(ResponseInfo resp) {
        return Optional.ofNullable(resp).map(ResponseInfo::getContentMap).map(contentMap -> contentMap.get("errorCode")).map(obj -> (long)((Long)obj)).orElse(-1L);
    }
}

