/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstorageAfterCheckConfig;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.FusionStorInspectRestImpl;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ItemProgressResult;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportDataManager;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.utils.ComputerStorageUtils;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class FusionStorInspectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionStorInspectService.class);
    private FusionStorInspectRestImpl restImpl = null;
    private CheckDevNode checkDevNode = null;
    private String deviceId = "";
    private Set<String> downLoadedItemIds = new HashSet<String>();
    private Map<String, String> itemTagMap = new HashMap<String, String>();
    private DstoragePatchInfo inspectPatch;
    private int totalBatch;
    private int currentBatch;
    private boolean isIpv6;

    public FusionStorInspectService(CheckDevNode checkDevNode, IUiObserver uiObserver) {
        this.checkDevNode = checkDevNode;
        this.restImpl = new FusionStorInspectRestImpl(checkDevNode, uiObserver);
        this.deviceId = checkDevNode.getDevNode().getDeviceSerialNumber();
    }

    public ItemProgressResult query(String taskId, CheckItem item, String[] taskNodeIds) {
        Map<Object, ItemProgressResult> resultMap = new HashMap();
        try {
            resultMap = this.restImpl.queryDStorageInspectProgress(taskId, new String[]{item.getItemId()}, taskNodeIds);
        }
        catch (Exception e) {
            LOGGER.error("query exception.", (Throwable)e);
        }
        return resultMap.getOrDefault(item.getItemId(), new ItemProgressResult(item.getItemId(), 0));
    }

    public Map<String, ItemProgressResult> query(String taskId, String[] itemIds, String[] taskNodeIds) {
        HashMap<String, ItemProgressResult> itemProgressResultMap = new HashMap();
        try {
            itemProgressResultMap = this.restImpl.queryDStorageInspectProgress(taskId, itemIds, taskNodeIds);
        }
        catch (Exception e) {
            LOGGER.error("query exception.", (Throwable)e);
        }
        return itemProgressResultMap;
    }

    public void downloadOriginInfo(String taskId, Map<String, ItemProgressResult> itemProgressResultMap) {
        List<CheckItem> items = InspectUtils.getAllCheckItemRemoveNoUsePreInspectScrips(this.checkDevNode);
        List<CheckItem> afterCheckItems = DstorageAfterCheckConfig.INS.filterAfterCheckItems(this.checkDevNode);
        afterCheckItems.removeAll(items);
        items.addAll(afterCheckItems);
        DstoragePatchInfo patch = Context.INS.findBestMatchPatch(this.checkDevNode.getDevNode(), DstoragePatchInfo.Type.INSPECT);
        for (ItemProgressResult itemResult : itemProgressResultMap.values()) {
            String itemId = itemResult.getItemId();
            if (itemResult.isFinished()) {
                if (null != patch && patch.getItemIdList().contains(itemId)) {
                    itemResult.setPatchItem(true);
                }
                itemResult.setClusterItem(this.isClusterItem(items, itemId));
            }
            if (!StringUtils.isNULLStr((String)itemResult.getResultPath()) || !itemResult.isFinished() || this.downLoadedItemIds.contains(itemId)) continue;
            this.download(taskId, itemResult, itemId);
        }
    }

    public void downloadOneBatchResultFile(String taskId, Map<String, ItemProgressResult> itemProgressResultMap) {
        itemProgressResultMap.values().stream().filter(progressResult -> progressResult.isFinished() && !this.downLoadedItemIds.contains(progressResult.getItemId())).forEach(progressResult -> this.setPropertyAndDownload(taskId, (ItemProgressResult)progressResult));
    }

    private void setPropertyAndDownload(String taskId, ItemProgressResult progressResult) {
        String itemId = progressResult.getItemId();
        progressResult.setClusterItem("cluster".equals(this.itemTagMap.get(itemId)));
        if (this.inspectPatch != null && this.inspectPatch.getItemIdList().contains(itemId)) {
            progressResult.setPatchItem(true);
        }
        this.downloadOneBatch(taskId, progressResult.getItemId());
    }

    void downloadOneBatch(String taskId, String itemId) {
        String downloadDir = this.getDownloadDir();
        boolean isDownloadSuccess = this.downloadForBatch(taskId, itemId, downloadDir);
        if (isDownloadSuccess && this.totalBatch > 1) {
            this.decompressAndMoveFile(downloadDir, itemId);
        }
    }

    private String getDownloadDir() {
        return ReportDataManager.DS_RESULT_PATH + File.separator + this.deviceId + File.separator + (this.totalBatch > 1 ? Integer.valueOf(this.currentBatch) : "");
    }

    private void decompressAndMoveFile(String downloadDir, String itemId) {
        File zipFile = new File(downloadDir, itemId + ".zip");
        if (!zipFile.exists() || !zipFile.isFile()) {
            LOGGER.error("decompress item file fail, the file is not exist or is not file, the itemId is {}", (Object)itemId);
            return;
        }
        String itemDirPath = downloadDir + File.separator + itemId + File.separator;
        String outerItemPath = ReportDataManager.DS_RESULT_PATH + File.separator + this.deviceId + File.separator + itemId;
        try {
            ZipUtils.decompressFileForWindows((File)zipFile, (String)itemDirPath);
            FilesUtil.copyFiles((File[])new File(itemDirPath).listFiles(), (String)outerItemPath);
        }
        catch (IOException e) {
            LOGGER.error("decompress batch item file fail,file path is {}", (Object)FilesUtil.getCanonicalPath((File)zipFile), (Object)e);
        }
    }

    boolean downloadForBatch(String taskId, String itemId, String downloadDir) {
        boolean isSuccess = false;
        try {
            isSuccess = this.restImpl.downloadDStorageInspectResult(this.checkDevNode, taskId, itemId, downloadDir);
        }
        catch (ToolException e) {
            LOGGER.error("current batch download item file fail,item id is {},current batch number is {}.", new Object[]{itemId, this.currentBatch, e});
        }
        if (isSuccess) {
            LOGGER.info("current batch download item file success,current batch number is {},item id is {}", (Object)this.currentBatch, (Object)itemId);
            this.downLoadedItemIds.add(itemId);
        } else {
            LOGGER.error("current batch download item file fail,current batch number is {},item id is {}", (Object)this.currentBatch, (Object)itemId);
        }
        return isSuccess;
    }

    public void download(String taskId, ItemProgressResult itemResult, String itemId) {
        try {
            String productDir = ReportDataManager.DS_RESULT_PATH + File.separator + this.deviceId;
            boolean isSuc = this.restImpl.downloadDStorageInspectResult(this.checkDevNode, taskId, itemId, productDir);
            if (isSuc) {
                itemResult.setResultPath(productDir, itemId);
                this.downLoadedItemIds.add(itemId);
            }
        }
        catch (Exception e) {
            LOGGER.error("downloadDStorageInspectResult error.", (Throwable)e);
        }
    }

    private boolean isClusterItem(List<CheckItem> items, String itemId) {
        for (CheckItem item : items) {
            if (!itemId.equals(item.getItemId()) || !"cluster".equals(item.getTag())) continue;
            return true;
        }
        return false;
    }

    public void initAllBatchData(List<String> selectedNodes, int totalBatch) {
        List<CheckItem> items = InspectUtils.getAllCheckItemRemoveNoUsePreInspectScrips(this.checkDevNode);
        List<CheckItem> afterCheckItems = DstorageAfterCheckConfig.INS.filterAfterCheckItems(this.checkDevNode);
        items.addAll(afterCheckItems);
        this.itemTagMap = items.stream().collect(Collectors.toMap(CheckItem::getItemId, CheckItem::getTag, (oldkey, newKey) -> oldkey));
        this.inspectPatch = Context.INS.findBestMatchPatch(this.checkDevNode.getDevNode(), DstoragePatchInfo.Type.INSPECT);
        this.totalBatch = totalBatch;
        this.isIpv6 = selectedNodes.stream().anyMatch(StringUtils::isIpv6Address);
    }

    public void mergeBatchCheckItemFiles(List<String> checkItems) {
        if (this.totalBatch == 1) {
            return;
        }
        String serialNumberDir = ReportDataManager.DS_RESULT_PATH + File.separator + this.deviceId + File.separator;
        HashSet<String> compressFailItems = new HashSet<String>();
        this.compressOuterItemFile(checkItems, serialNumberDir, compressFailItems);
        this.deleteOtherDir(new File(serialNumberDir), compressFailItems);
    }

    void deleteOtherDir(File parentDir, Set<String> compressFailItems) {
        File[] files = parentDir.listFiles();
        if (!parentDir.exists() || Objects.isNull(files)) {
            return;
        }
        Arrays.stream(files).filter(file -> file.isDirectory() && !compressFailItems.contains(file.getName())).forEach(file -> {
            LOGGER.info("delete outer file, the file name is {}", (Object)file.getName());
            FileUtils.deleteFile((File)file);
            ComputerStorageUtils.sleepMilliseconds(100);
        });
    }

    void compressOuterItemFile(List<String> checkItems, String serialNumberDir, Set<String> compressFailItems) {
        checkItems.forEach(itemId -> {
            boolean isSuccess;
            boolean bl = isSuccess = this.isIpv6 ? this.compressFileRestoreIpv6Colon(serialNumberDir + itemId.concat(".zip"), serialNumberDir + itemId) : ZipUtils.compressFile((String)(serialNumberDir + itemId.concat(".zip")), (String)(serialNumberDir + itemId));
            if (!isSuccess) {
                LOGGER.error("compress outer file fail,the itemId is {}", itemId);
                compressFailItems.add((String)itemId);
            } else {
                LOGGER.info("compress outer file success,the itemId is {}", itemId);
            }
            ComputerStorageUtils.sleepMilliseconds(100);
        });
    }

    public void handleSourceInfo(Map<String, ItemProgressResult> totalProgressMap) {
        String serialNumberDir = ReportDataManager.DS_RESULT_PATH + File.separator + this.deviceId;
        totalProgressMap.values().forEach(progressResult -> progressResult.setResultPath(serialNumberDir, progressResult.getItemId()));
    }

    public void initOneBatchData(int currentBatchNumber) {
        this.currentBatch = currentBatchNumber;
        this.downLoadedItemIds.clear();
    }

    /*
     * Exception decompiling
     */
    boolean compressFileRestoreIpv6Colon(String targetPath, String sourcePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void zipFileRestoreColon(ZipOutputStream out, String filePath, File srcFile) throws IOException {
        if (srcFile.isFile()) {
            this.handleFileCompress(out, filePath, srcFile);
            return;
        }
        if (ArrayUtils.isEmpty((Object[])srcFile.listFiles())) {
            this.handleEmptyDir(out, filePath);
            return;
        }
        for (File file : srcFile.listFiles()) {
            if (file.isDirectory()) {
                this.zipFileRestoreColon(out, this.getIpv6ZipPath(filePath, file), file);
                continue;
            }
            this.handleFileCompress(out, filePath, file);
        }
    }

    private String getIpv6ZipPath(String filePath, File dirctory) {
        String dirName = dirctory.getName();
        String dirReplaceName = dirName.replace("_", ":");
        String resultName = StringUtils.isIpv6Address((String)dirReplaceName) ? dirReplaceName : dirName;
        return this.getZipFilePath(filePath, resultName);
    }

    private void handleEmptyDir(ZipOutputStream out, String filePath) throws IOException {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)filePath)) {
            out.putNextEntry(new ZipEntry(filePath + File.separator));
            out.closeEntry();
        }
    }

    private void handleFileCompress(ZipOutputStream out, String filePath, File file) {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int length;
            String entryPath = this.getZipFilePath(filePath, file.getName());
            out.putNextEntry(new ZipEntry(entryPath));
            byte[] bytes = new byte[1024];
            while ((length = bis.read(bytes)) != -1) {
                out.write(bytes, 0, length);
            }
        }
        catch (IOException e) {
            LOGGER.error("write zipEntry error.", (Throwable)e);
        }
    }

    private String getZipFilePath(String filePath, String fileName) {
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)filePath) ? filePath + File.separator + fileName : fileName;
    }
}

