/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionInspectTaskResult;
import com.huawei.ism.tool.fusioncube.entity.MetaVisionItemProgressResult;
import com.huawei.ism.tool.fusioncube.service.MetaVisionInspectService;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Config;
import com.huawei.ism.tool.inspect.entity.DstorageAfterCheckConfig;
import com.huawei.ism.tool.inspect.entity.DstoragePreCheckConfig;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.exception.BatchInspectStartException;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.FusionStorExpansionTaskByLocal;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.FusionStorExpansionTaskByUpload;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.FusionStorInspectRestImpl;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.FusionStorInspectService;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.FusionStorInspectorTaskObserver;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ItemProgressResult;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.PatchAutoBuilder;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportDataManager;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.ResultCalc;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.ComputerStorageUtils;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.NodeHardwareUsage;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.utils.GetDistributedDeviceHardwareUsage;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.service.PatchImportImp;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorInspector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FusionStorInspector.class);
    private static final int QUERY_TIMEOUT = FusionStorageConfig.getQueryTimeOut();
    private static final long AFTER_CHECK_EXEC_TIMEOUT = FusionStorageConfig.getAfterCheckExecTimeout();
    private static final int QUERY_INTERVAL = 5000;
    private static final int MAX_INSPECT_PARAM_LENGTH = Integer.parseInt(ResourceBundle.getBundle("config.inspect").getString("inspect.param.max.length"));
    private static final int MAX_HARDWARE_ABNORMAL_SHOW_IP = 3;
    private final FusionStorInspectorTaskObserver observer = new FusionStorInspectorTaskObserver();
    private final IUiObserver uiObserver;
    private final CheckDevNode checkDevNode;
    private final ResultCalc rcCount;
    private final FusionStorInspectRestImpl restImpl;
    private final FusionStorInspectService service;
    private final List<String> associatedItemIds = new ArrayList<String>();
    private List<String> afterCheckItemIds = new ArrayList<String>();
    private long itemStartTime;
    private final List<String> patchItems = new ArrayList<String>();
    private int totalBatch;
    private int currentBatch;
    private int totalItemBatch = 1;
    private int currentItemBatch = 1;
    private Map<String, Long> endTimeMap = new HashMap<String, Long>();
    private Set<String> notExecuteNodes = new LinkedHashSet<String>();
    private List<String> hasExceptionNodes = new ArrayList<String>();
    private Map<String, Integer> ipBatchMap = new HashMap<String, Integer>();
    private Map<String, String> ipStatusMap = new HashMap<String, String>();
    private Set<String> errorCodes = new HashSet<String>();
    private boolean isStop = false;

    public FusionStorInspector(CheckDevNode checkDevNode, IUiObserver uiObserver, ResultCalc rcCount) {
        this.uiObserver = uiObserver;
        this.checkDevNode = checkDevNode;
        this.rcCount = rcCount;
        this.restImpl = new FusionStorInspectRestImpl(checkDevNode, uiObserver);
        this.service = new FusionStorInspectService(checkDevNode, uiObserver);
        DstoragePatchInfo patch = Context.INS.findBestMatchPatch(checkDevNode.getDevNode(), DstoragePatchInfo.Type.INSPECT);
        if (Objects.nonNull(patch)) {
            this.patchItems.addAll(patch.getItemIdList());
        }
    }

    public void init() {
        this.clearEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInspect() {
        if (InspectContext.getInstance().isHardwareInspect()) {
            return;
        }
        List<CheckItem> preCheckItemOpt = this.getPreCheckItem();
        if (preCheckItemOpt.isEmpty()) {
            return;
        }
        String stepName = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.preInspect");
        log.info("Start pre Check");
        int processStep = 0;
        Calendar startTime = Calendar.getInstance();
        this.updateProcess(stepName, processStep, startTime, RecordStatus.PROCESSING);
        try {
            this.executeAllItem(preCheckItemOpt);
            this.deCompressMultiPlePreInspect(this.checkDevNode);
            this.importCheckResult();
        }
        catch (Throwable ex) {
            log.error("Pre check exec failed.", ex);
        }
        finally {
            processStep = 1;
            this.updateProcess(stepName, processStep, startTime, RecordStatus.NORMAL);
        }
    }

    private void deCompressMultiPlePreInspect(CheckDevNode checkDevNode) {
        DstoragePreCheckConfig.INS.findMatchConfig(checkDevNode.getDevNode()).filter(Config::isMultiple).ifPresent(config -> this.deCompressPreInspectResult(checkDevNode, config.getPreItemID()));
    }

    private void updateProcess(String stepName, int processStep, Calendar startTime, RecordStatus status) {
        if (Objects.isNull(this.uiObserver)) {
            return;
        }
        this.uiObserver.update(this.checkDevNode, null, stepName, processStep, startTime, status);
    }

    private List<CheckItem> getPreCheckItem() {
        List<CheckItem> preCheckItems = CheckItemUtils.getPreCheckItems(this.checkDevNode);
        if (preCheckItems.isEmpty()) {
            log.info("Can not find preCheck item for {}", (Object)this.checkDevNode.getDevNode().getIp());
            return Collections.emptyList();
        }
        List<Config> preInspectConfig = DstoragePreCheckConfig.INS.findMatchConfigs(this.checkDevNode.getDevNode());
        preInspectConfig.forEach(config -> this.associatedItemIds.addAll(config.getAssociatedItemIds()));
        return preCheckItems;
    }

    private Boolean deCompressPreInspectResult(CheckDevNode checkDevNode, String preCheckItemId) {
        String deviceSerialNumber = checkDevNode.getDevNode().getDeviceSerialNumber();
        String resourceZipFileName = FilePathUtils.checkFile((String)(ReportDataManager.DS_RESULT_PATH + File.separator + deviceSerialNumber + File.separator + preCheckItemId + ".zip"));
        String targetDir = InspectContext.getInstance().getDstorageTmpPath() + File.separator + deviceSerialNumber + File.separator;
        Boolean unZipSucc = false;
        if (resourceZipFileName != null) {
            unZipSucc = FileAssistant.deCopmressAllZipFile(targetDir, resourceZipFileName);
        }
        if (!unZipSucc.booleanValue()) {
            log.info("preInspect resource file is not exist or unZip false");
        } else {
            new File(resourceZipFileName).delete();
        }
        return unZipSucc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAllItem(List<CheckItem> checkItems) throws ToolException, InterruptedException {
        List<String> allNodesIds = this.getSelectNodes();
        String[] nodeIds = allNodesIds.toArray(new String[0]);
        Object[] preItem = (String[])checkItems.stream().map(CheckItem::getItemId).toArray(String[]::new);
        log.info("pre inspect start with itemIds:{}", (Object)Arrays.toString(preItem));
        String taskId = null;
        try {
            taskId = this.restImpl.startPreCheck((String[])preItem, nodeIds);
            this.pollingPreCheck2Finish(checkItems, taskId, nodeIds, (String[])preItem);
            this.clearTask(taskId);
        }
        catch (Throwable throwable) {
            this.clearTask(taskId);
            throw throwable;
        }
    }

    private void importCheckResult() {
        List configs = DstoragePreCheckConfig.INS.findMatchConfigs(this.checkDevNode.getDevNode()).stream().filter(config -> !StringUtils.isNULLStr((String)config.getResultItemId())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(configs)) {
            log.info("Do not need re-import");
            return;
        }
        for (Config config2 : configs) {
            this.deCompressPreInspectResult(this.checkDevNode, config2.getPreItemID());
            List<CheckItem> selectedItems = InspectUtils.getAllCheckItem(this.checkDevNode);
            PatchAutoBuilder builder = new PatchAutoBuilder(this.checkDevNode, config2, this.getLocalExtendedItems(selectedItems));
            Optional<DstoragePatchInfo> patchPath = builder.buildResultPatch();
            if (!patchPath.isPresent()) {
                log.info("Patch Path not exist");
                continue;
            }
            PatchImportImp importImp = new PatchImportImp(this.checkDevNode.getDevNode(), patchPath.get(), null);
            TaskResult result = importImp.importPatch();
            log.info("Upload preCheck result {} .", (Object)result.getResult());
        }
    }

    private List<String> getAllNodeIds() {
        return this.checkDevNode.getDevNode().getClusterNodes().stream().map(ClusterNode::getManagementIp).collect(Collectors.toList());
    }

    public void execute() throws ToolException {
        if (MetaVisionInspectService.isFusionCubeMetaVisionNode(this.checkDevNode)) {
            this.inspectMetaVisionStorage(this.checkDevNode);
            return;
        }
        List<String> selectedNodes = this.getClusterNodeIps();
        List<CheckItem> selectedItems = InspectUtils.getAllCheckItemRemoveNoUsePreInspectScrips(this.checkDevNode);
        this.executeRestfulItem(selectedNodes, selectedItems);
        this.executeExtendedItems(selectedItems);
        selectedItems = InspectUtils.getAllCheckItem(this.checkDevNode);
        this.resultStatistic(selectedItems);
    }

    private List<String> getClusterNodeIps() {
        return this.getClusterNodes().stream().map(ClusterNode::getManagementIp).collect(Collectors.toList());
    }

    private void executeExtendedItems(List<CheckItem> selectedItems) {
        if (this.isNeedStop()) {
            this.handleStopExtendItems(selectedItems);
            return;
        }
        this.inspectExtendedItems(selectedItems);
    }

    private void handleStopExtendItems(List<CheckItem> selectedItems) {
        selectedItems.stream().filter(item -> this.isUploadExtendedItem((CheckItem)item) || this.isLocalExtendedItem((CheckItem)item)).forEach(this::setResultStopAndRefreshUI);
    }

    private void setResultStopAndRefreshUI(CheckItem checkItem) {
        ResultItem resultItem = new ResultItem();
        resultItem.setRecordStatus(RecordStatus.STOPPED);
        resultItem.setProgress(100);
        resultItem.setStop(true);
        resultItem.setFinished(true);
        checkItem.setCheckResult(resultItem);
        this.uiObserver.update(this.checkDevNode, checkItem, checkItem.getName(), 0, resultItem.getStartTime(), RecordStatus.STOPPED);
    }

    private void executeRestfulItem(List<String> selectedNodes, List<CheckItem> selectedItems) throws ToolException {
        List<CheckItem> restfulItems = this.getNormalItems(selectedItems);
        if (restfulItems.isEmpty()) {
            return;
        }
        if (!this.overParamLength(restfulItems)) {
            this.batchInspectDStorage(restfulItems, selectedNodes);
            return;
        }
        log.info("param length over size, start by step");
        this.inspectByStep(restfulItems, selectedNodes);
    }

    private void inspectByStep(List<CheckItem> restfulItems, List<String> selectedNodes) throws ToolException {
        List<List<CheckItem>> groupItems = this.groupItemWithMaxLength(restfulItems);
        this.totalItemBatch = groupItems.size();
        for (List<CheckItem> groupItem : groupItems) {
            this.batchInspectDStorage(groupItem, selectedNodes);
            ++this.currentItemBatch;
        }
    }

    private List<List<CheckItem>> groupItemWithMaxLength(List<CheckItem> restfulItems) {
        ArrayList<List<CheckItem>> groupItems = new ArrayList<List<CheckItem>>();
        StringBuilder inspectParam = new StringBuilder();
        ArrayList<CheckItem> checkItems = new ArrayList<CheckItem>();
        for (CheckItem restfulItem : restfulItems) {
            inspectParam.append(restfulItem.getItemId()).append(",");
            checkItems.add(restfulItem);
            if (inspectParam.length() < MAX_INSPECT_PARAM_LENGTH) continue;
            groupItems.add(checkItems);
            inspectParam = new StringBuilder();
            checkItems = new ArrayList();
        }
        if (!checkItems.isEmpty()) {
            groupItems.add(checkItems);
        }
        return groupItems;
    }

    private boolean overParamLength(List<CheckItem> restfulItems) {
        return restfulItems.stream().map(CheckItem::getItemId).collect(Collectors.joining(",")).length() > MAX_INSPECT_PARAM_LENGTH;
    }

    public void fusionCubeAfterCheckTask(CheckDevNode node) throws ToolException {
        log.info("[OP:fusionCubeAfterCheckTask] start for : [{}]", (Object)this.checkDevNode.getDevNode().getIp());
        List<Config> configOpt = DstorageAfterCheckConfig.INS.findMatchConfig(this.checkDevNode.getDevNode());
        if (CollectionUtils.isEmpty(configOpt)) {
            log.info("Can not find afterCheck item for {}", (Object)this.checkDevNode.getDevNode().getIp());
            return;
        }
        List<CheckItem> checkItems = DstorageAfterCheckConfig.INS.filterAfterCheckItems(node);
        if (CollectionUtils.isEmpty(checkItems)) {
            log.info("Can not find any afterCheck item for {}", (Object)this.checkDevNode.getDevNode().getIp());
            return;
        }
        checkItems.forEach(item -> item.setCheckResult(null));
        List<String> checkItemIds = checkItems.stream().map(CheckItem::getItemId).collect(Collectors.toList());
        this.afterCheckItemIds = checkItemIds;
        List<String> allNodes = node.getDevNode().getClusterNodes().stream().map(ClusterNode::getManagementIp).collect(Collectors.toList());
        String taskId = null;
        try {
            log.info("The checkItemIds is: {}", checkItemIds);
            String[] itemIds = checkItemIds.toArray(new String[0]);
            String[] nodeIds = allNodes.toArray(new String[0]);
            taskId = this.restImpl.startAfterCheckTask(itemIds, nodeIds);
            this.pollingAfterCheckResult2Finish(checkItems, taskId, itemIds, nodeIds);
            this.clearTask(taskId);
        }
        catch (Exception e) {
            try {
                log.error("inspect interrupt by toolException.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.clearTask(taskId);
                log.info("[OP:fusionCubeAfterCheckTask] end for : [{}]", (Object)this.checkDevNode.getDevNode().getIp());
                throw throwable;
            }
        }
        log.info("[OP:fusionCubeAfterCheckTask] end for : [{}]", (Object)this.checkDevNode.getDevNode().getIp());
    }

    private void pollingAfterCheckResult2Finish(List<CheckItem> checkItems, String taskId, String[] itemIds, String[] nodeIds) {
        Map<String, ItemProgressResult> lastItemResultMap = new HashMap<String, ItemProgressResult>();
        long startTime = System.currentTimeMillis();
        while (true) {
            Map<String, ItemProgressResult> itemProgressResultMap = this.service.query(taskId, itemIds, nodeIds);
            this.service.downloadOriginInfo(taskId, itemProgressResultMap);
            this.refreshCheckItemStatus(checkItems, itemProgressResultMap, false);
            if (this.checkQueryOver(checkItems)) {
                log.info("All check items finished, query progress over...");
                break;
            }
            boolean statusChanged = this.checkItemStatusChanged(checkItems, lastItemResultMap, itemProgressResultMap);
            if (statusChanged) {
                startTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - startTime > AFTER_CHECK_EXEC_TIMEOUT) {
                log.info("[op:pollingAfterCheckResult2Finish]refresh item status timeout");
                this.refreshCheckItemStatusWhenError(checkItems, false);
                break;
            }
            lastItemResultMap = itemProgressResultMap;
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                log.error("Caught interrupted exception", (Throwable)e);
            }
        }
    }

    private List<String> getSelectNodes() {
        return this.checkDevNode.getDevNode().getClusterNodes().stream().filter(ClusterNode::isSelected).map(ClusterNode::getManagementIp).collect(Collectors.toList());
    }

    private List<CheckItem> getUploadExtendedItems(List<CheckItem> selectedItems) {
        return selectedItems.stream().filter(this::isUploadExtendedItem).collect(Collectors.toList());
    }

    private List<CheckItem> getLocalExtendedItems(List<CheckItem> selectedItems) {
        return selectedItems.stream().filter(this::isLocalExtendedItem).collect(Collectors.toList());
    }

    private List<CheckItem> getNormalItems(List<CheckItem> selectedItems) {
        return selectedItems.stream().filter(this::isRestfulItem).collect(Collectors.toList());
    }

    private boolean isRestfulItem(CheckItem checkItem) {
        return StringUtils.isNULLStr((String)checkItem.getExtendItemMode());
    }

    private boolean isLocalExtendedItem(CheckItem checkItem) {
        return "local".equals(checkItem.getExtendItemMode());
    }

    private boolean isUploadExtendedItem(CheckItem checkItem) {
        return "upload".equals(checkItem.getExtendItemMode());
    }

    private void inspectExtendedItems(List<CheckItem> selectedItems) {
        this.executeUploadExtendedItems(selectedItems);
        this.executeLocalExtendedItems(selectedItems);
    }

    private void executeLocalExtendedItems(List<CheckItem> selectedItems) {
        List<CheckItem> localExtendedItems = this.getLocalExtendedItems(selectedItems);
        List localItemIds = localExtendedItems.stream().map(CheckItem::getItemId).collect(Collectors.toList());
        if (!localExtendedItems.isEmpty()) {
            log.info("local extend items inspect start, the itemIds is:{}", localItemIds);
            if (CollectionUtils.isEmpty(this.getUploadExtendedItems(selectedItems))) {
                this.uiObserver.update(this.checkDevNode, null, ResourceUtil.getString((String)"dsstorage.batch.inspect.extend.item.start.msg"), 0, Calendar.getInstance());
            }
            FusionStorExpansionTaskByLocal task = new FusionStorExpansionTaskByLocal(this.checkDevNode, this.uiObserver, localExtendedItems);
            task.execute();
            log.info("local extend items inspect end, the itemIds is:{}", localItemIds);
        }
    }

    private void executeUploadExtendedItems(List<CheckItem> selectedItems) {
        List<CheckItem> uploadExtendedItems = this.getUploadExtendedItems(selectedItems);
        List uploadItemIds = uploadExtendedItems.stream().map(CheckItem::getItemId).collect(Collectors.toList());
        if (!uploadExtendedItems.isEmpty()) {
            log.info("upload extend items inspect start, the itemIds is:{}", uploadItemIds);
            this.uiObserver.update(this.checkDevNode, null, ResourceUtil.getString((String)"dsstorage.batch.inspect.extend.item.start.msg"), 0, Calendar.getInstance());
            FusionStorExpansionTaskByUpload task = new FusionStorExpansionTaskByUpload(this.checkDevNode, this.uiObserver, uploadExtendedItems);
            task.execute();
            log.info("upload extend items inspect end, the itemIds is:{}", uploadItemIds);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void inspectDStorage(List<CheckItem> checkItems, List<String> selectedNodes) throws ToolException {
        String taskId = null;
        try {
            List<String> selectedItems = this.initCheckItemAndGetIds(checkItems);
            log.info("The selectedItems is:{}", selectedItems);
            String[] itemIds = selectedItems.toArray(new String[0]);
            String[] nodeIds = selectedNodes.toArray(new String[0]);
            this.itemStartTime = System.currentTimeMillis();
            taskId = this.restImpl.startDStorageInspectTask(itemIds, nodeIds);
            this.pollingInspectResult2Finish(checkItems, taskId, itemIds, nodeIds, true);
            this.clearTask(taskId);
            return;
        }
        catch (ToolException e) {
            try {
                log.error("inspect interrupt by toolException");
                throw e;
                catch (Exception ex) {
                    throw new ToolException("inspect interrupt by no excepted failed.", (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                this.clearTask(taskId);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchInspectDStorage(List<CheckItem> checkItems, List<String> selectedNodes) throws ToolException {
        if (CollectionUtils.isEmpty(selectedNodes)) {
            log.info("ths inspect nodeIds is empty, change to use not batch method");
            this.inspectDStorage(checkItems, selectedNodes);
            return;
        }
        List<String> checkItemIds = this.initCheckItemAndGetIds(checkItems);
        List<List<String>> selectNodeBatchs = this.getBatchSelectNodes();
        this.initAllBatchData(checkItemIds, selectedNodes, selectNodeBatchs.size());
        this.recordIpBatch(selectNodeBatchs);
        HashMap<String, ItemProgressResult> totalProgressMap = new HashMap<String, ItemProgressResult>();
        String[] itemIds = checkItemIds.toArray(new String[0]);
        for (int i = 0; i < selectNodeBatchs.size(); ++i) {
            this.currentBatch = i + 1;
            if (this.isNeedStop()) {
                this.handleStop(checkItemIds, totalProgressMap, checkItems);
                break;
            }
            List<NodeHardwareUsage> nodeHardwareUsages = this.getHighNodeUsage();
            if (CollectionUtils.isNotEmpty(nodeHardwareUsages)) {
                this.handleHardwareStop(checkItemIds, totalProgressMap, checkItems, nodeHardwareUsages);
                break;
            }
            this.service.initOneBatchData(this.currentBatch);
            List<String> currentNodes = selectNodeBatchs.get(i);
            String[] nodeIps = currentNodes.toArray(new String[0]);
            String taskId = null;
            try {
                taskId = this.restImpl.startOneBatchInspectTask(itemIds, nodeIps, this.currentBatch);
                this.firstBatchRefreshUI(checkItems);
                this.addMsgToListModel(ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.every.batch.start.msg", (Object[])new Object[]{this.currentBatch}));
                this.updateNodeStatus(nodeIps, ResourceUtil.getString((String)"dsstorage.batch.inspect.execute.status.executing"));
                this.updateNodeTabelStatus();
                boolean isFinishSuccess = this.pollingOneBatchInspect(taskId, checkItemIds, totalProgressMap, checkItems, nodeIps);
                if (!isFinishSuccess) {
                    this.clearTask(taskId);
                    break;
                }
                this.clearTask(taskId);
                continue;
            }
            catch (BatchInspectStartException e) {
                try {
                    this.handleException(checkItems, checkItemIds, totalProgressMap, currentNodes, e);
                    this.clearTask(taskId);
                    continue;
                }
                catch (Throwable throwable) {
                    this.clearTask(taskId);
                    throw throwable;
                }
            }
        }
    }

    private void handleException(List<CheckItem> checkItems, List<String> checkItemIds, Map<String, ItemProgressResult> totalProgressMap, List<String> currentNodes, BatchInspectStartException e) {
        log.error("one batch inspect error,the current batch number is {},node ids is {}", new Object[]{this.currentBatch, currentNodes, e});
        String errorMsg = ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.start.inspect.error", (Object[])new Object[]{e.getErrorCode()});
        currentNodes.forEach(nodeIp -> this.ipStatusMap.put((String)nodeIp, errorMsg));
        this.errorCodes.add(e.getErrorCode());
        this.hasExceptionNodes.addAll(currentNodes);
        this.notExecuteNodes.removeAll(currentNodes);
        if (this.currentBatch == this.totalBatch) {
            this.handleLastBatchException(checkItems, checkItemIds, totalProgressMap);
        }
    }

    private void handleHardwareStop(List<String> checkItemIds, Map<String, ItemProgressResult> totalProgressMap, List<CheckItem> checkItems, List<NodeHardwareUsage> nodeHardwareUsages) {
        this.isStop = true;
        this.handleStop(checkItemIds, totalProgressMap, checkItems);
        String hardwareMsg = this.getHardwareMsg(nodeHardwareUsages);
        log.error("check hardware status abnormal for current batch {}, the msg is:{}", (Object)this.currentBatch, (Object)hardwareMsg);
        this.uiObserver.update(this.checkDevNode, null, hardwareMsg, 0, Calendar.getInstance());
    }

    String getHardwareMsg(List<NodeHardwareUsage> nodeHardwareUsages) {
        if (CollectionUtils.isEmpty(nodeHardwareUsages)) {
            return "";
        }
        StringJoiner joiner = new StringJoiner("; ");
        nodeHardwareUsages.stream().limit(3L).forEach(usage -> joiner.add(ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.hardware.check.stat", (Object[])new Object[]{usage.getNodeIp(), usage.getCpuUsage(), usage.getMemUsage(), usage.getIoUsage(), usage.getDiskUsage()})));
        String hardwareMsg = ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.hardware.check.title", (Object[])new Object[]{nodeHardwareUsages.size(), joiner.toString()});
        if (nodeHardwareUsages.size() > 3) {
            hardwareMsg = hardwareMsg + ResourceUtil.getString((String)"dsstorage.batch.inspect.hardware.check.ellipsis");
        }
        return hardwareMsg;
    }

    List<NodeHardwareUsage> getHighNodeUsage() {
        if (!InspectContext.getInstance().isNeedCheckHighUsage()) {
            return Collections.emptyList();
        }
        log.info("start to check hardware status for current batch {}", (Object)this.currentBatch);
        try {
            return GetDistributedDeviceHardwareUsage.getHardwareStatus((DevNode)this.checkDevNode.getDevNode());
        }
        catch (ToolException e) {
            DevNode devNode = this.checkDevNode.getDevNodeSafe();
            log.error("check hardware status error for device ip {}, current batch {}, model and version is {}", new Object[]{devNode.getIp(), this.currentBatch, devNode.getProductModel() + " " + devNode.getProductVersion(), e});
            return Collections.emptyList();
        }
    }

    boolean isNeedStop() {
        return this.isStop || InspectContext.getInstance().getInspectionGradientGuidance().isStop() || InspectContext.getInstance().getInspectionGradientGuidance().isDsAbnormalStop();
    }

    private List<List<String>> getBatchSelectNodes() {
        List<ClusterNode> selectNodes = this.getClusterNodes();
        int storageInputNumber = InspectContext.getInstance().getInspectionGradientGuidance().getStorageInputNumber();
        int computeInputNumber = InspectContext.getInstance().getInspectionGradientGuidance().getComputeInputNumber();
        List<List<String>> batchNodes = InspectUtils.getBatchNodes(selectNodes, storageInputNumber, computeInputNumber);
        log.info("finish batch node for dev ip:{},total node is {}, total batch number is {},", new Object[]{this.checkDevNode.getDevNode().getIp(), selectNodes.size(), batchNodes.size()});
        return batchNodes;
    }

    private List<ClusterNode> getClusterNodes() {
        List<ClusterNode> selectNodes;
        if (InspectUtils.isDistributedFrw()) {
            selectNodes = this.getClusterNodesInDsFwScene();
            log.info("scene Upgrade_FSFW inspect");
        } else {
            selectNodes = this.getClusterNodeSelected();
        }
        return selectNodes;
    }

    private List<ClusterNode> getClusterNodeSelected() {
        return this.checkDevNode.getDevNode().getClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toList());
    }

    private List<ClusterNode> getClusterNodesInDsFwScene() {
        return this.checkDevNode.getDevNode().getClusterNodes().stream().filter(clusterNode -> clusterNode.isProprietaryHardware() && clusterNode.isSelected()).collect(Collectors.toList());
    }

    private void addMsgToListModel(String msg) {
        SwingUtilities.invokeLater(() -> {
            UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(this.checkDevNode);
            ui.setFinished(false);
            Record record = new Record();
            record.setDate(new Date());
            record.setMessage(msg);
            record.setCheckDevNode(this.checkDevNode);
            record.setStatus(RecordStatus.NORMAL);
            ui.getListMode().addElement(record);
        });
    }

    private void handleLastBatchException(List<CheckItem> checkItems, List<String> checkItemIds, Map<String, ItemProgressResult> totalProgressMap) {
        this.service.mergeBatchCheckItemFiles(checkItemIds);
        this.service.handleSourceInfo(totalProgressMap);
        checkItems.forEach(checkItem -> this.handleLastBatchFinish(totalProgressMap, (CheckItem)checkItem));
        this.updateProgress();
    }

    private void recordIpBatch(List<List<String>> selectNodeBatchs) {
        for (int i = 0; i < selectNodeBatchs.size(); ++i) {
            int batchNumber = i + 1;
            selectNodeBatchs.get(i).forEach(nodeIp -> this.ipBatchMap.put((String)nodeIp, batchNumber));
        }
    }

    private void handleStop(List<String> itemIds, Map<String, ItemProgressResult> totalProgressMap, List<CheckItem> checkItems) {
        log.info("stop batch inspect,total batch is {},current batch is {},not execute nodeIps is {}", new Object[]{this.totalBatch, this.currentBatch, this.notExecuteNodes});
        if (this.currentBatch > 1) {
            this.service.mergeBatchCheckItemFiles(itemIds);
            this.service.handleSourceInfo(totalProgressMap);
        }
        String abnormalInfo = this.createAbnormalNodesInfo();
        checkItems.forEach(checkItem -> this.updateItemStopStatus(totalProgressMap, (CheckItem)checkItem, abnormalInfo));
        this.setProgressToFinish();
        String stopMsg = ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.stop.msg", (Object[])new Object[]{this.currentBatch});
        this.uiObserver.update(this.checkDevNode, null, stopMsg, 0, Calendar.getInstance());
    }

    private void updateItemStopStatus(Map<String, ItemProgressResult> totalProgressMap, CheckItem checkItem, String abnormalInfo) {
        this.setResultStop(checkItem);
        ItemProgressResult progressResult = totalProgressMap.get(checkItem.getItemId());
        if (progressResult != null) {
            String sourceInfo = totalProgressMap.get(checkItem.getItemId()).getSourceInfo();
            checkItem.setSourceInfo(String.join((CharSequence)System.lineSeparator(), sourceInfo, abnormalInfo), this.checkDevNode);
            checkItem.setSourceInfoPath(progressResult.getSourceInfoPath());
        } else {
            checkItem.setSourceInfo(abnormalInfo, this.checkDevNode);
        }
        if (!checkItem.getName().startsWith("pre_inspect_")) {
            this.uiObserver.updateAndWait(this.checkDevNode, checkItem, 0, checkItem.getCheckResult().getStartTime(), RecordStatus.STOPPED);
        }
    }

    private void updateItemOvertimeStatus(Map<String, ItemProgressResult> totalProgressMap, CheckItem checkItem, String abnormalInfo) {
        this.setResultOvertime(checkItem);
        String sourceInfo = Optional.ofNullable(totalProgressMap.get(checkItem.getItemId())).map(ItemProgressResult::getSourceInfo).orElse("");
        checkItem.setSourceInfo(String.join((CharSequence)System.lineSeparator(), sourceInfo, abnormalInfo), this.checkDevNode);
        this.uiObserver.updateAndWait(this.checkDevNode, checkItem, 0, checkItem.getCheckResult().getStartTime(), RecordStatus.NORMAL);
    }

    private boolean pollingOneBatchInspect(String taskId, List<String> selectedItems, Map<String, ItemProgressResult> totalProgressMap, List<CheckItem> checkItems, String[] nodeIps) {
        String[] itemIds = selectedItems.toArray(new String[0]);
        long startTime = System.currentTimeMillis();
        Map<String, ItemProgressResult> lastItemResultMap = new HashMap<String, ItemProgressResult>();
        while (true) {
            Map<String, ItemProgressResult> itemProgressResultMap = this.service.query(taskId, itemIds, nodeIps);
            this.recordEndTime(itemProgressResultMap);
            this.service.downloadOneBatchResultFile(taskId, itemProgressResultMap);
            if (this.checkQueryOver(itemProgressResultMap)) {
                this.mergeOperate(selectedItems, totalProgressMap, itemProgressResultMap);
                this.handleEveryBatchFinishUI(checkItems, totalProgressMap, nodeIps);
                return true;
            }
            if (this.checkItemStatusChanged(checkItems, lastItemResultMap, itemProgressResultMap)) {
                startTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - startTime > (long)QUERY_TIMEOUT) {
                this.handleOneBatchOvertime(checkItems, selectedItems, totalProgressMap, nodeIps);
                this.isStop = true;
                return false;
            }
            lastItemResultMap = itemProgressResultMap;
            ComputerStorageUtils.sleepMilliseconds(5000);
        }
    }

    private void handleOneBatchOvertime(List<CheckItem> checkItems, List<String> selectedItems, Map<String, ItemProgressResult> totalProgressMap, String[] nodeIds) {
        log.error("current batch inspect over time, current batch number is {}, nodeId is {}", (Object)this.currentBatch, (Object)Arrays.toString(nodeIds));
        if (this.currentBatch > 1) {
            this.service.mergeBatchCheckItemFiles(selectedItems);
            this.service.handleSourceInfo(totalProgressMap);
        }
        String abnormalInfo = this.createAbnormalNodesInfo();
        checkItems.forEach(checkItem -> this.updateItemOvertimeStatus(totalProgressMap, (CheckItem)checkItem, abnormalInfo));
        this.setProgressToFinish();
        String overtimeMsg = ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.overtime.msg", (Object[])new Object[]{this.currentBatch});
        this.uiObserver.update(this.checkDevNode, null, overtimeMsg, 0, Calendar.getInstance());
    }

    private void setProgressToFinish() {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(this.checkDevNode);
        ui.setProgress(99);
        ui.updateProgress(100);
    }

    private void setResultOvertime(CheckItem checkItem) {
        checkItem.setErrorInfo(ResourceUtil.getString((String)"dsstorage.query.nochange"));
        ResultItem resultItem = checkItem.getCheckResult();
        resultItem.setProgress(100);
        resultItem.setFinished(true);
        resultItem.setNoCheck(true);
        resultItem.setStatus(RecordStatus.FAILED);
    }

    private void setResultStop(CheckItem checkItem) {
        checkItem.setErrorInfo(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.stopped"));
        if (checkItem.getCheckResult() == null) {
            checkItem.setCheckResult(new ResultItem());
        }
        ResultItem resultItem = checkItem.getCheckResult();
        resultItem.setProgress(100);
        resultItem.setFinished(true);
        resultItem.setStop(true);
        resultItem.setRecordStatus(RecordStatus.STOPPED);
    }

    private String createAbnormalNodesInfo() {
        String hasExceptionNodesInfo = this.createNodeInfo(this.hasExceptionNodes, ResourceUtil.getString((String)"dsstorage.batch.inspect.node.execute.exception.result.info"));
        String notExecuteNodesInfo = this.createNodeInfo(this.notExecuteNodes, ResourceUtil.getString((String)"dsstorage.batch.inspect.node.not.execute.result.info"));
        return String.join((CharSequence)System.lineSeparator(), hasExceptionNodesInfo, notExecuteNodesInfo);
    }

    private String createNodeInfo(Collection<String> nodeIps, String nodeResult) {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        String nodeTip = ResourceUtil.getString((String)"dsnode.name");
        nodeIps.forEach(nodeIp -> joiner.add(nodeTip + nodeIp + System.lineSeparator() + nodeResult));
        return joiner.toString();
    }

    private void mergeOperate(List<String> selectedItems, Map<String, ItemProgressResult> totalProgressMap, Map<String, ItemProgressResult> itemProgressResultMap) {
        this.mergeProgressMap(totalProgressMap, itemProgressResultMap);
        if (this.currentBatch == this.totalBatch) {
            this.service.mergeBatchCheckItemFiles(selectedItems);
            this.service.handleSourceInfo(totalProgressMap);
        }
    }

    private void firstBatchRefreshUI(List<CheckItem> checkItems) {
        if (checkItems.get(0).getCheckResult() != null) {
            return;
        }
        this.uiObserver.update(this.checkDevNode, null, ResourceUtil.getString((String)"finished.ds.storage.inspection"), 1, Calendar.getInstance());
        checkItems.forEach(this::initResultItem);
    }

    private void initAllBatchData(List<String> selectedItems, List<String> selectedNodes, int batchSize) {
        this.totalBatch = batchSize;
        this.itemStartTime = System.currentTimeMillis();
        this.errorCodes.clear();
        this.notExecuteNodes.clear();
        this.hasExceptionNodes.clear();
        this.notExecuteNodes.addAll(selectedNodes);
        String notStartStatus = ResourceUtil.getString((String)"dsstorage.batch.inspect.execute.status.not.start");
        selectedNodes.forEach(nodeIp -> this.ipStatusMap.put((String)nodeIp, notStartStatus));
        this.service.initAllBatchData(selectedNodes, this.totalBatch);
        log.info("batch inspect start, total batch number is:{}, selectNodes is:{}, the selectedItems is:{}", new Object[]{this.totalBatch, selectedNodes, selectedItems});
        this.uiObserver.update(this.checkDevNode, null, ResourceUtil.getString((String)"starting.ds.storage.inspection"), 1, Calendar.getInstance());
    }

    private void recordEndTime(Map<String, ItemProgressResult> itemProgressResultMap) {
        if (this.currentBatch != this.totalBatch) {
            return;
        }
        long endTime = System.currentTimeMillis();
        itemProgressResultMap.values().stream().filter(progressResult -> progressResult.isFinished() && !this.endTimeMap.containsKey(progressResult.getItemId())).forEach(progressResult -> this.endTimeMap.put(progressResult.getItemId(), endTime));
    }

    private void mergeProgressMap(Map<String, ItemProgressResult> totalProgressMap, Map<String, ItemProgressResult> currentProgressMap) {
        for (ItemProgressResult currentProgress : currentProgressMap.values()) {
            ItemProgressResult totalProgress = totalProgressMap.get(currentProgress.getItemId());
            if (Objects.isNull(totalProgress)) {
                totalProgressMap.put(currentProgress.getItemId(), currentProgress);
                continue;
            }
            this.mergeProgress(currentProgress, totalProgress);
        }
    }

    private void mergeProgress(ItemProgressResult currentProgress, ItemProgressResult totalProgress) {
        Map<String, Integer> totalIpMap = totalProgress.getIpToResultMap();
        Map<String, Integer> currentIpMap = currentProgress.getIpToResultMap();
        totalIpMap.putAll(currentIpMap);
        totalProgress.setErrorInfo(totalProgress.getErrorInfo() + currentProgress.getErrorInfo());
        if (totalProgress.getInspectStatus() == InspectStatus.EXECNOTPASS || currentProgress.getInspectStatus() == InspectStatus.EXECNOTPASS) {
            totalProgress.setInspectStatus(InspectStatus.EXECNOTPASS);
        }
    }

    boolean checkQueryOver(Map<String, ItemProgressResult> itemProgressResultMap) {
        return MapUtils.isNotEmpty(itemProgressResultMap) && itemProgressResultMap.values().stream().allMatch(ItemProgressResult::isFinished);
    }

    private void clearEnv() {
        if (InspectContext.getInstance().isHardwareInspect()) {
            return;
        }
        FileUtils.deleteAllInFolder((String)(ReportDataManager.DS_RESULT_PATH + File.separator + this.checkDevNode.getDevNode().getDeviceSerialNumber()));
    }

    private void clearTask(String taskId) {
        if (taskId == null) {
            return;
        }
        this.restImpl.deleteDStorageInspectTask(this.checkDevNode.getDevNode(), taskId);
    }

    private List<String> initCheckItemAndGetIds(List<CheckItem> checkItems) {
        return checkItems.stream().peek(checkItem -> checkItem.setCheckResult(null)).map(CheckItem::getItemId).collect(Collectors.toList());
    }

    private void pollingPreCheck2Finish(List<CheckItem> checkItems, String taskId, String[] nodeIds, String[] itemIds) throws InterruptedException {
        ItemProgressResult lastResult = new ItemProgressResult(taskId, 0);
        ItemProgressResult currentResult = new ItemProgressResult(taskId, 0);
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)QUERY_TIMEOUT) {
            Map<String, ItemProgressResult> itemProgressResultMap = this.service.query(taskId, itemIds, nodeIds);
            this.service.downloadOriginInfo(taskId, itemProgressResultMap);
            if (CollectionUtils.isEmpty(itemProgressResultMap.values())) {
                log.warn("No pre-inspection item exists....");
                return;
            }
            this.changeProgressResult(itemProgressResultMap, currentResult);
            this.updateItemProgress(currentResult, checkItems, itemProgressResultMap);
            if (this.checkQueryOver(checkItems)) {
                log.info("All check items finished, qury progress over...");
                return;
            }
            if (lastResult.compareTo(currentResult) != 0) {
                startTime = System.currentTimeMillis();
            }
            lastResult = currentResult;
            Thread.sleep(5000L);
        }
    }

    private void changeProgressResult(Map<String, ItemProgressResult> itemProgressResultMap, ItemProgressResult currentResult) {
        int finishedPreItem = (int)itemProgressResultMap.values().stream().filter(ItemProgressResult::isFinished).count();
        int allItemProcessResults = itemProgressResultMap.values().size();
        currentResult.setProgress(finishedPreItem * 100 / allItemProcessResults);
    }

    private void updateItemProgress(ItemProgressResult currentResult, List<CheckItem> checkItems, Map<String, ItemProgressResult> itemProgressResultMap) {
        UiUpdatePair updatePair = InspectContext.getInstance().getUiUpdatePair(this.checkDevNode);
        if (Objects.isNull(updatePair)) {
            return;
        }
        for (CheckItem checkItem : checkItems) {
            String itemId = checkItem.getItemId();
            ItemProgressResult itemProgressResult = itemProgressResultMap.get(itemId);
            if (!itemProgressResult.isFinished()) continue;
            ResultItem resultItem = new ResultItem();
            resultItem.setFinished(true);
            checkItem.setCheckResult(resultItem);
        }
        updatePair.updateProgress(Math.min(currentResult.getProgress(), 95));
    }

    private void pollingInspectResult2Finish(List<CheckItem> checkItems, String taskId, String[] itemIds, String[] nodeIds, boolean updateStatus) {
        Map<String, ItemProgressResult> lastItemResultMap = new HashMap<String, ItemProgressResult>();
        long startTime = System.currentTimeMillis();
        while (true) {
            Map<String, ItemProgressResult> itemProgressResultMap = this.service.query(taskId, itemIds, nodeIds);
            this.service.downloadOriginInfo(taskId, itemProgressResultMap);
            this.refreshCheckItemStatus(checkItems, itemProgressResultMap, updateStatus);
            if (this.checkQueryOver(checkItems)) {
                log.info("All check items finished, qury progress over...");
                break;
            }
            if (this.checkItemStatusChanged(checkItems, lastItemResultMap, itemProgressResultMap)) {
                startTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - startTime > (long)QUERY_TIMEOUT) {
                log.info("item status has not change for a long time, query progress over...");
                this.refreshCheckItemStatusWhenError(checkItems, updateStatus);
                break;
            }
            lastItemResultMap = itemProgressResultMap;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error("Caught interrupted exception", (Throwable)e);
            }
        }
    }

    private boolean checkQueryOver(List<CheckItem> checkItems) {
        for (CheckItem checkItem : checkItems) {
            ResultItem resultItem = checkItem.getCheckResult();
            if (resultItem != null && resultItem.isFinished()) continue;
            return false;
        }
        return true;
    }

    private boolean checkItemStatusChanged(List<CheckItem> checkItems, Map<String, ItemProgressResult> lastItemResultMap, Map<String, ItemProgressResult> curtItemResultMap) {
        for (CheckItem checkItem : checkItems) {
            ItemProgressResult lastResult = lastItemResultMap.get(checkItem.getItemId());
            ItemProgressResult currentResult = curtItemResultMap.get(checkItem.getItemId());
            if (lastResult == null || currentResult == null || lastResult.compareTo(currentResult) == 0) continue;
            log.debug("item status changed.");
            return true;
        }
        log.debug("item status not changed.");
        return false;
    }

    private void refreshCheckItemStatus(List<CheckItem> chkItems, Map<String, ItemProgressResult> itemProgressResultMap, boolean updateStatus) {
        int totalProgress = 0;
        HashMap<String, Integer> progressMap = new HashMap<String, Integer>();
        long endTime = System.currentTimeMillis();
        for (CheckItem ci : chkItems) {
            String itemId = ci.getItemId();
            ItemProgressResult ipr = itemProgressResultMap.get(itemId);
            if (ci.getName().contains("pre_inspect_")) {
                this.updateCheckItemResultAndUpdateUI(false, progressMap, endTime, ci, ipr);
            }
            this.updateCheckItemResultAndUpdateUI(updateStatus, progressMap, endTime, ci, ipr);
            if (ci.getCheckResult() == null || ci.getCheckResult().getProgress() <= 0) continue;
            totalProgress += ci.getCheckResult().getProgress();
        }
        if (updateStatus) {
            UiUpdatePair ui;
            List<CheckItem> selectedAllItems = InspectUtils.getAllCheckItem(this.checkDevNode);
            if ((totalProgress = (totalProgress = totalProgress / selectedAllItems.size() + 5) >= 100 ? 95 : totalProgress) > (ui = InspectContext.getInstance().getUiUpdatePair(this.checkDevNode)).getProgress()) {
                ui.setProgress(totalProgress);
            }
            ui.updateProgress(progressMap);
        }
    }

    private void handleEveryBatchFinishUI(List<CheckItem> checkItems, Map<String, ItemProgressResult> itemProgressResultMap, String[] nodeIps) {
        List items = checkItems.stream().map(CheckItem::getItemId).collect(Collectors.toList());
        log.info("current batch inspect finished, current batch number is {}, nodes is {}, items is {}", new Object[]{this.currentBatch, Arrays.toString(nodeIps), items});
        this.notExecuteNodes.removeAll(Arrays.asList(nodeIps));
        if (this.currentBatch == this.totalBatch) {
            checkItems.forEach(checkItem -> this.handleLastBatchFinish(itemProgressResultMap, (CheckItem)checkItem));
        }
        this.updateProgress();
        this.updateNodeStatus(nodeIps, ResourceUtil.getString((String)"dsstorage.batch.inspect.execute.status.finished"));
        this.updateNodeTabelStatus();
    }

    private void updateNodeStatus(String[] nodeIps, String status) {
        Arrays.stream(nodeIps).forEach(nodeIp -> this.ipStatusMap.put((String)nodeIp, status));
    }

    private void handleLastBatchFinish(Map<String, ItemProgressResult> itemProgressResultMap, CheckItem checkItem) {
        ResultItem resultItem;
        ItemProgressResult progressResult = itemProgressResultMap.get(checkItem.getItemId());
        if (checkItem.getCheckResult() == null) {
            resultItem = new ResultItem();
            resultItem.setStartTime(Calendar.getInstance());
            checkItem.setCheckResult(resultItem);
            progressResult = new ItemProgressResult(checkItem.getItemId(), 100);
            progressResult.setStatus(RecordStatus.NORMAL);
        }
        resultItem = checkItem.getCheckResult();
        this.setCheckItemInfoAndResult(checkItem, progressResult, resultItem);
        boolean isPreInspect = checkItem.getName().contains("pre_inspect_");
        if (!isPreInspect) {
            this.uiObserver.updateAndWait(this.checkDevNode, checkItem, 0, resultItem.getStartTime(), progressResult.getStatus());
        }
    }

    private void updateProgress() {
        UiUpdatePair ui;
        int progress = (this.totalBatch * (this.currentItemBatch - 1) + this.currentBatch) * 100 / (this.totalBatch * this.totalItemBatch);
        int totalProgress = Math.min(progress, 95);
        if (totalProgress > (ui = InspectContext.getInstance().getUiUpdatePair(this.checkDevNode)).getProgress()) {
            ui.setProgress(totalProgress);
        }
        ui.updateProgress(this.currentBatch * 100 / this.totalBatch);
    }

    private void updateNodeTabelStatus() {
        String batchRadioDesc = this.currentBatch + "/" + this.totalBatch;
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(this.checkDevNode);
        ui.updateNodeTabelStatus(batchRadioDesc, this.ipBatchMap, this.ipStatusMap);
    }

    private void updateCheckItemResultAndUpdateUI(boolean updateStatus, Map<String, Integer> progressMap, long endTime, CheckItem ci, ItemProgressResult ipr) {
        if (ipr != null) {
            ResultItem ri = ci.getCheckResult();
            if (ri == null) {
                ri = new ResultItem();
                ri.setStartTime(Calendar.getInstance());
                ci.setCheckResult(ri);
                if (updateStatus) {
                    this.uiObserver.update(this.checkDevNode, ci, ci.getName(), 0, ri.getStartTime(), RecordStatus.RUNNING);
                }
            }
            if (ipr.isFinished() && !ri.isFinished()) {
                ri.setFinished(true);
                ri.setTimeTake(endTime - this.itemStartTime);
                ci.setErrorInfo(ipr.getErrorInfo());
                ci.setSourceInfo(ipr.getSourceInfo(), this.checkDevNode);
                ci.setSourceInfoPath(ipr.getSourceInfoPath());
                this.syncItemResult(ipr, ri, ci);
                if (updateStatus) {
                    this.uiObserver.update(this.checkDevNode, ci, ci.getName(), 0, ri.getStartTime(), ipr.getStatus());
                }
            }
            if (!StringUtils.isNULLStr((String)ipr.getSourceInfo())) {
                ci.setErrorInfo(ipr.getErrorInfo());
                ci.setSourceInfo(ipr.getSourceInfo(), this.checkDevNode);
                ci.setSourceInfoPath(ipr.getSourceInfoPath());
                this.syncItemResult(ipr, ri, ci);
            }
            ri.setProgress(ipr.getProgress());
            progressMap.put(ci.getItemId(), ipr.getProgress());
        }
    }

    void initResultItem(CheckItem checkItem) {
        ResultItem resultItem = new ResultItem();
        resultItem.setStartTime(Calendar.getInstance());
        checkItem.setCheckResult(resultItem);
        if (!checkItem.getName().startsWith("pre_inspect_")) {
            this.uiObserver.updateAndWait(this.checkDevNode, checkItem, 0, resultItem.getStartTime(), RecordStatus.RUNNING);
        }
    }

    void setCheckItemInfoAndResult(CheckItem checkItem, ItemProgressResult progressResult, ResultItem resultItem) {
        resultItem.setFinished(true);
        resultItem.setTimeTake(this.endTimeMap.getOrDefault(progressResult.getItemId(), System.currentTimeMillis()) - this.itemStartTime);
        if (CollectionUtils.isNotEmpty(this.hasExceptionNodes)) {
            resultItem.setNoCheck(true);
            resultItem.setStatus(RecordStatus.FAILED);
            checkItem.setErrorInfo(this.createInspectExceptionMsg(this.errorCodes));
            this.setSourceInfo(checkItem, progressResult);
        } else {
            this.setTotalResult(resultItem, progressResult);
            checkItem.setErrorInfo(progressResult.getErrorInfo());
            this.setSourceInfo(checkItem, progressResult);
            this.syncItemResult(progressResult, resultItem, checkItem);
        }
    }

    private void setSourceInfo(CheckItem checkItem, ItemProgressResult progressResult) {
        checkItem.setSourceInfoPath(progressResult.getSourceInfoPath());
        checkItem.setSourceInfo(String.join((CharSequence)System.lineSeparator(), progressResult.getSourceInfo(), this.createAbnormalNodesInfo()), this.checkDevNode);
    }

    String createInspectExceptionMsg(Set<String> errorCodes) {
        String allErrorMsg = errorCodes.stream().map(errorCode -> ResourceUtil.getString((String)("dsstorage.batch.inspect.error.code." + errorCode))).filter(errorMsg -> !"--".equals(errorMsg)).collect(Collectors.joining(System.lineSeparator()));
        return StringUtils.isNULLStr((String)allErrorMsg) ? ResourceUtil.getString((String)"dsstorage.batch.inspect.has.node.start.fail.result.msg") : allErrorMsg;
    }

    private void setTotalResult(ResultItem resultItem, ItemProgressResult progressResult) {
        if (progressResult.isNotPass()) {
            resultItem.setNormal(false);
            return;
        }
        if (progressResult.isNotSupport()) {
            resultItem.setNoSupport(true);
            return;
        }
        if (progressResult.isManualConfirmation()) {
            resultItem.setManualConfirmation(true);
            return;
        }
        if (progressResult.isInspectWarning()) {
            resultItem.setWarning(true);
            return;
        }
        if (progressResult.isNormal()) {
            resultItem.setNormal(true);
        }
    }

    private void syncItemResult(ItemProgressResult ipr, ResultItem ri, CheckItem checkItem) {
        if (checkItem.getCheckScript() != null) {
            this.observer.executePyScript(ipr, checkItem, ri, this.checkDevNode);
            return;
        }
        if (this.associatedItemIds.contains(checkItem.getItemId())) {
            this.syncPreCheckItemResult(ipr, ri, checkItem);
            return;
        }
        if (this.afterCheckItemIds.contains(checkItem.getItemId())) {
            this.syncAfterCheckItemResult(ipr, ri, checkItem);
            return;
        }
        if (this.patchItems.contains(checkItem.getItemId())) {
            this.syncPatchItemResult(ipr, ri);
            checkItem.setErrorInfo(ipr.getErrorInfo());
            return;
        }
        if (ipr instanceof MetaVisionItemProgressResult) {
            MetaVisionItemProgressResult progressResult = (MetaVisionItemProgressResult)ipr;
            ri.setNormal(progressResult.isNormal());
            ri.setNoSupport(progressResult.isNotSupport());
            return;
        }
        ri.setNormal(ipr.isNormal());
    }

    private void syncAfterCheckItemResult(ItemProgressResult ipr, ResultItem ri, CheckItem checkItem) {
        if (this.isNormalInPreCheckAssociatedItem(ipr)) {
            ri.setNormal(true);
            ipr.setErrorInfo("");
            checkItem.setErrorInfo("");
        }
    }

    private void syncPatchItemResult(ItemProgressResult ipr, ResultItem ri) {
        ipr.setPatchItem(true);
        ipr.calInspectStatus(this.checkDevNode);
        if (ipr.isNotSupport()) {
            ri.setNoSupport(true);
            return;
        }
        if (ipr.isNotPass()) {
            ri.setNormal(false);
            return;
        }
        if (ipr.isManualConfirmation()) {
            ri.setManualConfirmation(true);
            return;
        }
        if (ipr.isInspectWarning()) {
            ri.setWarning(true);
            return;
        }
        ri.setNormal(ipr.isNormal());
    }

    private void syncPreCheckItemResult(ItemProgressResult ipr, ResultItem ri, CheckItem checkItem) {
        if (ipr.isNotSupport()) {
            ri.setNoSupport(true);
            ipr.setErrorInfo("");
            checkItem.setErrorInfo("");
            return;
        }
        if (this.isNormalInPreCheckAssociatedItem(ipr)) {
            ri.setNormal(true);
            ipr.setErrorInfo("");
            checkItem.setErrorInfo("");
            return;
        }
    }

    private boolean isNormalInPreCheckAssociatedItem(ItemProgressResult ipr) {
        return ipr.getIpToResultMap().values().stream().map(statusNum -> statusNum.toString()).allMatch(status -> "0".equals(status) || "3".equals(status));
    }

    private void refreshCheckItemStatusWhenError(List<CheckItem> checkItems, boolean updateStatus) {
        HashMap<String, Integer> progressMap = new HashMap<String, Integer>();
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(this.checkDevNode);
        for (CheckItem ci : checkItems) {
            ResultItem ri = ci.getCheckResult();
            this.updateCheckItemTimeoutResultAndUpdateUI(updateStatus, progressMap, ci, ri);
        }
        if (updateStatus) {
            ui.setProgress(99);
            ui.updateProgress(progressMap);
        }
    }

    private void updateCheckItemTimeoutResultAndUpdateUI(boolean updateStatus, Map<String, Integer> progressMap, CheckItem ci, ResultItem ri) {
        ResultItem item = ri;
        if (item == null) {
            item = new ResultItem();
            item.setStartTime(Calendar.getInstance());
            ci.setCheckResult(item);
        }
        if (!item.isFinished()) {
            item.setStatus(RecordStatus.FAILED);
            item.setProgress(100);
            item.setNoCheck(true);
            item.setFinished(true);
            ci.setErrorInfo(ResourceUtil.getString((String)"dsstorage.query.nochange"));
            progressMap.put(ci.getItemId(), 100);
            if (updateStatus) {
                this.uiObserver.update(this.checkDevNode, ci, ci.getName(), 0, item.getStartTime());
            }
        }
    }

    void resultStatistic(List<CheckItem> selectedItems) {
        this.rcCount.setAllCheckNumCount(this.rcCount.getAllCheckNumCount() + selectedItems.size());
        for (CheckItem checkItem : selectedItems) {
            ResultItem ri = checkItem.getCheckResult();
            if (ri.isNoCheck()) {
                this.rcCount.setNotCheckdCount(this.rcCount.getNotCheckdCount() + 1);
            }
            if (ri.isNoSupport()) {
                this.rcCount.setNotSupportCount(this.rcCount.getNotSupportCount() + 1);
            }
            if (ri.isWarning()) {
                this.rcCount.setWarningCount(this.rcCount.getWarningCount() + 1);
            }
            if (ri.isNotPass()) {
                this.rcCount.setNotPassedCount(this.rcCount.getNotPassedCount() + 1);
            }
            if (ri.isManualConfirmation()) {
                this.rcCount.setManualConfirmationCount(this.rcCount.getManualConfirmationCount() + 1);
            }
            if (!ri.isStop()) continue;
            this.rcCount.setStopCountAutoIncrement();
        }
    }

    public void inspectMetaVisionStorage(CheckDevNode checkDevNode) {
        DevNode devNode = checkDevNode.getDevNode();
        List<CheckItem> selectCheckItems = checkDevNode.getCheckItems().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).filter(CheckItem::isEnable).collect(Collectors.toList());
        this.itemStartTime = System.currentTimeMillis();
        String taskId = MetaVisionInspectService.startMetaVisionInspectTask(devNode, selectCheckItems);
        this.pollingMetaVisionInspectResult2Finish(taskId, checkDevNode, true, selectCheckItems);
        List<CheckItem> selectedItems = InspectUtils.getAllCheckItem(checkDevNode);
        this.resultStatistic(selectedItems);
        RestConnectionManager.releaseMetaVisionConnection((DevNode)devNode);
    }

    private void pollingMetaVisionInspectResult2Finish(String taskId, CheckDevNode checkDevNode, boolean updateStatus, List<CheckItem> selectCheckItems) {
        DevNode devNode = checkDevNode.getDevNode();
        Map<String, ItemProgressResult> lastItemResultMap = new HashMap<String, ItemProgressResult>();
        long startTime = System.currentTimeMillis();
        while (true) {
            Map<String, ItemProgressResult> metaVisionProgress = MetaVisionInspectService.getMetaVisionProgress(taskId, devNode);
            this.refreshCheckItemStatus(selectCheckItems, metaVisionProgress, updateStatus);
            if (this.checkQueryOver(selectCheckItems)) {
                FusionStorInspector.fillInspectResult(taskId, checkDevNode, devNode);
                log.info("All check items finished, qury progress over...");
                break;
            }
            if (this.checkItemStatusChanged(selectCheckItems, lastItemResultMap, metaVisionProgress)) {
                startTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - startTime > (long)QUERY_TIMEOUT) {
                log.info("item status has not change for a long time, query progress over...");
                this.refreshCheckItemStatusWhenError(selectCheckItems, updateStatus);
                break;
            }
            lastItemResultMap = metaVisionProgress;
            FusionStorInspector.sleep();
        }
    }

    private static void fillInspectResult(String taskId, CheckDevNode checkDevNode, DevNode devNode) {
        try {
            MetaVisionInspectTaskResult metaVisionInspectResult = MetaVisionInspectService.getMetaVisionInspectResult(devNode, taskId);
            MetaVisionInspectService.fillMetaVisionTaskRespForOneNode(checkDevNode, metaVisionInspectResult);
        }
        catch (ToolException e) {
            log.error("query inspect task result and fill error ,task id is {}", (Object)taskId, (Object)e);
        }
    }

    private static void sleep() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            log.error("Caught interrupted exception", (Throwable)e);
        }
    }
}

