/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstoragePreCheckConfig;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.fit.common.ExpansionNodesManager;
import com.huawei.ism.tool.inspect.logic.config.ArrayProductParser;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ExpansionTaskUtils;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ItemProgressResult;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.PreInspectHandler;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportDataManager;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.service.deploy.conf.VersionMappingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class FusionStorInspectorTaskObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FusionStorInspectorTaskObserver.class);
    private static final String PYTHON_ENV = "py_java_env";
    private static final String VERSION_MAPPING_FILE_PATH = ArrayProductParser.DSTORAGE_EXPANSION_PATH;
    private static final VersionMappingStrategy VERSION_MAPPING_STRATEGY = new VersionMappingStrategy(VERSION_MAPPING_FILE_PATH);
    private final Map<String, Object> env = new HashMap<String, Object>();
    private JythonExecuter jythonExecuter;

    private void initEnv(ItemProgressResult ipr, CheckDevNode checkDevNode) {
        String baseScriptPath = FilesUtil.getCanonicalPath((File)checkDevNode.getScriptDir().getParentFile().getParentFile());
        ArrayList<File> pyClassPaths = new ArrayList<File>();
        String pyFramePth = baseScriptPath + File.separator + "pyframe";
        pyClassPaths.add(new File(pyFramePth));
        pyClassPaths.add(new File(ExpansionTaskUtils.PY_SCRIPTS_DIR));
        this.jythonExecuter = new JythonExecuter(pyClassPaths);
        String preResPath = InspectContext.getInstance().getDstorageTmpPath() + File.separator + checkDevNode.getDevNode().getDeviceSerialNumber() + File.separator;
        this.env.put("preResPath", preResPath);
        this.env.put("lang", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        this.env.put("devInfo", checkDevNode.getDevNode());
        this.env.put("newExpansionNodes", this.getDevNodeList(checkDevNode));
        this.env.put("progressObserver", InspectContext.getInstance().getUiUpdatePair(checkDevNode));
        this.env.put("logger", log);
        this.env.put("result_path", ReportDataManager.DS_RESULT_PATH + File.separator + checkDevNode.getDevNodeSafe().getDeviceSerialNumber());
        this.env.put("temp_path", InspectContext.getInstance().getDstorageTmpPath() + File.separator + checkDevNode.getDevNodeSafe().getDeviceSerialNumber());
        this.env.put("mappingStrategy", VERSION_MAPPING_STRATEGY);
        this.env.put("hot_patch_file", InspectContext.HOT_PATCH_FILE);
        this.env.put("preInspectHandle", new PreInspectHandler(checkDevNode.getDevNode(), DstoragePreCheckConfig.INS.findMatchConfigs(checkDevNode.getDevNode())));
        this.env.put("inspect_context", (Object)InspectContext.getInstance());
        this.env.put("scsi_driver_timeout", checkDevNode.getScsiTimeOut());
        this.env.put("switch_resource", checkDevNode.getSwitchResource());
        if (Objects.nonNull(checkDevNode.getSwitchResource())) {
            this.env.put("switch_bundle", checkDevNode.getSwitchResource());
        }
        this.env.put("compression_ratio", checkDevNode.getCompressionRatio());
        this.env.put("version", checkDevNode.getTargetVersion().toUpperCase(Locale.ENGLISH));
        this.env.put("sourceInfo", ipr.getSourceInfo());
        this.jythonExecuter.set(PYTHON_ENV, this.env);
    }

    public void executePyScript(ItemProgressResult ipr, CheckItem item, ResultItem result, CheckDevNode checkDevNode) {
        String fileName = item.getCheckScript();
        File pythonScFile = new File(ExpansionTaskUtils.PY_SCRIPTS_DIR, fileName);
        if (!pythonScFile.exists()) {
            result.setNormal(false);
            item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.filenotfound"));
            return;
        }
        try {
            this.initEnv(ipr, checkDevNode);
            this.jythonExecuter.compileScript(pythonScFile);
            List retList = this.jythonExecuter.invokeFunction("execute", new Object[]{item});
            item.setErrorInfo(retList.get(2).toString());
            String resultFlag = retList.get(0).toString();
            FusionStorInspectorTaskObserver.updateInspectResult(item, result, resultFlag);
            String cmdResult = retList.get(1).toString();
            item.setSourceInfo(cmdResult, checkDevNode);
        }
        catch (Throwable et) {
            log.error("The pre-upgrade result check script fails to be executed.", et);
            result.setNormal(false);
            item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.checkfail"));
        }
    }

    private static void updateInspectResult(CheckItem item, ResultItem result, String flag) {
        if ("0".equals(flag)) {
            result.setNormal(true);
        } else if ("1".equals(flag)) {
            result.setNormal(false);
        } else if ("2".equals(flag)) {
            result.setNoCheck(true);
        } else if ("3".equals(flag)) {
            result.setNoSupport(true);
        } else if ("4".equals(flag)) {
            result.setWarning(true);
        } else {
            item.setErrorInfo(ResourceUtil.getString((String)"dstorage.expansiontask.error.checkfail"));
            result.setNormal(false);
        }
    }

    private List<DevNode> getDevNodeList(CheckDevNode checkDevNode) {
        if (InspectUtils.isStartedByYingLong()) {
            return ExpansionNodesManager.getInstance().getNewAddNode().entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(checkDevNode.getDevNode().getDevKey())).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
        }
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(node -> ItDeviceType.FUIONSTOR_EXP_NEW_NODE.equals((Object)node.getItDeviceType())).collect(Collectors.toList());
    }

    @Generated
    public FusionStorInspectorTaskObserver() {
    }
}

