/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportDataManager;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportNode;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemProgressResult
implements Comparable<ItemProgressResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemProgressResult.class);
    private static final int ORIGIN_INFO_MAX_LINE = Integer.parseInt(ResourceBundle.getBundle("config.inspect").getString("origin.info.max.num"));
    private static final int NODE_ORIGIN_INFO_MAX_LINE = Integer.parseInt(ResourceBundle.getBundle("config.inspect").getString("node.info.max.num"));
    private static final String ITEM_ROOT_DIR = "data" + File.separator + "dsnodes";
    private static final String ITEM_RECORD_DIR = "data" + File.separator + "dsrecord";
    private static final int ITEM_PASS_STATUS = 0;
    public static final String NEWLINE = System.lineSeparator();
    String itemId;
    int progress;
    RecordStatus status = RecordStatus.RUNNING;
    InspectStatus inspectStatus = InspectStatus.WAITING;
    Map<String, Integer> ipToResultMap;
    String resultPath = "";
    String errorInfo = "";
    String sourceInfo = "";
    private String COMPUTE_ROLE = "compute";
    private String STORAGE_ROLE = "storage";
    private String MANAGEMENT_ROLE = "management";
    private boolean clusterItem = false;
    private boolean isPatchItem = false;
    private CheckDevNode checkDevNode;
    private long endTime;
    private String sourceInfoPath;

    public String getSourceInfoPath() {
        return this.sourceInfoPath;
    }

    public void setSourceInfoPath(String sourceInfoPath) {
        this.sourceInfoPath = sourceInfoPath;
    }

    public ItemProgressResult(String itemId, int progress) {
        this.itemId = itemId;
        this.progress = progress;
        if (this.progress > 0 && this.progress < 100) {
            this.inspectStatus = InspectStatus.EXECUTING;
        }
    }

    public boolean isNotSupport() {
        return this.ipToResultMap.values().stream().allMatch(statusNum -> "3".equals(String.valueOf(statusNum)));
    }

    public boolean isManualConfirmation() {
        return this.ipToResultMap.values().stream().anyMatch(statusNum -> "5".equals(String.valueOf(statusNum)));
    }

    public boolean isInspectWarning() {
        return this.ipToResultMap.values().stream().anyMatch(statusNum -> "4".equals(String.valueOf(statusNum)));
    }

    public boolean isNotPass() {
        return this.ipToResultMap.values().stream().anyMatch(statusNum -> "1".equals(String.valueOf(statusNum)));
    }

    public boolean isNormal() {
        return this.inspectStatus == InspectStatus.EXECPASS;
    }

    public void setClusterItem(boolean isCulster) {
        this.clusterItem = isCulster;
    }

    public void calInspectStatus(CheckDevNode checkDevNode) {
        this.checkDevNode = checkDevNode;
        Map<String, LinkedList<String>> allNodes = this.getPassAndNopassNodesMap();
        List nopassNodes = allNodes.get("nopassNodes");
        List passNodes = allNodes.get("passNodes");
        StringBuffer errInfo = new StringBuffer();
        if (!nopassNodes.isEmpty()) {
            HashMap<String, StringBuffer> classifiedMap = new HashMap<String, StringBuffer>();
            classifiedMap.put("managementNodes", new StringBuffer());
            classifiedMap.put("computeNodes", new StringBuffer());
            classifiedMap.put("storageNodes", new StringBuffer());
            classifiedMap.put("managementAndComputeNodes", new StringBuffer());
            classifiedMap.put("managementAndStorageNodes", new StringBuffer());
            classifiedMap.put("computeAndStorageNodes", new StringBuffer());
            classifiedMap.put("managementAndComputeAndStorageNodes", new StringBuffer());
            this.classifyNopassNodes(checkDevNode, nopassNodes, classifiedMap);
            errInfo.append(ResourceUtil.getString((String)"dsnode.nopass.title"));
            this.generateErrInfo(errInfo, classifiedMap);
        }
        this.inspectStatus = nopassNodes.isEmpty() && !passNodes.isEmpty() ? InspectStatus.EXECPASS : InspectStatus.EXECNOTPASS;
        this.errorInfo = errInfo.toString();
    }

    private void generateErrInfo(StringBuffer errInfo, Map<String, StringBuffer> classifiedMap) {
        for (String key : classifiedMap.keySet()) {
            StringBuffer nodes = classifiedMap.get(key);
            if (nodes.length() == 0) continue;
            classifiedMap.get(key).deleteCharAt(classifiedMap.get(key).length() - 1);
            errInfo.append(ResourceUtil.getString((String)("dsnode.nopass." + key))).append(classifiedMap.get(key));
        }
    }

    private void classifyNopassNodes(CheckDevNode checkDevNode, List<String> nopassNodes, Map<String, StringBuffer> classifiedMap) {
        for (String nopassNode : nopassNodes) {
            this.classifyNopassNodes(checkDevNode, classifiedMap, nopassNode);
        }
    }

    private void classifyNopassNodes(CheckDevNode checkDevNode, Map<String, StringBuffer> classifiedMap, String nopassNode) {
        for (ClusterNode clusterNode : checkDevNode.getDevNode().getClusterNodes()) {
            String ip = clusterNode.getManagementIp();
            Set roles = clusterNode.getRoles();
            if (!ip.equals(nopassNode) || roles.size() == 0) continue;
            if (roles.size() >= 3) {
                classifiedMap.get("managementAndComputeAndStorageNodes").append(nopassNode).append(",");
                break;
            }
            String rolesStr = roles.toString();
            if (roles.size() == 2) {
                if (rolesStr.contains(this.MANAGEMENT_ROLE) && rolesStr.contains(this.COMPUTE_ROLE)) {
                    classifiedMap.get("managementAndComputeNodes").append(nopassNode).append(",");
                    break;
                }
                if (rolesStr.contains(this.MANAGEMENT_ROLE) && rolesStr.contains(this.STORAGE_ROLE)) {
                    classifiedMap.get("managementAndStorageNodes").append(nopassNode).append(",");
                    break;
                }
                if (rolesStr.contains(this.STORAGE_ROLE) && rolesStr.contains(this.COMPUTE_ROLE)) {
                    classifiedMap.get("computeAndStorageNodes").append(nopassNode).append(",");
                    break;
                }
            }
            if (rolesStr.contains(this.MANAGEMENT_ROLE)) {
                classifiedMap.get("managementNodes").append(nopassNode).append(",");
                break;
            }
            if (rolesStr.contains(this.COMPUTE_ROLE)) {
                classifiedMap.get("computeNodes").append(nopassNode).append(",");
                break;
            }
            if (!rolesStr.contains(this.STORAGE_ROLE)) continue;
            classifiedMap.get("storageNodes").append(nopassNode).append(",");
            break;
        }
    }

    private Map<String, LinkedList<String>> getPassAndNopassNodesMap() {
        Iterator<Map.Entry<String, Integer>> ipToErrCodeItr = this.ipToResultMap.entrySet().iterator();
        LinkedList<String> passNodes = new LinkedList<String>();
        LinkedList<String> nopassNodes = new LinkedList<String>();
        HashMap<String, LinkedList<String>> allNodes = new HashMap<String, LinkedList<String>>();
        while (ipToErrCodeItr.hasNext()) {
            Map.Entry<String, Integer> ipToErrorCodeEntry = ipToErrCodeItr.next();
            int statusNum = ipToErrorCodeEntry.getValue();
            if (statusNum == 0) {
                passNodes.add(ipToErrorCodeEntry.getKey());
                continue;
            }
            if ("3".equals(String.valueOf(statusNum))) {
                passNodes.add(ipToErrorCodeEntry.getKey());
                continue;
            }
            if (this.isPatchItem && "5".equals(String.valueOf(statusNum))) {
                passNodes.add(ipToErrorCodeEntry.getKey());
                continue;
            }
            nopassNodes.add(ipToErrorCodeEntry.getKey());
        }
        if (this.checkDevNode != null) {
            List<String> managementNodeIps = this.checkDevNode.getDevNode().getClusterNodes().stream().filter(clusterNode -> clusterNode.getRoles().contains(this.MANAGEMENT_ROLE) && clusterNode.isSelected()).map(clusterNode -> clusterNode.getManagementIp()).collect(Collectors.toList());
            this.sortNodesWithManagementFirst(passNodes, managementNodeIps);
            this.sortNodesWithManagementFirst(nopassNodes, managementNodeIps);
        } else {
            LOGGER.info("checkDevNode is null,management ip is not first in nodeIps.");
        }
        allNodes.put("passNodes", passNodes);
        allNodes.put("nopassNodes", nopassNodes);
        return allNodes;
    }

    private void sortNodesWithManagementFirst(LinkedList<String> nodeIps, List<String> managementNodeIps) {
        managementNodeIps.forEach(managementNodeIp -> {
            if (nodeIps.contains(managementNodeIp)) {
                nodeIps.remove(managementNodeIp);
                nodeIps.addFirst((String)managementNodeIp);
            }
        });
    }

    private List<ReportNode> generateSourceInfo(String checkItemId) {
        ArrayList<ReportNode> reportNodes = new ArrayList<ReportNode>();
        String path = this.resultPath + ".zip";
        try (ZipFile zf = new ZipFile(path);){
            this.readSourceInfo(reportNodes, zf, checkItemId);
        }
        catch (IOException e) {
            LOGGER.error("zip path not exist", (Throwable)e);
        }
        return reportNodes;
    }

    private void readSourceInfo(List<ReportNode> reportNodes, ZipFile zf, String checkItemId) throws IOException {
        int count = 0;
        Map<String, LinkedList<String>> nodes = this.getPassAndNopassNodesMap();
        List nodesIpWithNopass = nodes.get("nopassNodes");
        List nodesIpWithPass = nodes.get("passNodes");
        nodesIpWithNopass.addAll(nodesIpWithPass);
        for (String nodeInfo : nodesIpWithNopass) {
            StringBuffer sb = new StringBuffer();
            String nodeIp = nodeInfo.replace('_', ':');
            ZipEntry ze = this.getZipEntry(zf, checkItemId, nodeIp);
            ReportNode reportNode = new ReportNode(nodeIp, this.ipToResultMap.get(nodeIp));
            if (this.clusterItem && reportNode.getStatus() == 0) continue;
            reportNodes.add(reportNode);
            if (ze == null) {
                sb.append("No available information.");
                sb.append(NEWLINE);
                ++count;
                reportNode.setSourceInfo(sb.toString());
                continue;
            }
            StringBuffer infoAll = new StringBuffer();
            BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                count = this.readFileContent(count, sb, infoAll, br, reportNode);
                reportNode.setSourceInfo(sb.toString());
                reportNode.setSourceInfoAll(infoAll.toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (br == null) continue;
                if (throwable != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                br.close();
            }
        }
    }

    private ZipEntry getZipEntry(ZipFile zipFile, String checkItemId, String nodeIp) {
        String originalInfoPathPrefix = checkItemId + "/" + nodeIp + "/";
        ArrayList<String> originalInfoPaths = new ArrayList<String>();
        originalInfoPaths.add(originalInfoPathPrefix + checkItemId + ".sh.rst");
        originalInfoPaths.add(originalInfoPathPrefix + "inspect_" + checkItemId + ".sh.rst");
        originalInfoPaths.add(originalInfoPathPrefix + checkItemId + ".py.rst");
        for (String originalInfoPath : originalInfoPaths) {
            ZipEntry zipEntry = zipFile.getEntry(originalInfoPath);
            if (zipEntry == null) continue;
            return zipEntry;
        }
        Map<String, String> specificCheckItems = FusionStorageConfig.getSpecificCheckItems();
        if (specificCheckItems.containsKey(checkItemId)) {
            return zipFile.getEntry(originalInfoPathPrefix + specificCheckItems.get(checkItemId));
        }
        return null;
    }

    private int readFileContent(int count, StringBuffer sb, StringBuffer infoAll, BufferedReader br, ReportNode reportNode) {
        int nodeLineCount = 0;
        int totalCount = count;
        String line = "";
        try {
            while ((line = br.readLine()) != null) {
                if (reportNode.isLimitShowInfo()) {
                    sb.append(line);
                    sb.append(NEWLINE);
                    infoAll.append(line);
                    infoAll.append(NEWLINE);
                    ++totalCount;
                    ++nodeLineCount;
                } else {
                    infoAll.append(line);
                    infoAll.append(NEWLINE);
                }
                if (!this.isLimitInfoStatusChange(reportNode, nodeLineCount, totalCount)) continue;
                reportNode.setLimitShowInfo(false);
                sb.append(ResourceUtil.getString((String)"dsnode.sourceinfo.remind"));
                sb.append(NEWLINE);
            }
        }
        catch (IOException e) {
            LOGGER.error("read file error", (Throwable)e);
        }
        return totalCount;
    }

    private boolean isLimitInfoStatusChange(ReportNode reportNode, int nodeLineCount, int totalCount) {
        return (totalCount > ORIGIN_INFO_MAX_LINE || nodeLineCount >= NODE_ORIGIN_INFO_MAX_LINE) && reportNode.isLimitShowInfo();
    }

    public boolean isExecuting() {
        return this.progress > 0 && this.progress < 100;
    }

    public boolean isFinished() {
        return this.progress == 100;
    }

    public boolean notStarted() {
        return this.progress == 0;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public String getErrorInfo() {
        if (this.clusterItem) {
            this.errorInfo = "";
        }
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(String sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public void setResultPath(String resultDir, String checkItemId) {
        this.resultPath = resultDir + File.separator + checkItemId;
        List<ReportNode> reportNodes = this.generateSourceInfo(checkItemId);
        if (this.clusterItem) {
            this.sourceInfo = this.getClusterItemResult(reportNodes);
            return;
        }
        this.sourceInfo = this.getItemResult(reportNodes, resultDir);
    }

    private String getItemResult(List<ReportNode> reportNodes, String resultDir) {
        StringBuffer sb = new StringBuffer();
        int maxNum = FusionStorageConfig.getReportMaxShowNode();
        int showNum = Integer.min(reportNodes.size(), maxNum);
        for (int i = 0; i < showNum; ++i) {
            ReportNode reportNode = reportNodes.get(i);
            sb.append(ResourceUtil.getString((String)"dsnode.name")).append(reportNode.getNodeId()).append(NEWLINE);
            sb.append(reportNode.getSourceInfo());
        }
        if (this.ipToResultMap.size() > maxNum) {
            this.sourceInfoPath = String.join((CharSequence)File.separator, ITEM_RECORD_DIR, this.checkDevNode.getDevNode().getDeviceSerialNumber(), this.itemId.concat(".txt"));
            sb.append(NEWLINE);
            sb.append(ResourceUtil.getStringWithParams((String)"dsnode.sourceinfo.maxnode.remind", (Object[])new Object[]{showNum}));
            this.dumpWriteItemResult(reportNodes);
            return sb.toString();
        }
        if (reportNodes.stream().anyMatch(node -> !node.isLimitShowInfo())) {
            this.sourceInfoPath = String.join((CharSequence)File.separator, ITEM_RECORD_DIR, this.checkDevNode.getDevNode().getDeviceSerialNumber(), this.itemId.concat(".txt"));
            this.dumpWriteItemResult(reportNodes);
        }
        return sb.toString();
    }

    private void dumpWriteItemResult(List<ReportNode> reportNodes) {
        if (!Objects.isNull(this.checkDevNode.getDevNode()) && !this.checkDevNode.getDevNode().isDsStorage()) {
            LOGGER.warn("Device {} is not a distributed device. The original information is not dumped.", (Object)this.checkDevNode.getDevNode().getIp());
            return;
        }
        LOGGER.info("Start to dump the inspection item[{}] result.", (Object)this.itemId);
        String tempTxtDirPath = String.join((CharSequence)File.separator, ReportDataManager.DS_BUREAU_CHECK_RESULT_PATH, this.checkDevNode.getDevNode().getDeviceSerialNumber());
        String tmpTxtPath = String.join((CharSequence)File.separator, tempTxtDirPath, this.itemId.concat(".txt"));
        if (!FileAssistant.createFile(new File(tmpTxtPath))) {
            LOGGER.warn("ceart inspection item[{}] tmp txt file failed", (Object)this.itemId);
            return;
        }
        boolean isWriteSuccess = this.writeItemInfoLocal(reportNodes, tmpTxtPath);
        LOGGER.info("dump the inspection item[{}] {}", (Object)this.itemId, (Object)(isWriteSuccess ? "success" : "failed"));
    }

    /*
     * Exception decompiling
     */
    private boolean writeItemInfoLocal(List<ReportNode> reportNodes, String tmpFilePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getClusterItemResult(List<ReportNode> reportNodes) {
        if (reportNodes.isEmpty() && this.inspectStatus == InspectStatus.EXECPASS) {
            return ResourceUtil.getString((String)"dstorage.inspect.result.normal");
        }
        StringBuilder sb = new StringBuilder();
        for (ReportNode node : reportNodes) {
            sb.append(node.getSourceInfo());
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    public RecordStatus getStatus() {
        return this.status;
    }

    public void setStatus(RecordStatus status) {
        this.status = status;
    }

    public Map<String, Integer> getIpToResultMap() {
        return this.ipToResultMap;
    }

    public void setIpToResultMap(Map<String, Integer> ipToResultMap, CheckDevNode checkDevNode) {
        this.ipToResultMap = ipToResultMap;
        this.calInspectStatus(checkDevNode);
        this.setStatus(RecordStatus.NORMAL);
    }

    public InspectStatus getInspectStatus() {
        return this.inspectStatus;
    }

    public void setInspectStatus(InspectStatus inspectStatus) {
        this.inspectStatus = inspectStatus;
    }

    @Override
    public int compareTo(ItemProgressResult result) {
        if (this.progress != result.getProgress() || this.status != result.getStatus()) {
            return 1;
        }
        if (result.getIpToResultMap() != null && this.ipToResultMap != null) {
            Set<Map.Entry<String, Integer>> entrySet = result.getIpToResultMap().entrySet();
            for (Map.Entry<String, Integer> entry : entrySet) {
                String key = entry.getKey();
                if (this.ipToResultMap.get(key).equals(entry.getValue())) continue;
                return 1;
            }
        }
        return 0;
    }

    public void setPatchItem(boolean patchItem) {
        this.isPatchItem = patchItem;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }
}

