/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.SHA256Check;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Config;
import com.huawei.ism.tool.inspect.logic.config.ArrayProductParser;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportDataManager;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class PatchAutoBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchAutoBuilder.class);
    private static final String COLLECT_START_FLAG = "collectResultStart";
    private static final String COLLECT_END_FLAG = "collectResultEnd";
    private static final String RESULT_PATCH_NAME = "inspect_patch_preCheck";
    private static final String RESULT_REMOVE_PATCH_NAME = "inspect_patch_auto_remove";
    private static final String BASIC_REMOVE_YAML = "inspect_patch_remove.yaml";
    private static final String BASIC_PATCH_YAML = "inspect_patch.yaml";
    private static final String YAML_PRODUCT_NAME = "product_name";
    private static final String YAML_PRODUCT_VERSION = "product_version";
    private static final String YAML_ITEM_KEY = "item";
    private static final String YAML_TYPE_KEY = "type";
    private static final String YAML_ITEM_OP_REMOVE = "remove";
    private static final String TAR_GZ_SUB_FIX = ".tar.gz";
    private static final String KEY_SPLIT = ":";
    private static final String LINE_SPLIT = "\n";
    private String collectResultPath;
    private String resultShellPath;
    private String resultPatchDir;
    private String preCheckResultTempPath;
    private String patchPath;
    private DevNode devNode;
    private Config config;
    private List<CheckItem> localItems;

    public PatchAutoBuilder(CheckDevNode checkNode, Config conf, List<CheckItem> localItems) {
        this.devNode = checkNode.getDevNode();
        this.localItems = localItems;
        this.config = conf;
        this.initPath();
    }

    private void initPath() {
        this.collectResultPath = InspectContext.getInstance().getDstorageTmpPath() + File.separator + this.devNode.getDeviceSerialNumber() + File.separator + this.config.getPreItemID();
        this.resultPatchDir = ReportDataManager.DS_RESULT_PATH + File.separator + this.devNode.getDeviceSerialNumber() + File.separator + "preCheckResultPatch";
        this.preCheckResultTempPath = this.resultPatchDir + File.separator + "temp";
        this.resultShellPath = this.preCheckResultTempPath + File.separator + "inspect" + File.separator + "FusionStorage_base" + File.separator + this.config.getResultItemId() + ".sh";
        this.patchPath = this.resultPatchDir + File.separator + RESULT_PATCH_NAME + TAR_GZ_SUB_FIX;
    }

    public Optional<DstoragePatchInfo> buildResultPatch() {
        List<String> rstFileList = this.initRstFile(this.devNode);
        if (rstFileList.isEmpty()) {
            LOGGER.warn("Can not find preCheck result.");
            return Optional.empty();
        }
        if (!this.mergeFile(rstFileList)) {
            LOGGER.warn("Merge rst result failed.");
            return Optional.empty();
        }
        if (!this.makeYaml()) {
            LOGGER.warn("Make patch yaml result failed.");
            return Optional.empty();
        }
        if (!this.makePatchFile()) {
            LOGGER.warn("Make preCheck patch failed.");
            return Optional.empty();
        }
        DstoragePatchInfo patch = new DstoragePatchInfo();
        patch.setType(DstoragePatchInfo.Type.INSPECT);
        patch.setPatchPath(this.patchPath);
        return Optional.of(patch);
    }

    public static DstoragePatchInfo autoBuildRemovePatch(DevNode devNode, Set<String> itemList) {
        String rootPath = InspectUtils.getItemDumpTempPath() + File.separator + devNode.getIp().replaceAll(KEY_SPLIT, "_");
        File root = new File(rootPath);
        if (root.exists()) {
            FileUtils.deleteAllInFolder((String)rootPath);
        }
        root.mkdirs();
        String baseYaml = ArrayProductParser.DSTORAGE_EXPANSION_PATH + File.separator + BASIC_REMOVE_YAML;
        if (!PatchAutoBuilder.createRemoveYaml(devNode, itemList, baseYaml, rootPath + File.separator)) {
            return null;
        }
        String firstTgzName = "inspect_patch";
        if (!FileAssistant.compress2TGZ(rootPath, firstTgzName, new String[]{rootPath + File.separator + BASIC_PATCH_YAML})) {
            return null;
        }
        String sha256Path = PatchAutoBuilder.createSha256File(rootPath);
        if (!FileAssistant.compress2TGZ(rootPath, RESULT_REMOVE_PATCH_NAME, new String[]{rootPath + File.separator + firstTgzName + TAR_GZ_SUB_FIX, sha256Path})) {
            return null;
        }
        DstoragePatchInfo patch = new DstoragePatchInfo();
        patch.setType(DstoragePatchInfo.Type.INSPECT);
        patch.setPatchPath(rootPath + File.separator + RESULT_REMOVE_PATCH_NAME + TAR_GZ_SUB_FIX);
        return patch;
    }

    private static boolean createRemoveYaml(DevNode devNode, Set<String> removeItems, String baseYamlPath, String resultPath) {
        try (FileInputStream fis = new FileInputStream(baseYamlPath);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(resultPath, BASIC_PATCH_YAML)), "UTF-8");){
            Yaml yamlConfig = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            Map configMap = (Map)yamlConfig.load((InputStream)fis);
            List patchInfoMap = (List)configMap.get("patch_info");
            patchInfoMap.clear();
            removeItems.stream().forEach(item -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(YAML_ITEM_KEY, (String)item);
                map.put(YAML_TYPE_KEY, YAML_ITEM_OP_REMOVE);
                patchInfoMap.add(map);
            });
            configMap.put(YAML_PRODUCT_NAME, devNode.getProductModel());
            configMap.put(YAML_PRODUCT_VERSION, devNode.getProductVersion());
            yamlConfig.dump((Object)configMap, (Writer)writer);
        }
        catch (Exception e) {
            LOGGER.error("Build remove yaml error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean makePatchFile() {
        String firstTgzName = "inspect_patch";
        if (!FileAssistant.compress2TGZ(this.resultPatchDir, firstTgzName, new String[]{this.preCheckResultTempPath + File.separator + "inspect", this.preCheckResultTempPath + File.separator + "**\\**", this.preCheckResultTempPath + File.separator + BASIC_PATCH_YAML})) {
            return false;
        }
        String sha256Path = PatchAutoBuilder.createSha256File(this.resultPatchDir);
        return FileAssistant.compress2TGZ(this.resultPatchDir, RESULT_PATCH_NAME, new String[]{this.resultPatchDir + File.separator + firstTgzName + TAR_GZ_SUB_FIX, sha256Path});
    }

    private List<String> initRstFile(DevNode node) {
        return node.getClusterNodes().stream().map(this::clusterNodeRstPath).filter(path -> new File((String)path).exists()).collect(Collectors.toList());
    }

    private String clusterNodeRstPath(ClusterNode clusterNode) {
        return this.collectResultPath + File.separator + clusterNode.getManagementIp().replaceAll(KEY_SPLIT, "_") + File.separator + this.config.getPreItemID() + ".sh.rst";
    }

    private boolean mergeFile(List<String> rstFileList) {
        ConcurrentHashMap<String, StringBuffer> itemResultInfo = new ConcurrentHashMap<String, StringBuffer>();
        rstFileList.forEach(rstFile -> this.loadItemInfo((String)rstFile, (Map<String, StringBuffer>)itemResultInfo));
        if (itemResultInfo.isEmpty()) {
            return false;
        }
        return this.dumpItemResultInfo(itemResultInfo);
    }

    private boolean isLocalItem(String itemId) {
        for (CheckItem item : this.localItems) {
            if (!itemId.equals(item.getItemId())) continue;
            return true;
        }
        return false;
    }

    private boolean dumpItemResultInfo(Map<String, StringBuffer> itemResultInfo) {
        File resultFile = new File(this.resultShellPath);
        File parentDir = resultFile.getParentFile();
        if (!parentDir.exists()) {
            LOGGER.info("Create parent dir result : {}", (Object)parentDir.mkdirs());
        }
        if (resultFile.exists()) {
            LOGGER.info("Delete file {} result : {}", (Object)this.resultShellPath, (Object)resultFile.delete());
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(resultFile, true));){
            for (String itemId : itemResultInfo.keySet()) {
                if (!this.isLocalItem(itemId)) {
                    this.dumpOneItemInfo(bw, itemId, itemResultInfo.get(itemId).toString());
                }
                itemResultInfo.put(itemId, new StringBuffer());
            }
        }
        catch (Exception e) {
            LOGGER.error("Write file error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private void dumpOneItemInfo(BufferedWriter bw, String itemId, String msg) throws IOException {
        bw.write("collectResultStart:" + itemId + LINE_SPLIT);
        bw.write(msg);
        bw.write("collectResultEnd:" + itemId + LINE_SPLIT);
    }

    private void loadItemInfo(String rstPath, Map<String, StringBuffer> itemResultInfo) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(rstPath)));){
            String line;
            StringBuffer buffer = new StringBuffer();
            String itemId = "";
            while (null != (line = br.readLine())) {
                if (line.startsWith(COLLECT_START_FLAG)) {
                    itemId = line.split(KEY_SPLIT)[1];
                    continue;
                }
                if (line.startsWith(COLLECT_END_FLAG)) {
                    if (!itemResultInfo.containsKey(itemId)) {
                        itemResultInfo.put(itemId, new StringBuffer());
                    }
                    itemResultInfo.get(itemId).append(buffer);
                    buffer = new StringBuffer();
                    continue;
                }
                buffer.append(line).append(LINE_SPLIT);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Can not find file {}.", (Object)new File(rstPath).getName());
        }
        catch (Exception e) {
            LOGGER.error("Load rst file {} failed", (Object)rstPath, (Object)e);
        }
    }

    private static String createSha256File(String rootPath) {
        String inspectFilePath = rootPath + File.separator + "inspect_patch.tar.gz";
        String sha256FilePath = inspectFilePath + ".sha256";
        String sha256Str = SHA256Check.getInstance().getHash(inspectFilePath);
        StreamUtils.writeInfo2File((byte[])sha256Str.getBytes(StandardCharsets.UTF_8), (String)sha256FilePath);
        return sha256FilePath;
    }

    private boolean makeYaml() {
        String modelYamlFile = ArrayProductParser.DSTORAGE_EXPANSION_PATH + File.separator + "inspect_patch_preCheck.yaml";
        String yamlOutPath = this.preCheckResultTempPath + File.separator + BASIC_PATCH_YAML;
        try (FileInputStream fis = new FileInputStream(modelYamlFile);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(yamlOutPath), StandardCharsets.UTF_8));){
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            Map configMap = (Map)yaml.load((InputStream)fis);
            configMap.put(YAML_PRODUCT_NAME, this.devNode.getProductModel());
            configMap.put(YAML_PRODUCT_VERSION, this.devNode.getProductVersion());
            yaml.dump((Object)configMap, (Writer)writer);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Can not find result yaml.");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Write yaml error.", (Throwable)e);
            return false;
        }
        return true;
    }
}

