/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.inspect.entity.Config;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportDataManager;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreInspectHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreInspectHandler.class);
    private static final String COLLECT_START_FLAG = "collectResultStart";
    private static final String COLLECT_END_FLAG = "collectResultEnd";
    private static final String SH_RST = ".sh.rst";
    private static final String PY_RST = ".py.rst";
    private static final String LINE_SPLIT = "\n";
    private static final String KEY_SPLIT = ":";
    private static final String INIT_ITEM = "flag_item";
    private String preInspectResult;
    private String preInspectUnzipPath;
    private String itemFlag;
    private final List<Config> configs;

    PreInspectHandler(DevNode devNode, List<Config> configs) {
        this.preInspectResult = ReportDataManager.DS_RESULT_PATH + File.separator + devNode.getDeviceSerialNumber() + File.separator;
        this.preInspectUnzipPath = InspectContext.getInstance().getDstorageTmpPath() + File.separator + devNode.getDeviceSerialNumber() + File.separator;
        this.itemFlag = INIT_ITEM;
        this.configs = configs;
    }

    private String getClusterNodePath(String clusterNodeIp, String itemId) {
        return this.preInspectUnzipPath + itemId + File.separator + clusterNodeIp.replaceAll(KEY_SPLIT, "_") + File.separator + itemId;
    }

    public String getPreInspectResult(String clusterNodeIp, String itemId) {
        this.deCompressPreInspectResult(itemId);
        String rstPath = this.getClusterNodePath(clusterNodeIp, itemId) + SH_RST;
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rstPath), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (FileNotFoundException e) {
            log.error("Can not find file {}.", (Object)new File(rstPath).getName());
        }
        catch (Exception e) {
            log.error("Load rst file {} failed", (Object)rstPath, (Object)e);
        }
        return buffer.toString();
    }

    public String getPreInspectResultWithLine(String clusterNodeIp, String itemId) {
        this.deCompressPreInspectResult(itemId);
        String rstPath = this.getClusterNodePath(clusterNodeIp, itemId) + SH_RST;
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rstPath), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                buffer.append(line);
                buffer.append(System.lineSeparator());
            }
        }
        catch (FileNotFoundException e) {
            log.error("Can not find file {}.", (Object)new File(rstPath).getName());
        }
        catch (Exception e) {
            log.error("Load rst file {} failed", (Object)rstPath, (Object)e);
        }
        return buffer.toString();
    }

    public String getPreInspectResultWithLinePython(String clusterNodeIp, String itemId) {
        this.deCompressPreInspectResult(itemId);
        String rstPath = this.getClusterNodePath(clusterNodeIp, itemId) + PY_RST;
        StringBuilder builder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rstPath), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                builder.append(line);
                builder.append(System.lineSeparator());
            }
        }
        catch (FileNotFoundException e) {
            log.error("Can not find file {}.", (Object)new File(rstPath).getName());
        }
        catch (IOException e) {
            log.error("Load rst file {} failed", (Object)rstPath, (Object)e);
        }
        return builder.toString();
    }

    private void deCompressPreInspectResult(String itemId) {
        try {
            if (itemId.equals(this.itemFlag)) {
                return;
            }
            String resourceZipFileName = FilePathUtils.checkFile((String)(this.preInspectResult + itemId + ".zip"));
            if (resourceZipFileName == null) {
                return;
            }
            boolean isUnZipSuccess = FileAssistant.deCopmressAllZipFile(this.preInspectUnzipPath, resourceZipFileName);
            if (!isUnZipSuccess) {
                log.info("preInspect resource file is not exist or unZip false");
                return;
            }
            this.itemFlag = itemId;
        }
        catch (Exception e) {
            log.info("preInspect resource file is not exist or unZip false");
        }
    }

    public String getTargetCheckResult(String clusterNodeIp, String itemId) {
        this.deCompressPreInspectResult(itemId);
        String rstPath = this.getClusterNodePath(clusterNodeIp, this.getMultiplePreInspectItemID(itemId)) + PY_RST;
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(rstPath)));){
            String line;
            String startLine = "collectResultStart:" + itemId;
            boolean isStart = false;
            while (null != (line = br.readLine())) {
                if (line.startsWith(startLine)) {
                    isStart = true;
                    continue;
                }
                if (!isStart) continue;
                if (line.startsWith(COLLECT_END_FLAG)) {
                    break;
                }
                buffer.append(line).append(LINE_SPLIT);
            }
        }
        catch (FileNotFoundException e) {
            log.error("Can not find file {}.", (Object)new File(rstPath).getName());
        }
        catch (Exception e) {
            log.error("Load rst file {} failed", (Object)rstPath, (Object)e);
        }
        return buffer.toString();
    }

    private String getMultiplePreInspectItemID(String itemId) {
        Optional<Config> preConfig = this.configs.stream().filter(Config::isMultiple).filter(config -> config.getAssociatedItemIds().contains(itemId)).findFirst();
        if (!preConfig.isPresent()) {
            log.warn("the itemId {} not exist preInspect", (Object)itemId);
            return itemId;
        }
        return preConfig.get().getPreItemID();
    }
}

