/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.NodeCollectStatus;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class RestCollectSubTask {
    private String parentTaskId;
    private int subTaskId;
    private int subTaskProgress;
    private boolean hasResultFile = true;
    private String resultFileName;
    private boolean failed = false;
    private String errorMsg;
    private Map<Integer, NodeCollectStatus> nodesCollectStatusMap = new KeyOrderedHashMap();

    public RestCollectSubTask(String parentTaskId, int subTaskId) {
        this.parentTaskId = parentTaskId;
        this.subTaskId = subTaskId;
    }

    public RestCollectSubTask(String parentTaskId, int subTaskId, int subTaskProgress, boolean hasResultFile) {
        this(parentTaskId, subTaskId);
        this.subTaskProgress = subTaskProgress;
        this.hasResultFile = hasResultFile;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public String getNodesString() {
        Iterator<Map.Entry<Integer, NodeCollectStatus>> entryIterator = this.nodesCollectStatusMap.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (entryIterator.hasNext()) {
            sb.append(entryIterator.next().getKey()).append(',');
        }
        String ret = sb.toString();
        return this.nodesCollectStatusMap.isEmpty() ? "" : ret.substring(0, ret.length() - 1);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean isFinished() {
        if (this.nodesCollectStatusMap.isEmpty()) {
            return false;
        }
        return this.failed || this.hasResultFile && !StringUtils.isNULLStr((String)this.resultFileName);
    }

    public void setSubTaskProgress(int subTaskProgress) {
        this.subTaskProgress = subTaskProgress;
    }

    public void setHasResultFile(boolean hasResultFile) {
        this.hasResultFile = hasResultFile;
    }

    public Map<Integer, NodeCollectStatus> getNodesCollectStatusMap() {
        return this.nodesCollectStatusMap;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    public void setResultFileName(String resultFileName) {
        this.resultFileName = resultFileName;
    }

    public String toString() {
        String subTaskProgressDesc = ResourceUtil.getStringWithParams((String)"sub.task.progress", (Object[])new Object[]{this.subTaskId, this.subTaskProgress});
        StringBuilder sb = new StringBuilder(subTaskProgressDesc);
        Set<Integer> nodeIds = this.nodesCollectStatusMap.keySet();
        for (int nid : nodeIds) {
            NodeCollectStatus ncs = this.nodesCollectStatusMap.get(nid);
            sb.append(ncs.toString()).append(System.lineSeparator());
        }
        return sb.toString();
    }
}

