/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.inspector;

import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.ui.wizard.SelectClusterNodeCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.service.IHandler;
import com.huawei.ism.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateItemHandle
implements IHandler<TaskResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateItemHandle.class);
    private final CheckDevNode checkDevNode;
    private DstoragePatchInfo.Type type;
    private SelectClusterNodeCardLayout layout;
    private DstoragePatchInfo patchInfo;
    private final boolean updateCheckDevNode;

    public UpdateItemHandle(SelectClusterNodeCardLayout layout) {
        this.checkDevNode = layout.getChooseChkDevNode();
        this.layout = layout;
        this.updateCheckDevNode = true;
    }

    public UpdateItemHandle(DevNode node, DstoragePatchInfo.Type type, boolean update) {
        this.checkDevNode = InspectContext.getInstance().matchCheckDevNode(node);
        this.type = type;
        this.updateCheckDevNode = update;
        this.patchInfo = Context.INS.findBestMatchPatch(node, type);
    }

    public UpdateItemHandle(CheckDevNode checkNode, DstoragePatchInfo.Type type, boolean update) {
        this.checkDevNode = checkNode;
        this.type = type;
        this.updateCheckDevNode = update;
    }

    public TaskResult handle() {
        TaskResult result = new TaskResult();
        try {
            if (this.checkDevNode == null) {
                LOGGER.warn("CheckDevNode is null.");
                result.setResultObject((Object)new Pair((Object)new DevNode(), (Object)this.patchInfo));
                return result;
            }
            result.setResultObject((Object)new Pair((Object)this.checkDevNode.getDevNode(), (Object)this.patchInfo));
            if (this.layout != null && DstoragePatchInfo.Type.INSPECT == this.layout.getComponent().getCurrentPatch().getType() || DstoragePatchInfo.Type.INSPECT == this.type) {
                InspectContext.getInstance().updateDStorageProduct(this.checkDevNode, this.updateCheckDevNode);
            }
            result.setResult(TaskResult.Result.SUCCESS);
        }
        catch (Exception e) {
            LOGGER.error("Update dstorage config failed.", (Throwable)e);
            String errMsg = ResourceUtil.getString((String)"inspsctor.wizard.selectcluster.uploadpatch.error");
            result.setResult(TaskResult.Result.FAILED);
            result.setErrorLocaleDescription(errMsg);
        }
        return result;
    }
}

