/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.fusionstor.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.CommonData;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportCheckItem;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportData;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportNode;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;

public class ReportDataManager {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ReportDataManager.class);
    public static final String DS_RESULT_PATH = InspectContext.getInstance().getDstorageTmpPath() + File.separator + "dsnodes";
    public static final String DS_BUREAU_CHECK_RESULT_PATH = InspectContext.getInstance().getDstorageTmpPath() + File.separator + "dsrecord";
    public static final String DS_SWITCH_RESULT_PATH = InspectContext.getInstance().getDstorageTmpPath() + File.separator + "switch";
    public static final int STATUS_OK = 0;
    public static final int STATUS_NOTOK = 1;
    public static final int STATUS_NOCHECK = 2;
    public static final int STATUS_NOSUPPORT = 3;
    public static final int STATUS_WARNING = 4;
    public static final int MANUAL_CONFIRMATION = 5;
    private File deviceJs;
    private String resultDataPath;
    private File commonJs;

    public ReportDataManager(String resultDataPath) {
        this.resultDataPath = resultDataPath;
        this.deviceJs = new File(resultDataPath, "device.js");
        this.commonJs = new File(resultDataPath, "common.js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReportData(List<CheckDevNode> checkDevNodes) {
        block7: {
            OutputStreamWriter oStreamWriter = null;
            FileOutputStream fo = null;
            try {
                fo = new FileOutputStream(this.deviceJs);
                oStreamWriter = new OutputStreamWriter((OutputStream)fo, "utf-8");
                oStreamWriter.append("var ALL_DEVICES={}");
                oStreamWriter.append('\n');
                for (CheckDevNode checkDevNode : checkDevNodes) {
                    ReportData reportData = this.toReportData(checkDevNode);
                    String key = reportData.getDeviceIp() + "_" + reportData.getDeviceSN();
                    String oneDeviceVar = "ALL_DEVICES['" + key + "']";
                    String dataStr = oneDeviceVar + "=" + JSON.toJSONString((Object)reportData);
                    oStreamWriter.append(dataStr);
                    oStreamWriter.append('\n');
                    List<CheckItem> selectedItems = InspectUtils.getAllCheckItem(checkDevNode);
                    int index = 1;
                    for (CheckItem checkItem : selectedItems) {
                        ReportCheckItem reportCheckItem = this.toReportCheckItem(checkDevNode, checkItem, index++);
                        String oneItemVar = oneDeviceVar + "['checkItems']['" + reportCheckItem.getRelateId() + "']";
                        dataStr = oneItemVar + "=" + JSON.toJSONString((Object)reportCheckItem);
                        oStreamWriter.append(dataStr);
                        oStreamWriter.append('\n');
                    }
                }
                JSONObject commonConfig = new JSONObject();
                commonConfig.put("lang", (Object)"zh");
                commonConfig.put("tool", (Object)"Inspect");
                String configStr = "var GLOBAL_CONFIG=" + JSON.toJSONString((Object)commonConfig);
                oStreamWriter.append(configStr);
                StreamUtils.closeResource((Flushable)oStreamWriter, (Closeable)oStreamWriter);
            }
            catch (Exception e) {
                LOGGER.error("write report data exception.", (Throwable)e);
                break block7;
            }
            finally {
                StreamUtils.closeResource(oStreamWriter, oStreamWriter);
                StreamUtils.closeResource((Flushable)fo, (Closeable)fo);
            }
            StreamUtils.closeResource((Flushable)fo, (Closeable)fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCommonData() {
        block5: {
            OutputStreamWriter oStreamWriter = null;
            FileOutputStream fo = null;
            try {
                CommonData commonData = new CommonData();
                commonData.setReportDate(this.dealDateStr(StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss 'GMT'Z")));
                commonData.setToolboxVersion(UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version"));
                commonData.setToolVersion(UserOpDataSaveUtil.getViewVersion());
                fo = new FileOutputStream(this.commonJs);
                oStreamWriter = new OutputStreamWriter((OutputStream)fo, "utf-8");
                String dataStr = "var COMMON_DATA=" + JSON.toJSONString((Object)commonData);
                oStreamWriter.append(dataStr);
                oStreamWriter.append(System.lineSeparator());
                StreamUtils.closeResource((Flushable)oStreamWriter, (Closeable)oStreamWriter);
            }
            catch (Exception e) {
                LOGGER.error("write report data exception.", (Throwable)e);
                break block5;
            }
            finally {
                StreamUtils.closeResource(oStreamWriter, oStreamWriter);
                StreamUtils.closeResource(fo, fo);
            }
            StreamUtils.closeResource((Flushable)fo, (Closeable)fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReportNode(String itemId, List<ReportNode> reportNodes) {
        block5: {
            OutputStreamWriter oStreamWriter = null;
            FileOutputStream fo = null;
            try {
                File nodeJs = new File(this.resultDataPath, itemId + ".js");
                fo = new FileOutputStream(nodeJs);
                oStreamWriter = new OutputStreamWriter((OutputStream)fo, "utf-8");
                String dataStr = "var NODES=" + JSON.toJSONString(reportNodes);
                oStreamWriter.append(dataStr);
                oStreamWriter.append('\n');
                StreamUtils.closeResource((Flushable)oStreamWriter, (Closeable)oStreamWriter);
            }
            catch (Exception e) {
                LOGGER.error("write report data exception.", (Throwable)e);
                break block5;
            }
            finally {
                StreamUtils.closeResource(oStreamWriter, oStreamWriter);
                StreamUtils.closeResource(fo, fo);
            }
            StreamUtils.closeResource((Flushable)fo, (Closeable)fo);
        }
    }

    private String dealDateStr(String dateStr) {
        String temp = ":" + dateStr.substring(dateStr.length() - 2, dateStr.length());
        StringBuffer str = new StringBuffer(dateStr);
        str.replace(dateStr.length() - 2, dateStr.length(), temp);
        return str.toString();
    }

    private ReportData toReportData(CheckDevNode checkDevNode) {
        ReportData reportData = new ReportData();
        DevNode devNode = checkDevNode.getDevNode();
        reportData.setDeviceIp(devNode.getIp());
        reportData.setDeviceSN(devNode.getDeviceSerialNumber());
        return reportData;
    }

    private ReportCheckItem toReportCheckItem(CheckDevNode checkDevNode, CheckItem checkItem, int index) {
        ReportCheckItem reportCheckItem = new ReportCheckItem();
        reportCheckItem.setSerialNo(index);
        reportCheckItem.setCheckName(checkItem.getName());
        ResourceBundle bundle = checkDevNode.getResourceBundle();
        ResourceBundle expansionBundle = checkDevNode.getExpansionResource();
        String resId = this.getResId(checkItem);
        String method = bundle.getString(resId + ".method");
        String criterion = bundle.getString(resId + ".criterion");
        if (expansionBundle != null && criterion.equals("--")) {
            if (method.equals("--")) {
                method = expansionBundle.getString(resId + ".method");
            }
            if (criterion.equals("--")) {
                criterion = expansionBundle.getString(resId + ".criterion");
            }
        }
        reportCheckItem.setCheckMethod(method);
        reportCheckItem.setRelateId(checkItem.getItemId());
        reportCheckItem.setStatus(this.getRetStatus(checkItem.getCheckResult()));
        reportCheckItem.setSuggestion(checkItem.getSuggestionInfo());
        reportCheckItem.setSourceInfo(checkItem.getSourceInfo());
        reportCheckItem.setErrorInfo(checkItem.getErrorInfo());
        reportCheckItem.setCriterion(criterion);
        return reportCheckItem;
    }

    private String getResId(CheckItem checkItem) {
        String itemId;
        String id = checkItem.getItemId();
        if (!checkItem.getItems().isEmpty() && (itemId = checkItem.getItems().get(0).getId()) != null) {
            id = checkItem.getItemId() + "." + itemId;
        }
        return id;
    }

    private int getRetStatus(ResultItem result) {
        int status = 2;
        status = result == null ? 1 : (result.isNoSupport() ? 3 : (result.isNormal() ? 0 : (result.isNoCheck() ? 2 : (result.isWarning() ? 4 : (result.isManualConfirmation() ? 5 : 1)))));
        return status;
    }
}

