/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector;

import com.huawei.ism.tool.inspect.entity.BaseInfoCheckResult;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.CommonValue;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.utils.ParseInspectResultException;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CheckResultParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckResultParser.class);
    private static final String XPATH_ALLCONTROLLER = "/device/ctrlinfo/controller";
    private static final String XPATH_ALLFIELD = "/device/sysinfo/field";
    private static final String ID_BASEINFO = "baseinfo";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String CMDRETURN_END = "</device>";
    private static final String CMDRETURN_ATTR_TYPE = "type";
    private static final String CMDRETURN_COMMONVALUETAG = "commonvalue";
    private static final String CMDRETURN_ERRORVALUETAG = "errorvalue";
    private static final String CMDRETURN_RAWVALUE = "rawvalue";
    private static final String CMDRETURN_JUDGETAG = "judge";
    private static final String CMDRETURN_CMDITEMTAG = "cmditem";
    private static final String CMDRETURN_ROOTTAG = "device";
    private boolean errorRedView = false;

    public CheckResultParser(boolean errorRedView) {
        this.errorRedView = errorRedView;
    }

    public ResultItem parser(String cmdResturn, CheckItem checkItem) {
        ResultItem resultItem = new ResultItem();
        boolean idBaseinfo = false;
        String cmdResult = cmdResturn;
        try {
            idBaseinfo = !ID_BASEINFO.equals(checkItem.getItemId());
            cmdResult = this.getResultXml(cmdResult);
            Document doc = XmlUtils.createDomByXmlString((String)cmdResult, (String)CMDRETURN_ROOTTAG);
            if (idBaseinfo) {
                idBaseinfo = true;
                resultItem = this.parseCmdItems(cmdResult, checkItem, doc);
            } else {
                resultItem = this.parseBaseInfo(checkItem, doc);
            }
        }
        catch (ToolException e) {
            LOGGER.error("parser cmdReturn error.", (Throwable)e);
            if (idBaseinfo) {
                resultItem.setCheckItem(checkItem);
                this.buildNocheckItem(cmdResult, resultItem);
            }
        }
        catch (Exception e) {
            LOGGER.error("parse result error!", (Throwable)e);
            if (idBaseinfo) {
                resultItem.setCheckItem(checkItem);
                this.buildNocheckItem(cmdResult, resultItem);
                return resultItem;
            }
            throw new ParseInspectResultException("parse result error!", e);
        }
        return resultItem;
    }

    private ResultItem parseBaseInfo(CheckItem checkItem, Document doc) {
        Collection fields = XmlUtils.searchByExp2Ele((Node)doc.getDocumentElement(), (String)XPATH_ALLFIELD);
        BaseInfoCheckResult ret = new BaseInfoCheckResult();
        for (Object field : fields) {
            String key = XmlUtils.getAttribute((Element)field, (String)ATTR_NAME);
            String value = field.getTextContent();
            ret.getSystemInfo().add((KeyValue<String, String>)new KeyValue((Object)key, (Object)value));
        }
        Collection controllers = XmlUtils.searchByExp2Ele((Node)doc.getDocumentElement(), (String)XPATH_ALLCONTROLLER);
        for (Element ctrl : controllers) {
            Collection fileds = XmlUtils.getChildren((Element)ctrl);
            ArrayList<KeyValue> keyList = new ArrayList<KeyValue>();
            for (Element field : fileds) {
                String key = XmlUtils.getAttribute((Element)field, (String)ATTR_NAME);
                String value = field.getTextContent();
                keyList.add(new KeyValue((Object)key, (Object)value));
            }
            ret.getCtrollerInfo().add(keyList);
        }
        ret.setItemId(checkItem.getItemId());
        ResultItem resultItem = new ResultItem();
        resultItem.addItem(ret);
        return resultItem;
    }

    private ResultItem parseCmdItems(String cmdResturn, CheckItem checkItem, Document doc) {
        ResultItem resultItem = new ResultItem();
        resultItem.setCheckItem(checkItem);
        if ("".equals(cmdResturn)) {
            return resultItem;
        }
        Element cmdItem = XmlUtils.getChild((Element)doc.getDocumentElement(), (String)CMDRETURN_CMDITEMTAG);
        Collection items = XmlUtils.getChildren((Element)cmdItem);
        if (items.isEmpty()) {
            this.buildNocheckItem(cmdResturn, resultItem);
            return resultItem;
        }
        for (Element item : items) {
            RItem ret = new RItem();
            ret.setItemId(XmlUtils.getAttribute((Element)item, (String)ATTR_ID));
            ret.setJudge(XmlUtils.getTextContentOfChild((Element)item, (String)CMDRETURN_JUDGETAG));
            ret.setCli(cmdResturn);
            ret.setCommonValues(this.getCommonVals(item));
            ret.setErrorValues(this.getErrorVals(item));
            ret.setRawval(this.getRawvalue(item));
            ret.setErrorRedView(this.errorRedView);
            resultItem.addItem(ret);
        }
        return resultItem;
    }

    private void buildNocheckItem(String rec, ResultItem resultItem) {
        RItem ret = new RItem();
        ret.setItemId("0");
        ret.setJudge("2");
        ret.setCli(rec);
        resultItem.addItem(ret);
    }

    private String getResultXml(String cmdReturn) {
        int startIndex = cmdReturn.indexOf("<?xml version");
        int endIndex = cmdReturn.lastIndexOf(CMDRETURN_END) + CMDRETURN_END.length();
        return cmdReturn.substring(startIndex, endIndex);
    }

    private List<CommonValue> getErrorVals(Element item) {
        return this.getVal(item, CMDRETURN_ERRORVALUETAG);
    }

    private List<CommonValue> getCommonVals(Element item) {
        return this.getVal(item, CMDRETURN_COMMONVALUETAG);
    }

    private List<CommonValue> getRawvalue(Element item) {
        return this.getVal(item, CMDRETURN_RAWVALUE);
    }

    private List<CommonValue> getVal(Element item, String tagName) {
        Collection commonVals = XmlUtils.getChildren((Element)item, (String)tagName);
        ArrayList<CommonValue> vals = new ArrayList<CommonValue>();
        for (Element e : commonVals) {
            CommonValue v = new CommonValue();
            v.setType(XmlUtils.getAttribute((Element)e, (String)CMDRETURN_ATTR_TYPE));
            v.setVal(e.getTextContent());
            vals.add(v);
        }
        return vals;
    }
}

