/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.fusioncube.service.MetaVisionInspectService;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DstorageAfterCheckConfig;
import com.huawei.ism.tool.inspect.entity.DstoragePreCheckConfig;
import com.huawei.ism.tool.inspect.entity.InspectUserOpData;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.FusionStorExtendCollect;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.FusionStorInspector;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.UpdateItemHandle;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.InspcetCallable;
import com.huawei.ism.tool.inspect.logic.inspector.ResultCalc;
import com.huawei.ism.tool.inspect.logic.inspector.TaskSchedule;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.ICheckModel;
import com.huawei.ism.tool.inspect.ui.wizard.PerformInspectCard;
import com.huawei.ism.tool.inspect.ui.wizard.PerformSoftInspectCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.PatchImport;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.service.BatchPatchImportImp;
import com.huawei.ism.tool.service.patch.service.IHandler;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DStorageInspectCallable
extends InspcetCallable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DStorageInspectCallable.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DStorageInspectCallable.class);
    private List<String> itemIds;
    private InspectScene scene;

    public DStorageInspectCallable(InspectScene scene, List<String> itemIds) {
        this.itemIds = itemIds;
        this.scene = scene;
    }

    @Override
    public void initValue(CheckDevNode checkDeviceNode, IUiObserver uiObserve, TaskSchedule taskScheduler, File resultFolder, InspectWorktaker inspectWorktaker) {
        super.initValue(checkDeviceNode, uiObserve, taskScheduler, resultFolder, inspectWorktaker);
    }

    @Override
    protected synchronized void callInspect() throws ToolException {
        if (InspectContext.getInstance().getInspectionGradientGuidance().isStop() || InspectContext.getInstance().getInspectionGradientGuidance().isDsAbnormalStop()) {
            this.checkDevNode.setStop(true);
            this.uiObserver.finished(this.checkDevNode);
            this.createEmptyReport(this.checkDevNode);
            return;
        }
        this.importPatchAndSelectItems(this.itemIds);
        int allCheckItemsCnt = InspectContext.getInstance().calcAllItemSize(this.checkDevNode);
        this.progressStep = 100 / Math.max(1, allCheckItemsCnt);
        if (this.progressStep == 0) {
            this.setNeedResetProgressStep(true);
        }
        List notConnectedDevNodes = (List)this.inspectWorktaker.get("not_connected_devices_" + this.inspectWorktaker.getUuid());
        this.userOpData = new InspectUserOpData();
        this.initDeviceUserData(this.checkDevNode);
        this.userOpDataList.add(this.userOpData);
        this.inspect(this.checkDevNode, notConnectedDevNodes);
    }

    private void importPatchAndSelectItems(List<String> itemIds) throws ToolException {
        if (this.scene == null) {
            return;
        }
        this.checkDevNode.setImportPatchErrorMsg("");
        String msg = ResourceUtil.getString((String)"inspector.distributed.items.init");
        Calendar calendar = Calendar.getInstance();
        this.uiObserver.update(this.checkDevNode, null, msg, 0, calendar, RecordStatus.PROCESSING);
        List<TaskResult> results = PatchImport.builder().checkDevNodes(Collections.singletonList(this.checkDevNode)).build().autoImport();
        if (BatchPatchImportImp.isUploadFailed(results)) {
            this.uiObserver.update(this.checkDevNode, null, msg, 0, calendar, RecordStatus.FAILED);
            String errorMsg = results.get(0).getErrorLocaleDescription();
            this.updateObserver(errorMsg, calendar);
            this.uiObserver.finished(this.checkDevNode);
            throw new ToolException(errorMsg);
        }
        this.uiObserver.update(this.checkDevNode, null, msg, 0, calendar);
        this.checkDevNode.selectItems(this.scene, itemIds);
    }

    private void updateObserver(String errorMsg, Calendar calendar) {
        log.info("Batch patch import failed. error message is: {}", (Object)errorMsg);
        if (!this.isDistributedDeployScene() || StringUtils.isNULLStr((String)errorMsg) || !errorMsg.startsWith(ResourceUtil.getString((String)"inspector.import.patch.error.msg.regex"))) {
            this.uiObserver.update(this.checkDevNode, null, errorMsg, 0, calendar, RecordStatus.FAILED);
            log.info("The error information does not contain the node ID.");
            return;
        }
        this.checkDevNode.setImportPatchErrorMsg(errorMsg);
        this.uiObserver.update(this.checkDevNode, this.createCheckItem(calendar, errorMsg), errorMsg, 0, calendar, RecordStatus.FAILED);
    }

    private boolean isDistributedDeployScene() {
        return SceneUtils.isScene() && SceneUtils.isSpecialScence((String)System.getenv("jsonScene"), (String[])new String[]{"Opening Delivery"}) && SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"Distributed Deploy"});
    }

    CheckItem createCheckItem(Calendar calendar, String errorMsg) {
        CheckItem checkItem = new CheckItem();
        checkItem.setItemId("importPatch");
        checkItem.setName(errorMsg);
        ResultItem resultItem = new ResultItem();
        resultItem.setStartTime(calendar);
        resultItem.setStatus(RecordStatus.FAILED);
        resultItem.setFinished(true);
        checkItem.setCheckResult(resultItem);
        return checkItem;
    }

    @Override
    protected int checkAndUpdate(CheckDevNode node, ICheckModel checkModel) throws ToolException {
        LOGGER.info("Inspection start >> Analyze  device {} begin.", (Object)node.getDevNode().getIp());
        return this.inspectDStorage(node, new ResultCalc(), checkModel);
    }

    private int inspectDStorage(CheckDevNode checkNode, ResultCalc rcCount, ICheckModel checkModel) throws ToolException {
        FusionStorInspector inspector = new FusionStorInspector(checkNode, this.uiObserver, rcCount);
        try {
            inspector.init();
            inspector.preInspect();
            inspector.execute();
            this.collectConfig(checkNode, inspector);
        }
        catch (ToolException e) {
            LOGGER.error("exception happened!", (Throwable)e);
            this.userOpData.setTaskResult(UserOpTaskResult.FAILED);
            throw e;
        }
        finally {
            DstoragePreCheckConfig.INS.filterHiddenItems(this.checkDevNode);
            DstoragePreCheckConfig.removePreItems(this.checkDevNode);
            DstorageAfterCheckConfig.INS.removeHiddenItems(this.checkDevNode);
        }
        List<CheckItem> selectItems = InspectUtils.getAllCheckItem(this.checkDevNode);
        for (CheckItem checkItem : selectItems) {
            this.userOpData.itemNumInc();
            this.concatItem(checkItem, checkItem.getCheckResult());
        }
        this.finishInspect(checkNode, rcCount);
        this.mergeSoftAndHardwareResult();
        this.reportMsghandle(checkNode, checkModel);
        rcCount.setEndTime(Calendar.getInstance());
        this.resultStat(checkNode, rcCount);
        return rcCount.getFaildCount();
    }

    private void mergeSoftAndHardwareResult() {
        if (!this.isHardwareInspect()) {
            return;
        }
        Map<String, List<CheckItem>> checkItems = this.checkDevNode.getCheckItems();
        String stepName = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.collect.soft");
        this.uiObserver.update(this.checkDevNode, null, stepName, 0, Calendar.getInstance(), RecordStatus.PROCESSING);
        checkItems.values().stream().flatMap(Collection::stream).filter(item -> Objects.nonNull(item.getCheckResult())).forEach(item -> item.setSelected(true));
        this.uiObserver.update(this.checkDevNode, null, stepName, 1, Calendar.getInstance(), RecordStatus.NORMAL);
    }

    private boolean isHardwareInspect() {
        return InspectContext.getInstance().isDetachCheck() && this.uiObserver.getClass().equals(PerformInspectCard.class);
    }

    @Override
    protected void finishInspect(CheckDevNode node, ResultCalc rcCount) {
        this.updateScore(node);
        this.userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
        this.userOpData.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectConfig(CheckDevNode node, FusionStorInspector inspector) {
        if (this.isHardwareInspect() || InspectUtils.isStorageConfig() || MetaVisionInspectService.isFusionCubeMetaVisionNode(node)) {
            return;
        }
        InspectContext.getInstance().getInspectionGradientGuidance().getDeviceInInfoSummaryMap().put(node.getDevNode().getDeviceSerialNumber(), true);
        String msg = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.postCollect");
        Calendar calendar = Calendar.getInstance();
        try {
            this.uiObserver.update(node, null, msg, 1, calendar, RecordStatus.PROCESSING);
            inspector.fusionCubeAfterCheckTask(node);
            this.uninstallAutoImportPatch();
            InspectContext.getInstance().getdStorageProduct().remove(node.getDevNode());
            String ip = this.checkDevNode.getDevNode().getIp().replaceAll(":", "_");
            String collectResultPath = this.resultFolder.getCanonicalPath() + File.separator + "data" + File.separator + "config" + File.separator + ip + "_" + this.checkDevNode.getDevNode().getDeviceSerialNumber();
            FusionStorExtendCollect extendCollect = new FusionStorExtendCollect(this.checkDevNode, collectResultPath);
            extendCollect.startCollect();
        }
        catch (Exception e) {
            LOGGER.error("Collect config failed.", (Throwable)e);
        }
        finally {
            this.uiObserver.update(node, null, msg, 1, calendar);
        }
    }

    private void uninstallAutoImportPatch() {
        if (this.isSoftWareInspect()) {
            return;
        }
        Context.INS.uninstallAutoImportPatch(this.checkDevNode.getDevNode(), DstoragePatchInfo.Type.INSPECT, (IHandler)new UpdateItemHandle(this.checkDevNode, DstoragePatchInfo.Type.INSPECT, false));
    }

    private boolean isSoftWareInspect() {
        return InspectContext.getInstance().isDetachCheck() && this.uiObserver instanceof PerformSoftInspectCard;
    }

    @Generated
    public DStorageInspectCallable() {
    }
}

