/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.inspect.entity.BureauFile;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.InspectType;
import com.huawei.ism.tool.inspect.entity.InspectUserOpData;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultFlag;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.SecureLineChecker;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportDataManager;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.InspectCaller;
import com.huawei.ism.tool.inspect.logic.inspector.InspectEventRecorder;
import com.huawei.ism.tool.inspect.logic.inspector.ResultCalc;
import com.huawei.ism.tool.inspect.logic.inspector.TaskSchedule;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.CheckModelInfo;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.ICheckModel;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.NormalCheckModel;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.PyScriptCheckModel;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.RestCheckModel;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.WindowsCheckModel;
import com.huawei.ism.tool.inspect.logic.result.CheckRuleBuiler;
import com.huawei.ism.tool.inspect.logic.result.IResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.SwitchExcelBuilder;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.ui.logic.ExecuteTaskProgressObserver;
import com.huawei.ism.tool.inspect.utils.ChannelWriteFile;
import com.huawei.ism.tool.inspect.utils.ComputerStorageUtils;
import com.huawei.ism.tool.inspect.utils.InspectCommonResBundle;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectLock;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.protocol.rest.FceRestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class InspcetCallable
extends InspectCaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspcetCallable.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(InspcetCallable.class);
    protected static final String THREAD_NAME_PREFIX = "InspectCallable_";
    protected static final String CSS_FILE_PATH = "css/table_inspector.css";
    protected static final String CHECKRULE_XLS = "checkrule/check.xsl";
    protected static final String CHECKRULE_XML = "checkrule/check.xml";
    protected static final int NUM_HUNDRED = 100;
    public static final String SYSTEM_INNER_CHECK_ITEM_ID = "system_Inner_check";
    private static final String INNER_CHECK = "innerCheck";
    protected File resultFolder;
    protected CheckDevNode checkDevNode;
    protected IUiObserver uiObserver;
    protected int progressStep = 0;
    protected TaskSchedule taskSchedule;
    protected InspectWorktaker inspectWorktaker;
    protected List<InspectUserOpData> userOpDataList = InspectContext.getInstance().getUseropList();
    protected InspectUserOpData userOpData;
    protected Map<CheckDevNode, Integer> itemIndexMap = new HashMap<CheckDevNode, Integer>();
    protected int finishedItemNum = 0;
    protected double tempProgressStep = 0.0;
    protected boolean needResetProgressStep = false;

    @Override
    public void initValue(CheckDevNode checkDeviceNode, IUiObserver uiObserve, TaskSchedule taskScheduler, File resultFolde, InspectWorktaker inspectWorktake) {
        this.taskSchedule = taskScheduler;
        this.checkDevNode = checkDeviceNode;
        this.uiObserver = uiObserve;
        this.resultFolder = resultFolde;
        this.inspectWorktaker = inspectWorktake;
    }

    @Override
    public Object call() {
        String threadName = THREAD_NAME_PREFIX + this.checkDevNode.getDevNode().getIp();
        Thread.currentThread().setName(threadName);
        LOGGER.info("set current thread name: {}", (Object)threadName);
        try {
            this.callInspect();
        }
        catch (Throwable e) {
            LOGGER.error("throw unknow exception.", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callInspect() throws ToolException {
        int allCheckItemsCnt = 0;
        allCheckItemsCnt = InspectContext.getInstance().calcAllItemSize(this.checkDevNode);
        this.progressStep = 100 / Math.max(1, allCheckItemsCnt);
        if (this.progressStep == 0) {
            this.setNeedResetProgressStep(true);
        }
        List<CheckDevNode> allNodes = this.checkDevNode.getAllCheckNode();
        Map<String, Integer> hyperMetroLockMap = InspectContext.getInstance().getHyperMetroLockMap();
        InspectEventRecorder.getInstance().startRecord(allNodes);
        for (CheckDevNode node : allNodes) {
            hyperMetroLockMap.put(node.getDevNode().getDeviceSerialNumber(), 0);
        }
        LOGGER.info("all check node size: {}", (Object)allNodes.size());
        List notConnectedDevNodes = (List)this.inspectWorktaker.get("not_connected_devices_" + this.inspectWorktaker.getUuid());
        for (CheckDevNode node : allNodes) {
            this.itemIndexMap.put(node, 0);
            InspectLock mutex = InspectUtils.getDevLock(InspectUtils.getDevIpAndSnKey(node.getDevNode()));
            LOGGER.info("get inspect lock for checkDevNode: {}", (Object)node.getDevNode().getIp());
            InspectLock inspectLock = mutex;
            synchronized (inspectLock) {
                this.userOpData = new InspectUserOpData();
                this.initDeviceUserData(node);
                this.userOpDataList.add(this.userOpData);
                if (InspectContext.getInstance().getInspectionGradientGuidance().isStop()) {
                    node.setStop(true);
                    this.uiObserver.finished(node);
                    this.createEmptyReport(node);
                    return;
                }
                if (!this.inspect(node, notConnectedDevNodes)) {
                    return;
                }
            }
        }
    }

    void createEmptyReport(CheckDevNode node) {
        File emptyReportPath = new File(this.resultFolder, String.join((CharSequence)File.separator, "data", "devs", node.getDevNode().getUuid()));
        File emptyReport = new File(emptyReportPath, "index.html");
        FileUtils.createDir((String)emptyReport.getParent());
        try (ChannelWriteFile file = new ChannelWriteFile(FilesUtil.getCanonicalPath((File)emptyReport), false);){
            file.write(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.stopinspect.report.msg"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean inspect(CheckDevNode node, List<CheckDevNode> notConnectedDevNodes) {
        ICheckModel checkModel;
        boolean isConnectFailed;
        block15: {
            block14: {
                block13: {
                    block12: {
                        LOGGER.info("----start to inspect----");
                        isConnectFailed = true;
                        checkModel = null;
                        InspectUtils.alarmDevLock(node.getDevNode().getIp());
                        checkModel = this.getCheckModel(node);
                        if (checkModel != null) break block12;
                        LOGGER.error("get checkModel is null!");
                        boolean bl = false;
                        this.handleFinally(node, checkModel);
                        return bl;
                    }
                    if (!EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)node.getDevNode()) || node.getDevNode().is2910V7()) break block13;
                    boolean bl = this.startFcvInspect(node, checkModel);
                    this.handleFinally(node, checkModel);
                    return bl;
                }
                if (!this.isInitConnectionFailed(checkModel)) break block14;
                notConnectedDevNodes.add(node);
                this.uiObserver.updateErrMsg(node, ResourceUtil.getString((String)"inspsctor.wizard.performinspect.error"));
                boolean bl = false;
                this.handleFinally(node, checkModel);
                return bl;
            }
            isConnectFailed = false;
            if (this.checkDevVersion(checkModel)) break block15;
            LOGGER.warn("Dev version check not pass.");
            this.updateInspcetTable(notConnectedDevNodes, node);
            this.uiObserver.updateErrMsg(node, ResourceUtil.getString((String)"error.version.conflict.silent"));
            boolean bl = false;
            this.handleFinally(node, checkModel);
            return bl;
        }
        try {
            LOGGER.info("start inspect node: {}", (Object)node.getDevNode().getIp());
            this.checkAndUpdate(node, checkModel);
            LOGGER.info("end inspect node: {}", (Object)node.getDevNode().getIp());
            if (InspectUtils.isSceneNeedRecord(this.inspectWorktaker)) {
                InspectUtils.writeExecuteInfoLocal(node);
            }
            node.setExecuteSuc(true);
            this.handleFinally(node, checkModel);
        }
        catch (InterruptedException e) {
            LOGGER.error("InterruptedException : Execute inspect error", (Throwable)e);
            this.handleException(notConnectedDevNodes, node, checkModel, isConnectFailed);
            this.handleFinally(node, checkModel);
        }
        catch (PwdException | ToolException | InvocationTargetException e2) {
            block16: {
                LOGGER.error("ToolException : Execute inspect error", e2);
                if (null != checkModel) break block16;
                LOGGER.error("failed to alarm dev lock");
                boolean bl = false;
                this.handleFinally(node, checkModel);
                return bl;
                {
                    catch (Throwable throwable) {
                        this.handleFinally(node, checkModel);
                        throw throwable;
                    }
                }
            }
            this.handleException(notConnectedDevNodes, node, checkModel, isConnectFailed);
            this.handleFinally(node, checkModel);
        }
        return true;
    }

    private boolean isInitConnectionFailed(ICheckModel checkModel) throws ToolException {
        return !InspectContext.getInstance().isHardwareInspect() && !checkModel.initConnection();
    }

    protected void updateInspcetTable(List<CheckDevNode> notConnectedDevNodes, CheckDevNode node) {
        this.uiObserver.update(node, null, ResourceUtil.getString((String)"error.version.conflict"), 0, Calendar.getInstance());
        notConnectedDevNodes.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFinally(CheckDevNode node, ICheckModel checkModel) {
        try {
            if (checkModel != null) {
                checkModel.clearDeviceRemainsFile();
                if (!EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)node.getDevNode())) {
                    checkModel.releaseConnection();
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Close connect error", (Throwable)e);
        }
        finally {
            SwingUtilities.invokeLater(() -> this.uiObserver.finished(node));
        }
        InspectUtils.releaseDevLock(node.getDevNode().getIp());
    }

    protected void handleException(List<CheckDevNode> notConnectedDevNodes, CheckDevNode node, ICheckModel checkModel, boolean isConnectFailed) {
        node.setEndTime(Calendar.getInstance());
        if (!this.taskSchedule.isCancel() && !isConnectFailed) {
            this.buildResultFile(node, checkModel);
        } else {
            notConnectedDevNodes.add(node);
            LOGGER.info("The node: {} can not connected!", (Object)node.getDevNode().getDeviceSerialNumber());
        }
        this.uiObserver.updateErrMsg(this.checkDevNode, ResourceUtil.getString((String)"inspsctor.wizard.performinspect.error"));
    }

    protected boolean checkDevVersion(ICheckModel checkModel) {
        return checkModel.isVersionSavewithDevice();
    }

    protected boolean buildResultFile(CheckDevNode node, ICheckModel checkModel) {
        try {
            List checkDevNodes = (List)this.inspectWorktaker.get("check_dev_nodes");
            File tmpPath = new File(this.resultFolder, "data" + File.separator + "devs" + File.separator + node.getDevNode().getUuid());
            File resultFileName = new File(tmpPath, "index.html");
            FileUtils.createDir((String)resultFileName.getParent());
            try {
                if (InspectContext.getInstance().isBureauCheck()) {
                    BureauDocuService.INS.handleFilesWithDocuByDevNode(this.resultFolder, node.getDevNode());
                }
            }
            catch (Exception e) {
                LOGGER.error("handle bureau document error", (Throwable)e);
            }
            if (node.getScriptDir() != null) {
                this.createSourceHlpCase(node, tmpPath);
            }
            IResultBuilder resultBuilder = checkModel.getResultBuilder();
            resultBuilder.buildResultFile(checkDevNodes, node, resultFileName.getCanonicalPath());
            this.buildSwitchInfoPage(node);
            if (!EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)node.getDevNode())) {
                InspcetCallable.copyCheckRuleFile(tmpPath, node);
            }
            this.copyCssFile(tmpPath);
            node.setResuleTmpFile(resultFileName);
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("build result error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private void createSourceHlpCase(CheckDevNode node, File tmpPath) throws IOException {
        File sourceHlpCase = new File(node.getScriptDir().getParentFile(), "helpCase");
        LOGGER.info("sourceHlpCase:{} tmpPath:{}", (Object)sourceHlpCase, (Object)tmpPath.getCanonicalPath());
        if (sourceHlpCase.exists()) {
            String typeFolder = InspectUtils.getTypeFolderName(this.checkDevNode);
            File destCaseFile = new File(tmpPath.getParentFile(), typeFolder + File.separator + "helpCase");
            LOGGER.info("destCaseFile.exists():{} destCaseFile:{}", (Object)destCaseFile.exists(), (Object)destCaseFile.getCanonicalPath());
            if (!destCaseFile.exists()) {
                FileUtils.copyDir((String)sourceHlpCase.getCanonicalPath(), (String)destCaseFile.getCanonicalPath());
            }
        }
    }

    private void buildSwitchInfoPage(CheckDevNode node) {
        List switchNodes = node.getDevNode().getSwitchNodes();
        if (CollectionUtil.isEmpty((Collection)switchNodes)) {
            return;
        }
        File file = new File(ReportDataManager.DS_SWITCH_RESULT_PATH);
        if (!file.exists() && !file.mkdirs()) {
            return;
        }
        new SwitchExcelBuilder().exportSwitchNodes(node.getDevNode().getIp(), switchNodes, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyCheckRuleFile(File destPath, CheckDevNode checkNode) throws IOException {
        String srcFile = InspectContext.INSPECT_CONFPATH + File.separator + CHECKRULE_XLS;
        File destFile = new File(destPath.getCanonicalPath() + File.separator + CHECKRULE_XLS);
        FileUtils.createDir((String)destFile.getParent());
        StreamUtils.copyFileThrowEx((File)new File(srcFile), (File)destFile);
        CheckRuleBuiler checkRuleBuiler = new CheckRuleBuiler(checkNode);
        File xmlFile = new File(destPath.getCanonicalPath() + File.separator + CHECKRULE_XML);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(xmlFile);
            checkRuleBuiler.transfor2Stream(outputStream);
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(InspcetCallable.class).error("create check rule xml error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream((OutputStream)outputStream, null);
        }
        return xmlFile;
    }

    protected void copyCssFile(File destPath) throws IOException {
        String srcFile = InspectContext.INSPECT_CONFPATH + File.separator + CSS_FILE_PATH;
        File destFile = new File(destPath.getCanonicalPath() + File.separator + CSS_FILE_PATH);
        FileUtils.createDir((String)destFile.getParent());
        StreamUtils.copyFileThrowEx((File)new File(srcFile), (File)destFile);
    }

    protected int checkAndUpdate(CheckDevNode node, ICheckModel checkModel) throws InterruptedException, ToolException, InvocationTargetException {
        LOGGER.info("Inspection start >> Analyze device {} begin][Success", (Object)node.getDevNode().getIp());
        Map<String, List<CheckItem>> items = this.getCheckItems(node);
        ArrayList<String> keys = new ArrayList<String>(items.keySet());
        String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.startinspect", (Object[])new Object[]{node.getDevNode().getIp()});
        this.uiObserver.update(node, null, msg, 1, Calendar.getInstance());
        ResultCalc rcCount = new ResultCalc();
        List<String> notExecutedKeys = new ArrayList<String>();
        int keyIndex = -1;
        try {
            for (int j = 0; j < keys.size(); ++j) {
                keyIndex = j;
                List<CheckItem> checkItems = items.get(keys.get(j));
                LOGGER.error("setItemsResult." + checkItems);
                this.itemIndexMap.put(node, 0);
                this.setItemsResult(node, checkModel, rcCount, checkItems);
            }
            if (node.getCheckItems().containsKey(this.getInnerCheckKey(node))) {
                node.getCheckItems().get(this.getInnerCheckKey(node)).addAll(InspectContext.getInstance().getInnerCheckResult(node.getDevNode().getIp()));
            }
            this.finishInspect(node, rcCount);
        }
        catch (ToolException e) {
            LOGGER.error("exception happened!", (Throwable)e);
            this.userOpData.setTaskResult(UserOpTaskResult.FAILED);
            this.plusIndexMap(node, -1);
            notExecutedKeys = keys.subList(keyIndex, keys.size());
            throw e;
        }
        finally {
            this.notcheckExceptionHandle(items, rcCount, notExecutedKeys, node);
        }
        LOGGER.info("start to hangle report msg.");
        this.reportMsghandle(node, checkModel);
        this.resultStat(node, rcCount);
        return rcCount.getFaildCount();
    }

    @NotNull
    private Map<String, List<CheckItem>> getCheckItems(CheckDevNode node) {
        Map<String, List<CheckItem>> items = node.getCheckItems();
        if (items.containsKey(this.getInnerCheckKey(node))) {
            List innerCheckItems = items.get(this.getInnerCheckKey(node)).stream().filter(checkItem -> SYSTEM_INNER_CHECK_ITEM_ID.equals(checkItem.getItemId())).collect(Collectors.toList());
            items.put(this.getInnerCheckKey(node), innerCheckItems);
        }
        return items;
    }

    private String getInnerCheckKey(CheckDevNode node) {
        return ResourceUtil.getString((ResourceBundle)node.getResourceBundle(), (ResourceBundle)InspectCommonResBundle.INS.getUnifiedResBundle(), (String)INNER_CHECK);
    }

    protected void finishInspect(CheckDevNode node, ResultCalc rcCount) {
        this.updateScore(node);
        this.userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
        this.userOpData.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
    }

    protected void plusIndexMap(CheckDevNode node, int add) {
        if (node == null || this.itemIndexMap.get(node) == null) {
            LOGGER.error("chenge itemIndex failed.");
            return;
        }
        this.itemIndexMap.put(node, this.itemIndexMap.get(node) + add);
    }

    protected void setItemsResult(CheckDevNode node, ICheckModel checkModel, ResultCalc rcCount, List<CheckItem> checkItems) throws InterruptedException, ToolException, InvocationTargetException {
        for (CheckItem checkItem : checkItems) {
            checkItem.reset();
            this.plusIndexMap(node, 1);
            if (!checkItem.isEnable()) continue;
            if (this.taskSchedule.isCancel()) {
                throw new InterruptedException("cancel task by user");
            }
            rcCount.setAllCheckNumCount(rcCount.getAllCheckNumCount() + checkItem.getCheckSize());
            rcCount.setEndTime(Calendar.getInstance());
            if (InspectContext.getInstance().getInspectionGradientGuidance().isStop()) {
                this.refreshThePageProgress(node, checkItem, ResultFlag.STOPPED, RecordStatus.STOPPED);
                rcCount.setStopCountAutoIncrement();
                continue;
            }
            this.userOpData.itemNumInc();
            Long itemStartTime = System.currentTimeMillis();
            ResultItem ret = this.checkAsItem(node, checkModel, checkItem, rcCount.getEndTime());
            node.setCurNodeFinishedItemNum(++this.finishedItemNum);
            LOGGER.info("set CurNodeFinishedItemNum : {}", (Object)this.finishedItemNum);
            Long itemEndTime = System.currentTimeMillis();
            this.userOpData.appendOverTimesItems(itemStartTime, itemEndTime, checkItem);
            this.collectCheckResult(node, rcCount, checkItem, ret);
            if (SYSTEM_INNER_CHECK_ITEM_ID.equals(checkItem.getItemId())) {
                List<CheckItem> innerCheckItems = InspectContext.getInstance().getInnerCheckResult(this.checkDevNode.getDevNode().getIp());
                innerCheckItems.forEach(innerCheckItem -> this.concatItem((CheckItem)innerCheckItem, innerCheckItem.getCheckResult()));
            }
            this.concatItem(checkItem, ret);
        }
    }

    private void collectCheckResult(CheckDevNode node, ResultCalc rcCount, CheckItem checkItem, ResultItem ret) {
        if (SYSTEM_INNER_CHECK_ITEM_ID.equals(checkItem.getItemId())) {
            this.collectInnerCheckResults(node, rcCount);
        }
        rcCount.setNotCheckdCount(rcCount.getNotCheckdCount() + this.getNotCheckdCount(ret, checkItem));
        rcCount.setNotSupportCount(rcCount.getNotSupportCount() + this.getNotSupportCount(ret, checkItem));
        rcCount.setWarningCount(rcCount.getWarningCount() + this.getWarningCount(ret, checkItem));
        rcCount.setNotPassedCount(rcCount.getNotPassedCount() + this.getNotPassedCount(ret, checkItem));
    }

    private void collectInnerCheckResults(CheckDevNode node, ResultCalc rcCount) {
        List<CheckItem> innerCheckItems = InspectContext.getInstance().getInnerCheckResult(this.checkDevNode.getDevNode().getIp());
        node.setCurNodeFinishedItemNum(this.finishedItemNum + innerCheckItems.size());
        rcCount.setAllCheckNumCount(rcCount.getAllCheckNumCount() + innerCheckItems.size());
        rcCount.setNotCheckdCount(rcCount.getNotCheckdCount() + this.getNotCheckdCountByInnerChecks(innerCheckItems));
        rcCount.setNotSupportCount(rcCount.getNotSupportCount() + this.getNoSupportCountByInnerChecks(innerCheckItems));
        rcCount.setWarningCount(rcCount.getWarningCount() + this.getWarningCountByInnerChecks(innerCheckItems));
        rcCount.setNotPassedCount(rcCount.getNotPassedCount() + this.getNotPassCountByInnerChecks(innerCheckItems));
    }

    protected void updateScore(CheckDevNode node) {
        Integer score = node.getScore();
        InspectContext.getInstance().setScore(score);
        HashMap<String, Integer> scoreMap = new HashMap<String, Integer>();
        scoreMap.put(node.getDevNode().getDeviceSerialNumber(), score);
        InspectContext.getInstance().setScoreMap(scoreMap);
    }

    protected void concatItem(CheckItem i, ResultItem ret) {
        block6: {
            block4: {
                block8: {
                    block7: {
                        block5: {
                            if (!i.isSingleElement()) break block4;
                            if (!ret.isNotPass()) break block5;
                            this.userOpData.setUserOpData(i.getItemId(), "failed");
                            break block6;
                        }
                        if (!ret.isNoCheck()) break block7;
                        this.userOpData.setUserOpData(i.getItemId(), "uncheck");
                        break block6;
                    }
                    if (!ret.isWarning()) break block8;
                    this.userOpData.setUserOpData(i.getItemId(), "optimise");
                    break block6;
                }
                if (!ret.isNormal()) break block6;
                this.userOpData.setUserOpData(i.getItemId(), "normal");
                break block6;
            }
            List<RItem> ritems = ret.getItems();
            for (RItem ritem : ritems) {
                if (ritem.isFailed()) {
                    this.userOpData.setUserOpData(i.getItemId(), "failed");
                    continue;
                }
                if (ritem.isNoCheck()) {
                    this.userOpData.setUserOpData(i.getItemId(), "uncheck");
                    continue;
                }
                if (ritem.isWarning()) {
                    this.userOpData.setUserOpData(i.getItemId(), "optimise");
                    continue;
                }
                if (!ritem.isNormal()) continue;
                this.userOpData.setUserOpData(i.getItemId(), "normal");
            }
        }
    }

    protected void initDeviceUserData(CheckDevNode node) {
        this.userOpData.setTaskResult(UserOpTaskResult.IN_COMPLETE);
        DevNode devNode = node.getDevNode();
        this.userOpData.setTaskStartTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
        this.userOpData.setDevNode(EntityUtils.toNewDev((DevNode)devNode));
        String chooseSence = (String)this.inspectWorktaker.get("select_sceneId");
        this.userOpData.setInspectType(this.getChooseSence(chooseSence));
        this.userOpData.setIntegration(node.isIntegration());
        this.userOpData.setUseApply(InspectContext.getInstance().isUseApply());
        BureauFile bureauFile = InspectContext.getInstance().getBureauFile(devNode);
        this.userOpData.setBureanScore(null == bureauFile ? -1 : bureauFile.getScore());
        List remoteSns = devNode.getRemoteSNs();
        this.userOpData.setHyperMetroDev(null == remoteSns ? false : remoteSns.isEmpty());
        InspectContext context = InspectContext.getInstance();
        if (context.getExtendInspectScene() != null) {
            this.userOpData.setInspectToolScene(context.getExpMode());
        }
    }

    protected InspectType getChooseSence(String chooseSence) {
        InspectType inspectType = null;
        if (chooseSence == null || chooseSence.isEmpty()) {
            LOGGER.info("chooseSence is null or empty.");
            inspectType = InspectType.REALTIMED;
            return inspectType;
        }
        inspectType = chooseSence.contains("bureau") ? InspectType.BUREAU : (chooseSence.contains("renewal") ? InspectType.RENEWAL : (chooseSence.contains("compass") ? InspectType.COMPASS : (chooseSence.contains("warning") ? InspectType.WARNING : InspectType.REALTIMED)));
        return inspectType;
    }

    protected void reportMsghandle(CheckDevNode node, ICheckModel checkModel) {
        InspectContext.getInstance().getInspectionGradientGuidance().getDeviceInInfoSummaryMap().put(node.getDevNode().getDeviceSerialNumber(), true);
        String msg = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.startreport");
        this.uiObserver.update(node, null, msg, 1, Calendar.getInstance());
        boolean ret = this.buildResultFile(node, checkModel);
        msg = ret ? ResourceUtil.getString((String)"inspsctor.wizard.performinspect.report.success") : ResourceUtil.getString((String)"inspsctor.wizard.performinspect.report.fail");
        this.uiObserver.update(node, null, msg, 1, Calendar.getInstance());
    }

    protected void resultStat(CheckDevNode node, ResultCalc rcCount) {
        node.setEndTime(rcCount.getEndTime());
        String msgKey = InspectUtils.isStorageConfig() ? "storage.config.wizard.performinspect.completeinspect" : "inspsctor.wizard.performinspect.completeinspect";
        String msg = ResourceUtil.getStringWithParams((String)msgKey, (Object[])new Object[]{node.getDevNode().getIp(), node.getInspectTime()});
        this.uiObserver.update(node, null, msg, 1, Calendar.getInstance());
        msgKey = InspectUtils.isStorageConfig() ? "storage.config.wizard.performinspect.inspectstat" : "inspsctor.wizard.performinspect.inspectstat";
        msg = ResourceUtil.getStringWithParams((String)msgKey, (Object[])new Object[]{rcCount.getAllCheckNumCount(), rcCount.getNotPassedCount(), rcCount.getSuccesscount(), rcCount.getNotCheckdCount(), rcCount.getNotSupportCount(), rcCount.getWarningCount(), rcCount.getStopCount(), rcCount.getManualConfirmationCount()});
        this.uiObserver.update(node, null, msg, 1, Calendar.getInstance());
        if (this.uiObserver instanceof ExecuteTaskProgressObserver) {
            ExecuteTaskProgressObserver executeTaskProgressObserver = (ExecuteTaskProgressObserver)this.uiObserver;
            executeTaskProgressObserver.calcPassRate(node, rcCount);
        }
    }

    protected void notcheckExceptionHandle(Map<String, List<CheckItem>> items, ResultCalc rcCount, List<String> notExecutedKeys, CheckDevNode node) {
        if (null == node || null == this.itemIndexMap.get(node)) {
            LOGGER.error("get item index error.");
            return;
        }
        int itemIndex = this.itemIndexMap.get(node);
        for (int j = 0; j < notExecutedKeys.size(); ++j) {
            List<CheckItem> checkItems = items.get(notExecutedKeys.get(j));
            if (j == 0 && itemIndex < checkItems.size()) {
                for (int i = 0; i < checkItems.size(); ++i) {
                    CheckItem item = checkItems.get(i);
                    if (!item.isEnable() || i < itemIndex) continue;
                    this.nocheckItemHandle(rcCount, item);
                }
                continue;
            }
            for (CheckItem i : checkItems) {
                if (!i.isEnable()) continue;
                this.nocheckItemHandle(rcCount, i);
            }
        }
    }

    protected void nocheckItemHandle(ResultCalc rcCount, CheckItem item) {
        rcCount.setAllCheckNumCount(rcCount.getAllCheckNumCount() + item.getCheckSize());
        rcCount.setEndTime(Calendar.getInstance());
        ResultItem ret = new ResultItem();
        List<Item> items = item.getItems();
        if (items != null && !items.isEmpty()) {
            for (Item item2 : items) {
                RItem rItem = new RItem();
                rItem.setItemId(item2.getId());
                rItem.setJudge("2");
                rItem.setCli(ResourceUtil.getString((String)"inspect.undetected.nocheck.msg"));
                ret.addItem(rItem);
            }
        }
        ret.setCheckItem(item);
        item.setSourceInfo(ResourceUtil.getString((String)"inspect.undetected.nocheck.msg"), this.checkDevNode);
        ret.setNoCheck(true);
        item.setCheckResult(ret);
        rcCount.setNotCheckdCount(rcCount.getNotCheckdCount() + this.getNotCheckdCount(ret, item));
        rcCount.setNotSupportCount(rcCount.getNotSupportCount() + this.getNotSupportCount(ret, item));
        rcCount.setWarningCount(rcCount.getWarningCount() + this.getWarningCount(ret, item));
        rcCount.setNotPassedCount(rcCount.getNotPassedCount() + this.getNotPassedCount(ret, item));
    }

    protected int getNotSupportCount(ResultItem ret, CheckItem cItem) {
        int notSupportCount = 0;
        if (cItem.isSingleElement()) {
            notSupportCount += ret.isNoSupport() ? 1 : 0;
        } else {
            List<RItem> ritems = ret.getItems();
            notSupportCount += this.calcNotSupportCount(ritems);
        }
        return notSupportCount;
    }

    protected int calcNotSupportCount(List<RItem> ritems) {
        int count = 0;
        for (RItem ritem : ritems) {
            count += ritem.isNoSupport() ? 1 : 0;
        }
        return count;
    }

    protected int getWarningCount(ResultItem ret, CheckItem cItem) {
        int warningCount = 0;
        if (cItem.isSingleElement() && cItem.getCheckResult() != null) {
            warningCount += cItem.getCheckResult().isWarning() ? 1 : 0;
        } else {
            List<RItem> ritems = ret.getItems();
            warningCount += this.calcWarningCount(ritems);
        }
        return warningCount;
    }

    protected int calcWarningCount(List<RItem> ritems) {
        int count = 0;
        for (RItem ritem : ritems) {
            count += ritem.isWarning() ? 1 : 0;
        }
        return count;
    }

    protected int getNotCheckdCount(ResultItem ret, CheckItem cItem) {
        int notExecutedCount = 0;
        if (cItem.isSingleElement()) {
            notExecutedCount = ret.isNoCheck() ? 1 : 0;
        } else {
            List<RItem> ritems = ret.getItems();
            notExecutedCount += this.calcNotExecutedCount(ritems);
        }
        return notExecutedCount;
    }

    private int getNotCheckdCountByInnerChecks(List<CheckItem> checkItems) {
        return (int)checkItems.stream().filter(checkItem -> checkItem.getCheckResult().isNoCheck()).count();
    }

    private int getWarningCountByInnerChecks(List<CheckItem> checkItems) {
        return (int)checkItems.stream().filter(checkItem -> checkItem.getCheckResult().isWarning()).count();
    }

    private int getNoSupportCountByInnerChecks(List<CheckItem> checkItems) {
        return (int)checkItems.stream().filter(checkItem -> checkItem.getCheckResult().isNoSupport()).count();
    }

    private int getNotPassCountByInnerChecks(List<CheckItem> checkItems) {
        return (int)checkItems.stream().filter(checkItem -> checkItem.getCheckResult().isNotPass()).count();
    }

    protected int calcNotExecutedCount(List<RItem> ritems) {
        int count = 0;
        for (RItem ritem : ritems) {
            count += ritem.isNoCheck() ? 1 : 0;
        }
        return count;
    }

    protected int getNotPassedCount(ResultItem ret, CheckItem cItem) {
        int faildCount = 0;
        if (cItem.isSingleElement()) {
            faildCount = ret.isNotPass() ? 1 : 0;
        } else {
            List<Item> items = cItem.getItems();
            List<RItem> ritems = ret.getItems();
            faildCount += this.calcFualtCount(items, ritems);
        }
        return faildCount;
    }

    protected int calcFualtCount(List<Item> items, List<RItem> ritems) {
        int count = 0;
        if (ritems == null || ritems.isEmpty()) {
            count = items.size();
        } else {
            for (RItem ritem : ritems) {
                count += ritem.isFailed() ? 1 : 0;
            }
        }
        return count;
    }

    protected ResultItem checkAsItem(CheckDevNode node, ICheckModel checkModel, CheckItem checkItem, Calendar time) throws ToolException {
        ResultItem ret = new ResultItem();
        ret.setCheckItem(checkItem);
        this.uiObserver.update(node, null, checkItem.getName(), 0, time, RecordStatus.RUNNING);
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(node);
        if (ui != null) {
            ui.updateProgress(0);
        }
        try {
            ret = checkModel.check(checkItem);
            checkItem.setCheckResult(ret);
        }
        catch (ToolException tex) {
            this.checkDevNode.setError(true);
            this.uiObserver.update(node, null, ResourceUtil.getString((String)"inspsctor.wizard.performinspect.error"), 1, Calendar.getInstance(), RecordStatus.INTERRUPPED);
            throw tex;
        }
        if (this.isNeedResetProgressStep()) {
            this.resetProgressStep();
        }
        this.uiObserver.update(node, checkItem, checkItem.getName(), this.progressStep, time);
        return ret;
    }

    protected ICheckModel getCheckModel(CheckDevNode node) throws ToolException {
        ICheckModel checkModel = null;
        if (node == null) {
            return null;
        }
        Product product = node.getProduct();
        if (product == null) {
            return null;
        }
        LOGGER.info("port : {} ip : {} serialNo : {} user : {}", new Object[]{node.getDevNode().getPort(), node.getDevNode().getIp(), node.getDevNode().getDeviceSerialNumber(), node.getDevNode().getLoginUser()});
        String resultFolderPath = "";
        try {
            resultFolderPath = this.resultFolder.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get path error.", (Throwable)e);
            return null;
        }
        CheckModelInfo modelInfo = product.getCheckModelInfo();
        if (modelInfo == null || "normal".equals(modelInfo.getModelType()) || modelInfo.getModelType().equals("sh")) {
            checkModel = new NormalCheckModel(node, this.uiObserver);
            ((NormalCheckModel)checkModel).getParaMap().put("tmpDataDir", resultFolderPath);
            return checkModel;
        }
        String modelType = modelInfo.getModelType();
        if ((checkModel = this.getiCheckModel(node, checkModel, product, resultFolderPath, modelType)) instanceof NormalCheckModel) {
            ((NormalCheckModel)checkModel).getParaMap().put("tmpDataDir", resultFolderPath);
        }
        if (checkModel instanceof PyScriptCheckModel) {
            ((PyScriptCheckModel)checkModel).getParaMap().put("tmpDataDir", resultFolderPath);
            try {
                ((PyScriptCheckModel)checkModel).getEnv().put("inspectTmpDataDir", this.resultFolder.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("get path error.", (Throwable)e);
            }
        }
        return checkModel;
    }

    private ICheckModel getiCheckModel(CheckDevNode node, ICheckModel checkModel, Product product, String resultFolderPath, String modelType) throws ToolException {
        ICheckModel result = checkModel;
        if ("python".equals(modelType)) {
            result = new PyScriptCheckModel(node, this.uiObserver);
        } else if ("auto".equals(modelType)) {
            try {
                boolean isSecured = SecureLineChecker.isSecuredLine(this.checkDevNode, product.getConfigDir());
                result = isSecured ? new PyScriptCheckModel(node, this.uiObserver) : new NormalCheckModel(node, this.uiObserver);
            }
            catch (Exception e) {
                throw new ToolException("", (Throwable)e);
            }
        } else if ("windows".equals(modelType)) {
            result = new WindowsCheckModel(node, this.uiObserver);
        } else if ("rest".equals(modelType)) {
            result = new RestCheckModel(node, this.uiObserver);
            ((RestCheckModel)result).setTmpDir(resultFolderPath);
        }
        return result;
    }

    public InspectWorktaker getInspectWorktaker() {
        return this.inspectWorktaker;
    }

    public boolean isNeedResetProgressStep() {
        return this.needResetProgressStep;
    }

    public void setNeedResetProgressStep(boolean needResetProgressStep) {
        this.needResetProgressStep = needResetProgressStep;
    }

    public void resetProgressStep() {
        this.tempProgressStep += 100.0 / (double)Math.max(1, InspectContext.getInstance().calcAllItemSize(this.checkDevNode));
        if (this.tempProgressStep >= 1.0) {
            this.progressStep = 1;
            this.tempProgressStep -= 1.0;
        } else {
            this.progressStep = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startFcvInspect(CheckDevNode node, ICheckModel checkModel) {
        try {
            log.info("start inspect node: {}", (Object)node.getDevNode().getIp());
            FceRestConnection fcvRest = RestConnectionManager.getFceRestConnection((DevNode)node.getDevNode());
            this.refreshTheFcvStartupStatus(node);
            ResultCalc rcCount = new ResultCalc();
            boolean progressStatus = this.queryFcvProgressInfo(node, fcvRest, rcCount);
            if (rcCount.getAllCheckNumCount() > 0) {
                this.reportMsghandle(node, checkModel);
                this.resultStat(node, rcCount);
            }
            log.info("end inspect node: {}", (Object)node.getDevNode().getIp());
            boolean bl = progressStatus;
            return bl;
        }
        catch (ToolException e) {
            log.error("An exception occurs during the inspection", (Throwable)e);
            this.refreshErrorInfo(node, ResourceUtil.getString((String)"metavision.running.failed"));
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error("The MetaVision interface returns an error", (Throwable)e);
            this.refreshErrorInfo(node, ResourceUtil.getString((String)"metavision.running.failed"));
            boolean bl = false;
            return bl;
        }
        finally {
            node.setExecuteSuc(true);
            RestConnectionManager.releaseFceConnection((DevNode)node.getDevNode());
        }
    }

    private void refreshTheFcvStartupStatus(CheckDevNode node) {
        node.setStartTime(Calendar.getInstance());
        String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.startinspect", (Object[])new Object[]{node.getDevNode().getIp()});
        this.uiObserver.update(node, null, msg, 50, Calendar.getInstance());
    }

    private boolean queryFcvProgressInfo(CheckDevNode node, FceRestConnection fcvRest, ResultCalc rcCount) throws ToolException {
        JSONArray paramArray = ComputerStorageUtils.getEnableCheckItemsJsonArray(node);
        JSONObject taskInfoObject = ComputerStorageUtils.startMetaVisionInspect(fcvRest, paramArray.toString());
        this.refreshCheckItemsInBatches(node, ResultFlag.WAITING, RecordStatus.RUNNING);
        return this.upgradeProgressInfo(node, fcvRest, rcCount, taskInfoObject.getStringOrDefault("data", ""));
    }

    private boolean upgradeProgressInfo(CheckDevNode node, FceRestConnection fcvRest, ResultCalc rcCount, String taskId) throws ToolException {
        String status;
        long startQueryTime = System.currentTimeMillis();
        do {
            JSONObject progressInfoObject;
            if (ComputerStorageUtils.INSPECTION_ERROR_STATUS.containsKey(status = (progressInfoObject = ComputerStorageUtils.queryMetaVisionInspectProgress(fcvRest, taskId)).getJSONObject("data").getStringOrDefault("status", ""))) {
                log.error("query task error, status is [{}]", (Object)ComputerStorageUtils.INSPECTION_ERROR_STATUS.get(status));
                this.refreshErrorInfo(node, ResourceUtil.getStringWithParams((String)"metavision.running.error", (Object[])new Object[]{status}));
                return false;
            }
            if (ComputerStorageUtils.INSPECTION_SUCCESS_STATUS.containsKey(status)) {
                log.info("query task status is [{}]", (Object)ComputerStorageUtils.INSPECTION_SUCCESS_STATUS.get(status));
                Map<String, JSONObject> inspectResults = ComputerStorageUtils.queryMetaVisionInspectResults(fcvRest, taskId, node.getCheckItems().size());
                node.getCheckItems().values().stream().flatMap(Collection::stream).filter(CheckItem::isEnable).forEach(checkItem -> this.queryFcvInspectResult(node, inspectResults, (CheckItem)checkItem, rcCount));
                rcCount.setEndTime(Calendar.getInstance());
                return rcCount.getFaildCount() > 0;
            }
            ComputerStorageUtils.sleepMilliseconds(1000);
        } while (System.currentTimeMillis() - startQueryTime <= ComputerStorageUtils.META_VISION_INSPECTION_TIME_OUT);
        log.error("query task timeout, status is [{}]", (Object)status);
        this.refreshErrorInfo(node, ResourceUtil.getString((String)"metavision.query.timeout"));
        return false;
    }

    private void refreshErrorInfo(CheckDevNode node, String message) {
        this.refreshCheckItemsInBatches(node, ResultFlag.NOTPASS, RecordStatus.FAILED);
        this.uiObserver.update(node, null, message, 0, Calendar.getInstance());
    }

    private void queryFcvInspectResult(CheckDevNode node, Map<String, JSONObject> inspectResults, CheckItem checkItem, ResultCalc rcCount) {
        ResultFlag flag = this.updateInspectResult(node, inspectResults, checkItem);
        RecordStatus itemStatus = ResultFlag.NOTPASS.equals((Object)flag) ? RecordStatus.FAILED : RecordStatus.FINISHED;
        rcCount.summarizeInspectResult(flag);
        this.refreshThePageProgress(node, checkItem, flag, itemStatus);
    }

    private void refreshCheckItemsInBatches(CheckDevNode node, ResultFlag flag, RecordStatus status) {
        node.getCheckItems().values().stream().flatMap(Collection::stream).filter(CheckItem::isEnable).forEach(checkItem -> this.refreshThePageProgress(node, (CheckItem)checkItem, flag, status));
    }

    private void refreshThePageProgress(CheckDevNode node, CheckItem checkItem, ResultFlag flag, RecordStatus status) {
        Calendar operationTime = Calendar.getInstance();
        ResultItem ret = new ResultItem();
        ret.setStartTime(operationTime);
        if (!status.isRunning()) {
            ret.setCheckItem(checkItem);
            ret.setFinished(true);
            InspectUIUtil.setResultStatus(ret, flag);
        }
        checkItem.setCheckResult(ret);
        this.uiObserver.update(node, checkItem, checkItem.getName(), this.getItemRefreshStep(status), operationTime, status);
        ComputerStorageUtils.sleepMilliseconds(100);
    }

    private int getItemRefreshStep(RecordStatus status) {
        return status.isRunning() ? 0 : 1;
    }

    private ResultFlag updateInspectResult(CheckDevNode node, Map<String, JSONObject> inspectResults, CheckItem checkItem) {
        if (!inspectResults.containsKey(checkItem.getTag())) {
            log.error("The item {} has not result.", (Object)checkItem.getName());
            checkItem.setSourceInfo(ResourceUtil.getString((String)"metavision.result.query.nosupport"), node);
            checkItem.setErrorInfo(ResourceUtil.getString((String)"metavision.result.query.nosupport"));
            return ResultFlag.NOSUPPORT;
        }
        JSONArray deviceResults = inspectResults.get(checkItem.getTag()).getJSONArray("details");
        return IntStream.range(0, deviceResults.length()).mapToObj(arg_0 -> ((JSONArray)deviceResults).getJSONObject(arg_0)).filter(resultJObject -> ComputerStorageUtils.isCurrentCheckItem(checkItem, resultJObject.getStringOrDefault("itemId", ""))).findFirst().map(resultJObject -> this.getCheckItemStatus(node, checkItem, (JSONObject)resultJObject)).orElse(ResultFlag.NOSUPPORT);
    }

    @NotNull
    private ResultFlag getCheckItemStatus(CheckDevNode node, CheckItem checkItem, JSONObject resultJObject) {
        checkItem.setSourceInfo(resultJObject.getStringOrDefault(ComputerStorageUtils.getMetaVisionInternalizationId("detail"), ""), node);
        if ("normal".equals(resultJObject.getStringOrDefault("state", ""))) {
            return ResultFlag.PASS;
        }
        checkItem.setErrorInfo(resultJObject.getStringOrDefault(ComputerStorageUtils.getMetaVisionInternalizationId("detail"), ""));
        return ResultFlag.NOTPASS;
    }
}

