/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector;

import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.lifecycle.model.ToolLifecycleMessage;
import com.huawei.ism.tool.lifecycle.util.ToolLifecycleMessageReportUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.tool.service.lifecycle.model.inspect.BizCloudInpectionMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectEventRecorder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspectEventRecorder.class);
    private static final InspectEventRecorder INSTANCE = new InspectEventRecorder();
    private static final String EVENT_REPORT_FILE_PATH = String.join((CharSequence)File.separator, UserOpDataSaveUtil.getToolBoxPath(), "data", "tool_message", "inspector");
    private static final int PROGRESS_MAX_VALUE = 100;
    List<CheckDevNode> devNodeList;
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ToolThreadFactory("bizCloudRecorder"));
    private ScheduledFuture<?> recordSchedule;
    private String taskName;
    private volatile int times;
    private volatile String taskId;

    private InspectEventRecorder() {
    }

    public static InspectEventRecorder getInstance() {
        return INSTANCE;
    }

    public synchronized String startRecord(List<CheckDevNode> nodeList) {
        if (!InspectEventRecorder.isBizCloudReportEnable() || ObjectUtils.isEmpty(nodeList)) {
            log.info("biz cloud event report is unable.");
            return this.taskId;
        }
        if (this.recordSchedule == null) {
            this.taskId = UUID.randomUUID().toString();
            this.taskName = String.valueOf(InspectContext.getInstance().getInspectWorktaker().get("select_sceneId"));
            this.times = 1;
            this.devNodeList = nodeList;
            this.recordSchedule = this.executor.scheduleAtFixedRate(() -> this.record(this.taskId), 0L, 5L, TimeUnit.MINUTES);
        }
        return this.taskId;
    }

    synchronized boolean record(String taskId) {
        try {
            ToolLifecycleMessage msg = this.buildToolLifecycleMessage(taskId, this.times);
            ToolLifecycleMessageReportUtil.reportMessage((ToolLifecycleMessage)msg);
            ++this.times;
            return true;
        }
        catch (ToolException e) {
            log.error("Fail to report inspect biz_cloud InspectionInfo.taskId is {}", (Object)taskId, (Object)e);
            return false;
        }
    }

    public synchronized void stopRecord() {
        this.setInspectStatusSuc();
        this.record(this.taskId);
        this.taskId = null;
        InspectContext.getInstance().setEventReportFileName(null);
        this.recordSchedule.cancel(true);
        this.recordSchedule = null;
    }

    private ToolLifecycleMessage buildToolLifecycleMessage(String taskId, int times) {
        BizCloudInpectionMessage bizCloudInpectionMessage = new BizCloudInpectionMessage();
        bizCloudInpectionMessage.setTaskId(taskId);
        bizCloudInpectionMessage.setTaskName(this.taskName);
        bizCloudInpectionMessage.setType("Storage");
        bizCloudInpectionMessage.setFilePath(InspectContext.getInstance().getEventReportFileName());
        bizCloudInpectionMessage.setStartTime(this.formatTime(InspectContext.getInstance().getInspectWorktaker().getStartTimeStamp()));
        bizCloudInpectionMessage.setEndTime(this.formatTime(InspectContext.getInstance().getInspectWorktaker().getEndTimeStamp()));
        bizCloudInpectionMessage.setExecutionTime(this.formatTime(Calendar.getInstance().getTime().getTime()));
        bizCloudInpectionMessage.setProgress(this.getInspectProgress());
        bizCloudInpectionMessage.setStatus(this.getInspectStatus());
        bizCloudInpectionMessage.setTimes(times);
        bizCloudInpectionMessage.setContent(InspectContext.getInstance().getTitle() + " " + this.taskName);
        return new ToolLifecycleMessage("inspector", LocalDateTime.now(), "BIZ_CLOUD", (Object)bizCloudInpectionMessage);
    }

    void setInspectStatusSuc() {
        for (CheckDevNode node : this.devNodeList) {
            UiUpdatePair uiUpdatePair = InspectContext.getInstance().getUiUpdatePair(node);
            if (uiUpdatePair == null) continue;
            uiUpdatePair.setInspectStatus(InspectStatus.EXESUC);
            uiUpdatePair.setProgress(100);
        }
    }

    private String getInspectStatus() {
        for (CheckDevNode node : this.devNodeList) {
            if (!this.isNodeInspectRunning(node)) continue;
            return InspectStatus.EXECUTING.getKey();
        }
        return InspectStatus.EXESUC.getKey();
    }

    private int getInspectProgress() {
        int sumProgress = 0;
        for (CheckDevNode node : this.devNodeList) {
            UiUpdatePair uiUpdatePair = InspectContext.getInstance().getUiUpdatePair(node);
            if (this.isNodeInspectRunning(node)) {
                sumProgress += Optional.ofNullable(uiUpdatePair).map(UiUpdatePair::getProgress).orElse(0).intValue();
                continue;
            }
            sumProgress += 100;
        }
        return sumProgress / this.devNodeList.size();
    }

    private boolean isNodeInspectRunning(CheckDevNode node) {
        UiUpdatePair uiUpdatePair = InspectContext.getInstance().getUiUpdatePair(node);
        String status = Optional.ofNullable(uiUpdatePair).map(UiUpdatePair::getInspectStatus).map(InspectStatus::getKey).orElse(InspectStatus.WAITINGTIMED.getKey());
        return InspectStatus.WAITINGTIMED.getKey().equals(status) || InspectStatus.EXECUTING.getKey().equals(status);
    }

    private String formatTime(long data) {
        return StringUtils.formatDate((Object)data, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public void createBizCloudReportExcel(HSSFWorkbook workBook, String excelFileName) {
        if (!InspectEventRecorder.isBizCloudReportEnable() || this.recordSchedule == null) {
            return;
        }
        String eventReportFilePath = Paths.get(EVENT_REPORT_FILE_PATH, excelFileName).toString();
        try (FileOutputStream fos = new FileOutputStream(eventReportFilePath);){
            workBook.write((OutputStream)fos);
            InspectContext.getInstance().getInspectWorktaker().setEndTimeStamp(Calendar.getInstance().getTimeInMillis());
            InspectContext.getInstance().setEventReportFileName(excelFileName);
            this.stopRecord();
        }
        catch (Exception e) {
            log.error("Write Excel fialed!,FileName : " + excelFileName, (Throwable)e);
        }
    }

    public static boolean isBizCloudReportEnable() {
        return Boolean.parseBoolean(System.getenv("bizCloudReportEnable"));
    }
}

