/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.utils.CallbackPackageSnMappingUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.inspect.entity.BureauFile;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.InspectionExecutionMode;
import com.huawei.ism.tool.inspect.entity.InspectionGradientGuidance;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.InspectCaller;
import com.huawei.ism.tool.inspect.logic.inspector.InspectEventRecorder;
import com.huawei.ism.tool.inspect.logic.inspector.SubmitWaitTask;
import com.huawei.ism.tool.inspect.logic.inspector.TaskSchedule;
import com.huawei.ism.tool.inspect.logic.result.ExcelConfigurationResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.TreeViewResultBuilder;
import com.huawei.ism.tool.inspect.ui.wizard.PerformSoftInspectCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.LockProduceUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.lifecycle.model.stm.StmReportMessage;
import com.huawei.ism.tool.lifecycle.util.StmReportUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.ZipUtils;
import com.huawei.ism.tool.obase.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class InspectExecuter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspectExecuter.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectExecuter.class);
    private static final String CHECK_PERIOD_START_TIME = "checkPeriodStartTime";
    private static final String MEMORY_TASK_DB_PATH = "memoryTaskDbPath";
    private Map<String, List<String>> nodeSelectItems;
    private boolean retFilewhether = false;
    private boolean connectedDevEmpty = false;
    private TaskSchedule taskSchedule = new TaskSchedule();
    private ResourceBundle sysBundle = ResourceBundle.getBundle("config.inspect");
    private AtomicBoolean finished = new AtomicBoolean(false);
    private InspectWorktaker inspectWorktaker;
    private IUiObserver uiObserver;
    private List<InspectCaller> inspects;
    private List<InspectCaller> hostInspects;
    private File resultTmpFolder = InspectUtils.getTmpResultFilePath();

    public InspectExecuter(InspectWorktaker inspectWorktaker, IUiObserver uiObserver) {
        this.inspectWorktaker = inspectWorktaker;
        this.uiObserver = uiObserver;
    }

    public InspectExecuter(InspectWorktaker inspectWorktaker, IUiObserver uiObserver, Map<String, List<String>> selectItems) {
        this(inspectWorktaker, uiObserver);
        this.nodeSelectItems = selectItems;
    }

    public void startInspect() {
        this.inspectWorktaker.setStartTimeStamp(Calendar.getInstance().getTimeInMillis());
        if (InspectContext.getInstance().isInMemoryInspectionSence()) {
            InspectContext.getInstance().setCheckPeriodStartTime(System.getenv(CHECK_PERIOD_START_TIME));
            InspectContext.getInstance().setMemoryTaskDbPath(System.getenv(MEMORY_TASK_DB_PATH));
            InspectContext.getInstance().setWorkPath((String)this.inspectWorktaker.get("check_savepath"));
        }
        this.inspectWorktaker.put("not_connected_devices_" + this.inspectWorktaker.getUuid(), Collections.synchronizedList(new ArrayList()));
        List checkDevs = (List)this.inspectWorktaker.get("check_dev_nodes");
        ListOrderedMap<String, List<CheckDevNode>> result = InspectUtils.classifyDevs(checkDevs);
        List<CheckDevNode> allCheckDevNode = InspectUtils.getAllDevs(result);
        StmReportUtil.reportStmMessage((StmReportMessage)new StmReportMessage("001", allCheckDevNode.size()), (String)"inspector");
        InspectEventRecorder.getInstance().startRecord(checkDevs);
        this.inspects = new ArrayList<InspectCaller>();
        this.hostInspects = new ArrayList<InspectCaller>();
        Map<String, Boolean> deviceInInfoSummaryMap = InspectContext.getInstance().getInspectionGradientGuidance().getDeviceInInfoSummaryMap();
        for (CheckDevNode dev : allCheckDevNode) {
            for (CheckDevNode checkNode : dev.getAllCheckNode()) {
                deviceInInfoSummaryMap.put(checkNode.getDevNode().getDeviceSerialNumber(), false);
                checkNode.reset();
                InspectCaller caller = this.instanceInspectCaller(checkNode);
                this.selectItems(checkNode);
                caller.initValue(checkNode, this.uiObserver, this.taskSchedule, this.resultTmpFolder, this.inspectWorktaker);
                if (ItDeviceType.Host.equals((Object)dev.getDevNode().getItDeviceType())) {
                    this.hostInspects.add(caller);
                    continue;
                }
                this.inspects.add(caller);
            }
        }
        log.info("Storage inspect task size: {}, host inspect task size {}", (Object)this.inspects.size(), (Object)this.hostInspects.size());
    }

    private void selectItems(CheckDevNode checkNode) {
        if (MapUtils.isEmpty(this.nodeSelectItems)) {
            return;
        }
        String devSn = checkNode.getDevNode().getDeviceSerialNumber();
        if (StringUtils.isNULLStr((String)devSn)) {
            return;
        }
        List<String> selectItems = this.nodeSelectItems.getOrDefault(devSn, Collections.emptyList());
        if (CollectionUtil.isEmpty(selectItems)) {
            return;
        }
        InspectScene scene = InspectScene.of(InspectContext.getInstance().getInspectWorktaker().get("select_sceneId").toString());
        checkNode.selectItems(scene, selectItems);
    }

    private InspectCaller instanceInspectCaller(CheckDevNode checkNode) {
        Product product = checkNode.getProduct();
        int cfgVer = product.getInspectCfgVersion();
        String clz = product.isOld() ? this.sysBundle.getString("oldinspectcaller") : (cfgVer >= 3 ? this.sysBundle.getString("secondgenerationinspectcaller") : (null != product.getCheckModelInfo() && "rest".equalsIgnoreCase(product.getCheckModelInfo().getModelType()) ? this.sysBundle.getString("dstorageinspectcaller") : this.sysBundle.getString("newinspectcaller")));
        return (InspectCaller)ReflectionUtils.newInstance((String)clz);
    }

    public File waitResult(boolean async) {
        log.info("async model : {}", (Object)async);
        if (async) {
            log.info("Submit inspect task.");
            this.submitWait();
            return null;
        }
        log.info("Submit inspect task and wait end.");
        File ret = this.waitResult();
        try {
            if (ret == null) {
                log.error("Get ret file path error. ret is null.");
                throw new ToolException("Get ret file path error. ret is null.");
            }
            InspectContext.getInstance().setResultFileList(ret.getCanonicalPath());
        }
        catch (Exception e) {
            log.error("Get ret file path error.");
        }
        return ret;
    }

    private void submitWait() {
        ThreadPoolManager manager = ThreadPoolManager.getInstance();
        SubmitWaitTask submitWaitTask = new SubmitWaitTask(this);
        manager.execute((Runnable)submitWaitTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File waitResult() {
        try {
            Object object;
            File reportFile;
            this.uiObserver.updateAllStatus(InspectStatus.WAITING);
            if (InspectContext.getInstance().isBackgroundMode()) {
                reportFile = this.executeInspect();
            } else {
                object = LockProduceUtils.getInstance().getInspectLock();
                synchronized (object) {
                    reportFile = this.executeInspect();
                }
            }
            this.saveReportFile(reportFile);
            object = reportFile;
            return object;
        }
        finally {
            this.finished.set(true);
            this.inspectWorktaker.setEndTimeStamp(Calendar.getInstance().getTimeInMillis());
            this.uiObserver.finishAll(this.inspectWorktaker.getEndTimeStamp() - this.inspectWorktaker.getStartTimeStamp());
        }
    }

    private void saveReportFile(File reportFile) {
        if (!(this.uiObserver instanceof PerformSoftInspectCard)) {
            return;
        }
        ((PerformSoftInspectCard)this.uiObserver).setReportFile(reportFile);
    }

    private File executeInspect() {
        if (!InspectContext.getInstance().isBackgroundMode()) {
            InspectContext.getInstance().getPerformInspectCard().updateBottomMsgInpsecting();
        }
        this.traversalInspects();
        File retFile = this.buildResultFile(this.resultTmpFolder);
        if (retFile == null) {
            this.connectedDevEmpty = true;
        }
        if (retFile != null && !retFile.exists()) {
            this.retFilewhether = true;
        }
        this.inspectWorktaker.clearNoConnected();
        log.info("Result file has created, return!");
        return retFile;
    }

    private void traversalInspects() {
        log.info("start inspect task threads");
        ExecutorService executorService = ThreadPoolHelper.getFixedNumThreadPool((int)this.getInspectNum(), (String)"inspector_thread_pool");
        try {
            this.executeInspectTask(this.hostInspects, executorService);
            this.executeInspectTask(this.inspects, executorService);
        }
        finally {
            executorService.shutdown();
            log.info("inspect task threads end");
        }
    }

    private int getInspectNum() {
        InspectionGradientGuidance guidance = InspectContext.getInstance().getInspectionGradientGuidance();
        return InspectionExecutionMode.NORMAL.equals((Object)guidance.getInspectionExecutionMode()) ? guidance.getInspectNum() : 1;
    }

    private void executeInspectTask(List<InspectCaller> taskQueues, ExecutorService executorService) {
        taskQueues.stream().map(executorService::submit).collect(Collectors.toList()).forEach(this::safeWait);
    }

    private void safeWait(Future<?> task) {
        try {
            task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("invokeAll InterruptedException error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File buildResultFile(File resultTmpFolde) {
        Object object = LockProduceUtils.getInstance().getBuildResulLock();
        synchronized (object) {
            if (this.taskSchedule.isCancel()) {
                return null;
            }
            return this.executeBuildResultFile(resultTmpFolde);
        }
    }

    private File executeBuildResultFile(File resultTmpFolde) {
        InspectContext.getInstance().setTempPath(FilesUtil.getCanonicalPath((File)this.getResultTmpFolder()));
        String retInfo = ResourceUtil.getString((String)"inspsctor.wizard.report.mes");
        this.uiObserver.updateReporttingMsg(retInfo);
        try {
            List<CheckDevNode> connectedDevNode = this.inspectWorktaker.getConnectedDev();
            if (connectedDevNode.isEmpty()) {
                return null;
            }
            FileUtils.copyDir((String)(InspectContext.INSPECT_CONFPATH + File.separator + "template"), (String)resultTmpFolde.getCanonicalPath());
            if (InspectUtils.isFsExInspect()) {
                ExcelConfigurationResultBuilder excelBuilder = new ExcelConfigurationResultBuilder();
                excelBuilder.injectData(connectedDevNode);
                excelBuilder.saveExcel(resultTmpFolde.getCanonicalPath() + File.separator + "Configuration_Summary.xlsx");
            }
            TreeViewResultBuilder builder = new TreeViewResultBuilder();
            this.setBuresuScore(connectedDevNode);
            log.info("connected devs is {}", connectedDevNode);
            builder.buildResult((Map<String, List<CheckDevNode>>)InspectUtils.classifyDevs(connectedDevNode), resultTmpFolde, connectedDevNode);
            if (this.inspectWorktaker.get("check_savepath") == null) {
                return null;
            }
            String retPath = this.inspectWorktaker.get("check_savepath").toString();
            if (this.inspectWorktaker.get("check_savepath_filename") == null) {
                return null;
            }
            String retFile = this.inspectWorktaker.get("check_savepath_filename").toString();
            File ret = InspectExecuter.senseDuplicateName(new File(retPath, retFile));
            FileUtils.createDir((String)retPath);
            if (!InspectContext.getInstance().isOemOutTool()) {
                this.addFileToResult(resultTmpFolde.getCanonicalPath());
            }
            InspectUtils.addSHA256SignFile(resultTmpFolde);
            this.compressResylt(resultTmpFolde, ret);
            if (ApplicationContext.getInstance().isWindowsOS()) {
                FileUtils.setFilePermissions((File)ret);
            }
            this.checkUpload(connectedDevNode, ret);
            this.uiObserver.updateReporttingMsg("");
            return ret;
        }
        catch (IOException e) {
            log.error("build inspect result File error. ", (Throwable)e);
            return null;
        }
    }

    private void checkUpload(List<CheckDevNode> connectedDevNode, File ret) {
        try {
            if (InspectUtils.checkUploadRight()) {
                JSONArray devicesInfo = new JSONArray();
                for (CheckDevNode checkDevNode : connectedDevNode) {
                    for (CheckDevNode checkNode : checkDevNode.getAllCheckNode()) {
                        DevNode node = checkNode.getDevNode();
                        if (node == null) continue;
                        JSONObject devInfo = new JSONObject();
                        devInfo.put("SN", (Object)node.getDeviceSerialNumber());
                        devInfo.put("DeviceType", (Object)(node.getItDeviceType() != null ? node.getItDeviceType().getName() : "unknown"));
                        devicesInfo.put((Object)devInfo);
                    }
                }
                if (!CallbackPackageSnMappingUtils.recordToolPackageSnMapping((String)"inspector", (String)devicesInfo.toString(), (String)ret.getCanonicalPath())) {
                    log.info("write sn failed!  ");
                }
            }
        }
        catch (Exception e) {
            log.error("write sn failed! {}", (Throwable)e);
        }
    }

    private void setBuresuScore(List<CheckDevNode> nodes) {
        Set<Map.Entry<DevNode, BureauFile>> entries = InspectContext.getInstance().getBureauFiles().entrySet();
        block0: for (CheckDevNode node : nodes) {
            for (Map.Entry<DevNode, BureauFile> entry : entries) {
                if (!entry.getKey().equals((Object)node.getDevNode())) continue;
                node.setBureauScore(entry.getValue().getScore());
                continue block0;
            }
        }
    }

    private void addFileToResult(String inspectDir) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        InspectContext context = InspectContext.getInstance();
        params.put("dir", inspectDir);
        params.put("logger", LOGGER);
        params.put("connectedDevs", this.inspectWorktaker.getConnectedDev());
        Object scene = this.inspectWorktaker.get("select_sceneId");
        params.put("scene", String.valueOf(scene));
        params.put("qualityCheckUser", this.gbEncoding(context.getQualityCheckUser()));
        if (context.getExtendInspectScene() != null) {
            params.put("scene", context.getExpMode());
        }
        String jthonFile = InspectContext.INSPECT_CONFPATH + File.separator + "products" + File.separator + "pkginfo" + File.separator + "script";
        String scriptFilePath = jthonFile + File.separator + "creatPkgInfo.py";
        try {
            JythonExecuter executer = new JythonExecuter(new File(jthonFile));
            executer.compileScript(new File(scriptFilePath));
            executer.invokeFunction("execute", params);
        }
        catch (Exception e) {
            log.error("Excute Py Script error!", (Throwable)e);
        }
    }

    private String gbEncoding(String gbString) {
        char[] utfBytes = gbString.toCharArray();
        String unicodeBytes = "";
        for (int i = 0; i < utfBytes.length; ++i) {
            String hexB = Integer.toHexString(utfBytes[i]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes = unicodeBytes + "\\u" + hexB;
        }
        return unicodeBytes;
    }

    private void compressResylt(File resultTmpFolde, File ret) throws IOException {
        boolean zipBoolean = ZipUtils.compressFile((String)ret.getCanonicalPath(), (String)resultTmpFolde.getCanonicalPath());
        if (!zipBoolean) {
            this.retFilewhether = true;
            FileUtils.deleteFile((File)ret);
        }
    }

    private static File senseDuplicateName(File ret) {
        if (!ret.exists()) {
            return ret;
        }
        File path = ret.getParentFile();
        String retName = ret.getName();
        String suffix = retName.substring(retName.lastIndexOf("."));
        retName = retName.substring(0, retName.lastIndexOf("."));
        boolean exists = true;
        File newRet = null;
        while (exists) {
            String uuid = UUID.randomUUID().toString().substring(0, 8);
            newRet = new File(path, retName + "_" + uuid + suffix);
            exists = newRet.exists();
        }
        return newRet;
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public File getResultTmpFolder() {
        return this.resultTmpFolder;
    }

    public void cancelAllTask() {
        this.taskSchedule.setCancel(true);
    }

    public boolean isRetFilewhether() {
        return this.retFilewhether;
    }

    public boolean isConnectedDevEmpty() {
        return this.connectedDevEmpty;
    }
}

